/*
 * Decompiled with CFR 0.152.
 */
package com.ocs.dynamo.ui.composite.dialog;

import com.ocs.dynamo.dao.FetchJoinInformation;
import com.ocs.dynamo.domain.AbstractEntity;
import com.ocs.dynamo.domain.model.EntityModel;
import com.ocs.dynamo.service.BaseService;
import com.ocs.dynamo.service.MessageService;
import com.ocs.dynamo.service.ServiceLocatorFactory;
import com.ocs.dynamo.ui.composite.dialog.BaseModalDialog;
import com.ocs.dynamo.ui.composite.form.ModelBasedEditForm;
import com.ocs.dynamo.ui.composite.layout.FormOptions;
import com.ocs.dynamo.ui.composite.layout.SimpleEditLayout;
import com.ocs.dynamo.ui.utils.VaadinUtils;
import com.vaadin.ui.Button;
import com.vaadin.ui.Component;
import com.vaadin.ui.HorizontalLayout;
import com.vaadin.ui.Layout;
import java.io.Serializable;
import java.util.List;

public class EntityPopupDialog<ID extends Serializable, T extends AbstractEntity<ID>>
extends BaseModalDialog {
    private static final long serialVersionUID = -2012972894321597214L;
    private MessageService messageService = ServiceLocatorFactory.getServiceLocator().getMessageService();
    private EntityModel<T> entityModel;
    private SimpleEditLayout<ID, T> layout;
    private BaseService<ID, T> service;
    private FormOptions formOptions;
    private T entity;
    private Button okButton;

    public EntityPopupDialog(BaseService<ID, T> service, T entity, EntityModel<T> entityModel, FormOptions formOptions) {
        this.service = service;
        this.entityModel = entityModel;
        this.formOptions = formOptions;
        this.entity = entity;
    }

    public void afterEditDone(boolean cancel, boolean newEntity, T entity) {
    }

    protected T createEntity() {
        return (T)this.service.createNewEntity();
    }

    @Override
    protected void doBuild(Layout parent) {
        this.formOptions.setHideCancelButton(false);
        this.layout = new SimpleEditLayout<ID, T>((AbstractEntity)this.entity, (BaseService)this.service, (EntityModel)this.entityModel, this.formOptions, new FetchJoinInformation[0]){
            private static final long serialVersionUID = -2965981316297118264L;

            @Override
            protected void afterEditDone(boolean cancel, boolean newEntity, T entity) {
                super.afterEditDone(cancel, newEntity, entity);
                EntityPopupDialog.this.close();
                EntityPopupDialog.this.afterEditDone(cancel, newEntity, entity);
            }

            @Override
            protected T createEntity() {
                return EntityPopupDialog.this.createEntity();
            }

            @Override
            protected void postProcessButtonBar(HorizontalLayout buttonBar, boolean viewMode) {
                EntityPopupDialog.this.postProcessButtonBar(buttonBar, viewMode);
            }

            @Override
            protected void postProcessEditFields(ModelBasedEditForm<ID, T> editForm) {
                EntityPopupDialog.this.postProcessEditFields(editForm);
            }
        };
        parent.addComponent(this.layout);
    }

    @Override
    protected void doBuildButtonBar(HorizontalLayout buttonBar) {
        buttonBar.setVisible(this.formOptions.isReadOnly());
        if (this.formOptions.isReadOnly()) {
            this.okButton = new Button(this.messageService.getMessage("ocs.ok", VaadinUtils.getLocale()));
            this.okButton.addClickListener((Button.ClickListener & Serializable)event -> this.close());
            buttonBar.addComponent((Component)this.okButton);
        }
    }

    public T getEntity() {
        return this.layout.getEntity();
    }

    public List<Button> getSaveButtons() {
        return this.layout.getEditForm().getSaveButtons();
    }

    @Override
    protected String getTitle() {
        return this.entityModel.getDisplayName();
    }

    protected void postProcessButtonBar(HorizontalLayout buttonBar, boolean viewMode) {
    }

    protected void postProcessEditFields(ModelBasedEditForm<ID, T> editForm) {
    }

    public SimpleEditLayout<ID, T> getLayout() {
        return this.layout;
    }

    public Button getOkButton() {
        return this.okButton;
    }
}

