/*
 * Decompiled with CFR 0.152.
 */
package com.ocs.dynamo.ui.composite.dialog;

import com.ocs.dynamo.dao.FetchJoinInformation;
import com.ocs.dynamo.domain.AbstractEntity;
import com.ocs.dynamo.domain.model.EntityModel;
import com.ocs.dynamo.service.BaseService;
import com.ocs.dynamo.service.ServiceLocatorFactory;
import com.ocs.dynamo.ui.component.DefaultVerticalLayout;
import com.ocs.dynamo.ui.composite.dialog.SimpleModalDialog;
import com.ocs.dynamo.ui.composite.layout.FormOptions;
import com.ocs.dynamo.ui.composite.layout.SimpleSearchLayout;
import com.ocs.dynamo.ui.container.QueryType;
import com.ocs.dynamo.ui.utils.VaadinUtils;
import com.vaadin.data.Container;
import com.vaadin.data.sort.SortOrder;
import com.vaadin.event.ItemClickEvent;
import com.vaadin.ui.Component;
import com.vaadin.ui.Layout;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ModelBasedSearchDialog<ID extends Serializable, T extends AbstractEntity<ID>>
extends SimpleModalDialog {
    private static final long serialVersionUID = -7158664165266474097L;
    private List<Container.Filter> filters;
    private EntityModel<T> entityModel;
    private FetchJoinInformation[] joins;
    private boolean multiSelect;
    private boolean searchImmediately;
    private Integer pageLength;
    private SimpleSearchLayout<ID, T> searchLayout;
    private BaseService<ID, T> service;
    private List<SortOrder> sortOrders = new ArrayList<SortOrder>();

    public ModelBasedSearchDialog(BaseService<ID, T> service, EntityModel<T> entityModel, List<Container.Filter> filters, List<SortOrder> sortOrders, boolean multiSelect, boolean searchImmediately, FetchJoinInformation ... joins) {
        super(true);
        this.service = service;
        this.entityModel = entityModel;
        this.sortOrders = sortOrders != null ? sortOrders : new ArrayList();
        this.filters = filters;
        this.multiSelect = multiSelect;
        this.joins = joins;
        this.searchImmediately = searchImmediately;
    }

    @Override
    protected void doBuild(Layout parent) {
        FormOptions formOptions = new FormOptions().setReadOnly(true).setPopup(true).setSearchImmediately(this.searchImmediately);
        DefaultVerticalLayout wrapper = new DefaultVerticalLayout(false, false);
        wrapper.setStyleName("searchDialogWrapper");
        parent.addComponent((Component)wrapper);
        this.searchLayout = new SimpleSearchLayout<ID, T>(this.service, this.entityModel, QueryType.ID_BASED, formOptions, null, this.joins);
        this.searchLayout.setDefaultFilters(this.filters);
        for (SortOrder order : this.sortOrders) {
            this.searchLayout.addSortOrder(order);
        }
        if (this.pageLength != null) {
            this.searchLayout.setPageLength(this.pageLength);
        }
        this.searchLayout.setMultiSelect(this.multiSelect);
        this.searchLayout.getTableWrapper().getTable().addItemClickListener((ItemClickEvent.ItemClickListener & Serializable)event -> {
            if (event.isDoubleClick()) {
                this.select(event.getItem().getItemProperty((Object)"id").getValue());
                this.getOkButton().click();
            }
        });
        wrapper.addComponent((Component)this.searchLayout);
    }

    public Integer getPageLength() {
        return this.pageLength;
    }

    protected T getSelectedItem() {
        return this.searchLayout.getSelectedItem();
    }

    protected Collection<T> getSelectedItems() {
        return this.searchLayout.getSelectedItems();
    }

    @Override
    protected String getTitle() {
        return ServiceLocatorFactory.getServiceLocator().getMessageService().getMessage("ocs.search.title", VaadinUtils.getLocale(), new Object[]{this.entityModel.getDisplayNamePlural()});
    }

    public void setPageLength(Integer pageLength) {
        this.pageLength = pageLength;
    }

    public SimpleSearchLayout<ID, T> getSearchLayout() {
        return this.searchLayout;
    }

    public void select(Object selectedItems) {
        if (selectedItems instanceof Collection) {
            Collection col = (Collection)selectedItems;
            for (Serializable id : col) {
                this.searchLayout.getTableWrapper().getTable().select((Object)id);
            }
        } else {
            Serializable id = (Serializable)selectedItems;
            this.searchLayout.getTableWrapper().getTable().select((Object)id);
        }
    }

    public List<Container.Filter> getFilters() {
        return this.filters;
    }

    public void setFilters(List<Container.Filter> filters) {
        this.filters = filters;
        if (this.searchLayout != null) {
            this.searchLayout.setDefaultFilters(filters);
        }
    }
}

