/*
 * Decompiled with CFR 0.152.
 */
package com.ocs.dynamo.ui.composite.dialog;

import com.ocs.dynamo.service.MessageService;
import com.ocs.dynamo.service.ServiceLocatorFactory;
import com.ocs.dynamo.ui.composite.dialog.BaseModalDialog;
import com.ocs.dynamo.ui.utils.VaadinUtils;
import com.vaadin.server.FontAwesome;
import com.vaadin.server.Resource;
import com.vaadin.ui.Button;
import com.vaadin.ui.Component;
import com.vaadin.ui.HorizontalLayout;
import java.io.Serializable;

public abstract class SimpleModalDialog
extends BaseModalDialog {
    private static final long serialVersionUID = -2265149201475495504L;
    private Button cancelButton;
    private Button okButton;
    private boolean showCancelButton;
    private MessageService messageService = ServiceLocatorFactory.getServiceLocator().getMessageService();

    public SimpleModalDialog(boolean showCancelButton) {
        this.showCancelButton = showCancelButton;
    }

    @Override
    protected void doBuildButtonBar(HorizontalLayout buttonBar) {
        this.cancelButton = new Button(this.messageService.getMessage("ocs.cancel", VaadinUtils.getLocale()));
        this.cancelButton.setIcon((Resource)FontAwesome.BAN);
        this.cancelButton.addClickListener((Button.ClickListener & Serializable)event -> {
            this.doCancel();
            this.close();
        });
        this.cancelButton.setVisible(this.showCancelButton);
        buttonBar.addComponent((Component)this.cancelButton);
        this.okButton = new Button(this.messageService.getMessage("ocs.ok", VaadinUtils.getLocale()));
        this.okButton.setIcon((Resource)FontAwesome.CHECK);
        this.okButton.addClickListener((Button.ClickListener & Serializable)event -> {
            if (this.doClose()) {
                this.close();
            }
        });
        buttonBar.addComponent((Component)this.okButton);
    }

    protected boolean doClose() {
        return true;
    }

    protected void doCancel() {
    }

    public Button getCancelButton() {
        return this.cancelButton;
    }

    public Button getOkButton() {
        return this.okButton;
    }

    protected String message(String key) {
        return this.messageService.getMessage(key, VaadinUtils.getLocale());
    }

    protected String message(String key, Object ... args) {
        return this.messageService.getMessage(key, VaadinUtils.getLocale(), args);
    }

    public MessageService getMessageService() {
        return this.messageService;
    }
}

