/*
 * Decompiled with CFR 0.152.
 */
package com.ocs.dynamo.ui.composite.form;

import com.ocs.dynamo.domain.AbstractEntity;
import com.ocs.dynamo.domain.model.AttributeModel;
import com.ocs.dynamo.domain.model.EntityModel;
import com.ocs.dynamo.ui.composite.layout.BaseCustomComponent;
import com.ocs.dynamo.ui.composite.layout.FormOptions;
import com.vaadin.data.Container;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public abstract class AbstractModelBasedForm<ID extends Serializable, T extends AbstractEntity<ID>>
extends BaseCustomComponent {
    private static final long serialVersionUID = -1163137979989646987L;
    private EntityModel<T> entityModel;
    private Map<String, String> fieldEntityModels = new HashMap<String, String>();
    private Map<String, Container.Filter> fieldFilters = new HashMap<String, Container.Filter>();
    private FormOptions formOptions;

    public AbstractModelBasedForm(FormOptions formOptions, Map<String, Container.Filter> fieldFilters, EntityModel<T> entityModel) {
        this.formOptions = formOptions;
        this.fieldFilters = fieldFilters == null ? new HashMap() : fieldFilters;
        this.entityModel = entityModel;
    }

    public EntityModel<T> getEntityModel() {
        return this.entityModel;
    }

    protected EntityModel<?> getFieldEntityModel(AttributeModel attributeModel) {
        String reference = this.getFieldEntityModels().get(attributeModel.getPath());
        return reference == null ? null : this.getEntityModelFactory().getModel(reference, attributeModel.getNormalizedType());
    }

    public Map<String, String> getFieldEntityModels() {
        return this.fieldEntityModels;
    }

    public Map<String, Container.Filter> getFieldFilters() {
        return this.fieldFilters;
    }

    public FormOptions getFormOptions() {
        return this.formOptions;
    }

    public void setEntityModel(EntityModel<T> entityModel) {
        this.entityModel = entityModel;
    }

    public void setFieldEntityModels(Map<String, String> fieldEntityModels) {
        this.fieldEntityModels = fieldEntityModels;
    }

    public void setFieldFilters(Map<String, Container.Filter> fieldFilters) {
        this.fieldFilters = fieldFilters;
    }

    public void setFormOptions(FormOptions formOptions) {
        this.formOptions = formOptions;
    }
}

