/*
 * Decompiled with CFR 0.152.
 */
package com.ocs.dynamo.ui.composite.form;

import com.ocs.dynamo.domain.AbstractEntity;
import com.ocs.dynamo.domain.model.AttributeModel;
import com.ocs.dynamo.domain.model.EntityModel;
import com.ocs.dynamo.domain.model.impl.ModelBasedFieldFactory;
import com.ocs.dynamo.exception.OCSValidationException;
import com.ocs.dynamo.filter.listener.FilterChangeEvent;
import com.ocs.dynamo.filter.listener.FilterListener;
import com.ocs.dynamo.ui.Refreshable;
import com.ocs.dynamo.ui.Searchable;
import com.ocs.dynamo.ui.component.DefaultHorizontalLayout;
import com.ocs.dynamo.ui.component.DefaultVerticalLayout;
import com.ocs.dynamo.ui.composite.form.AbstractModelBasedForm;
import com.ocs.dynamo.ui.composite.layout.FormOptions;
import com.ocs.dynamo.ui.utils.VaadinUtils;
import com.vaadin.data.Container;
import com.vaadin.data.util.filter.And;
import com.vaadin.data.util.filter.Or;
import com.vaadin.event.Action;
import com.vaadin.event.ShortcutAction;
import com.vaadin.server.FontAwesome;
import com.vaadin.server.Resource;
import com.vaadin.ui.Button;
import com.vaadin.ui.Component;
import com.vaadin.ui.Field;
import com.vaadin.ui.HorizontalLayout;
import com.vaadin.ui.Layout;
import com.vaadin.ui.Notification;
import com.vaadin.ui.Panel;
import com.vaadin.ui.VerticalLayout;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public abstract class AbstractModelBasedSearchForm<ID extends Serializable, T extends AbstractEntity<ID>>
extends AbstractModelBasedForm<ID, T>
implements FilterListener,
Button.ClickListener,
Refreshable {
    private static final long serialVersionUID = 2146875385041665280L;
    private List<Container.Filter> defaultFilters = new ArrayList<Container.Filter>();
    private Button clearButton;
    private List<Container.Filter> currentFilters = new ArrayList<Container.Filter>();
    private ModelBasedFieldFactory<T> fieldFactory;
    private Layout filterLayout;
    private Searchable searchable;
    private Button searchButton;
    private Button toggleButton;
    private Button searchAnyButton;
    private Panel wrapperPanel;
    private HorizontalLayout buttonBar;
    private VerticalLayout main;

    public AbstractModelBasedSearchForm(Searchable searchable, EntityModel<T> entityModel, FormOptions formOptions, List<Container.Filter> defaultFilters, Map<String, Container.Filter> fieldFilters) {
        super(formOptions, fieldFilters, entityModel);
        this.fieldFactory = ModelBasedFieldFactory.getSearchInstance(entityModel, this.getMessageService());
        this.defaultFilters = defaultFilters == null ? new ArrayList() : defaultFilters;
        this.currentFilters.addAll(this.defaultFilters);
        this.searchable = searchable;
    }

    protected void afterSearchPerformed() {
    }

    protected void afterSearchFieldToggle(boolean visible) {
    }

    public void attach() {
        super.attach();
        this.build();
    }

    @Override
    public void build() {
        if (this.main == null) {
            this.main = new DefaultVerticalLayout(false, true);
            this.preProcessLayout(this.main);
            this.filterLayout = this.constructFilterLayout();
            if (this.filterLayout.isVisible()) {
                this.wrapperPanel = new Panel();
                this.main.addComponent((Component)this.wrapperPanel);
                this.wrapperPanel.setContent((Component)this.filterLayout);
                this.wrapperPanel.addActionHandler(new Action.Handler(){
                    private static final long serialVersionUID = -2136828212405809213L;
                    private Action enter = new ShortcutAction(null, 13, null);

                    public Action[] getActions(Object target, Object sender) {
                        return new Action[]{this.enter};
                    }

                    public void handleAction(Action action, Object sender, Object target) {
                        if (action == this.enter) {
                            AbstractModelBasedSearchForm.this.search();
                        }
                    }
                });
                this.buttonBar = new DefaultHorizontalLayout();
                this.main.addComponent((Component)this.buttonBar);
                this.constructButtonBar((Layout)this.buttonBar);
                this.postProcessButtonBar((Layout)this.buttonBar);
                this.searchButton.setEnabled(this.isSearchAllowed());
            }
            this.postProcessLayout(this.main);
            this.setCompositionRoot((Component)this.main);
        }
    }

    public void buttonClick(Button.ClickEvent event) {
        if (event.getButton() == this.searchButton) {
            this.search();
        } else if (event.getButton() == this.searchAnyButton) {
            this.searchAny();
        } else if (event.getButton() == this.clearButton) {
            if (this.getFormOptions().isConfirmClear()) {
                VaadinUtils.showConfirmDialog(this.getMessageService(), this.message("ocs.confirm.clear"), () -> {
                    this.clear();
                    if (this.getFormOptions().isSearchImmediately()) {
                        this.search(true);
                    }
                });
            } else {
                this.clear();
                if (this.getFormOptions().isSearchImmediately()) {
                    this.search(true);
                }
            }
        } else if (event.getButton() == this.toggleButton) {
            this.toggle(!this.wrapperPanel.isVisible());
        }
    }

    public void clear() {
        this.currentFilters.clear();
        this.currentFilters.addAll(this.getDefaultFilters());
    }

    protected abstract void constructButtonBar(Layout var1);

    protected Button constructClearButton() {
        this.clearButton = new Button(this.message("ocs.clear"));
        this.clearButton.setIcon((Resource)FontAwesome.ERASER);
        this.clearButton.setImmediate(true);
        this.clearButton.addClickListener((Button.ClickListener)this);
        this.clearButton.setVisible(!this.getFormOptions().isHideClearButton());
        return this.clearButton;
    }

    protected Field<?> constructCustomField(EntityModel<T> entityModel, AttributeModel attributeModel) {
        return null;
    }

    protected abstract Layout constructFilterLayout();

    protected Button constructSearchButton() {
        this.searchButton = new Button(this.message("ocs.search"));
        this.searchButton.setIcon((Resource)FontAwesome.SEARCH);
        this.searchButton.setImmediate(true);
        this.searchButton.addClickListener((Button.ClickListener)this);
        return this.searchButton;
    }

    protected Button constructToggleButton() {
        this.toggleButton = new Button(this.message("ocs.hide"));
        this.toggleButton.setIcon((Resource)FontAwesome.ARROWS_V);
        this.toggleButton.addClickListener((Button.ClickListener)this);
        this.toggleButton.setVisible(this.getFormOptions().isShowToggleButton());
        return this.toggleButton;
    }

    protected Button constructSearchAnyButton() {
        this.searchAnyButton = new Button(this.message("ocs.search.any"));
        this.searchAnyButton.setIcon((Resource)FontAwesome.SEARCH);
        this.searchAnyButton.setVisible(this.getFormOptions().isShowSearchAnyButton());
        this.searchAnyButton.addClickListener((Button.ClickListener)this);
        return this.searchAnyButton;
    }

    public Container.Filter extractFilter() {
        return this.extractFilter(false);
    }

    private Container.Filter extractFilter(boolean matchAny) {
        if (!this.currentFilters.isEmpty()) {
            Or currentFilter;
            And defaultFilter = null;
            if (!this.defaultFilters.isEmpty()) {
                defaultFilter = new And(this.defaultFilters.toArray(new Container.Filter[0]));
            }
            ArrayList<Container.Filter> customFilters = new ArrayList<Container.Filter>(this.currentFilters);
            customFilters.removeAll(this.defaultFilters);
            if (this.currentFilters.isEmpty()) {
                return defaultFilter;
            }
            Object object = currentFilter = matchAny ? new Or(this.currentFilters.toArray(new Container.Filter[0])) : new And(this.currentFilters.toArray(new Container.Filter[0]));
            if (defaultFilter != null) {
                return new And(new Container.Filter[]{defaultFilter, currentFilter});
            }
            return currentFilter;
        }
        return null;
    }

    public List<Container.Filter> getDefaultFilters() {
        return this.defaultFilters;
    }

    public HorizontalLayout getButtonBar() {
        return this.buttonBar;
    }

    public Button getClearButton() {
        return this.clearButton;
    }

    public List<Container.Filter> getCurrentFilters() {
        return this.currentFilters;
    }

    public ModelBasedFieldFactory<T> getFieldFactory() {
        return this.fieldFactory;
    }

    public Layout getFilterLayout() {
        return this.filterLayout;
    }

    public Searchable getSearchable() {
        return this.searchable;
    }

    public Button getSearchButton() {
        return this.searchButton;
    }

    public Button getSearchAnyButton() {
        return this.searchAnyButton;
    }

    public boolean isFilterSet(String path) {
        for (Container.Filter filter : this.currentFilters) {
            if (!filter.appliesToProperty((Object)path)) continue;
            return true;
        }
        return false;
    }

    public int getFilterCount() {
        return this.currentFilters.size();
    }

    public boolean isSearchAllowed() {
        List requiredAttributes = this.getEntityModel().getRequiredForSearchingAttributeModels();
        if (requiredAttributes.isEmpty()) {
            return true;
        }
        if (this.currentFilters.isEmpty()) {
            return false;
        }
        int matches = (int)requiredAttributes.stream().filter(am -> this.currentFilters.stream().anyMatch(f -> f.appliesToProperty((Object)am.getPath()))).count();
        return matches == requiredAttributes.size();
    }

    protected void validateBeforeSearch() {
    }

    @Override
    public void onFilterChange(FilterChangeEvent event) {
        if (event.getOldFilter() != null) {
            this.currentFilters.remove(event.getOldFilter());
        }
        if (event.getNewFilter() != null) {
            this.currentFilters.add(event.getNewFilter());
        }
        this.searchButton.setEnabled(this.isSearchAllowed());
    }

    protected void postProcessButtonBar(Layout buttonBar) {
    }

    protected void postProcessLayout(VerticalLayout layout) {
    }

    protected void preProcessLayout(VerticalLayout layout) {
    }

    public boolean search() {
        return this.search(false, false);
    }

    public boolean searchAny() {
        return this.search(false, true);
    }

    private boolean search(boolean skipValidation) {
        return this.search(skipValidation, false);
    }

    private boolean search(boolean skipValidation, boolean matchAny) {
        if (!this.isSearchAllowed()) {
            return false;
        }
        if (this.searchable != null) {
            if (!skipValidation) {
                try {
                    this.validateBeforeSearch();
                }
                catch (OCSValidationException ex) {
                    this.showNotifification((String)ex.getErrors().get(0), Notification.Type.ERROR_MESSAGE);
                    return false;
                }
            }
            this.searchable.search(this.extractFilter(matchAny));
            if (!skipValidation) {
                this.afterSearchPerformed();
            }
            return true;
        }
        return false;
    }

    public void setSearchable(Searchable searchable) {
        this.searchable = searchable;
    }

    protected void toggle(boolean show) {
        if (!show) {
            this.toggleButton.setCaption(this.message("ocs.show.search.fields"));
        } else {
            this.toggleButton.setCaption(this.message("ocs.hide.search.fields"));
        }
        this.wrapperPanel.setVisible(show);
        this.afterSearchFieldToggle(this.wrapperPanel.isVisible());
    }

    public void setDefaultFilters(List<Container.Filter> defaultFilters) {
        this.defaultFilters = defaultFilters;
    }
}

