/*
 * Decompiled with CFR 0.152.
 */
package com.ocs.dynamo.ui.composite.form;

import com.ocs.dynamo.domain.model.AttributeModel;
import com.ocs.dynamo.service.MessageService;
import com.ocs.dynamo.service.ServiceLocatorFactory;
import com.ocs.dynamo.ui.component.DefaultHorizontalLayout;
import com.ocs.dynamo.ui.component.DefaultVerticalLayout;
import com.ocs.dynamo.ui.composite.form.ModelBasedEditForm;
import com.ocs.dynamo.ui.composite.form.SignalsParent;
import com.ocs.dynamo.ui.composite.layout.FormOptions;
import com.ocs.dynamo.ui.converter.ConverterFactory;
import com.ocs.dynamo.ui.utils.VaadinUtils;
import com.ocs.dynamo.util.SystemPropertyUtils;
import com.ocs.dynamo.utils.NumberUtils;
import com.vaadin.data.Container;
import com.vaadin.data.Property;
import com.vaadin.data.Validator;
import com.vaadin.data.util.IndexedContainer;
import com.vaadin.data.validator.IntegerRangeValidator;
import com.vaadin.data.validator.LongRangeValidator;
import com.vaadin.data.validator.StringLengthValidator;
import com.vaadin.server.ErrorMessage;
import com.vaadin.server.FontAwesome;
import com.vaadin.server.Resource;
import com.vaadin.server.UserError;
import com.vaadin.ui.AbstractField;
import com.vaadin.ui.Button;
import com.vaadin.ui.Component;
import com.vaadin.ui.CustomField;
import com.vaadin.ui.DefaultFieldFactory;
import com.vaadin.ui.Field;
import com.vaadin.ui.Layout;
import com.vaadin.ui.Table;
import com.vaadin.ui.TableFieldFactory;
import com.vaadin.ui.TextField;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

public class CollectionTable<T extends Serializable>
extends CustomField<Collection<T>>
implements SignalsParent {
    private static final long serialVersionUID = -1203245694503350276L;
    private static final String VALUE = "value";
    private final AttributeModel attributeModel;
    private final MessageService messageService;
    private final Table table;
    private Button addButton;
    private FormOptions formOptions;
    private int pageLength = SystemPropertyUtils.getDefaultListSelectRows();
    private ModelBasedEditForm<?, ?> parentForm;
    private boolean propagateChanges = true;
    private Object selectedItem;
    private boolean viewMode;

    public CollectionTable(AttributeModel attributeModel, boolean viewMode, FormOptions formOptions) {
        this.messageService = ServiceLocatorFactory.getServiceLocator().getMessageService();
        this.viewMode = viewMode;
        this.formOptions = formOptions;
        this.attributeModel = attributeModel;
        this.table = new Table("");
    }

    protected void constructAddButton(Layout buttonBar) {
        this.addButton = new Button(this.messageService.getMessage("ocs.add", VaadinUtils.getLocale()));
        this.addButton.setIcon((Resource)FontAwesome.PLUS);
        this.addButton.addClickListener((Button.ClickListener & Serializable)event -> {
            this.table.addItem();
            if (this.parentForm != null) {
                this.parentForm.signalDetailsComponentValid(this, false);
            }
        });
        buttonBar.addComponent((Component)this.addButton);
    }

    protected void constructButtonBar(Layout parent) {
        DefaultHorizontalLayout buttonBar = new DefaultHorizontalLayout();
        parent.addComponent((Component)buttonBar);
        if (!this.viewMode && !this.formOptions.isHideAddButton()) {
            this.constructAddButton((Layout)buttonBar);
        }
        this.postProcessButtonBar((Layout)buttonBar);
    }

    private void constructRemoveColumn() {
        if (!this.isViewMode() && this.formOptions.isShowRemoveButton()) {
            String removeMsg = this.messageService.getMessage("ocs.detail.remove", VaadinUtils.getLocale());
            this.table.addGeneratedColumn((Object)removeMsg, (Table.ColumnGenerator & Serializable)(source, itemId, columnId) -> {
                Button remove = new Button(removeMsg);
                remove.setIcon((Resource)FontAwesome.TRASH);
                remove.addClickListener((Button.ClickListener & Serializable)event -> {
                    this.table.removeItem(itemId);
                    this.setValue(this.extractValues());
                    this.setSelectedItem(null);
                });
                return remove;
            });
        }
    }

    private Set<T> extractValues() {
        HashSet set = new HashSet();
        this.table.getItemIds().stream().map(o -> this.table.getItem(o).getItemProperty((Object)VALUE).getValue()).filter(Objects::nonNull).forEach(t -> set.add((Serializable)t));
        return set;
    }

    public Button getAddButton() {
        return this.addButton;
    }

    public FormOptions getFormOptions() {
        return this.formOptions;
    }

    public void setFormOptions(FormOptions formOptions) {
        this.formOptions = formOptions;
    }

    public Integer getMaxLength() {
        return this.attributeModel.getMaxLength();
    }

    public Long getMaxValue() {
        return this.attributeModel.getMaxValue();
    }

    public Integer getMinLength() {
        return this.attributeModel.getMinLength();
    }

    public Long getMinValue() {
        return this.attributeModel.getMinValue();
    }

    public int getPageLength() {
        return this.pageLength;
    }

    public void setPageLength(int pageLength) {
        this.pageLength = pageLength;
    }

    public ModelBasedEditForm<?, ?> getParentForm() {
        return this.parentForm;
    }

    private void setParentForm(ModelBasedEditForm<?, ?> parentForm) {
        this.parentForm = parentForm;
        if (parentForm != null) {
            parentForm.signalDetailsComponentValid(this, VaadinUtils.allFixedTableFieldsValid(this.table));
        }
    }

    public Object getSelectedItem() {
        return this.selectedItem;
    }

    public void setSelectedItem(String selectedItem) {
        this.selectedItem = selectedItem;
    }

    public Table getTable() {
        return this.table;
    }

    public Class<? extends Collection<T>> getType() {
        return Collection.class;
    }

    protected Component initContent() {
        this.table.addContainerProperty((Object)VALUE, this.attributeModel.getNormalizedType(), null);
        this.table.setColumnHeader((Object)VALUE, this.messageService.getMessage("ocs.value", VaadinUtils.getLocale()));
        this.table.setEditable(!this.isViewMode());
        this.table.setMultiSelect(false);
        this.table.setPageLength(this.pageLength);
        this.table.setColumnCollapsingAllowed(false);
        this.table.setSizeFull();
        this.table.setTableFieldFactory((TableFieldFactory)new DefaultFieldFactory(){

            public Field<?> createField(Container container, Object itemId, Object propertyId, Component uiContext) {
                Field f = super.createField(container, itemId, propertyId, uiContext);
                if (f instanceof TextField) {
                    TextField tf = (TextField)f;
                    tf.setNullRepresentation("");
                    tf.setSizeFull();
                    tf.setConverter(ConverterFactory.createConverterFor(CollectionTable.this.attributeModel.getNormalizedType(), CollectionTable.this.attributeModel, SystemPropertyUtils.useThousandsGroupingInEditMode()));
                    tf.setRequired(true);
                    tf.setRequiredError("may not be null");
                }
                if (CollectionTable.this.attributeModel.getMaxLength() != null) {
                    f.addValidator((Validator)new StringLengthValidator(CollectionTable.this.messageService.getMessage("ocs.value.too.long", VaadinUtils.getLocale(), new Object[]{CollectionTable.this.attributeModel.getMaxLength()}), Integer.valueOf(0), CollectionTable.this.attributeModel.getMaxLength(), true));
                }
                if (CollectionTable.this.attributeModel.getMinLength() != null) {
                    f.addValidator((Validator)new StringLengthValidator(CollectionTable.this.messageService.getMessage("ocs.value.too.short", VaadinUtils.getLocale(), new Object[]{CollectionTable.this.attributeModel.getMinLength()}), CollectionTable.this.attributeModel.getMinLength(), Integer.valueOf(Integer.MAX_VALUE), true));
                }
                if (CollectionTable.this.attributeModel.getMinValue() != null) {
                    if (NumberUtils.isInteger((Class)CollectionTable.this.attributeModel.getNormalizedType())) {
                        f.addValidator((Validator)new IntegerRangeValidator(CollectionTable.this.messageService.getMessage("ocs.value.too.low", VaadinUtils.getLocale(), new Object[]{CollectionTable.this.attributeModel.getMinValue()}), Integer.valueOf(CollectionTable.this.attributeModel.getMinValue().intValue()), null));
                    } else if (NumberUtils.isLong((Class)CollectionTable.this.attributeModel.getNormalizedType())) {
                        f.addValidator((Validator)new LongRangeValidator(CollectionTable.this.messageService.getMessage("ocs.value.too.low", VaadinUtils.getLocale(), new Object[]{CollectionTable.this.attributeModel.getMinValue()}), CollectionTable.this.attributeModel.getMinValue(), null));
                    }
                }
                if (CollectionTable.this.attributeModel.getMaxValue() != null) {
                    if (NumberUtils.isInteger((Class)CollectionTable.this.attributeModel.getNormalizedType())) {
                        f.addValidator((Validator)new IntegerRangeValidator(CollectionTable.this.messageService.getMessage("ocs.value.too.high", VaadinUtils.getLocale(), new Object[]{CollectionTable.this.attributeModel.getMaxValue()}), null, Integer.valueOf(CollectionTable.this.attributeModel.getMaxValue().intValue())));
                    } else if (NumberUtils.isLong((Class)CollectionTable.this.attributeModel.getNormalizedType())) {
                        f.addValidator((Validator)new LongRangeValidator(CollectionTable.this.messageService.getMessage("ocs.value.too.high", VaadinUtils.getLocale(), new Object[]{CollectionTable.this.attributeModel.getMaxValue()}), null, CollectionTable.this.attributeModel.getMaxValue()));
                    }
                }
                f.addValueChangeListener((Property.ValueChangeListener & Serializable)event -> {
                    if (CollectionTable.this.propagateChanges) {
                        CollectionTable.this.propagateChanges = false;
                        CollectionTable.this.setValue(CollectionTable.this.extractValues());
                        CollectionTable.this.parentForm.signalDetailsComponentValid(CollectionTable.this, VaadinUtils.allFixedTableFieldsValid(CollectionTable.this.table));
                        CollectionTable.this.propagateChanges = true;
                    }
                });
                return f;
            }
        });
        this.table.addValueChangeListener((Property.ValueChangeListener & Serializable)event -> {
            this.selectedItem = this.table.getValue();
            this.onSelect(this.table.getValue());
        });
        this.constructRemoveColumn();
        DefaultVerticalLayout layout = new DefaultVerticalLayout(false, true);
        layout.addComponent((Component)this.table);
        this.constructButtonBar((Layout)layout);
        ModelBasedEditForm parent = VaadinUtils.getParentOfClass((Component)this, ModelBasedEditForm.class);
        this.setParentForm(parent);
        return layout;
    }

    public boolean isViewMode() {
        return this.viewMode;
    }

    public void setViewMode(boolean viewMode) {
        this.viewMode = viewMode;
    }

    protected void onSelect(Object selected) {
    }

    protected void postProcessButtonBar(Layout buttonBar) {
    }

    protected void setInternalValue(Collection<T> newValue) {
        if (this.propagateChanges && this.table != null) {
            this.table.setContainerDataSource((Container)new IndexedContainer());
            this.table.addContainerProperty((Object)VALUE, this.attributeModel.getNormalizedType(), null);
            if (this.table.removeGeneratedColumn((Object)this.messageService.getMessage("ocs.remove", VaadinUtils.getLocale()))) {
                this.constructRemoveColumn();
            }
            if (newValue != null) {
                for (Serializable t : newValue) {
                    Object o = this.table.addItem();
                    this.table.getItem(o).getItemProperty((Object)VALUE).setValue((Object)t);
                }
            }
        }
        super.setInternalValue(newValue);
    }

    @Override
    public boolean validateAllFields() {
        boolean error = false;
        for (Component next : this.table) {
            if (!(next instanceof AbstractField)) continue;
            try {
                ((AbstractField)next).validate();
                ((AbstractField)next).setComponentError(null);
            }
            catch (Validator.InvalidValueException ex) {
                error = true;
                ((AbstractField)next).setComponentError((ErrorMessage)new UserError(ex.getLocalizedMessage()));
            }
        }
        return error;
    }
}

