/*
 * Decompiled with CFR 0.152.
 */
package com.ocs.dynamo.ui.composite.form;

import com.ocs.dynamo.domain.AbstractEntity;
import com.ocs.dynamo.domain.model.AttributeModel;
import com.ocs.dynamo.domain.model.EntityModel;
import com.ocs.dynamo.service.BaseService;
import com.ocs.dynamo.service.MessageService;
import com.ocs.dynamo.service.ServiceLocatorFactory;
import com.ocs.dynamo.ui.component.DefaultHorizontalLayout;
import com.ocs.dynamo.ui.component.DefaultVerticalLayout;
import com.ocs.dynamo.ui.composite.form.ModelBasedEditForm;
import com.ocs.dynamo.ui.composite.form.ReceivesSignal;
import com.ocs.dynamo.ui.composite.form.SignalsParent;
import com.ocs.dynamo.ui.composite.form.UseInViewMode;
import com.ocs.dynamo.ui.composite.layout.FormOptions;
import com.ocs.dynamo.ui.utils.VaadinUtils;
import com.ocs.dynamo.util.ValidationMode;
import com.vaadin.data.Container;
import com.vaadin.server.FontAwesome;
import com.vaadin.server.Resource;
import com.vaadin.ui.Alignment;
import com.vaadin.ui.Button;
import com.vaadin.ui.Component;
import com.vaadin.ui.CustomField;
import com.vaadin.ui.Field;
import com.vaadin.ui.HorizontalLayout;
import com.vaadin.ui.Layout;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class DetailsEditLayout<ID extends Serializable, T extends AbstractEntity<ID>>
extends CustomField<Collection<T>>
implements SignalsParent,
ReceivesSignal,
UseInViewMode {
    private static final long serialVersionUID = -1203245694503350276L;
    private boolean onSameLine;
    private boolean alignRight;
    private Button addButton;
    private final EntityModel<T> entityModel;
    private Map<String, String> fieldEntityModels = new HashMap<String, String>();
    private final AttributeModel attributeModel;
    private Comparator<T> comparator;
    private Map<String, Container.Filter> fieldFilters = new HashMap<String, Container.Filter>();
    private FormOptions formOptions;
    private List<T> items;
    private final MessageService messageService;
    private ReceivesSignal receiver;
    private boolean viewMode;
    private BaseService<ID, T> service;
    private List<FormContainer> forms = new ArrayList<FormContainer>();
    private Map<SignalsParent, Boolean> detailComponentsValid = new HashMap<SignalsParent, Boolean>();
    private Layout mainFormContainer;

    public DetailsEditLayout(BaseService<ID, T> service, Collection<T> items, EntityModel<T> entityModel, AttributeModel attributeModel, boolean viewMode, FormOptions formOptions, Comparator<T> comparator, boolean onSameLine, boolean alignRight) {
        this.service = service;
        this.entityModel = entityModel;
        this.attributeModel = attributeModel;
        this.messageService = ServiceLocatorFactory.getServiceLocator().getMessageService();
        this.comparator = comparator;
        this.items = new ArrayList<T>();
        this.items.addAll(items);
        this.onSameLine = onSameLine;
        this.viewMode = viewMode;
        this.formOptions = formOptions;
        this.alignRight = alignRight;
    }

    private void addDetailEditForm(T t) {
        ModelBasedEditForm editForm = new ModelBasedEditForm<ID, T>((AbstractEntity)t, (BaseService)this.service, (EntityModel)this.entityModel, this.formOptions, this.fieldFilters){
            private static final long serialVersionUID = -7229109969816505927L;

            @Override
            protected void afterLayoutBuilt(Layout layout, boolean viewMode) {
                DetailsEditLayout.this.afterLayoutBuilt(this, viewMode);
            }

            @Override
            protected void afterModeChanged(boolean viewMode) {
                DetailsEditLayout.this.afterModeChanged(this, viewMode);
            }

            @Override
            protected Field<?> constructCustomField(EntityModel<T> entityModel, AttributeModel attributeModel, boolean viewMode) {
                return DetailsEditLayout.this.constructCustomField(entityModel, attributeModel, viewMode);
            }

            @Override
            protected void postProcessEditFields() {
                super.postProcessEditFields();
                DetailsEditLayout.this.postProcessEditFields(this);
            }
        };
        editForm.setFieldEntityModels(this.getFieldEntityModels());
        editForm.setFieldFilters(this.fieldFilters);
        editForm.setNestedMode(true);
        editForm.setViewMode(this.viewMode);
        editForm.build();
        FormContainer fc = new FormContainer(editForm, this.onSameLine){
            private static final long serialVersionUID = 6186428121967857827L;

            @Override
            public void postProcessButtonBar(Layout buttonBar) {
                DetailsEditLayout.this.postProcessDetailButtonBar(DetailsEditLayout.this.forms.size(), buttonBar, DetailsEditLayout.this.viewMode);
            }
        };
        this.forms.add(fc);
        this.mainFormContainer.addComponent((Component)fc);
        editForm.setReceiver(this);
        this.detailComponentsValid.put(editForm, editForm.isValid());
        ReceivesSignal receiver = VaadinUtils.getParentOfClass((Component)this, ReceivesSignal.class);
        if (receiver != null) {
            receiver.signalDetailsComponentValid(this, this.isAllValid());
        }
    }

    public final void addFieldEntityModel(String path, String reference) {
        this.fieldEntityModels.put(path, reference);
    }

    protected void afterLayoutBuilt(ModelBasedEditForm<ID, T> editForm, boolean viewMode) {
    }

    protected void afterModeChanged(ModelBasedEditForm<ID, T> editForm, boolean viewMode) {
    }

    protected void constructAddButton(HorizontalLayout buttonBar) {
        this.addButton = new Button(this.messageService.getMessage("ocs.add", VaadinUtils.getLocale()));
        this.addButton.setIcon((Resource)FontAwesome.PLUS);
        this.addButton.addClickListener((Button.ClickListener & Serializable)event -> {
            Object t = this.createEntity();
            this.items.add(t);
            this.addDetailEditForm(t);
            if (this.receiver != null) {
                this.receiver.signalDetailsComponentValid(this, this.isAllValid());
            }
        });
        this.addButton.setVisible(!this.viewMode && !this.formOptions.isHideAddButton());
        buttonBar.addComponent((Component)this.addButton);
        if (this.alignRight) {
            this.addButton.setSizeUndefined();
            buttonBar.setComponentAlignment((Component)this.addButton, Alignment.MIDDLE_RIGHT);
        }
    }

    protected void constructButtonBar(Layout parent) {
        DefaultHorizontalLayout buttonBar = new DefaultHorizontalLayout();
        if (this.alignRight) {
            buttonBar.setSizeFull();
        }
        buttonBar.setVisible(!this.viewMode);
        parent.addComponent((Component)buttonBar);
        this.constructAddButton(buttonBar);
        this.postProcessButtonBar((Layout)buttonBar);
    }

    protected Field<?> constructCustomField(EntityModel<T> entityModel, AttributeModel attributeModel, boolean viewMode) {
        return null;
    }

    protected abstract T createEntity();

    public Button getAddButton() {
        return this.addButton;
    }

    public Comparator<T> getComparator() {
        return this.comparator;
    }

    public T getEntity(int index) {
        if (index < this.forms.size()) {
            return this.forms.get(index).getEntity();
        }
        return null;
    }

    public EntityModel<T> getEntityModel() {
        return this.entityModel;
    }

    public Map<String, String> getFieldEntityModels() {
        return this.fieldEntityModels;
    }

    public Map<String, Container.Filter> getFieldFilters() {
        return this.fieldFilters;
    }

    public FormOptions getFormOptions() {
        return this.formOptions;
    }

    public Collection<T> getItems() {
        return this.items;
    }

    public ReceivesSignal getReceiver() {
        return this.receiver;
    }

    public Class<? extends Collection<T>> getType() {
        return Collection.class;
    }

    protected Component initContent() {
        DefaultVerticalLayout layout = new DefaultVerticalLayout(false, true);
        this.setCaption(this.attributeModel.getDisplayName());
        this.mainFormContainer = new DefaultVerticalLayout(false, false);
        layout.addComponent((Component)this.mainFormContainer);
        if (this.comparator != null) {
            this.items.sort(this.comparator);
        }
        for (AbstractEntity t : this.items) {
            this.addDetailEditForm(t);
        }
        this.constructButtonBar((Layout)layout);
        ReceivesSignal receiver = VaadinUtils.getParentOfClass((Component)this, ReceivesSignal.class);
        this.setReceiver(receiver);
        this.postConstruct();
        return layout;
    }

    private boolean isAllValid() {
        return this.detailComponentsValid.values().stream().allMatch(x -> x);
    }

    public boolean isOnSameLine() {
        return this.onSameLine;
    }

    public boolean isViewMode() {
        return this.viewMode;
    }

    protected void postConstruct() {
    }

    protected void postProcessButtonBar(Layout buttonBar) {
    }

    protected void postProcessDetailButtonBar(int index, Layout buttonBar, boolean viewMode) {
    }

    protected void postProcessEditFields(ModelBasedEditForm<ID, T> editForm) {
    }

    protected abstract void removeEntity(T var1);

    public void setComparator(Comparator<T> comparator) {
        this.comparator = comparator;
    }

    public void setDeleteEnabled(int index, boolean allowed) {
        if (index < this.forms.size()) {
            this.forms.get(index).setDeleteAllowed(allowed);
        }
    }

    public void setDeleteVisible(int index, boolean visible) {
        if (index < this.forms.size()) {
            this.forms.get(index).setDeleteVisible(visible);
        }
    }

    public void setEntity(int index, T entity) {
        if (index < this.forms.size()) {
            this.forms.get(index).setEntity(entity);
        }
    }

    public void setFieldEnabled(int index, String path, boolean enabled) {
        if (index < this.forms.size()) {
            this.forms.get(index).setFieldEnabled(path, enabled);
        }
    }

    public void setFieldVisible(int index, String path, boolean visible) {
        if (index < this.forms.size()) {
            this.forms.get(index).setFieldVisible(path, visible);
        }
    }

    public void setFieldEntityModels(Map<String, String> fieldEntityModels) {
        this.fieldEntityModels = fieldEntityModels;
    }

    public void setFieldFilters(Map<String, Container.Filter> fieldFilters) {
        this.fieldFilters = fieldFilters;
    }

    public void setFormOptions(FormOptions formOptions) {
        this.formOptions = formOptions;
    }

    protected void setInternalValue(Collection<T> newValue) {
        this.setItems(newValue);
        super.setInternalValue(newValue);
    }

    public void setItems(Collection<T> items) {
        ArrayList<T> list = new ArrayList<T>();
        list.addAll(items);
        if (this.comparator != null) {
            list.sort(this.comparator);
        }
        this.items = list;
        if (this.mainFormContainer != null) {
            this.mainFormContainer.removeAllComponents();
            this.forms.clear();
            for (AbstractEntity t : items) {
                this.addDetailEditForm(t);
            }
        }
    }

    public void setOnSameLine(boolean onSameLine) {
        this.onSameLine = onSameLine;
    }

    private void setReceiver(ReceivesSignal receiver) {
        this.receiver = receiver;
        if (receiver != null && ValidationMode.DISABLE_BUTTON.equals((Object)this.getFormOptions().getValidationMode())) {
            receiver.signalDetailsComponentValid(this, this.isAllValid());
        }
    }

    public void setService(BaseService<ID, T> service) {
        this.service = service;
    }

    public void setValue(Collection<T> newFieldValue) {
        this.setItems(newFieldValue);
        super.setValue(newFieldValue);
    }

    @Override
    public void signalDetailsComponentValid(SignalsParent component, boolean valid) {
        if (ValidationMode.DISABLE_BUTTON.equals((Object)this.getFormOptions().getValidationMode())) {
            this.detailComponentsValid.put(component, valid);
            if (this.receiver != null) {
                this.receiver.signalDetailsComponentValid(this, this.isAllValid());
            }
        }
    }

    @Override
    public boolean validateAllFields() {
        boolean error = false;
        if (ValidationMode.VALIDATE_DIRECTLY.equals((Object)this.getFormOptions().getValidationMode())) {
            for (FormContainer f : this.forms) {
                error |= f.validateAllFields();
            }
        }
        return error;
    }

    public void signalModeChange(boolean viewMode) {
    }

    private class FormContainer
    extends DefaultVerticalLayout {
        private static final long serialVersionUID = 3507638736422806589L;
        private ModelBasedEditForm<ID, T> form;
        private Button deleteButton;
        private HorizontalLayout buttonBar;

        FormContainer(ModelBasedEditForm<ID, T> form, boolean sameLine) {
            super(false, true);
            this.setStyleName(sameLine ? "formContainerSameLine" : "formContainer");
            this.form = form;
            if (!DetailsEditLayout.this.viewMode) {
                this.buttonBar = new DefaultHorizontalLayout(false, true, true);
                if (!sameLine) {
                    this.addComponent((Component)form);
                    this.addComponent((Component)this.buttonBar);
                } else {
                    DefaultHorizontalLayout hz = new DefaultHorizontalLayout(false, true, true);
                    hz.setSizeFull();
                    this.addComponent((Component)hz);
                    hz.addComponent((Component)form);
                    hz.setExpandRatio((Component)form, 0.8f);
                    hz.addComponent((Component)this.buttonBar);
                }
                this.deleteButton = new Button(DetailsEditLayout.this.messageService.getMessage("ocs.remove", VaadinUtils.getLocale()));
                this.deleteButton.setIcon((Resource)FontAwesome.TRASH);
                this.deleteButton.addClickListener((Button.ClickListener & Serializable)event -> {
                    DetailsEditLayout.this.removeEntity(this.form.getEntity());
                    DetailsEditLayout.this.items.remove(this.form.getEntity());
                    DetailsEditLayout.this.mainFormContainer.removeComponent((Component)this);
                    DetailsEditLayout.this.forms.remove((Object)this);
                    DetailsEditLayout.this.detailComponentsValid.remove(form);
                    DetailsEditLayout.this.receiver.signalDetailsComponentValid(DetailsEditLayout.this, DetailsEditLayout.this.isAllValid());
                });
                this.buttonBar.addComponent((Component)this.deleteButton);
                this.postProcessButtonBar((Layout)this.buttonBar);
            } else {
                this.addComponent((Component)form);
            }
        }

        public T getEntity() {
            return this.form.getEntity();
        }

        public void postProcessButtonBar(Layout buttonBar) {
        }

        public void setDeleteAllowed(boolean enabled) {
            if (this.deleteButton != null) {
                this.deleteButton.setEnabled(enabled);
            }
        }

        public void setDeleteVisible(boolean visible) {
            if (this.deleteButton != null) {
                this.deleteButton.setVisible(visible);
            }
        }

        public void setEntity(T t) {
            this.form.setEntity(t);
        }

        public void setFieldEnabled(String path, boolean enabled) {
            this.form.getFieldOptional(path).ifPresent(f -> f.setEnabled(enabled));
        }

        public void setFieldVisible(String path, boolean visible) {
            this.form.getFieldOptional(path).ifPresent(f -> f.setVisible(visible));
        }

        public boolean validateAllFields() {
            return this.form.validateAllFields();
        }

        public ModelBasedEditForm<ID, T> getForm() {
            return this.form;
        }
    }
}

