/*
 * Decompiled with CFR 0.152.
 */
package com.ocs.dynamo.ui.composite.form;

import com.google.common.collect.Lists;
import com.ocs.dynamo.dao.FetchJoinInformation;
import com.ocs.dynamo.domain.AbstractEntity;
import com.ocs.dynamo.domain.model.AttributeModel;
import com.ocs.dynamo.domain.model.EntityModel;
import com.ocs.dynamo.domain.model.impl.ModelBasedFieldFactory;
import com.ocs.dynamo.exception.OCSRuntimeException;
import com.ocs.dynamo.service.BaseService;
import com.ocs.dynamo.service.MessageService;
import com.ocs.dynamo.service.ServiceLocatorFactory;
import com.ocs.dynamo.ui.component.DefaultHorizontalLayout;
import com.ocs.dynamo.ui.component.DefaultVerticalLayout;
import com.ocs.dynamo.ui.composite.dialog.ModelBasedSearchDialog;
import com.ocs.dynamo.ui.composite.form.ReceivesSignal;
import com.ocs.dynamo.ui.composite.form.SignalsParent;
import com.ocs.dynamo.ui.composite.form.UseInViewMode;
import com.ocs.dynamo.ui.composite.layout.FormOptions;
import com.ocs.dynamo.ui.composite.table.ModelBasedTable;
import com.ocs.dynamo.ui.utils.VaadinUtils;
import com.vaadin.data.Container;
import com.vaadin.data.Property;
import com.vaadin.data.Validator;
import com.vaadin.data.sort.SortOrder;
import com.vaadin.data.util.BeanItemContainer;
import com.vaadin.server.ErrorMessage;
import com.vaadin.server.FontAwesome;
import com.vaadin.server.Resource;
import com.vaadin.server.UserError;
import com.vaadin.ui.AbstractField;
import com.vaadin.ui.Button;
import com.vaadin.ui.Component;
import com.vaadin.ui.CustomField;
import com.vaadin.ui.Field;
import com.vaadin.ui.Layout;
import com.vaadin.ui.Table;
import com.vaadin.ui.UI;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public abstract class DetailsEditTable<ID extends Serializable, T extends AbstractEntity<ID>>
extends CustomField<Collection<T>>
implements SignalsParent,
UseInViewMode {
    private static final long serialVersionUID = -1203245694503350276L;
    private Button addButton;
    private Comparator<T> comparator;
    private BeanItemContainer<T> container;
    private final EntityModel<T> entityModel;
    private Map<String, Container.Filter> fieldFilters = new HashMap<String, Container.Filter>();
    private FormOptions formOptions;
    private Collection<T> items;
    private final MessageService messageService;
    private int pageLength = 3;
    private ReceivesSignal receiver;
    private Button searchDialogButton;
    private EntityModel<T> searchDialogEntityModel;
    private List<Container.Filter> searchDialogFilters;
    private SortOrder searchDialogSortOrder;
    private T selectedItem;
    private BaseService<ID, T> service;
    private ModelBasedTable<ID, T> table;
    private List<Button> toUpdate = new ArrayList<Button>();
    private UI ui = UI.getCurrent();
    private ModelBasedSearchDialog<ID, T> dialog;
    private boolean viewMode;

    public DetailsEditTable(Collection<T> items, EntityModel<T> entityModel, boolean viewMode, FormOptions formOptions) {
        this.entityModel = entityModel;
        this.messageService = ServiceLocatorFactory.getServiceLocator().getMessageService();
        this.items = items;
        this.viewMode = viewMode;
        this.formOptions = formOptions;
    }

    public void afterItemsSelected(Collection<T> selectedItems) {
    }

    protected void checkButtonState(T selectedItem) {
        for (Button b : this.toUpdate) {
            b.setEnabled(selectedItem != null && this.mustEnableButton(b, selectedItem));
        }
    }

    protected void constructAddButton(Layout buttonBar) {
        this.addButton = new Button(this.messageService.getMessage("ocs.add", VaadinUtils.getLocale()));
        this.addButton.setIcon((Resource)FontAwesome.PLUS);
        this.addButton.addClickListener((Button.ClickListener & Serializable)event -> {
            Object t = this.createEntity();
            this.container.addBean(t);
            if (this.receiver != null) {
                this.receiver.signalDetailsComponentValid(this, VaadinUtils.allFixedTableFieldsValid(this.table));
            }
        });
        this.addButton.setVisible(this.isTableEditEnabled() && !this.formOptions.isHideAddButton());
        buttonBar.addComponent((Component)this.addButton);
    }

    protected void constructButtonBar(Layout parent) {
        DefaultHorizontalLayout buttonBar = new DefaultHorizontalLayout();
        parent.addComponent((Component)buttonBar);
        this.constructAddButton((Layout)buttonBar);
        this.constructSearchButton((Layout)buttonBar);
        this.postProcessButtonBar((Layout)buttonBar);
    }

    protected Field<?> constructCustomField(EntityModel<T> entityModel, AttributeModel attributeModel, boolean viewMode) {
        return null;
    }

    protected void constructSearchButton(Layout buttonBar) {
        this.searchDialogButton = new Button(this.messageService.getMessage("ocs.search", VaadinUtils.getLocale()));
        this.searchDialogButton.setIcon((Resource)FontAwesome.SEARCH);
        this.searchDialogButton.setDescription(this.messageService.getMessage("ocs.search.description", VaadinUtils.getLocale()));
        this.searchDialogButton.addClickListener((Button.ClickListener & Serializable)event -> {
            if (this.service == null) {
                throw new OCSRuntimeException(this.messageService.getMessage("ocs.no.service.specified", VaadinUtils.getLocale()));
            }
            this.dialog = new ModelBasedSearchDialog<ID, T>(this.service, this.searchDialogEntityModel != null ? this.searchDialogEntityModel : this.entityModel, this.searchDialogFilters, this.searchDialogSortOrder == null ? null : Lists.newArrayList((Object[])new SortOrder[]{this.searchDialogSortOrder}), true, true, new FetchJoinInformation[0]){

                @Override
                protected boolean doClose() {
                    Collection selected = this.getSelectedItems();
                    if (selected != null) {
                        DetailsEditTable.this.afterItemsSelected(selected);
                        for (AbstractEntity t : selected) {
                            DetailsEditTable.this.container.addBean((Object)t);
                        }
                    }
                    return true;
                }
            };
            this.dialog.build();
            this.ui.addWindow(this.dialog);
        });
        this.searchDialogButton.setVisible(!this.viewMode && this.formOptions.isDetailsTableSearchMode());
        buttonBar.addComponent((Component)this.searchDialogButton);
    }

    protected abstract T createEntity();

    public Button getAddButton() {
        return this.addButton;
    }

    public Comparator<T> getComparator() {
        return this.comparator;
    }

    public EntityModel<T> getEntityModel() {
        return this.entityModel;
    }

    public Map<String, Container.Filter> getFieldFilters() {
        return this.fieldFilters;
    }

    public FormOptions getFormOptions() {
        return this.formOptions;
    }

    public Collection<T> getItems() {
        return this.items;
    }

    public ReceivesSignal getReceiver() {
        return this.receiver;
    }

    public Button getSearchDialogButton() {
        return this.searchDialogButton;
    }

    public EntityModel<T> getSearchDialogEntityModel() {
        return this.searchDialogEntityModel;
    }

    public List<Container.Filter> getSearchDialogFilters() {
        return this.searchDialogFilters;
    }

    public SortOrder getSearchDialogSortOrder() {
        return this.searchDialogSortOrder;
    }

    public T getSelectedItem() {
        return this.selectedItem;
    }

    public BaseService<ID, T> getService() {
        return this.service;
    }

    public ModelBasedTable<ID, T> getTable() {
        return this.table;
    }

    public Class<? extends Collection<T>> getType() {
        return Collection.class;
    }

    protected Component initContent() {
        this.container = new BeanItemContainer(this.entityModel.getEntityClass());
        this.container.addAll(this.items);
        this.table = new ModelBasedTable((Container)this.container, this.entityModel, false);
        if (!this.isViewMode() && this.formOptions.isShowRemoveButton()) {
            String removeMsg = this.messageService.getMessage("ocs.detail.remove", VaadinUtils.getLocale());
            this.table.addGeneratedColumn(removeMsg, (Table.ColumnGenerator & Serializable)(source, itemId, columnId) -> {
                Button remove = new Button(removeMsg);
                remove.setIcon((Resource)FontAwesome.TRASH);
                remove.addClickListener((Button.ClickListener & Serializable)event -> {
                    this.container.removeItem(itemId);
                    this.items.remove(itemId);
                    this.removeEntity((AbstractEntity)itemId);
                    if (this.receiver != null) {
                        this.receiver.signalDetailsComponentValid(this, VaadinUtils.allFixedTableFieldsValid(this.table));
                    }
                });
                return remove;
            });
        }
        this.table.setTableFieldFactory(new ModelBasedFieldFactory<T>(this.entityModel, this.messageService, true, false){

            @Override
            public Field<?> createField(String propertyId, EntityModel<?> fieldEntityModel) {
                AttributeModel attributeModel = DetailsEditTable.this.entityModel.getAttributeModel(propertyId);
                Object field = DetailsEditTable.this.constructCustomField(DetailsEditTable.this.entityModel, attributeModel, DetailsEditTable.this.isTableEditEnabled());
                if (field == null) {
                    Container.Filter filter = DetailsEditTable.this.fieldFilters == null ? null : (Container.Filter)DetailsEditTable.this.fieldFilters.get(attributeModel.getName());
                    field = filter != null ? this.constructComboBox(attributeModel.getNestedEntityModel(), attributeModel, filter, false) : super.createField(propertyId, fieldEntityModel);
                }
                if (field != null) {
                    field.setEnabled(DetailsEditTable.this.isTableEditEnabled());
                    field.setSizeFull();
                    if (!DetailsEditTable.this.viewMode) {
                        field.addValueChangeListener((Property.ValueChangeListener & Serializable)event -> {
                            if (DetailsEditTable.this.receiver != null) {
                                DetailsEditTable.this.receiver.signalDetailsComponentValid(DetailsEditTable.this, VaadinUtils.allFixedTableFieldsValid(DetailsEditTable.this.table));
                            }
                        });
                        DetailsEditTable.this.postProcessTableField(propertyId, (Field<?>)field);
                    }
                }
                return field;
            }
        });
        this.table.setEditable(this.isTableEditEnabled());
        this.table.setMultiSelect(false);
        this.table.setPageLength(this.pageLength);
        this.table.setColumnCollapsingAllowed(false);
        DefaultVerticalLayout layout = new DefaultVerticalLayout(false, true);
        layout.addComponent((Component)this.table);
        this.table.addValueChangeListener((Property.ValueChangeListener & Serializable)event -> {
            this.selectedItem = (AbstractEntity)this.table.getValue();
            this.onSelect(this.table.getValue());
            this.checkButtonState(this.selectedItem);
        });
        this.table.updateTableCaption();
        this.constructButtonBar((Layout)layout);
        ReceivesSignal receiver = VaadinUtils.getParentOfClass((Component)this, ReceivesSignal.class);
        this.setReceiver(receiver);
        this.postConstruct();
        return layout;
    }

    private boolean isTableEditEnabled() {
        return !this.viewMode && !this.formOptions.isDetailsTableSearchMode() && !this.formOptions.isReadOnly();
    }

    public boolean isViewMode() {
        return this.viewMode;
    }

    protected boolean mustEnableButton(Button button, T selectedItem) {
        return true;
    }

    protected void onSelect(Object selected) {
    }

    protected void postProcessButtonBar(Layout buttonBar) {
    }

    public void postProcessTableField(String propertyId, Field<?> field) {
    }

    public void registerButton(Button button) {
        if (button != null) {
            button.setEnabled(false);
            this.toUpdate.add(button);
        }
    }

    protected abstract void removeEntity(T var1);

    protected void postConstruct() {
    }

    public void setComparator(Comparator<T> comparator) {
        this.comparator = comparator;
    }

    public void setFieldFilters(Map<String, Container.Filter> fieldFilters) {
        this.fieldFilters = fieldFilters;
    }

    public void setFormOptions(FormOptions formOptions) {
        this.formOptions = formOptions;
    }

    protected void setInternalValue(Collection<T> newValue) {
        this.setItems(newValue);
        super.setInternalValue(newValue);
    }

    public void setItems(Collection<T> items) {
        ArrayList<T> list = new ArrayList<T>();
        list.addAll(items);
        if (this.comparator != null) {
            list.sort(this.comparator);
        }
        this.items = list;
        if (this.container != null) {
            this.container.removeAllItems();
            this.container.addAll(this.items);
        }
        this.setSelectedItem(null);
    }

    public void setPageLength(int pageLength) {
        this.pageLength = pageLength;
    }

    private void setReceiver(ReceivesSignal receiver) {
        this.receiver = receiver;
        if (receiver != null) {
            receiver.signalDetailsComponentValid(this, VaadinUtils.allFixedTableFieldsValid(this.table));
        }
    }

    public void setSearchDialogEntityModel(EntityModel<T> searchDialogEntityModel) {
        this.searchDialogEntityModel = searchDialogEntityModel;
    }

    public void setSearchDialogFilters(List<Container.Filter> searchDialogFilters) {
        this.searchDialogFilters = searchDialogFilters;
        if (this.dialog != null) {
            this.dialog.setFilters(searchDialogFilters);
        }
    }

    public void setSearchDialogSortOrder(SortOrder searchDialogSortOrder) {
        this.searchDialogSortOrder = searchDialogSortOrder;
    }

    public void setSelectedItem(T selectedItem) {
        this.selectedItem = selectedItem;
        this.checkButtonState(selectedItem);
    }

    public void setService(BaseService<ID, T> service) {
        this.service = service;
    }

    public void setValue(Collection<T> newFieldValue) {
        this.setItems(newFieldValue);
        super.setValue(newFieldValue);
    }

    @Override
    public boolean validateAllFields() {
        boolean error = false;
        Iterator component = this.table.iterator();
        while (component.hasNext()) {
            Component next = (Component)component.next();
            try {
                if (!(next instanceof AbstractField)) continue;
                ((AbstractField)next).validate();
                ((AbstractField)next).setComponentError(null);
            }
            catch (Validator.InvalidValueException ex) {
                error = true;
                ((AbstractField)next).setComponentError((ErrorMessage)new UserError(ex.getLocalizedMessage()));
            }
        }
        return error;
    }
}

