/*
 * Decompiled with CFR 0.152.
 */
package com.ocs.dynamo.ui.composite.form;

import com.ocs.dynamo.domain.model.AttributeModel;
import com.ocs.dynamo.filter.listener.FilterChangeEvent;
import com.ocs.dynamo.filter.listener.FilterListener;
import com.ocs.dynamo.ui.composite.form.ModelBasedSearchForm;
import com.ocs.dynamo.ui.utils.ConvertUtil;
import com.vaadin.data.Container;
import com.vaadin.data.Property;
import com.vaadin.data.util.converter.Converter;
import com.vaadin.data.util.filter.And;
import com.vaadin.data.util.filter.Compare;
import com.vaadin.data.util.filter.SimpleStringFilter;
import com.vaadin.ui.Component;
import com.vaadin.ui.Field;
import com.vaadin.ui.Slider;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public class FilterGroup {
    private final AttributeModel attributeModel;
    private final String propertyId;
    private final ModelBasedSearchForm.FilterType filterType;
    private final Component filterComponent;
    private final Field<?> field;
    private Container.Filter fieldFilter;
    private Container.Filter mainFilter;
    private final Field<?> auxField;
    private Container.Filter auxFieldFilter;
    private List<FilterListener> listeners = new ArrayList<FilterListener>();

    public FilterGroup(AttributeModel attributeModel, ModelBasedSearchForm.FilterType filterType, Component filterComponent, Field<?> field, Field<?> auxField) {
        this.attributeModel = attributeModel;
        this.propertyId = attributeModel.getPath();
        this.filterType = filterType;
        this.filterComponent = filterComponent;
        this.field = field;
        this.auxField = auxField;
        field.addValueChangeListener((Property.ValueChangeListener & Serializable)event -> {
            try {
                this.valueChange(this.field, ConvertUtil.convertSearchValue(this.attributeModel, event.getProperty().getValue()));
            }
            catch (Converter.ConversionException conversionException) {
                // empty catch block
            }
        });
        if (auxField != null) {
            auxField.addValueChangeListener((Property.ValueChangeListener & Serializable)event -> {
                try {
                    this.valueChange(this.auxField, ConvertUtil.convertSearchValue(this.attributeModel, event.getProperty().getValue()));
                }
                catch (Converter.ConversionException conversionException) {
                    // empty catch block
                }
            });
        }
    }

    public void addListener(FilterListener listener) {
        this.listeners.add(listener);
    }

    protected void broadcast(FilterChangeEvent event) {
        for (FilterListener listener : this.listeners) {
            listener.onFilterChange(event);
        }
    }

    public Field<Object> getAuxField() {
        return this.auxField;
    }

    public Field<Object> getField() {
        return this.field;
    }

    public Component getFilterComponent() {
        return this.filterComponent;
    }

    public List<FilterListener> getListeners() {
        return this.listeners;
    }

    public String getPropertyId() {
        return this.propertyId;
    }

    public void reset() {
        Slider slider;
        if (this.field instanceof Slider) {
            slider = (Slider)this.field;
            slider.setValue(Double.valueOf(slider.getMin()));
        } else {
            this.field.setValue(null);
        }
        if (this.auxField != null) {
            if (this.auxField instanceof Slider) {
                slider = (Slider)this.auxField;
                slider.setValue(Double.valueOf(slider.getMin()));
            } else {
                this.auxField.setValue(null);
            }
        }
    }

    public void setEnabled(boolean enabled) {
        this.field.setEnabled(enabled);
        if (this.auxField != null) {
            this.auxField.setEnabled(enabled);
        }
    }

    public void setListeners(List<FilterListener> listeners) {
        this.listeners = listeners;
    }

    public void valueChange(Field<?> field, Object value) {
        Container.Filter oldFilter = this.fieldFilter;
        Compare.Equal filter = null;
        switch (this.filterType) {
            case BETWEEN: {
                if (field == this.auxField) {
                    this.auxFieldFilter = value != null ? new Compare.LessOrEqual((Object)this.propertyId, value) : null;
                } else {
                    this.mainFilter = value != null ? new Compare.GreaterOrEqual((Object)this.propertyId, value) : null;
                }
                if (this.auxFieldFilter != null && this.mainFilter != null) {
                    filter = new And(new Container.Filter[]{this.mainFilter, this.auxFieldFilter});
                    break;
                }
                if (this.auxFieldFilter != null) {
                    filter = this.auxFieldFilter;
                    break;
                }
                filter = this.mainFilter;
                break;
            }
            case LIKE: {
                if (value == null) break;
                if (value instanceof Collection) {
                    filter = new Compare.Equal((Object)this.propertyId, value);
                    break;
                }
                String valueStr = value.toString();
                if (!StringUtils.isNotEmpty((String)valueStr)) break;
                filter = new SimpleStringFilter((Object)this.propertyId, valueStr, !this.attributeModel.isSearchCaseSensitive(), this.attributeModel.isSearchPrefixOnly());
                break;
            }
            default: {
                if (value == null || value instanceof Collection && ((Collection)value).isEmpty()) break;
                filter = new Compare.Equal((Object)this.propertyId, value);
            }
        }
        this.fieldFilter = filter;
        if (!this.listeners.isEmpty()) {
            this.broadcast(new FilterChangeEvent(this.propertyId, oldFilter, (Container.Filter)filter, value));
        }
    }
}

