/*
 * Decompiled with CFR 0.152.
 */
package com.ocs.dynamo.ui.composite.form;

import com.ocs.dynamo.dao.FetchJoinInformation;
import com.ocs.dynamo.domain.AbstractEntity;
import com.ocs.dynamo.domain.model.AttributeModel;
import com.ocs.dynamo.domain.model.AttributeType;
import com.ocs.dynamo.domain.model.CascadeMode;
import com.ocs.dynamo.domain.model.EditableType;
import com.ocs.dynamo.domain.model.EntityModel;
import com.ocs.dynamo.domain.model.impl.ModelBasedFieldFactory;
import com.ocs.dynamo.exception.OCSRuntimeException;
import com.ocs.dynamo.service.BaseService;
import com.ocs.dynamo.ui.CanAssignEntity;
import com.ocs.dynamo.ui.Refreshable;
import com.ocs.dynamo.ui.component.Cascadable;
import com.ocs.dynamo.ui.component.CollapsiblePanel;
import com.ocs.dynamo.ui.component.DefaultEmbedded;
import com.ocs.dynamo.ui.component.DefaultHorizontalLayout;
import com.ocs.dynamo.ui.component.DefaultVerticalLayout;
import com.ocs.dynamo.ui.component.QuickAddListSelect;
import com.ocs.dynamo.ui.component.URLField;
import com.ocs.dynamo.ui.composite.form.AbstractModelBasedForm;
import com.ocs.dynamo.ui.composite.form.CollectionTable;
import com.ocs.dynamo.ui.composite.form.DetailsEditLayout;
import com.ocs.dynamo.ui.composite.form.ReceivesSignal;
import com.ocs.dynamo.ui.composite.form.SignalsParent;
import com.ocs.dynamo.ui.composite.form.UseInViewMode;
import com.ocs.dynamo.ui.composite.layout.FormOptions;
import com.ocs.dynamo.ui.composite.type.AttributeGroupMode;
import com.ocs.dynamo.ui.composite.type.ScreenMode;
import com.ocs.dynamo.ui.utils.EntityModelUtil;
import com.ocs.dynamo.ui.utils.VaadinUtils;
import com.ocs.dynamo.util.SystemPropertyUtils;
import com.ocs.dynamo.util.ValidationMode;
import com.ocs.dynamo.utils.ClassUtils;
import com.vaadin.data.Container;
import com.vaadin.data.Item;
import com.vaadin.data.Property;
import com.vaadin.data.Validator;
import com.vaadin.data.fieldgroup.BeanFieldGroup;
import com.vaadin.data.util.BeanItem;
import com.vaadin.data.util.filter.Compare;
import com.vaadin.server.ErrorMessage;
import com.vaadin.server.FontAwesome;
import com.vaadin.server.Resource;
import com.vaadin.server.Sizeable;
import com.vaadin.server.StreamResource;
import com.vaadin.server.UserError;
import com.vaadin.shared.ui.label.ContentMode;
import com.vaadin.ui.AbstractField;
import com.vaadin.ui.Button;
import com.vaadin.ui.CheckBox;
import com.vaadin.ui.Component;
import com.vaadin.ui.CustomField;
import com.vaadin.ui.Embedded;
import com.vaadin.ui.Field;
import com.vaadin.ui.FormLayout;
import com.vaadin.ui.HasComponents;
import com.vaadin.ui.HorizontalLayout;
import com.vaadin.ui.Label;
import com.vaadin.ui.Layout;
import com.vaadin.ui.Notification;
import com.vaadin.ui.TabSheet;
import com.vaadin.ui.Upload;
import com.vaadin.ui.VerticalLayout;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.apache.commons.io.FilenameUtils;
import org.vaadin.teemu.switchui.Switch;

public class ModelBasedEditForm<ID extends Serializable, T extends AbstractEntity<ID>>
extends AbstractModelBasedForm<ID, T>
implements SignalsParent,
ReceivesSignal {
    private static final long serialVersionUID = 2201140375797069148L;
    private static final String EDIT_BUTTON_DATA = "editButton";
    private static final String SAVE_BUTTON_DATA = "saveButton";
    private static final String BACK_BUTTON_DATA = "backButton";
    private static final String CANCEL_BUTTON_DATA = "cancelButton";
    private static final String NEXT_BUTTON_DATA = "nextButton";
    private static final String PREV_BUTTON_DATA = "prevButton";
    private Map<Boolean, Map<String, Object>> attributeGroups = new HashMap<Boolean, Map<String, Object>>();
    private FetchJoinInformation[] detailJoins;
    private Map<SignalsParent, Boolean> detailComponentsValid = new HashMap<SignalsParent, Boolean>();
    private T entity;
    private ModelBasedFieldFactory<T> fieldFactory;
    private boolean fieldsProcessed;
    private Map<Boolean, BeanFieldGroup<T>> groups = new HashMap<Boolean, BeanFieldGroup<T>>();
    private Map<Boolean, Map<AttributeModel, Component>> labels = new HashMap<Boolean, Map<AttributeModel, Component>>();
    private VerticalLayout mainEditLayout;
    private VerticalLayout mainViewLayout;
    private Map<Boolean, List<Button>> buttons = new HashMap<Boolean, List<Button>>();
    private BaseService<ID, T> service;
    private Map<Boolean, TabSheet> tabSheets = new HashMap<Boolean, TabSheet>();
    private Map<Boolean, HorizontalLayout> titleBars = new HashMap<Boolean, HorizontalLayout>();
    private Map<Boolean, Label> titleLabels = new HashMap<Boolean, Label>();
    private Map<Boolean, Map<AttributeModel, Component>> uploads = new HashMap<Boolean, Map<AttributeModel, Component>>();
    private Map<Boolean, Map<AttributeModel, Component>> previews = new HashMap<Boolean, Map<AttributeModel, Component>>();
    private Map<Boolean, Set<String>> alreadyBound = new HashMap<Boolean, Set<String>>();
    private Map<Integer, Field<?>> firstFields = new HashMap();
    private ReceivesSignal receiver;
    private Integer formTitleWidth;
    private boolean supportsIteration;
    private boolean viewMode;
    private List<CanAssignEntity<ID, T>> assignEntityToFields = new ArrayList<CanAssignEntity<ID, T>>();
    private boolean nestedMode;
    private Consumer<T> customSaveConsumer;

    public ModelBasedEditForm(T entity, BaseService<ID, T> service, EntityModel<T> entityModel, FormOptions formOptions, Map<String, Container.Filter> fieldFilters) {
        super(formOptions, fieldFilters, entityModel);
        this.service = service;
        this.entity = entity;
        this.afterEntitySet(entity);
        Class clazz = service.getEntityClass();
        this.fieldFactory = ModelBasedFieldFactory.getInstance(entityModel, this.getMessageService());
        this.viewMode = !this.isEditAllowed() || formOptions.isOpenInViewMode() && entity.getId() != null;
        BeanItem beanItem = new BeanItem(entity);
        BeanFieldGroup group = new BeanFieldGroup(clazz);
        group.setItemDataSource((Item)beanItem);
        group.setBuffered(false);
        this.groups.put(Boolean.FALSE, group);
        beanItem = new BeanItem(entity);
        group = new BeanFieldGroup(clazz);
        group.setItemDataSource((Item)beanItem);
        group.setBuffered(false);
        this.groups.put(Boolean.TRUE, group);
        this.attributeGroups.put(Boolean.TRUE, new HashMap());
        this.attributeGroups.put(Boolean.FALSE, new HashMap());
        this.alreadyBound.put(Boolean.TRUE, new HashSet());
        this.alreadyBound.put(Boolean.FALSE, new HashSet());
        this.buttons.put(Boolean.TRUE, new ArrayList());
        this.buttons.put(Boolean.FALSE, new ArrayList());
    }

    private void addField(Layout parent, EntityModel<T> entityModel, AttributeModel attributeModel, int tabIndex, boolean sameRow) {
        AttributeType type = attributeModel.getAttributeType();
        if (!this.alreadyBound.get(this.isViewMode()).contains(attributeModel.getPath()) && attributeModel.isVisible() && (AttributeType.BASIC.equals((Object)type) || AttributeType.LOB.equals((Object)type) || attributeModel.isComplexEditable())) {
            if (EditableType.READ_ONLY.equals((Object)attributeModel.getEditableType()) || this.isViewMode()) {
                if (attributeModel.isUrl()) {
                    this.constructField(parent, entityModel, attributeModel, true, tabIndex, sameRow);
                } else if (AttributeType.LOB.equals((Object)type) && attributeModel.isImage()) {
                    Component c = this.constructImagePreview(attributeModel);
                    parent.addComponent(c);
                    this.previews.get(this.isViewMode()).put(attributeModel, c);
                } else if (AttributeType.DETAIL.equals((Object)type) && attributeModel.isComplexEditable()) {
                    Field<?> f = this.constructCustomField(entityModel, attributeModel, this.viewMode);
                    if (f instanceof UseInViewMode) {
                        this.constructField(parent, entityModel, attributeModel, true, tabIndex, sameRow);
                    } else {
                        this.constructLabel(parent, entityModel, attributeModel, tabIndex, sameRow);
                    }
                } else {
                    Field<?> f = this.constructCustomField(entityModel, attributeModel, this.viewMode);
                    if (f instanceof UseInViewMode) {
                        this.constructField(parent, entityModel, attributeModel, true, tabIndex, sameRow);
                    } else {
                        this.constructLabel(parent, entityModel, attributeModel, tabIndex, sameRow);
                    }
                }
            } else if (AttributeType.BASIC.equals((Object)type) || AttributeType.MASTER.equals((Object)type) || AttributeType.DETAIL.equals((Object)type) || AttributeType.ELEMENT_COLLECTION.equals((Object)type)) {
                this.constructField(parent, entityModel, attributeModel, false, tabIndex, sameRow);
            } else if (AttributeType.LOB.equals((Object)type)) {
                UploadComponent uploadForm = this.constructUploadField(attributeModel);
                parent.addComponent((Component)uploadForm);
                this.uploads.get(this.isViewMode()).put(attributeModel, (Component)uploadForm);
            }
            this.alreadyBound.get(this.isViewMode()).add(attributeModel.getPath());
        }
    }

    private void addTabChangeListener(TabSheet tabSheet) {
        tabSheet.addSelectedTabChangeListener((TabSheet.SelectedTabChangeListener & Serializable)event -> {
            Component c = event.getTabSheet().getSelectedTab();
            if (this.tabSheets.get(this.isViewMode()) != null && this.tabSheets.get(this.isViewMode()).getTab(c) != null) {
                int index = VaadinUtils.getTabIndex(this.tabSheets.get(this.isViewMode()), this.tabSheets.get(this.isViewMode()).getTab(c).getCaption());
                this.afterTabSelected(index);
                if (this.firstFields.get(index) != null) {
                    this.firstFields.get(index).focus();
                }
            }
        });
    }

    protected void afterEditDone(boolean cancel, boolean newObject, T entity) {
    }

    protected void afterEntitySet(T entity) {
    }

    protected void afterLayoutBuilt(Layout layout, boolean viewMode) {
    }

    protected void afterModeChanged(boolean viewMode) {
    }

    protected void afterTabSelected(int tabIndex) {
    }

    protected void back() {
    }

    @Override
    public void build() {
        if (this.isViewMode()) {
            if (this.mainViewLayout == null) {
                HashMap map = new HashMap();
                this.labels.put(Boolean.TRUE, map);
                HashMap uploadMap = new HashMap();
                this.uploads.put(Boolean.TRUE, uploadMap);
                HashMap previewMap = new HashMap();
                this.previews.put(Boolean.TRUE, previewMap);
                this.mainViewLayout = this.buildMainLayout(this.getEntityModel());
            }
            this.setCompositionRoot((Component)this.mainViewLayout);
        } else {
            if (this.mainEditLayout == null) {
                HashMap map = new HashMap();
                this.labels.put(Boolean.FALSE, map);
                HashMap uploadMap = new HashMap();
                this.uploads.put(Boolean.FALSE, uploadMap);
                HashMap previewMap = new HashMap();
                this.previews.put(Boolean.FALSE, previewMap);
                this.mainEditLayout = this.buildMainLayout(this.getEntityModel());
                if (!this.fieldsProcessed) {
                    this.postProcessEditFields();
                    this.fieldsProcessed = true;
                }
            }
            this.setCompositionRoot((Component)this.mainEditLayout);
        }
    }

    protected VerticalLayout buildMainLayout(EntityModel<T> entityModel) {
        DefaultVerticalLayout layout = new DefaultVerticalLayout(false, true);
        this.titleLabels.put(this.isViewMode(), this.constructTitleLabel());
        this.titleBars.put(this.isViewMode(), new DefaultHorizontalLayout(false, true, true));
        this.titleBars.get(this.isViewMode()).addComponent((Component)this.titleLabels.get(this.isViewMode()));
        HorizontalLayout buttonBar = null;
        if (!this.nestedMode) {
            buttonBar = this.constructButtonBar(false);
            buttonBar.setSizeUndefined();
            if (this.getFormOptions().isPlaceButtonBarAtTop()) {
                layout.addComponent((Component)buttonBar);
            } else {
                this.titleBars.get(this.isViewMode()).addComponent((Component)buttonBar);
            }
        }
        layout.addComponent((Component)this.titleBars.get(this.isViewMode()));
        this.titleBars.get(this.isViewMode()).setVisible(!this.nestedMode);
        Object form = null;
        form = entityModel.usesDefaultGroupOnly() ? new FormLayout() : new DefaultVerticalLayout(false, true);
        if (ScreenMode.VERTICAL.equals((Object)this.getFormOptions().getScreenMode())) {
            form.setStyleName("halfScreen");
        }
        if (!entityModel.usesDefaultGroupOnly()) {
            int tabIndex;
            boolean tabs = AttributeGroupMode.TABSHEET.equals((Object)this.getFormOptions().getAttributeGroupMode());
            if (tabs) {
                TabSheet tabSheet = new TabSheet();
                this.tabSheets.put(this.isViewMode(), tabSheet);
                form.addComponent((Component)tabSheet);
                this.addTabChangeListener(tabSheet);
            }
            if (this.getParentGroupHeaders() != null && this.getParentGroupHeaders().length > 0) {
                tabIndex = 0;
                for (String parentGroupHeader : this.getParentGroupHeaders()) {
                    boolean innerTabs;
                    Layout innerForm = this.constructAttributeGroupLayout((Layout)form, tabs, this.tabSheets.get(this.isViewMode()), parentGroupHeader, false);
                    TabSheet innerTabSheet = null;
                    boolean bl = innerTabs = !tabs;
                    if (innerTabs) {
                        innerTabSheet = new TabSheet();
                        innerForm.addComponent((Component)innerTabSheet);
                    }
                    this.processParentHeaderGroup(parentGroupHeader, innerForm, innerTabs, innerTabSheet, tabIndex);
                    ++tabIndex;
                }
            } else {
                tabIndex = 0;
                for (String attributeGroup : entityModel.getAttributeGroups()) {
                    if (!entityModel.isAttributeGroupVisible(attributeGroup, this.isViewMode())) continue;
                    Layout innerForm = this.constructAttributeGroupLayout((Layout)form, tabs, this.tabSheets.get(this.isViewMode()), attributeGroup, true);
                    if (ScreenMode.VERTICAL.equals((Object)this.getFormOptions().getScreenMode())) {
                        innerForm.setStyleName("halfScreen");
                    }
                    for (AttributeModel attributeModel : entityModel.getAttributeModelsForGroup(attributeGroup)) {
                        this.addField(innerForm, entityModel, attributeModel, tabIndex, false);
                    }
                    if (!AttributeGroupMode.TABSHEET.equals((Object)this.getFormOptions().getAttributeGroupMode())) continue;
                    ++tabIndex;
                }
            }
        } else {
            for (AttributeModel attributeModel : entityModel.getAttributeModels()) {
                this.addField((Layout)form, entityModel, attributeModel, 0, false);
            }
        }
        this.constructCascadeListeners();
        layout.addComponent((Component)form);
        if (this.firstFields.get(0) != null) {
            this.firstFields.get(0).focus();
        }
        if (!this.nestedMode) {
            buttonBar = this.constructButtonBar(true);
            buttonBar.setSizeUndefined();
            layout.addComponent((Component)buttonBar);
        } else {
            for (Field f : this.groups.get(this.isViewMode()).getFields()) {
                f.addValueChangeListener((Property.ValueChangeListener & Serializable)event -> {
                    if (this.receiver != null && ValidationMode.DISABLE_BUTTON.equals((Object)this.getFormOptions().getValidationMode())) {
                        this.receiver.signalDetailsComponentValid(this, this.isValid());
                    }
                    ((AbstractField)f).setComponentError(null);
                });
            }
        }
        this.checkSaveButtonState();
        this.disableCreateOnlyFields();
        this.afterLayoutBuilt((Layout)form, this.isViewMode());
        return layout;
    }

    private void checkIterationButtonState(boolean checkEnabled) {
        for (Button b : this.filterButtons(NEXT_BUTTON_DATA)) {
            b.setVisible(this.isSupportsIteration() && this.getFormOptions().isShowNextButton() && this.entity.getId() != null);
            if (checkEnabled && b.isVisible() && (this.isViewMode() || !this.getFormOptions().isOpenInViewMode())) {
                b.setEnabled(true);
                continue;
            }
            b.setEnabled(false);
        }
        for (Button b : this.filterButtons(PREV_BUTTON_DATA)) {
            b.setVisible(this.isSupportsIteration() && this.getFormOptions().isShowPrevButton() && this.entity.getId() != null);
            if (checkEnabled && b.isVisible() && (this.isViewMode() || !this.getFormOptions().isOpenInViewMode())) {
                b.setEnabled(true);
                continue;
            }
            b.setEnabled(false);
        }
    }

    private void checkSaveButtonState() {
        for (Button saveButton : this.buttons.get(this.isViewMode())) {
            if (!SAVE_BUTTON_DATA.equals(saveButton.getData())) continue;
            if (ValidationMode.DISABLE_BUTTON.equals((Object)this.getFormOptions().getValidationMode())) {
                saveButton.setEnabled(this.isValid());
                continue;
            }
            saveButton.setEnabled(true);
        }
    }

    public boolean isValid() {
        boolean valid = this.groups.get(this.isViewMode()).isValid();
        return valid &= this.detailComponentsValid.values().stream().allMatch(x -> x);
    }

    private Layout constructAttributeGroupLayout(Layout parent, boolean tabs, TabSheet tabSheet, String messageKey, boolean lowest) {
        Object innerLayout = null;
        if (lowest) {
            innerLayout = new FormLayout();
            innerLayout.setMargin(true);
            if (!tabs) {
                innerLayout.setStyleName("halfScreen");
            }
        } else {
            innerLayout = new DefaultVerticalLayout(true, true);
        }
        if (tabs) {
            TabSheet.Tab added = tabSheet.addTab((Component)innerLayout, this.message(messageKey));
            this.attributeGroups.get(this.isViewMode()).put(messageKey, added);
        } else {
            CollapsiblePanel panel = new CollapsiblePanel();
            panel.setStyleName("attributePanel");
            panel.setCaption(this.message(messageKey));
            panel.setContent((Component)innerLayout);
            parent.addComponent((Component)panel);
            this.attributeGroups.get(this.isViewMode()).put(messageKey, (Object)panel);
        }
        return innerLayout;
    }

    private HorizontalLayout constructButtonBar(boolean bottom) {
        DefaultHorizontalLayout buttonBar = new DefaultHorizontalLayout();
        Button backButton = new Button(this.message("ocs.back"));
        backButton.setIcon((Resource)FontAwesome.BACKWARD);
        backButton.addClickListener((Button.ClickListener & Serializable)event -> this.back());
        backButton.setVisible(this.isViewMode() && this.getFormOptions().isShowBackButton());
        backButton.setData((Object)BACK_BUTTON_DATA);
        buttonBar.addComponent((Component)backButton);
        this.buttons.get(this.isViewMode()).add(backButton);
        Button cancelButton = new Button(this.message("ocs.cancel"));
        cancelButton.setData((Object)CANCEL_BUTTON_DATA);
        cancelButton.addClickListener((Button.ClickListener & Serializable)event -> {
            if (this.entity.getId() != null) {
                this.entity = this.service.fetchById(this.entity.getId(), this.getDetailJoins());
            }
            this.afterEditDone(true, this.entity.getId() == null, this.entity);
        });
        cancelButton.setVisible(!this.isViewMode() && !this.getFormOptions().isHideCancelButton() || this.getFormOptions().isFormNested() && this.entity.getId() == null);
        cancelButton.setIcon((Resource)FontAwesome.BAN);
        buttonBar.addComponent((Component)cancelButton);
        this.buttons.get(this.isViewMode()).add(cancelButton);
        if (!this.isViewMode()) {
            Button saveButton = this.constructSaveButton(bottom);
            buttonBar.addComponent((Component)saveButton);
            this.buttons.get(this.isViewMode()).add(saveButton);
        }
        Button editButton = new Button(this.message("ocs.edit"));
        editButton.setIcon((Resource)FontAwesome.PENCIL);
        editButton.addClickListener((Button.ClickListener & Serializable)event -> this.setViewMode(false));
        buttonBar.addComponent((Component)editButton);
        this.buttons.get(this.isViewMode()).add(editButton);
        editButton.setData((Object)EDIT_BUTTON_DATA);
        editButton.setVisible(this.isViewMode() && this.getFormOptions().isEditAllowed() && this.isEditAllowed());
        Button prevButton = new Button(this.message("ocs.previous"));
        prevButton.setIcon((Resource)FontAwesome.ARROW_LEFT);
        prevButton.addClickListener((Button.ClickListener & Serializable)e -> {
            T prev = this.getPrevEntity(this.getEntity());
            if (prev != null) {
                this.setEntity(prev, true);
            } else {
                prevButton.setEnabled(false);
            }
        });
        prevButton.setData((Object)PREV_BUTTON_DATA);
        this.buttons.get(this.isViewMode()).add(prevButton);
        buttonBar.addComponent((Component)prevButton);
        Button nextButton = new Button(this.message("ocs.next"));
        nextButton.setIcon((Resource)FontAwesome.ARROW_RIGHT);
        nextButton.addClickListener((Button.ClickListener & Serializable)e -> {
            T next = this.getNextEntity(this.getEntity());
            if (next != null) {
                this.setEntity(next, true);
            } else {
                nextButton.setEnabled(false);
            }
        });
        nextButton.setData((Object)NEXT_BUTTON_DATA);
        this.buttons.get(this.isViewMode()).add(nextButton);
        buttonBar.addComponent((Component)nextButton);
        prevButton.setVisible(this.isSupportsIteration() && this.getFormOptions().isShowPrevButton() && this.entity.getId() != null);
        nextButton.setVisible(this.isSupportsIteration() && this.getFormOptions().isShowNextButton() && this.entity.getId() != null);
        this.postProcessButtonBar(buttonBar, this.isViewMode());
        return buttonBar;
    }

    private void constructCascadeListeners() {
        for (AttributeModel am : this.getEntityModel().getCascadeAttributeModels()) {
            Field field = this.groups.get(this.isViewMode()).getField((Object)am.getPath());
            if (field == null) continue;
            field.addValueChangeListener((Property.ValueChangeListener & Serializable)event -> {
                for (String cascadePath : am.getCascadeAttributes()) {
                    CascadeMode cm = am.getCascadeMode(cascadePath);
                    if (!CascadeMode.BOTH.equals((Object)cm) && !CascadeMode.EDIT.equals((Object)cm)) continue;
                    Field cascadeField = this.groups.get(this.isViewMode()).getField((Object)cascadePath);
                    if (cascadeField instanceof Cascadable) {
                        Cascadable ca = (Cascadable)cascadeField;
                        if (event.getProperty().getValue() == null) {
                            ca.clearAdditionalFilter();
                            continue;
                        }
                        ca.setAdditionalFilter((Container.Filter)new Compare.Equal((Object)am.getCascadeFilterPath(cascadePath), event.getProperty().getValue()));
                        continue;
                    }
                    throw new OCSRuntimeException("Cannot setup cascading from " + am.getPath() + " to " + cascadePath);
                }
            });
        }
    }

    protected Field<?> constructCustomField(EntityModel<T> entityModel, AttributeModel attributeModel, boolean viewMode) {
        return null;
    }

    private Component constructImagePreview(AttributeModel attributeModel) {
        byte[] bytes = ClassUtils.getBytes(this.getEntity(), (String)attributeModel.getName());
        DefaultEmbedded image = new DefaultEmbedded(attributeModel.getDisplayName(), bytes);
        image.setStyleName("fileUpload");
        return image;
    }

    private void constructField(Layout parent, EntityModel<T> entityModel, AttributeModel attributeModel, boolean viewMode, int tabIndex, boolean sameRow) {
        EntityModel<?> em = this.getFieldEntityModel(attributeModel);
        Field<?> field = this.constructCustomField(entityModel, attributeModel, viewMode);
        if (field == null) {
            field = this.fieldFactory.constructField(attributeModel, this.getFieldFilters(), em);
        }
        if (field instanceof URLField) {
            ((URLField)field).setEditable(!this.isViewMode() && !EditableType.CREATE_ONLY.equals((Object)attributeModel.getEditableType()));
        }
        if (field instanceof CollectionTable) {
            ((CollectionTable)field).setViewMode(this.isViewMode());
        }
        if (field instanceof QuickAddListSelect) {
            ((QuickAddListSelect)field).setViewMode(this.isViewMode());
        }
        if (field != null) {
            if (!(field instanceof Switch)) {
                Integer fieldWidth = SystemPropertyUtils.getDefaultFieldWidth();
                if (fieldWidth == null || sameRow || field instanceof DetailsEditLayout || !attributeModel.getGroupTogetherWith().isEmpty()) {
                    field.setSizeFull();
                } else {
                    field.setWidth(fieldWidth + "px");
                }
            }
            this.groups.get(viewMode).bind(field, (Object)attributeModel.getName());
            if (!attributeModel.getGroupTogetherWith().isEmpty()) {
                HorizontalLayout horizontal = this.constructRowLayout(attributeModel, attributeModel.isRequired(), !(field instanceof CheckBox));
                Integer fieldWidth = SystemPropertyUtils.getDefaultFieldWidth();
                if (fieldWidth == null || this.nestedMode) {
                    horizontal.setSizeFull();
                } else {
                    horizontal.setWidth(fieldWidth + "px");
                }
                parent.addComponent((Component)horizontal);
                if (!(field instanceof CheckBox)) {
                    field.setCaption("");
                }
                float sums = attributeModel.getExpansionFactor();
                for (String path : attributeModel.getGroupTogetherWith()) {
                    AttributeModel am = this.getEntityModel().getAttributeModel(path);
                    if (am == null) continue;
                    sums += am.getExpansionFactor();
                }
                FormLayout fl = this.constructNestedFormLayout(true);
                fl.addComponent(field);
                horizontal.addComponent((Component)fl);
                float ep = attributeModel.getExpansionFactor() / sums;
                horizontal.setExpandRatio((Component)fl, ep);
                for (String path : attributeModel.getGroupTogetherWith()) {
                    AttributeModel nestedAm = this.getEntityModel().getAttributeModel(path);
                    if (nestedAm == null) continue;
                    FormLayout fl2 = this.constructNestedFormLayout(false);
                    horizontal.addComponent((Component)fl2);
                    ep = nestedAm.getExpansionFactor() / sums;
                    this.addField((Layout)fl2, entityModel, nestedAm, tabIndex, true);
                    horizontal.setExpandRatio((Component)fl2, ep);
                }
            } else {
                parent.addComponent(field);
            }
        }
        if (this.entity.getId() == null && attributeModel.getDefaultValue() != null) {
            field.getPropertyDataSource().setValue(attributeModel.getDefaultValue());
        }
        if (!this.isViewMode() && this.firstFields.get(tabIndex) == null && field.isEnabled() && !(field instanceof CheckBox)) {
            this.firstFields.put(tabIndex, field);
        }
        if (field instanceof CanAssignEntity) {
            this.assignEntityToFields.add((CanAssignEntity)field);
        }
    }

    private void constructLabel(Layout parent, EntityModel<T> entityModel, AttributeModel attributeModel, int tabIndex, boolean sameRow) {
        Component label = this.constructLabel(this.entity, attributeModel);
        this.labels.get(this.isViewMode()).put(attributeModel, label);
        if (!attributeModel.getGroupTogetherWith().isEmpty()) {
            HorizontalLayout horizontal = this.constructRowLayout(attributeModel, false, true);
            parent.addComponent((Component)horizontal);
            label.setCaption("");
            FormLayout fl = this.constructNestedFormLayout(true);
            fl.addComponent(label);
            horizontal.addComponent((Component)fl);
            for (String path : attributeModel.getGroupTogetherWith()) {
                AttributeModel am = entityModel.getAttributeModel(path);
                if (am == null) continue;
                FormLayout fl2 = this.constructNestedFormLayout(false);
                horizontal.addComponent((Component)fl2);
                this.addField((Layout)fl2, this.getEntityModel(), am, tabIndex, sameRow);
            }
        } else {
            parent.addComponent(label);
        }
    }

    private FormLayout constructNestedFormLayout(boolean first) {
        FormLayout fl = new FormLayout();
        if (first) {
            fl.setStyleName("first", true);
        } else {
            fl.setStyleName("additional", true);
        }
        fl.setMargin(false);
        return fl;
    }

    private HorizontalLayout constructRowLayout(AttributeModel attributeModel, boolean required, boolean setCaption) {
        DefaultHorizontalLayout horizontal = new DefaultHorizontalLayout(false, true, true);
        if (setCaption) {
            horizontal.setCaption(attributeModel.getDisplayName());
        }
        horizontal.setStyleName("nested", true);
        if (required) {
            horizontal.setStyleName("nested required", true);
        }
        return horizontal;
    }

    private Button constructSaveButton(boolean bottom) {
        Button saveButton = new Button(this.entity != null && this.entity.getId() != null ? this.message("ocs.save.existing") : this.message("ocs.save.new"));
        saveButton.setIcon((Resource)FontAwesome.SAVE);
        saveButton.addClickListener((Button.ClickListener & Serializable)event -> {
            block7: {
                try {
                    boolean error = this.validateAllFields();
                    if (!error) {
                        if (this.getFormOptions().isConfirmSave()) {
                            this.service.validate(this.entity);
                            VaadinUtils.showConfirmDialog(this.getMessageService(), this.getMessageService().getMessage("ocs.confirm.save", VaadinUtils.getLocale(), new Object[]{this.getEntityModel().getDisplayName()}), () -> {
                                block2: {
                                    try {
                                        this.doSave();
                                    }
                                    catch (RuntimeException ex) {
                                        if (this.handleCustomException(ex)) break block2;
                                        this.handleSaveException(ex);
                                    }
                                }
                            });
                        } else if (this.customSaveConsumer != null) {
                            this.customSaveConsumer.accept(this.entity);
                        } else {
                            this.doSave();
                        }
                    }
                }
                catch (RuntimeException ex) {
                    if (this.handleCustomException(ex)) break block7;
                    this.handleSaveException(ex);
                }
            }
        });
        saveButton.setData((Object)SAVE_BUTTON_DATA);
        saveButton.setEnabled(this.groups.get(this.isViewMode()).isValid());
        if (bottom) {
            for (Field f : this.groups.get(this.isViewMode()).getFields()) {
                f.addValueChangeListener((Property.ValueChangeListener & Serializable)event -> {
                    this.checkSaveButtonState();
                    ((AbstractField)f).setComponentError(null);
                });
            }
        }
        return saveButton;
    }

    private Label constructTitleLabel() {
        Label label = null;
        String mainValue = EntityModelUtil.getMainAttributeValue(this.entity, this.getEntityModel());
        label = this.isViewMode() ? new Label(this.message("ocs.modelbasededitform.title.view", this.getEntityModel().getDisplayName(), mainValue), ContentMode.HTML) : (this.entity.getId() == null ? new Label(this.message("ocs.modelbasededitform.title.create", this.getEntityModel().getDisplayName()), ContentMode.HTML) : new Label(this.message("ocs.modelbasededitform.title.update", this.getEntityModel().getDisplayName(), mainValue), ContentMode.HTML));
        if (this.getFormTitleWidth() != null) {
            label.setWidth((float)this.getFormTitleWidth().intValue(), Sizeable.Unit.PIXELS);
        } else if (SystemPropertyUtils.getDefaultFormTitleWidth() > 0 && !this.getFormOptions().isPlaceButtonBarAtTop()) {
            label.setWidth((float)SystemPropertyUtils.getDefaultFormTitleWidth(), Sizeable.Unit.PIXELS);
        }
        return label;
    }

    private UploadComponent constructUploadField(AttributeModel attributeModel) {
        return new UploadComponent(attributeModel);
    }

    private void disableCreateOnlyFields() {
        if (!this.isViewMode()) {
            for (AttributeModel am : this.getEntityModel().getAttributeModels()) {
                Field field = this.groups.get(this.isViewMode()).getField((Object)am.getPath());
                if (field == null || !EditableType.CREATE_ONLY.equals((Object)am.getEditableType())) continue;
                field.setEnabled(this.entity.getId() == null);
            }
        }
    }

    private List<Button> filterButtons(String data) {
        return Collections.unmodifiableList(this.buttons.get(this.isViewMode()).stream().filter(b -> data.equals(b.getData())).collect(Collectors.toList()));
    }

    public List<Button> getBackButtons() {
        return this.filterButtons(BACK_BUTTON_DATA);
    }

    public List<Button> getCancelButtons() {
        return this.filterButtons(CANCEL_BUTTON_DATA);
    }

    public FetchJoinInformation[] getDetailJoins() {
        return this.detailJoins;
    }

    public List<Button> getEditButtons() {
        return this.filterButtons(EDIT_BUTTON_DATA);
    }

    public T getEntity() {
        return this.entity;
    }

    public Field<?> getField(String propertyName) {
        return this.groups.get(this.isViewMode()).getField((Object)propertyName);
    }

    public void setFieldRequired(String propertyName, boolean required) {
        Field<?> field = this.getField(propertyName);
        if (field != null) {
            AttributeModel am;
            field.setRequired(required);
            if (!required) {
                ((AbstractField)field).setComponentError(null);
            }
            if ((am = this.getEntityModel().getAttributeModel(propertyName)) != null && !am.getGroupTogetherWith().isEmpty()) {
                HorizontalLayout hz = (HorizontalLayout)field.getParent().getParent();
                if (required) {
                    hz.addStyleName("required");
                } else {
                    hz.removeStyleName("required");
                }
            }
        }
    }

    public Optional<Field<?>> getFieldOptional(String propertyName) {
        return Optional.ofNullable(this.groups.get(this.isViewMode()).getField((Object)propertyName));
    }

    public Integer getFormTitleWidth() {
        return this.formTitleWidth;
    }

    public Label getLabel(String propertyName) {
        AttributeModel am = this.getEntityModel().getAttributeModel(propertyName);
        if (am != null) {
            return (Label)this.labels.get(this.isViewMode()).get(am);
        }
        return null;
    }

    public List<Button> getNextButtons() {
        return this.filterButtons(NEXT_BUTTON_DATA);
    }

    protected T getNextEntity(T current) {
        return null;
    }

    protected String getParentGroup(String childGroup) {
        return null;
    }

    protected String[] getParentGroupHeaders() {
        return null;
    }

    protected T getPrevEntity(T current) {
        return null;
    }

    public List<Button> getPreviousButtons() {
        return this.filterButtons(PREV_BUTTON_DATA);
    }

    public List<Button> getSaveButtons() {
        return this.filterButtons(SAVE_BUTTON_DATA);
    }

    protected boolean hasNextEntity(T current) {
        return false;
    }

    protected boolean hasPrevEntity(T current) {
        return false;
    }

    protected boolean handleCustomException(RuntimeException ex) {
        return false;
    }

    public boolean isAttributeGroupVisible(String key) {
        Object c = this.attributeGroups.get(false).get(key);
        return c == null ? false : this.isGroupVisible(c);
    }

    protected boolean isEditAllowed() {
        return true;
    }

    private boolean isGroupVisible(Object c) {
        if (c != null) {
            if (c instanceof Component) {
                return ((Component)c).isVisible();
            }
            if (c instanceof TabSheet.Tab) {
                return ((TabSheet.Tab)c).isVisible();
            }
        }
        return false;
    }

    public boolean isSupportsIteration() {
        return this.supportsIteration;
    }

    public boolean isViewMode() {
        return this.viewMode;
    }

    protected void postProcessButtonBar(HorizontalLayout buttonBar, boolean viewMode) {
    }

    protected void postProcessEditFields() {
    }

    private void processParentHeaderGroup(String parentGroupHeader, Layout innerForm, boolean innerTabs, TabSheet innerTabSheet, int tabIndex) {
        for (String attributeGroup : this.getEntityModel().getAttributeGroups()) {
            if ("ocs.default.attribute.group".equals(attributeGroup) && !this.getEntityModel().isAttributeGroupVisible(attributeGroup, this.viewMode) || !this.getParentGroup(attributeGroup).equals(parentGroupHeader)) continue;
            Layout innerLayout2 = this.constructAttributeGroupLayout(innerForm, innerTabs, innerTabSheet, attributeGroup, true);
            for (AttributeModel attributeModel : this.getEntityModel().getAttributeModelsForGroup(attributeGroup)) {
                this.addField(innerLayout2, this.getEntityModel(), attributeModel, tabIndex, false);
            }
        }
    }

    private void reconstructLabels() {
        Label titleLabel;
        if (this.labels.get(this.isViewMode()) != null) {
            for (Map.Entry<AttributeModel, Component> e : this.labels.get(this.isViewMode()).entrySet()) {
                FormLayout fl;
                HasComponents hc;
                Component newLabel = this.constructLabel(this.entity, e.getKey());
                newLabel.setVisible(this.entity.getId() != null || this.isViewMode());
                if (e.getValue().getStyleName() != null) {
                    newLabel.setStyleName(e.getValue().getStyleName());
                }
                if ((hc = e.getValue().getParent()) instanceof Layout) {
                    ((Layout)hc).replaceComponent(e.getValue(), newLabel);
                    this.labels.get(this.isViewMode()).put(e.getKey(), newLabel);
                }
                if (!(newLabel.getParent() instanceof FormLayout) || !(fl = (FormLayout)newLabel.getParent()).getStyleName().contains("first")) continue;
                newLabel.setCaption("");
            }
        }
        if ((titleLabel = this.titleLabels.get(this.isViewMode())) != null) {
            Label newLabel = this.constructTitleLabel();
            this.titleLabels.put(this.isViewMode(), newLabel);
            this.titleBars.get(this.isViewMode()).replaceComponent((Component)titleLabel, (Component)newLabel);
        }
    }

    public void refreshLabel(String propertyName) {
        AttributeModel am = this.getEntityModel().getAttributeModel(propertyName);
        if (am != null) {
            Component replacement = this.constructLabel(this.getEntity(), am);
            Component oldLabel = this.labels.get(this.isViewMode()).get(am);
            replacement.setVisible(true);
            HasComponents hc = this.labels.get(this.isViewMode()).get(am).getParent();
            if (hc instanceof Layout) {
                ((Layout)hc).replaceComponent(oldLabel, replacement);
                this.labels.get(this.isViewMode()).put(am, replacement);
            }
        }
    }

    public void refreshLabel(String propertyName, String value) {
        AttributeModel am = this.getEntityModel().getAttributeModel(propertyName);
        if (am != null) {
            Label replacement = new Label(value);
            replacement.setCaption(am.getDisplayName());
            Component oldLabel = this.labels.get(this.isViewMode()).get(am);
            replacement.setVisible(true);
            HasComponents hc = this.labels.get(this.isViewMode()).get(am).getParent();
            if (hc instanceof Layout) {
                ((Layout)hc).replaceComponent(oldLabel, (Component)replacement);
                this.labels.get(this.isViewMode()).put(am, (Component)replacement);
            }
        }
    }

    public void resetTab() {
        if (this.tabSheets.get(this.isViewMode()) != null && !this.getFormOptions().isPreserveSelectedTab()) {
            this.tabSheets.get(this.isViewMode()).setSelectedTab(0);
        }
    }

    public void doSave() {
        boolean isNew = this.entity.getId() == null;
        this.entity = this.service.save(this.entity);
        this.setEntity(this.service.fetchById(this.entity.getId(), this.getDetailJoins()));
        this.showNotifification(this.message("ocs.changes.saved"), Notification.Type.TRAY_NOTIFICATION);
        if (this.getFormOptions().isOpenInViewMode()) {
            this.viewMode = true;
            this.build();
        }
        this.afterEditDone(false, isNew, this.getEntity());
    }

    public void selectTab(int index) {
        if (this.tabSheets.get(this.isViewMode()) != null) {
            this.tabSheets.get(this.isViewMode()).setSelectedTab(index);
        }
    }

    public int getSelectedTabIndex() {
        if (this.tabSheets.get(this.isViewMode()) != null) {
            Component c = this.tabSheets.get(this.isViewMode()).getSelectedTab();
            return VaadinUtils.getTabIndex(this.tabSheets.get(this.isViewMode()), this.tabSheets.get(this.isViewMode()).getTab(c).getCaption());
        }
        return 0;
    }

    public void setAttributeGroupVisible(String key, boolean visible) {
        Object c = this.attributeGroups.get(false).get(key);
        this.setGroupVisible(c, visible);
        c = this.attributeGroups.get(true).get(key);
        this.setGroupVisible(c, visible);
    }

    public CollapsiblePanel getAttributeGroupPanel(String key) {
        Object c = this.attributeGroups.get(this.isViewMode()).get(key);
        if (c instanceof CollapsiblePanel) {
            return (CollapsiblePanel)((Object)c);
        }
        return null;
    }

    public void putAttributeGroupPanel(String key, Component c) {
        this.attributeGroups.get(this.isViewMode()).put(key, c);
    }

    public void setComponentVisible(String propertyName, boolean visible) {
        this.setLabelVisible(propertyName, visible);
        Field<?> field = this.getField(propertyName);
        if (field != null) {
            field.setVisible(visible);
        }
    }

    public void setDetailJoins(FetchJoinInformation[] detailJoins) {
        this.detailJoins = detailJoins;
    }

    public void setEntity(T entity) {
        this.setEntity(entity, entity.getId() != null);
    }

    private void setEntity(T entity, boolean checkIterationButtons) {
        HasComponents hc;
        this.entity = entity;
        this.afterEntitySet(this.entity);
        for (CanAssignEntity<ID, T> canAssignEntity : this.assignEntityToFields) {
            canAssignEntity.assignEntity(entity);
        }
        this.setViewMode(this.getFormOptions().isOpenInViewMode() && entity.getId() != null, checkIterationButtons);
        BeanItem beanItem = new BeanItem(entity);
        this.groups.get(this.isViewMode()).setItemDataSource((Item)beanItem);
        this.build();
        this.reconstructLabels();
        for (Map.Entry<AttributeModel, Component> e : this.uploads.get(this.isViewMode()).entrySet()) {
            hc = e.getValue().getParent();
            if (!(hc instanceof Layout)) continue;
            UploadComponent uc = this.constructUploadField(e.getKey());
            ((Layout)hc).replaceComponent(e.getValue(), (Component)uc);
            this.uploads.get(this.isViewMode()).put(e.getKey(), (Component)uc);
        }
        for (Map.Entry<AttributeModel, Component> e : this.previews.get(this.isViewMode()).entrySet()) {
            hc = e.getValue().getParent();
            if (!(hc instanceof Layout)) continue;
            Component pv = this.constructImagePreview(e.getKey());
            ((Layout)hc).replaceComponent(e.getValue(), pv);
            this.previews.get(this.isViewMode()).put(e.getKey(), pv);
        }
        for (Field f : this.groups.get(this.isViewMode()).getFields()) {
            if (!(f instanceof Refreshable)) continue;
            ((Refreshable)f).refresh();
        }
        this.disableCreateOnlyFields();
        Label label = this.constructTitleLabel();
        this.titleBars.get(this.isViewMode()).replaceComponent((Component)this.titleLabels.get(this.isViewMode()), (Component)label);
        this.titleLabels.put(this.isViewMode(), label);
        this.updateSaveButtonCaptions();
        for (Button b : this.getCancelButtons()) {
            b.setVisible(!this.isViewMode() && !this.getFormOptions().isHideCancelButton() || this.getFormOptions().isFormNested() && entity.getId() == null);
        }
        if (this.receiver != null) {
            this.receiver.signalDetailsComponentValid(this, this.isValid());
        }
    }

    public void setFormTitleWidth(Integer formTitleWidth) {
        this.formTitleWidth = formTitleWidth;
    }

    private void setGroupVisible(Object c, boolean visible) {
        if (c != null) {
            if (c instanceof Component) {
                ((Component)c).setVisible(visible);
            } else if (c instanceof TabSheet.Tab) {
                ((TabSheet.Tab)c).setVisible(visible);
            }
        }
    }

    public void setLabelVisible(String propertyName, boolean visible) {
        Component label;
        AttributeModel am = this.getEntityModel().getAttributeModel(propertyName);
        if (am != null && (label = this.labels.get(this.isViewMode()).get(am)) != null) {
            if (ClassUtils.getFieldValue(this.entity, (String)propertyName) != null) {
                label.setVisible(visible);
                label.setCaption(am.getDisplayName());
            } else {
                label.setVisible(false);
                label.setCaption(null);
            }
        }
    }

    public void setSupportsIteration(boolean supportsIteration) {
        this.supportsIteration = supportsIteration;
    }

    public void setViewMode(boolean viewMode) {
        this.setViewMode(viewMode, true);
    }

    private void setViewMode(boolean viewMode, boolean checkIterationButtons) {
        boolean oldMode = this.viewMode;
        this.viewMode = !this.isEditAllowed() || viewMode;
        BeanItem beanItem = new BeanItem(this.entity);
        this.groups.get(this.isViewMode()).setItemDataSource((Item)beanItem);
        this.constructTitleLabel();
        this.reconstructLabels();
        this.build();
        this.checkIterationButtonState(checkIterationButtons);
        if (!this.isViewMode() && !this.fieldsProcessed) {
            this.postProcessEditFields();
            this.fieldsProcessed = true;
        }
        this.updateSaveButtonCaptions();
        this.disableCreateOnlyFields();
        if (this.tabSheets.get(oldMode) != null) {
            Component c = this.tabSheets.get(oldMode).getSelectedTab();
            int index = VaadinUtils.getTabIndex(this.tabSheets.get(oldMode), this.tabSheets.get(oldMode).getTab(c).getCaption());
            this.tabSheets.get(this.viewMode).setSelectedTab(index);
            if (!this.isViewMode() && this.firstFields.get(index) != null) {
                this.firstFields.get(index).focus();
            }
        } else if (this.firstFields.get(0) != null) {
            this.firstFields.get(0).focus();
        }
        this.resetComponentErrors();
        if (oldMode != this.viewMode) {
            this.afterModeChanged(this.isViewMode());
            for (Field f : this.groups.get(this.isViewMode()).getFields()) {
                if (!(f instanceof DetailsEditLayout)) continue;
                DetailsEditLayout detMode = (DetailsEditLayout)f;
                detMode.signalModeChange(this.isViewMode());
            }
        }
    }

    public void setTitleLabel(String value) {
        this.titleLabels.get(this.isViewMode()).setValue(value);
    }

    @Override
    public void signalDetailsComponentValid(SignalsParent component, boolean valid) {
        if (ValidationMode.DISABLE_BUTTON.equals((Object)this.getFormOptions().getValidationMode())) {
            this.detailComponentsValid.put(component, valid);
            this.checkSaveButtonState();
            if (this.receiver != null) {
                this.receiver.signalDetailsComponentValid(this, this.isValid());
            }
        }
    }

    public void styleLabel(String propertyName, String className) {
        AttributeModel am = this.getEntityModel().getAttributeModel(propertyName);
        if (am != null) {
            Component viewLabel;
            Component editLabel = this.labels.get(false) == null ? null : this.labels.get(false).get(am);
            Component component = viewLabel = this.labels.get(true) == null ? null : this.labels.get(true).get(am);
            if (editLabel != null) {
                editLabel.addStyleName(className);
            }
            if (viewLabel != null) {
                viewLabel.addStyleName(className);
            }
        }
    }

    private void resetComponentErrors() {
        for (Field f : this.groups.get(this.isViewMode()).getFields()) {
            ((AbstractField)f).setComponentError(null);
        }
    }

    private void updateSaveButtonCaptions() {
        for (Button b : this.getSaveButtons()) {
            if (this.entity.getId() != null) {
                b.setCaption(this.message("ocs.save.existing"));
                continue;
            }
            b.setCaption(this.message("ocs.save.new"));
        }
    }

    public boolean isNestedMode() {
        return this.nestedMode;
    }

    public void setNestedMode(boolean nestedMode) {
        this.nestedMode = nestedMode;
    }

    public Collection<Field<?>> getFields(boolean viewMode) {
        return this.groups.get(viewMode).getFields();
    }

    public ReceivesSignal getReceiver() {
        return this.receiver;
    }

    public void setReceiver(ReceivesSignal receiver) {
        this.receiver = receiver;
    }

    @Override
    public boolean validateAllFields() {
        boolean error = false;
        if (ValidationMode.VALIDATE_DIRECTLY.equals((Object)this.getFormOptions().getValidationMode())) {
            for (Field f : this.groups.get(this.isViewMode()).getFields()) {
                try {
                    f.validate();
                    ((AbstractField)f).setComponentError(null);
                }
                catch (Validator.InvalidValueException ex) {
                    error = true;
                    ((AbstractField)f).setComponentError((ErrorMessage)new UserError(ex.getLocalizedMessage()));
                }
                if (!(f instanceof SignalsParent)) continue;
                error |= ((SignalsParent)f).validateAllFields();
            }
        }
        return error;
    }

    public Consumer<T> getCustomSaveConsumer() {
        return this.customSaveConsumer;
    }

    public void setCustomSaveConsumer(Consumer<T> customSaveConsumer) {
        this.customSaveConsumer = customSaveConsumer;
    }

    private final class UploadReceiver
    implements Upload.SucceededListener,
    Upload.Receiver {
        private String fieldName;
        private String fileNameFieldName;
        private ByteArrayOutputStream stream;
        private String[] supportedExtensions;
        private Embedded target;

        private UploadReceiver(Embedded target, String fieldName, String fileNameFieldName, String ... supportedExtensions) {
            this.target = target;
            this.fieldName = fieldName;
            this.fileNameFieldName = fileNameFieldName;
            this.supportedExtensions = supportedExtensions;
        }

        public OutputStream receiveUpload(String filename, String mimeType) {
            this.stream = new ByteArrayOutputStream();
            return this.stream;
        }

        public void uploadSucceeded(Upload.SucceededEvent event) {
            if (this.stream != null && this.stream.toByteArray().length > 0) {
                String extension = FilenameUtils.getExtension((String)event.getFilename());
                if (this.supportedExtensions == null || this.supportedExtensions.length == 0 || extension != null && Arrays.asList(this.supportedExtensions).contains(extension.toLowerCase())) {
                    if (this.target != null) {
                        this.target.setVisible(true);
                        StreamResource.StreamSource & Serializable ss = (StreamResource.StreamSource & Serializable)() -> new ByteArrayInputStream(this.stream.toByteArray());
                        this.target.setSource((Resource)new StreamResource((StreamResource.StreamSource)ss, System.nanoTime() + ".png"));
                    }
                    ClassUtils.setBytes((byte[])this.stream.toByteArray(), ModelBasedEditForm.this.getEntity(), (String)this.fieldName);
                    if (this.fileNameFieldName != null) {
                        ClassUtils.setFieldValue(ModelBasedEditForm.this.getEntity(), (String)this.fileNameFieldName, (Object)event.getFilename());
                        ModelBasedEditForm.this.refreshLabel(this.fileNameFieldName);
                    }
                } else {
                    ModelBasedEditForm.this.showNotifification(ModelBasedEditForm.this.message("ocs.modelbasededitform.upload.format.invalid"), Notification.Type.ERROR_MESSAGE);
                }
            }
        }
    }

    private final class UploadComponent
    extends CustomField<byte[]> {
        private AttributeModel attributeModel;

        private UploadComponent(AttributeModel attributeModel) {
            this.attributeModel = attributeModel;
        }

        public Class<? extends byte[]> getType() {
            return byte[].class;
        }

        protected Component initContent() {
            byte[] bytes = ClassUtils.getBytes(ModelBasedEditForm.this.getEntity(), (String)this.attributeModel.getName());
            DefaultEmbedded image = new DefaultEmbedded(null, bytes);
            DefaultVerticalLayout main = new DefaultVerticalLayout(false, true);
            if (this.attributeModel.isImage()) {
                image.setStyleName("fileUpload");
                image.setVisible(bytes != null);
                main.addComponent((Component)image);
            } else {
                Label label = new Label(ModelBasedEditForm.this.message("ocs.no.preview.available"));
                main.addComponent((Component)label);
            }
            UploadReceiver receiver = new UploadReceiver((Embedded)image, this.attributeModel.getName(), this.attributeModel.getFileNameProperty(), this.attributeModel.getAllowedExtensions().toArray(new String[0]));
            DefaultHorizontalLayout buttonBar = new DefaultHorizontalLayout(false, true, true);
            main.addComponent((Component)buttonBar);
            Upload upload = new Upload(null, (Upload.Receiver)receiver);
            upload.addSucceededListener((Upload.SucceededListener)receiver);
            buttonBar.addComponent((Component)upload);
            Button clearButton = new Button(ModelBasedEditForm.this.message("ocs.clear"));
            clearButton.addClickListener((Button.ClickListener & Serializable)event -> {
                ClassUtils.clearFieldValue(ModelBasedEditForm.this.getEntity(), (String)this.attributeModel.getName(), byte[].class);
                image.setVisible(false);
                if (this.attributeModel.getFileNameProperty() != null) {
                    ClassUtils.clearFieldValue(ModelBasedEditForm.this.getEntity(), (String)this.attributeModel.getFileNameProperty(), String.class);
                    ModelBasedEditForm.this.refreshLabel(this.attributeModel.getFileNameProperty());
                }
            });
            buttonBar.addComponent((Component)clearButton);
            this.setCaption(this.attributeModel.getDisplayName());
            return main;
        }
    }
}

