/*
 * Decompiled with CFR 0.152.
 */
package com.ocs.dynamo.ui.composite.form;

import com.ocs.dynamo.domain.AbstractEntity;
import com.ocs.dynamo.domain.model.AttributeModel;
import com.ocs.dynamo.domain.model.AttributeType;
import com.ocs.dynamo.domain.model.EntityModel;
import com.ocs.dynamo.filter.FlexibleFilterDefinition;
import com.ocs.dynamo.filter.listener.FilterChangeEvent;
import com.ocs.dynamo.filter.listener.FilterListener;
import com.ocs.dynamo.ui.Refreshable;
import com.ocs.dynamo.ui.Searchable;
import com.ocs.dynamo.ui.component.DefaultHorizontalLayout;
import com.ocs.dynamo.ui.component.DefaultVerticalLayout;
import com.ocs.dynamo.ui.component.FancyListSelect;
import com.ocs.dynamo.ui.composite.form.AbstractModelBasedSearchForm;
import com.ocs.dynamo.ui.composite.form.FlexibleFilterType;
import com.ocs.dynamo.ui.composite.layout.FormOptions;
import com.ocs.dynamo.ui.utils.ConvertUtil;
import com.ocs.dynamo.utils.DateUtils;
import com.vaadin.data.Container;
import com.vaadin.data.Property;
import com.vaadin.data.util.filter.Between;
import com.vaadin.data.util.filter.Compare;
import com.vaadin.data.util.filter.Not;
import com.vaadin.data.util.filter.SimpleStringFilter;
import com.vaadin.shared.ui.combobox.FilteringMode;
import com.vaadin.ui.Button;
import com.vaadin.ui.ComboBox;
import com.vaadin.ui.Component;
import com.vaadin.ui.Field;
import com.vaadin.ui.Label;
import com.vaadin.ui.Layout;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.StringUtils;

public class ModelBasedFlexibleSearchForm<ID extends Serializable, T extends AbstractEntity<ID>>
extends AbstractModelBasedSearchForm<ID, T> {
    private static final long serialVersionUID = -6668770373597055403L;
    private Button addFilterButton;
    private List<FilterRegion> regions = new ArrayList<FilterRegion>();
    private Set<String> basicStringFilterProperties = new HashSet<String>();

    public ModelBasedFlexibleSearchForm(Searchable searchable, EntityModel<T> entityModel, FormOptions formOptions) {
        this(searchable, entityModel, formOptions, null, null);
    }

    public ModelBasedFlexibleSearchForm(Searchable searchable, EntityModel<T> entityModel, FormOptions formOptions, List<Container.Filter> defaultFilters, Map<String, Container.Filter> fieldFilters) {
        super(searchable, entityModel, formOptions, defaultFilters, fieldFilters);
    }

    private void addFilter() {
        FilterRegion region = new FilterRegion(this);
        this.regions.add(region);
        this.getFilterLayout().addComponent((Component)region.getLayout());
        this.toggle(true);
    }

    public void addFilter(AttributeModel attributeModel, FlexibleFilterType filterType, Object value, Object auxValue) {
        boolean multi = Collection.class.isAssignableFrom(attributeModel.getType()) || attributeModel.isMultipleSearch();
        FilterRegion match = this.regions.stream().filter(region -> ((FilterRegion)region).am != null && ((FilterRegion)region).am.getPath().equals(attributeModel.getPath())).findFirst().orElse(null);
        if (match == null) {
            this.addFilter();
            match = this.regions.get(this.regions.size() - 1);
            match.attributeFilterComboBox.setValue((Object)attributeModel);
            match.filterAttributeChange(attributeModel, true);
            match.typeFilterCombo.setValue((Object)filterType);
        }
        if (multi) {
            ArrayList<Object> list = new ArrayList<Object>();
            if (match.mainValueComponent.getValue() != null) {
                Collection col = (Collection)match.mainValueComponent.getValue();
                list.addAll(col);
            }
            list.add(value);
            match.mainValueComponent.setValue(list);
        } else {
            match.typeFilterCombo.setValue((Object)filterType);
            match.mainValueComponent.setValue(value);
            if (match.auxValueComponent != null) {
                match.auxValueComponent.setValue(auxValue);
            }
        }
    }

    @Override
    public void clear() {
        Iterator<FilterRegion> it = this.regions.iterator();
        while (it.hasNext()) {
            FilterRegion fr = it.next();
            if (fr.am == null || !fr.am.isRequiredForSearching()) {
                this.getFilterLayout().removeComponent((Component)fr.getLayout());
                it.remove();
                continue;
            }
            fr.mainValueComponent.setValue(null);
            if (fr.auxValueComponent == null) continue;
            fr.auxValueComponent.setValue(null);
        }
        super.clear();
    }

    @Override
    protected void constructButtonBar(Layout buttonBar) {
        this.addFilterButton = new Button(this.message("ocs.add.filter"));
        this.addFilterButton.addClickListener((Button.ClickListener & Serializable)evenbt -> this.addFilter());
        buttonBar.addComponent((Component)this.addFilterButton);
        buttonBar.addComponent((Component)this.constructSearchButton());
        buttonBar.addComponent((Component)this.constructSearchAnyButton());
        buttonBar.addComponent((Component)this.constructClearButton());
        buttonBar.addComponent((Component)this.constructToggleButton());
    }

    @Override
    protected Layout constructFilterLayout() {
        return new DefaultVerticalLayout();
    }

    public List<FlexibleFilterDefinition> extractFilterDefinitions() {
        return this.regions.stream().map(FilterRegion::toDefinition).filter(Objects::nonNull).collect(Collectors.toList());
    }

    public Button getAddFilterButton() {
        return this.addFilterButton;
    }

    public Set<String> getBasicStringFilterProperties() {
        return this.basicStringFilterProperties;
    }

    public FlexibleFilterType getDefaultFilterType(AttributeModel am) {
        if (AttributeType.BASIC.equals((Object)am.getAttributeType())) {
            if (String.class.equals((Object)am.getType())) {
                return FlexibleFilterType.CONTAINS;
            }
            if (Enum.class.isAssignableFrom(am.getType())) {
                return FlexibleFilterType.EQUALS;
            }
            if (Number.class.isAssignableFrom(am.getType()) || Date.class.isAssignableFrom(am.getType()) || DateUtils.isJava8DateType((Class)am.getType())) {
                return FlexibleFilterType.BETWEEN;
            }
        }
        return FlexibleFilterType.EQUALS;
    }

    public boolean hasFilter(AttributeModel attributeModel) {
        return this.regions.stream().anyMatch(r -> ObjectUtils.equals((Object)attributeModel, (Object)((FilterRegion)r).am));
    }

    public FilterRegion getFilterRegion(AttributeModel attributeModel) {
        return this.regions.stream().filter(r -> ObjectUtils.equals((Object)attributeModel, (Object)((FilterRegion)r).am)).findFirst().orElse(null);
    }

    private List<AttributeModel> iterate(List<AttributeModel> attributeModels) {
        ArrayList<AttributeModel> result = new ArrayList<AttributeModel>();
        for (AttributeModel attributeModel : attributeModels) {
            if (attributeModel.isSearchable()) {
                result.add(attributeModel);
            }
            if (attributeModel.getNestedEntityModel() == null) continue;
            EntityModel nested = attributeModel.getNestedEntityModel();
            result.addAll(this.iterate(nested.getAttributeModels()));
        }
        return result;
    }

    @Override
    public void refresh() {
        for (FilterRegion r : this.regions) {
            if (r.mainValueComponent == null || !(r.mainValueComponent instanceof Refreshable)) continue;
            ((Refreshable)r.mainValueComponent).refresh();
        }
    }

    public void restoreFilterDefinitions(List<FlexibleFilterDefinition> definitions) {
        for (FlexibleFilterDefinition def : definitions) {
            FilterRegion region = new FilterRegion(this);
            region.restoring = true;
            region.attributeFilterComboBox.setValue((Object)def.getAttributeModel());
            region.filterAttributeChange(def.getAttributeModel(), true);
            region.typeFilterCombo.setValue((Object)def.getFlexibleFilterType());
            region.mainValueComponent.setValue(ConvertUtil.convertToPresentationValue(def.getAttributeModel(), def.getValue()));
            if (region.auxValueComponent != null) {
                region.auxValueComponent.setValue(ConvertUtil.convertToPresentationValue(def.getAttributeModel(), def.getValueTo()));
            }
            region.restoring = false;
            this.regions.add(region);
            this.getFilterLayout().addComponent((Component)region.getLayout());
        }
    }

    public void setBasicStringFilterProperties(Set<String> basicStringFilterProperties) {
        this.basicStringFilterProperties = basicStringFilterProperties;
    }

    private class FilterRegion {
        private boolean restoring;
        private AttributeModel am;
        private Container.Filter auxFilter;
        private Field<Object> auxValueComponent;
        private Container.Filter fieldFilter;
        private ComboBox attributeFilterComboBox;
        private Label noFilterLabel;
        private FlexibleFilterType filterType;
        private Layout layout;
        private FilterListener listener;
        private Container.Filter mainFilter;
        private Field<Object> mainValueComponent;
        private Button removeButton;
        private ComboBox typeFilterCombo;

        FilterRegion(FilterListener listener) {
            this.listener = listener;
            this.layout = new DefaultHorizontalLayout();
            this.removeButton = new Button(ModelBasedFlexibleSearchForm.this.message("ocs.remove"));
            this.removeButton.addClickListener((Button.ClickListener & Serializable)e -> {
                Layout parent = (Layout)this.layout.getParent();
                parent.removeComponent((Component)this.layout);
                ModelBasedFlexibleSearchForm.this.regions.remove(this);
                if (this.am != null) {
                    this.listener.onFilterChange(new FilterChangeEvent(this.am.getPath(), this.fieldFilter, null, null));
                }
            });
            this.layout.addComponent((Component)this.removeButton);
            this.attributeFilterComboBox = new ComboBox(ModelBasedFlexibleSearchForm.this.message("ocs.filter"));
            this.attributeFilterComboBox.setStyleName("nested");
            this.attributeFilterComboBox.setFilteringMode(FilteringMode.CONTAINS);
            List filteredModels = ModelBasedFlexibleSearchForm.this.iterate(ModelBasedFlexibleSearchForm.this.getEntityModel().getAttributeModels());
            filteredModels.sort((o1, o2) -> o1.getDisplayName().compareToIgnoreCase(o2.getDisplayName()));
            for (AttributeModel a : filteredModels) {
                boolean mayAdd = !a.isRequiredForSearching() || !ModelBasedFlexibleSearchForm.this.hasFilter(a);
                if (!mayAdd) continue;
                this.attributeFilterComboBox.addItem((Object)a);
                this.attributeFilterComboBox.setItemCaption((Object)a, a.getDisplayName());
            }
            this.attributeFilterComboBox.addValueChangeListener((Property.ValueChangeListener & Serializable)e -> this.handleFilterAttributeChange(e, this.restoring));
            this.layout.addComponent((Component)this.attributeFilterComboBox);
            this.noFilterLabel = new Label(ModelBasedFlexibleSearchForm.this.message("ocs.select.filter"));
            this.noFilterLabel.setCaption("");
            this.layout.addComponent((Component)this.noFilterLabel);
        }

        private SimpleStringFilter createStringFilter(Object value, boolean prefixOnly) {
            String valueStr;
            String string = valueStr = value == null ? "" : value.toString();
            if (StringUtils.isNotEmpty((String)valueStr)) {
                return new SimpleStringFilter((Object)this.am.getPath(), valueStr, !this.am.isSearchCaseSensitive(), prefixOnly);
            }
            return null;
        }

        private void filterAttributeChange(AttributeModel attributeModel, boolean restoring) {
            this.am = attributeModel;
            if (this.am != null) {
                ComboBox newTypeFilterCombo = new ComboBox(ModelBasedFlexibleSearchForm.this.message("ocs.type"));
                newTypeFilterCombo.setNullSelectionAllowed(false);
                newTypeFilterCombo.addValueChangeListener((Property.ValueChangeListener & Serializable)event -> this.handleFilterTypeChange((FlexibleFilterType)((Object)((Object)((Object)event.getProperty().getValue())))));
                newTypeFilterCombo.setStyleName("nested");
                this.getFilterTypes(this.am).stream().forEach(arg_0 -> ((ComboBox)newTypeFilterCombo).addItem(arg_0));
                this.removeButton.setEnabled(!this.am.isRequiredForSearching());
                this.attributeFilterComboBox.setEnabled(!this.am.isRequiredForSearching());
                if (this.typeFilterCombo != null) {
                    this.layout.replaceComponent((Component)this.typeFilterCombo, (Component)newTypeFilterCombo);
                } else {
                    this.layout.addComponent((Component)newTypeFilterCombo);
                }
                if (this.mainValueComponent != null) {
                    this.layout.removeComponent(this.mainValueComponent);
                }
                if (this.auxValueComponent != null) {
                    this.layout.removeComponent(this.auxValueComponent);
                }
                this.typeFilterCombo = newTypeFilterCombo;
                if (!restoring) {
                    this.typeFilterCombo.setValue((Object)ModelBasedFlexibleSearchForm.this.getDefaultFilterType(this.am));
                }
                if (this.getFilterTypes(this.am).size() == 1) {
                    this.typeFilterCombo.setEnabled(false);
                }
            } else {
                if (this.typeFilterCombo != null) {
                    this.layout.removeComponent((Component)this.typeFilterCombo);
                }
                if (this.mainValueComponent != null) {
                    this.layout.removeComponent(this.mainValueComponent);
                }
                if (this.auxValueComponent != null) {
                    this.layout.removeComponent(this.auxValueComponent);
                }
            }
            this.noFilterLabel.setVisible(this.am == null);
        }

        private List<FlexibleFilterType> getFilterTypes(AttributeModel am) {
            ArrayList<FlexibleFilterType> result = new ArrayList<FlexibleFilterType>();
            result.add(FlexibleFilterType.EQUALS);
            switch (am.getAttributeType()) {
                case BASIC: {
                    if (String.class.equals((Object)am.getType())) {
                        if (ModelBasedFlexibleSearchForm.this.basicStringFilterProperties.contains(am.getPath())) {
                            result.add(FlexibleFilterType.CONTAINS);
                            result.add(FlexibleFilterType.STARTS_WITH);
                            break;
                        }
                        result.add(FlexibleFilterType.NOT_EQUAL);
                        result.add(FlexibleFilterType.CONTAINS);
                        result.add(FlexibleFilterType.STARTS_WITH);
                        result.add(FlexibleFilterType.NOT_CONTAINS);
                        result.add(FlexibleFilterType.NOT_STARTS_WITH);
                        break;
                    }
                    if (Enum.class.isAssignableFrom(am.getType())) {
                        result.add(FlexibleFilterType.NOT_EQUAL);
                        break;
                    }
                    if (!Number.class.isAssignableFrom(am.getType()) && !DateUtils.isSupportedDateType((Class)am.getType())) break;
                    result.add(FlexibleFilterType.BETWEEN);
                    result.add(FlexibleFilterType.LESS_THAN);
                    result.add(FlexibleFilterType.LESS_OR_EQUAL);
                    result.add(FlexibleFilterType.GREATER_OR_EQUAL);
                    result.add(FlexibleFilterType.GREATER_THAN);
                    break;
                }
                case MASTER: 
                case DETAIL: {
                    result.add(FlexibleFilterType.NOT_EQUAL);
                    break;
                }
            }
            return result;
        }

        public Layout getLayout() {
            return this.layout;
        }

        private void handleFilterAttributeChange(Property.ValueChangeEvent event, boolean restoring) {
            AttributeModel temp = (AttributeModel)event.getProperty().getValue();
            this.filterAttributeChange(temp, restoring);
        }

        private void handleFilterTypeChange(FlexibleFilterType type) {
            Field<?> newComponent;
            this.filterType = type;
            Object oldValue = this.mainValueComponent == null ? null : this.mainValueComponent.getValue();
            Object oldAuxValue = this.auxValueComponent == null ? null : this.auxValueComponent.getValue();
            Field<?> custom = ModelBasedFlexibleSearchForm.this.constructCustomField(ModelBasedFlexibleSearchForm.this.getEntityModel(), this.am);
            Field<?> field = newComponent = custom != null ? custom : ModelBasedFlexibleSearchForm.this.getFieldFactory().constructField(this.am, ModelBasedFlexibleSearchForm.this.getFieldFilters(), ModelBasedFlexibleSearchForm.this.getFieldEntityModel(this.am));
            if (newComponent instanceof FancyListSelect) {
                FancyListSelect fls = (FancyListSelect)newComponent;
                fls.getListSelect().setStyleName("nested");
                fls.getComboBox().setStyleName("nested");
            }
            newComponent.addValueChangeListener((Property.ValueChangeListener & Serializable)event -> this.handleValueChange(newComponent, event.getProperty().getValue()));
            if (this.mainValueComponent == null) {
                this.layout.addComponent(newComponent);
            } else {
                this.layout.replaceComponent(this.mainValueComponent, newComponent);
            }
            this.mainValueComponent = newComponent;
            if (FlexibleFilterType.BETWEEN.equals((Object)this.filterType)) {
                newComponent.setCaption(this.am.getDisplayName() + " " + ModelBasedFlexibleSearchForm.this.message("ocs.from"));
                Field<?> newAuxComponent = ModelBasedFlexibleSearchForm.this.getFieldFactory().createField(this.am.getPath());
                newAuxComponent.addValueChangeListener((Property.ValueChangeListener & Serializable)event -> this.handleValueChange(newAuxComponent, event.getProperty().getValue()));
                newAuxComponent.setCaption(this.am.getDisplayName() + " " + ModelBasedFlexibleSearchForm.this.message("ocs.to"));
                if (this.auxValueComponent == null) {
                    this.layout.addComponent(newAuxComponent);
                } else {
                    this.layout.replaceComponent(this.auxValueComponent, newAuxComponent);
                }
                this.auxValueComponent = newAuxComponent;
            } else if (this.auxValueComponent != null) {
                this.layout.removeComponent(this.auxValueComponent);
                this.auxValueComponent = null;
            }
            try {
                if (oldValue != null) {
                    this.mainValueComponent.setValue(oldValue);
                }
                if (oldAuxValue != null && this.auxValueComponent != null) {
                    this.auxValueComponent.setValue(oldAuxValue);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        private void handleValueChange(Field<?> field, Object value) {
            Container.Filter oldFilter = this.fieldFilter;
            SimpleStringFilter filter = null;
            value = ConvertUtil.convertSearchValue(this.am, value);
            switch (this.filterType) {
                case BETWEEN: {
                    if (field == this.auxValueComponent) {
                        this.auxFilter = value != null ? new Compare.LessOrEqual((Object)this.am.getPath(), value) : null;
                    } else {
                        this.mainFilter = value != null ? new Compare.GreaterOrEqual((Object)this.am.getPath(), value) : null;
                    }
                    if (this.auxFilter != null && this.mainFilter != null) {
                        filter = new Between((Object)this.am.getPath(), (Comparable)((Compare.GreaterOrEqual)this.mainFilter).getValue(), (Comparable)((Compare.LessOrEqual)this.auxFilter).getValue());
                        break;
                    }
                    if (this.auxFilter != null) {
                        filter = this.auxFilter;
                        break;
                    }
                    filter = this.mainFilter;
                    break;
                }
                case LESS_OR_EQUAL: {
                    filter = new Compare.LessOrEqual((Object)this.am.getPath(), value);
                    break;
                }
                case LESS_THAN: {
                    filter = new Compare.Less((Object)this.am.getPath(), value);
                    break;
                }
                case GREATER_OR_EQUAL: {
                    filter = new Compare.GreaterOrEqual((Object)this.am.getPath(), value);
                    break;
                }
                case GREATER_THAN: {
                    filter = new Compare.Greater((Object)this.am.getPath(), value);
                    break;
                }
                case CONTAINS: {
                    filter = this.createStringFilter(value, false);
                    break;
                }
                case NOT_EQUAL: {
                    filter = new Not((Container.Filter)new Compare.Equal((Object)this.am.getPath(), value));
                    break;
                }
                case STARTS_WITH: {
                    filter = this.createStringFilter(value, true);
                    break;
                }
                case NOT_CONTAINS: {
                    filter = new Not((Container.Filter)this.createStringFilter(value, false));
                    break;
                }
                case NOT_STARTS_WITH: {
                    filter = new Not((Container.Filter)this.createStringFilter(value, true));
                    break;
                }
                default: {
                    if (value == null) break;
                    filter = new Compare.Equal((Object)this.am.getPath(), value);
                }
            }
            this.fieldFilter = filter;
            this.listener.onFilterChange(new FilterChangeEvent(this.am.getPath(), oldFilter, (Container.Filter)filter, value));
        }

        public FlexibleFilterDefinition toDefinition() {
            if (this.mainValueComponent != null) {
                FlexibleFilterDefinition definition = new FlexibleFilterDefinition();
                definition.setFlexibleFilterType(this.filterType);
                definition.setAttributeModel(this.am);
                definition.setValue(ConvertUtil.convertSearchValue(this.am, this.mainValueComponent.getValue()));
                if (this.auxValueComponent != null) {
                    definition.setValueTo(ConvertUtil.convertSearchValue(this.am, this.auxValueComponent.getValue()));
                }
                return definition;
            }
            return null;
        }
    }
}

