/*
 * Decompiled with CFR 0.152.
 */
package com.ocs.dynamo.ui.composite.form;

import com.ocs.dynamo.domain.AbstractEntity;
import com.ocs.dynamo.domain.model.AttributeModel;
import com.ocs.dynamo.domain.model.AttributeType;
import com.ocs.dynamo.domain.model.CascadeMode;
import com.ocs.dynamo.domain.model.EntityModel;
import com.ocs.dynamo.exception.OCSRuntimeException;
import com.ocs.dynamo.filter.listener.FilterListener;
import com.ocs.dynamo.ui.Refreshable;
import com.ocs.dynamo.ui.Searchable;
import com.ocs.dynamo.ui.component.Cascadable;
import com.ocs.dynamo.ui.component.DefaultHorizontalLayout;
import com.ocs.dynamo.ui.component.DefaultVerticalLayout;
import com.ocs.dynamo.ui.composite.form.AbstractModelBasedSearchForm;
import com.ocs.dynamo.ui.composite.form.FilterGroup;
import com.ocs.dynamo.ui.composite.layout.FormOptions;
import com.ocs.dynamo.util.SystemPropertyUtils;
import com.vaadin.data.Container;
import com.vaadin.data.Property;
import com.vaadin.data.util.filter.Compare;
import com.vaadin.ui.Button;
import com.vaadin.ui.Component;
import com.vaadin.ui.Field;
import com.vaadin.ui.FormLayout;
import com.vaadin.ui.GridLayout;
import com.vaadin.ui.Layout;
import com.vaadin.ui.VerticalLayout;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ModelBasedSearchForm<ID extends Serializable, T extends AbstractEntity<ID>>
extends AbstractModelBasedSearchForm<ID, T>
implements FilterListener,
Button.ClickListener {
    private static final long serialVersionUID = -7226808613882934559L;
    private int fieldsAdded = 0;
    private Layout form;
    private Map<String, FilterGroup> groups = new HashMap<String, FilterGroup>();
    private int nrOfColumns = 1;
    private List<FormLayout> subForms = new ArrayList<FormLayout>();

    public ModelBasedSearchForm(Searchable searchable, EntityModel<T> entityModel, FormOptions formOptions) {
        this(searchable, entityModel, formOptions, null, null);
    }

    public ModelBasedSearchForm(Searchable searchable, EntityModel<T> entityModel, FormOptions formOptions, List<Container.Filter> defaultFilters, Map<String, Container.Filter> fieldFilters) {
        super(searchable, entityModel, formOptions, defaultFilters, fieldFilters);
    }

    @Override
    public void clear() {
        for (FilterGroup group : this.groups.values()) {
            group.reset();
        }
        super.clear();
    }

    @Override
    protected void constructButtonBar(Layout buttonBar) {
        buttonBar.addComponent((Component)this.constructSearchButton());
        buttonBar.addComponent((Component)this.constructSearchAnyButton());
        buttonBar.addComponent((Component)this.constructClearButton());
        buttonBar.addComponent((Component)this.constructToggleButton());
    }

    protected void constructCascadeListeners() {
        for (AttributeModel am : this.getEntityModel().getCascadeAttributeModels()) {
            if (!am.isSearchable()) continue;
            Field<Object> field = this.groups.get(am.getPath()).getField();
            field.addValueChangeListener((Property.ValueChangeListener & Serializable)event -> {
                for (String cascadePath : am.getCascadeAttributes()) {
                    this.handleCascade(event, am, cascadePath);
                }
            });
        }
    }

    protected List<Component> constructExtraSearchFields() {
        return new ArrayList<Component>();
    }

    protected Field<?> constructField(EntityModel<T> entityModel, AttributeModel attributeModel) {
        Field<?> field = this.constructCustomField(entityModel, attributeModel);
        if (field == null) {
            EntityModel<?> em = this.getFieldEntityModel(attributeModel);
            field = this.getFieldFactory().constructField(attributeModel, this.getFieldFilters(), em);
        }
        if (field != null) {
            field.setSizeFull();
        }
        return field;
    }

    protected FilterGroup constructFilterGroup(EntityModel<T> entityModel, AttributeModel attributeModel) {
        Field<?> field = this.constructField(entityModel, attributeModel);
        if (field != null) {
            FilterType filterType = FilterType.BETWEEN;
            if (String.class.isAssignableFrom(attributeModel.getType())) {
                filterType = FilterType.LIKE;
            } else if (Boolean.class.isAssignableFrom(attributeModel.getType()) || Boolean.TYPE.isAssignableFrom(attributeModel.getType())) {
                filterType = FilterType.BOOLEAN;
            } else if (attributeModel.getType().isEnum()) {
                filterType = FilterType.ENUM;
            } else if (AttributeType.ELEMENT_COLLECTION.equals((Object)attributeModel.getAttributeType())) {
                filterType = FilterType.EQUAL;
            } else if (AbstractEntity.class.isAssignableFrom(attributeModel.getType()) || AttributeType.DETAIL.equals((Object)attributeModel.getAttributeType())) {
                filterType = FilterType.ENTITY;
            } else if (attributeModel.isSearchForExactValue()) {
                filterType = FilterType.EQUAL;
            }
            Object comp = field;
            Field<?> auxField = null;
            if (FilterType.BETWEEN.equals((Object)filterType)) {
                String from = this.message("ocs.from");
                field.setCaption(attributeModel.getDisplayName() + " " + from);
                auxField = this.constructField(entityModel, attributeModel);
                String to = this.message("ocs.to");
                auxField.setCaption(attributeModel.getDisplayName() + " " + to);
                auxField.setVisible(true);
                DefaultHorizontalLayout layout = new DefaultHorizontalLayout();
                layout.setSizeFull();
                layout.addComponent((Component)field);
                layout.addComponent((Component)auxField);
                comp = layout;
            }
            return new FilterGroup(attributeModel, filterType, (Component)comp, field, auxField);
        }
        return null;
    }

    @Override
    protected Layout constructFilterLayout() {
        if (this.nrOfColumns == 1) {
            this.form = new FormLayout();
            if (!this.getFormOptions().isPopup()) {
                this.form.setStyleName("halfScreen");
            }
        } else {
            this.form = new GridLayout(this.nrOfColumns, 1);
            this.form.setSizeFull();
            for (int i = 0; i < this.nrOfColumns; ++i) {
                FormLayout column = new FormLayout();
                column.setMargin(true);
                this.subForms.add(column);
                this.form.addComponent((Component)column);
            }
        }
        List<Component> extra = this.constructExtraSearchFields();
        for (Component c : extra) {
            if (this.nrOfColumns == 1) {
                this.form.addComponent(c);
            } else {
                int index = this.fieldsAdded % this.nrOfColumns;
                this.subForms.get(index).addComponent(c);
            }
            ++this.fieldsAdded;
        }
        this.iterate(this.getEntityModel().getAttributeModels());
        this.constructCascadeListeners();
        DefaultVerticalLayout margin = new DefaultVerticalLayout(true, false);
        margin.addComponent((Component)this.form);
        if (this.groups.isEmpty() && extra.isEmpty()) {
            margin.setVisible(false);
        }
        return margin;
    }

    public void forceSearch(String propertyId, Object value) {
        this.setSearchValue(propertyId, value);
        this.search();
    }

    public void forceSearch(String propertyId, Object lower, Object upper) {
        this.setSearchValue(propertyId, lower, upper);
        this.search();
    }

    public Map<String, FilterGroup> getGroups() {
        return this.groups;
    }

    public int getNrOfColumns() {
        return this.nrOfColumns;
    }

    private void handleCascade(Property.ValueChangeEvent event, AttributeModel am, String cascadePath) {
        CascadeMode cm = am.getCascadeMode(cascadePath);
        if (CascadeMode.BOTH.equals((Object)cm) || CascadeMode.SEARCH.equals((Object)cm)) {
            Field<Object> cascadeField = this.groups.get(cascadePath).getField();
            if (cascadeField instanceof Cascadable) {
                Cascadable ca = (Cascadable)cascadeField;
                if (event.getProperty().getValue() == null) {
                    ca.clearAdditionalFilter();
                } else {
                    ca.setAdditionalFilter((Container.Filter)new Compare.Equal((Object)am.getCascadeFilterPath(cascadePath), event.getProperty().getValue()));
                }
            } else {
                throw new OCSRuntimeException("Cannot setup cascading from " + am.getPath() + " to " + cascadePath);
            }
        }
    }

    private void iterate(List<AttributeModel> attributeModels) {
        for (AttributeModel attributeModel : attributeModels) {
            if (attributeModel.isSearchable()) {
                FilterGroup group = this.constructFilterGroup(this.getEntityModel(), attributeModel);
                Integer fieldWidth = SystemPropertyUtils.getDefaultFieldWidth();
                if (fieldWidth != null) {
                    group.getFilterComponent().setWidth(fieldWidth + "px");
                } else {
                    group.getFilterComponent().setSizeFull();
                }
                if (this.nrOfColumns == 1) {
                    this.form.addComponent(group.getFilterComponent());
                } else {
                    int index = this.fieldsAdded % this.nrOfColumns;
                    this.subForms.get(index).addComponent(group.getFilterComponent());
                }
                group.addListener(this);
                this.groups.put(group.getPropertyId(), group);
                ++this.fieldsAdded;
            }
            if (attributeModel.getNestedEntityModel() == null) continue;
            EntityModel nested = attributeModel.getNestedEntityModel();
            this.iterate(nested.getAttributeModels());
        }
    }

    protected void postProcessFilterGroups(Map<String, FilterGroup> groups) {
    }

    @Override
    protected void postProcessLayout(VerticalLayout layout) {
        this.postProcessFilterGroups(this.groups);
    }

    @Override
    public void refresh() {
        for (FilterGroup group : this.getGroups().values()) {
            if (!(group.getField() instanceof Refreshable)) continue;
            ((Refreshable)group.getField()).refresh();
        }
    }

    public void setNrOfColumns(int nrOfColumns) {
        this.nrOfColumns = nrOfColumns;
    }

    public void setSearchValue(String propertyId, Object value) {
        this.setSearchValue(propertyId, value, null);
    }

    public void setSearchValue(String propertyId, Object value, Object auxValue) {
        FilterGroup group = this.groups.get(propertyId);
        group.getField().setValue(value);
        if (group.getAuxField() != null) {
            group.getAuxField().setValue(auxValue);
        }
    }

    protected static enum FilterType {
        BETWEEN,
        BOOLEAN,
        ENTITY,
        ENUM,
        EQUAL,
        LIKE;

    }
}

