/*
 * Decompiled with CFR 0.152.
 */
package com.ocs.dynamo.ui.composite.form;

import com.ocs.dynamo.service.MessageService;
import com.ocs.dynamo.service.ServiceLocatorFactory;
import com.ocs.dynamo.ui.composite.form.Progressable;
import com.ocs.dynamo.ui.utils.VaadinUtils;
import com.ocs.dynamo.utils.MathUtils;
import com.vaadin.ui.UI;
import java.math.BigDecimal;

public class ProgressBarUpdater
implements Runnable {
    private Progressable progressable;
    private int estimatedSize;
    private volatile float progress;
    private volatile boolean stopped;
    private UI ui;

    public ProgressBarUpdater(UI ui, Progressable progressable, int estimatedSize) {
        this.ui = ui;
        this.progressable = progressable;
        this.progress = 0.0f;
        this.estimatedSize = estimatedSize;
    }

    public void setStopped(boolean stopped) {
        this.stopped = stopped;
    }

    @Override
    public void run() {
        while (!this.stopped && (double)this.progress < 1.0) {
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.ui.access(() -> {
                this.progress = this.estimatedSize > 0 ? (float)(1.0 * (double)this.progressable.estimateCurrentProgress() / (1.0 * (double)this.estimatedSize)) : 1.0f;
                if ((double)this.progress > 1.0) {
                    this.progress = 1.0f;
                }
                this.progressable.getProgressBar().setValue(Float.valueOf(this.progress));
                String progressString = VaadinUtils.bigDecimalToString(true, false, BigDecimal.valueOf(this.progress).multiply(MathUtils.HUNDRED));
                MessageService ms = ServiceLocatorFactory.getServiceLocator().getMessageService();
                this.progressable.getStatusLabel().setValue(ms.getMessage("ocs.progress.done", VaadinUtils.getLocale(), new Object[]{progressString}));
            });
        }
    }
}

