/*
 * Decompiled with CFR 0.152.
 */
package com.ocs.dynamo.ui.composite.form;

import com.ocs.dynamo.exception.OCSRuntimeException;
import com.ocs.dynamo.ui.component.DefaultHorizontalLayout;
import com.ocs.dynamo.ui.component.DefaultVerticalLayout;
import com.ocs.dynamo.ui.composite.form.ProgressBarUpdater;
import com.ocs.dynamo.ui.composite.form.Progressable;
import com.ocs.dynamo.ui.composite.layout.BaseCustomComponent;
import com.vaadin.ui.Button;
import com.vaadin.ui.Component;
import com.vaadin.ui.Label;
import com.vaadin.ui.Layout;
import com.vaadin.ui.Notification;
import com.vaadin.ui.ProgressBar;
import com.vaadin.ui.UI;
import java.io.Serializable;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.log4j.Logger;

public abstract class ProgressForm<T>
extends BaseCustomComponent
implements Progressable {
    public static final int POLL_INTERVAL = 500;
    private static final long serialVersionUID = -4717815709838453902L;
    private static final Logger LOGGER = Logger.getLogger(ProgressForm.class);
    private volatile AtomicInteger counter = new AtomicInteger();
    private UI ui = UI.getCurrent();
    private Layout mainLayout;
    private ProgressBar progressBar;
    private Layout progressLayout;
    private ProgressMode progressMode;
    private Label status;

    public ProgressForm(ProgressMode progressMode) {
        this.progressMode = progressMode;
    }

    protected void afterWorkComplete(boolean exceptionOccurred) {
    }

    public void attach() {
        super.attach();
        this.build();
    }

    @Override
    public void build() {
        this.formMode();
    }

    protected void constructSingleButtonLayout(Layout parent, String caption) {
        DefaultHorizontalLayout buttonBar = new DefaultHorizontalLayout(true, true, true);
        parent.addComponent((Component)buttonBar);
        Button clearButton = new Button(caption);
        clearButton.addClickListener((Button.ClickListener & Serializable)event -> this.startWork(null));
        buttonBar.addComponent((Component)clearButton);
    }

    protected abstract void doBuildLayout(Layout var1);

    private void done(boolean exceptionOccurred) {
        this.afterWorkComplete(exceptionOccurred);
        this.formMode();
    }

    @Override
    public int estimateCurrentProgress() {
        return this.counter.get();
    }

    protected abstract int estimateSize(T var1);

    protected OCSRuntimeException extractRuntimeException(Throwable t) {
        if (t instanceof OCSRuntimeException) {
            return (OCSRuntimeException)t;
        }
        if (t.getCause() != null) {
            return this.extractRuntimeException(t.getCause());
        }
        return null;
    }

    protected void formMode() {
        if (this.mainLayout == null) {
            this.mainLayout = new DefaultVerticalLayout(false, true);
            Label label = new Label(this.getTitle());
            this.mainLayout.addComponent((Component)label);
            this.doBuildLayout(this.mainLayout);
        }
        this.ui.setPollInterval(-1);
        this.setCompositionRoot((Component)this.mainLayout);
    }

    public AtomicInteger getCounter() {
        return this.counter;
    }

    @Override
    public ProgressBar getProgressBar() {
        return this.progressBar;
    }

    @Override
    public Label getStatusLabel() {
        return this.status;
    }

    protected String getTitle() {
        return null;
    }

    protected void handleException(Exception ex) {
        OCSRuntimeException r = this.extractRuntimeException(ex);
        if (r != null) {
            this.showNotification(r.getMessage(), Notification.Type.ERROR_MESSAGE);
        } else {
            this.showNotification(ex.getMessage(), Notification.Type.ERROR_MESSAGE);
        }
    }

    protected boolean isFormValid(T t) {
        return true;
    }

    protected abstract void process(T var1, int var2);

    private void progressMode() {
        if (this.progressLayout == null) {
            this.progressLayout = new DefaultVerticalLayout(true, true);
            this.progressBar = new ProgressBar(0.0f);
            this.progressBar.setSizeFull();
            this.progressLayout.addComponent((Component)this.progressBar);
            this.status = new Label();
            this.progressLayout.addComponent((Component)this.status);
        }
        this.progressBar.setValue(Float.valueOf(0.0f));
        this.status.setValue("");
        this.setCompositionRoot((Component)this.progressLayout);
    }

    public void setCounter(AtomicInteger counter) {
        this.counter = counter;
    }

    protected void showNotification(String message, Notification.Type type) {
        this.ui.getSession().lock();
        try {
            super.showNotifification(message, type);
        }
        finally {
            this.ui.getSession().unlock();
        }
    }

    private void signalDone(boolean exceptionOccurred) {
        if (this.ui != null) {
            this.ui.getSession().lock();
            try {
                this.done(exceptionOccurred);
            }
            finally {
                this.ui.getSession().unlock();
            }
        } else {
            this.done(exceptionOccurred);
        }
    }

    protected final void startWork(T t) {
        if (this.isFormValid(t)) {
            if (ProgressMode.SIMPLE.equals((Object)this.progressMode)) {
                try {
                    this.process(t, 0);
                    this.done(false);
                }
                catch (RuntimeException ex) {
                    LOGGER.error((Object)ex.getMessage(), (Throwable)ex);
                    this.showNotification(ex.getMessage(), Notification.Type.ERROR_MESSAGE);
                    this.signalDone(true);
                }
            } else {
                this.progressMode();
                try {
                    int estimatedSize = this.estimateSize(t);
                    this.counter.set(0);
                    this.ui.setPollInterval(500);
                    ProgressBarUpdater updater = new ProgressBarUpdater(this.ui, this, estimatedSize);
                    Thread updateThread = new Thread(updater);
                    updateThread.start();
                    Thread worker = new Thread(() -> {
                        try {
                            this.process(t, estimatedSize);
                        }
                        finally {
                            updater.setStopped(true);
                            this.signalDone(false);
                        }
                    });
                    worker.start();
                }
                catch (RuntimeException ex) {
                    LOGGER.error((Object)ex.getMessage(), (Throwable)ex);
                    this.showNotification(ex.getMessage(), Notification.Type.ERROR_MESSAGE);
                    this.signalDone(true);
                }
            }
        }
    }

    public static enum ProgressMode {
        PROGRESSBAR,
        SIMPLE;

    }
}

