/*
 * Decompiled with CFR 0.152.
 */
package com.ocs.dynamo.ui.composite.form;

import com.ocs.dynamo.ui.composite.form.ProgressForm;
import com.ocs.dynamo.ui.composite.type.ScreenMode;
import com.vaadin.ui.Button;
import com.vaadin.ui.Component;
import com.vaadin.ui.FormLayout;
import com.vaadin.ui.Layout;
import com.vaadin.ui.Notification;
import com.vaadin.ui.Upload;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.Serializable;

public abstract class UploadForm
extends ProgressForm<byte[]> {
    private static final long serialVersionUID = -4717815709838453902L;
    private String fileName;
    private ScreenMode screenMode;
    private boolean showCancelButton;
    private Upload upload;

    public UploadForm(ProgressForm.ProgressMode progressMode, ScreenMode screenMode, boolean showCancelButton) {
        super(progressMode);
        this.screenMode = screenMode;
        this.showCancelButton = showCancelButton;
    }

    protected void cancel() {
    }

    protected void doBuildForm(Layout layout) {
    }

    @Override
    protected void doBuildLayout(Layout main) {
        FormLayout form = new FormLayout();
        form.setMargin(true);
        if (ScreenMode.VERTICAL.equals((Object)this.screenMode)) {
            form.setStyleName("halfScreen");
        }
        main.addComponent((Component)form);
        this.doBuildForm((Layout)form);
        UploadReceiver receiver = new UploadReceiver();
        this.upload = new Upload(this.message("ocs.uploadform.title"), (Upload.Receiver)receiver);
        this.upload.addSucceededListener((Upload.SucceededListener)receiver);
        form.addComponent((Component)this.upload);
        if (this.showCancelButton) {
            Button cancelButton = new Button(this.message("ocs.cancel"));
            cancelButton.addClickListener((Button.ClickListener & Serializable)event -> this.cancel());
            main.addComponent((Component)cancelButton);
        }
    }

    public String getFileName() {
        return this.fileName;
    }

    public Upload getUpload() {
        return this.upload;
    }

    private class UploadReceiver
    implements Upload.SucceededListener,
    Upload.Receiver {
        private static final long serialVersionUID = -8672072143565385035L;
        private ByteArrayOutputStream stream;

        private UploadReceiver() {
        }

        public OutputStream receiveUpload(String filename, String mimeType) {
            this.stream = new ByteArrayOutputStream();
            return this.stream;
        }

        public void uploadSucceeded(Upload.SucceededEvent event) {
            byte[] bytes = this.stream.toByteArray();
            if (bytes != null && bytes.length > 0) {
                UploadForm.this.fileName = event.getFilename();
                UploadForm.this.startWork(bytes);
            } else {
                UploadForm.this.showNotification(UploadForm.this.message("ocs.no.file.selected"), Notification.Type.ERROR_MESSAGE);
            }
        }
    }
}

