/*
 * Decompiled with CFR 0.152.
 */
package com.ocs.dynamo.ui.composite.grid;

import com.vaadin.data.Item;
import com.vaadin.data.Property;
import com.vaadin.data.util.PropertyValueGenerator;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Collection;

public class BigDecimalAverageGenerator
extends PropertyValueGenerator<BigDecimal> {
    private static final long serialVersionUID = -4000091542049888468L;
    private String propertyNameFilter;

    public BigDecimalAverageGenerator(String propertyNameFilter) {
        this.propertyNameFilter = propertyNameFilter;
    }

    public BigDecimal getValue(Item item, Object itemId, Object propertyId) {
        BigDecimal sum = BigDecimal.ZERO;
        int count = 0;
        Collection cols = item.getItemPropertyIds();
        for (Object o : cols) {
            Property prop;
            if (!o.toString().contains("_" + this.propertyNameFilter) || (prop = item.getItemProperty(o)).getValue() == null || !(prop.getValue() instanceof BigDecimal)) continue;
            BigDecimal v = (BigDecimal)prop.getValue();
            sum = sum.add(v);
            ++count;
        }
        return count == 0 ? null : sum.divide(new BigDecimal(count), 2, RoundingMode.HALF_UP);
    }

    public Class<BigDecimal> getType() {
        return BigDecimal.class;
    }
}

