/*
 * Decompiled with CFR 0.152.
 */
package com.ocs.dynamo.ui.composite.layout;

import com.google.common.collect.Lists;
import com.ocs.dynamo.dao.FetchJoinInformation;
import com.ocs.dynamo.domain.AbstractEntity;
import com.ocs.dynamo.domain.model.AttributeModel;
import com.ocs.dynamo.domain.model.EntityModel;
import com.ocs.dynamo.exception.OCSValidationException;
import com.ocs.dynamo.service.BaseService;
import com.ocs.dynamo.ui.component.DefaultHorizontalLayout;
import com.ocs.dynamo.ui.component.DefaultVerticalLayout;
import com.ocs.dynamo.ui.composite.form.AbstractModelBasedSearchForm;
import com.ocs.dynamo.ui.composite.form.ModelBasedEditForm;
import com.ocs.dynamo.ui.composite.layout.BaseCollectionLayout;
import com.ocs.dynamo.ui.composite.layout.BaseServiceCustomComponent;
import com.ocs.dynamo.ui.composite.layout.FormOptions;
import com.ocs.dynamo.ui.composite.layout.LazyTabLayout;
import com.ocs.dynamo.ui.composite.table.ServiceResultsTableWrapper;
import com.ocs.dynamo.ui.composite.type.ScreenMode;
import com.ocs.dynamo.ui.container.QueryType;
import com.ocs.dynamo.ui.utils.FormatUtils;
import com.vaadin.data.Container;
import com.vaadin.data.Property;
import com.vaadin.data.sort.SortOrder;
import com.vaadin.event.ItemClickEvent;
import com.vaadin.server.FontAwesome;
import com.vaadin.server.Resource;
import com.vaadin.ui.Button;
import com.vaadin.ui.Component;
import com.vaadin.ui.Field;
import com.vaadin.ui.HorizontalLayout;
import com.vaadin.ui.Label;
import com.vaadin.ui.Layout;
import com.vaadin.ui.Notification;
import com.vaadin.ui.VerticalLayout;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang.ObjectUtils;

public abstract class AbstractSearchLayout<ID extends Serializable, T extends AbstractEntity<ID>>
extends BaseCollectionLayout<ID, T> {
    private static final long serialVersionUID = 366639924823921266L;
    private Button addButton;
    private Button complexDetailModeBackButton;
    private List<Container.Filter> defaultFilters;
    private Button editButton;
    private ModelBasedEditForm<ID, T> editForm;
    private VerticalLayout mainEditLayout;
    private VerticalLayout mainSearchLayout;
    private Button nextButton;
    private Button prevButton;
    private QueryType queryType;
    private Button removeButton;
    private AbstractModelBasedSearchForm<ID, T> searchForm;
    private boolean searchLayoutConstructed;
    private VerticalLayout searchResultsLayout;
    private Component selectedDetailLayout;
    private Collection<T> selectedItems;
    private VerticalLayout tabContainerLayout;
    private LazyTabLayout<ID, T> tabLayout;

    public AbstractSearchLayout(BaseService<ID, T> service, EntityModel<T> entityModel, QueryType queryType, FormOptions formOptions, SortOrder sortOrder, FetchJoinInformation ... joins) {
        super(service, entityModel, formOptions, sortOrder, joins);
        this.queryType = queryType;
    }

    protected void afterClear() {
    }

    protected void afterSearchFieldToggle(boolean visible) {
    }

    protected void afterSearchPerformed() {
    }

    public void attach() {
        super.attach();
        this.build();
    }

    protected Container.Filter beforeSearchPerformed(Container.Filter filter) {
        return null;
    }

    @Override
    public void build() {
        if (this.mainSearchLayout == null) {
            this.mainSearchLayout = new DefaultVerticalLayout();
            if (this.getFormOptions().isSearchImmediately()) {
                this.constructSearchLayout();
                this.searchLayoutConstructed = true;
            }
            this.mainSearchLayout.addComponent(this.getSearchForm());
            if (this.getSearchForm().getClearButton() != null) {
                if (!this.getFormOptions().isSearchImmediately()) {
                    this.getSearchForm().getClearButton().addClickListener((Button.ClickListener & Serializable)e -> {
                        Label noSearchYetLabel = new Label(this.message("ocs.no.search.yet"));
                        this.searchResultsLayout.removeAllComponents();
                        this.searchResultsLayout.addComponent((Component)noSearchYetLabel);
                        this.getSearchForm().setSearchable(null);
                        this.searchLayoutConstructed = false;
                    });
                }
                this.getSearchForm().getClearButton().addClickListener((Button.ClickListener & Serializable)e -> this.afterClear());
            }
            this.searchResultsLayout = new DefaultVerticalLayout(false, false);
            this.mainSearchLayout.addComponent((Component)this.searchResultsLayout);
            if (this.getFormOptions().isSearchImmediately()) {
                this.searchResultsLayout.addComponent(this.getTableWrapper());
            } else {
                Label noSearchYetLabel = new Label(this.message("ocs.no.search.yet"));
                this.searchResultsLayout.addComponent((Component)noSearchYetLabel);
                this.getSearchForm().getSearchButton().addClickListener((Button.ClickListener & Serializable)e -> this.constructLayoutIfNeeded(noSearchYetLabel));
                if (this.getSearchForm().getSearchAnyButton() != null) {
                    this.getSearchForm().getSearchAnyButton().addClickListener((Button.ClickListener & Serializable)e -> this.constructLayoutIfNeeded(noSearchYetLabel));
                }
            }
            this.addButton = this.constructAddButton();
            this.getButtonBar().addComponent((Component)this.addButton);
            this.editButton = this.constructEditButton();
            this.registerButton(this.editButton);
            this.getButtonBar().addComponent((Component)this.editButton);
            this.removeButton = this.constructRemoveButton();
            this.registerButton(this.removeButton);
            this.getButtonBar().addComponent((Component)this.removeButton);
            this.postProcessButtonBar((Layout)this.getButtonBar());
            this.mainSearchLayout.addComponent((Component)this.getButtonBar());
            this.postProcessLayout((Layout)this.mainSearchLayout);
        }
        this.setCompositionRoot((Component)this.mainSearchLayout);
    }

    protected void buildDetailsTabLayout(T entity, final FormOptions formOptions) {
        this.tabContainerLayout = new DefaultVerticalLayout(true, true);
        DefaultHorizontalLayout buttonBar = new DefaultHorizontalLayout(false, true, true);
        this.tabContainerLayout.addComponent((Component)buttonBar);
        this.complexDetailModeBackButton = new Button(this.message("ocs.back"));
        this.complexDetailModeBackButton.setIcon((Resource)FontAwesome.BACKWARD);
        this.complexDetailModeBackButton.addClickListener((Button.ClickListener & Serializable)e -> this.searchMode());
        buttonBar.addComponent((Component)this.complexDetailModeBackButton);
        if (this.getFormOptions().isShowPrevButton()) {
            this.prevButton = new Button(this.message("ocs.previous"));
            this.prevButton.addClickListener((Button.ClickListener & Serializable)e -> {
                Object prev = this.getPrevEntity(this.tabLayout.getEntity());
                if (prev != null) {
                    this.tabLayout.setEntity(prev);
                    this.tabLayout.reload();
                } else {
                    this.prevButton.setEnabled(false);
                }
                if (this.nextButton != null) {
                    this.nextButton.setEnabled(true);
                }
            });
            buttonBar.addComponent((Component)this.prevButton);
        }
        if (this.getFormOptions().isShowNextButton()) {
            this.nextButton = new Button(this.message("ocs.next"));
            this.nextButton.addClickListener((Button.ClickListener & Serializable)e -> {
                Object next = this.getNextEntity(this.tabLayout.getEntity());
                if (next != null) {
                    this.tabLayout.setEntity(next);
                    this.tabLayout.reload();
                } else {
                    this.nextButton.setEnabled(false);
                }
                if (this.prevButton != null) {
                    this.prevButton.setEnabled(true);
                }
            });
            buttonBar.addComponent((Component)this.nextButton);
        }
        this.tabLayout = new LazyTabLayout<ID, T>((AbstractEntity)entity){
            private static final long serialVersionUID = 1278134557026074688L;

            @Override
            protected String createTitle() {
                return AbstractSearchLayout.this.getDetailModeTabTitle();
            }

            @Override
            protected String[] getTabCaptions() {
                return AbstractSearchLayout.this.getDetailModeTabCaptions();
            }

            @Override
            protected Resource getIconForTab(int index) {
                return AbstractSearchLayout.this.getIconForTab(index);
            }

            @Override
            protected Component initTab(int index) {
                return AbstractSearchLayout.this.initTab(this.getEntity(), index, formOptions, false);
            }
        };
        this.tabLayout.build();
        this.tabContainerLayout.addComponent(this.tabLayout);
    }

    protected void buildEditForm(T entity, FormOptions options) {
        this.editForm = new ModelBasedEditForm<ID, T>((AbstractEntity)entity, this.getService(), this.getEntityModel(), options, this.getFieldFilters()){
            private static final long serialVersionUID = 6485097089659928131L;

            @Override
            protected void afterEditDone(boolean cancel, boolean newObject, T entity) {
                if (this.getFormOptions().isOpenInViewMode()) {
                    if (newObject) {
                        this.back();
                    } else {
                        this.setViewMode(true);
                        AbstractSearchLayout.this.detailsMode(entity);
                    }
                } else if (cancel || newObject || !this.getFormOptions().isShowNextButton() && !this.getFormOptions().isShowPrevButton()) {
                    this.back();
                }
            }

            @Override
            protected void afterEntitySet(T entity) {
                AbstractSearchLayout.this.afterEntitySet(entity);
            }

            @Override
            protected void afterModeChanged(boolean viewMode) {
                AbstractSearchLayout.this.afterModeChanged(viewMode, AbstractSearchLayout.this.editForm);
            }

            @Override
            protected void afterTabSelected(int tabIndex) {
                AbstractSearchLayout.this.afterTabSelected(tabIndex);
            }

            @Override
            protected void back() {
                AbstractSearchLayout.this.searchMode();
            }

            @Override
            protected Field<?> constructCustomField(EntityModel<T> entityModel, AttributeModel attributeModel, boolean viewMode) {
                return AbstractSearchLayout.this.constructCustomField(entityModel, attributeModel, viewMode, false);
            }

            @Override
            protected T getNextEntity(T current) {
                return AbstractSearchLayout.this.getNextEntity(current);
            }

            @Override
            protected String getParentGroup(String childGroup) {
                return AbstractSearchLayout.this.getParentGroup(childGroup);
            }

            @Override
            protected String[] getParentGroupHeaders() {
                return AbstractSearchLayout.this.getParentGroupHeaders();
            }

            @Override
            protected T getPrevEntity(T current) {
                return AbstractSearchLayout.this.getPrevEntity(current);
            }

            @Override
            protected boolean handleCustomException(RuntimeException ex) {
                return AbstractSearchLayout.this.handleCustomException(ex);
            }

            @Override
            protected boolean hasNextEntity(T current) {
                return AbstractSearchLayout.this.hasNextEntity(current);
            }

            @Override
            protected boolean hasPrevEntity(T current) {
                return AbstractSearchLayout.this.hasPrevEntity(current);
            }

            @Override
            protected boolean isEditAllowed() {
                return AbstractSearchLayout.this.isEditAllowed();
            }

            @Override
            protected void postProcessButtonBar(HorizontalLayout buttonBar, boolean viewMode) {
                AbstractSearchLayout.this.postProcessDetailButtonBar((Layout)buttonBar, viewMode);
            }

            @Override
            protected void postProcessEditFields() {
                AbstractSearchLayout.this.postProcessEditFields(AbstractSearchLayout.this.editForm);
            }
        };
        this.editForm.setFormTitleWidth(this.getFormTitleWidth());
        this.editForm.setSupportsIteration(true);
        this.editForm.setDetailJoins(this.getDetailJoinsFallBack());
        this.editForm.setFieldEntityModels(this.getFieldEntityModels());
        this.editForm.build();
    }

    protected final Button constructEditButton() {
        Button eb = new Button(!this.getFormOptions().isEditAllowed() || !this.isEditAllowed() ? this.message("ocs.view") : this.message("ocs.edit"));
        eb.setIcon((Resource)FontAwesome.PENCIL);
        eb.addClickListener((Button.ClickListener & Serializable)e -> {
            if (this.getSelectedItem() != null) {
                this.doEdit();
            }
        });
        eb.setVisible(!this.getFormOptions().isPopup());
        return eb;
    }

    private void constructLayoutIfNeeded(Label noSearchYetLabel) {
        if (!this.searchLayoutConstructed) {
            try {
                this.validateBeforeSearch();
                this.searchResultsLayout.removeAllComponents();
                this.constructSearchLayout();
                this.searchResultsLayout.addComponent(this.getTableWrapper());
                this.getSearchForm().setSearchable(this.getTableWrapper());
                this.searchResultsLayout.removeComponent((Component)noSearchYetLabel);
                this.searchLayoutConstructed = true;
                this.afterSearchPerformed();
            }
            catch (OCSValidationException ex) {
                this.showNotifification((String)ex.getErrors().get(0), Notification.Type.ERROR_MESSAGE);
            }
        }
    }

    protected final Button constructRemoveButton() {
        BaseServiceCustomComponent.RemoveButton rb = new BaseServiceCustomComponent.RemoveButton(this.message("ocs.remove"), null){
            private static final long serialVersionUID = -7428844985367616649L;

            @Override
            protected void doDelete() {
                AbstractSearchLayout.this.remove();
            }

            @Override
            protected String getItemToDelete() {
                Object t = AbstractSearchLayout.this.getSelectedItem();
                return FormatUtils.formatEntity(AbstractSearchLayout.this.getEntityModel(), t);
            }
        };
        rb.setIcon((Resource)FontAwesome.TRASH);
        rb.setVisible(this.isEditAllowed() && this.getFormOptions().isShowRemoveButton());
        return rb;
    }

    protected abstract AbstractModelBasedSearchForm<ID, T> constructSearchForm();

    public final void constructSearchLayout() {
        this.getTableWrapper().getTable().setPageLength(this.getPageLength());
        this.getTableWrapper().getTable().setSortEnabled(this.isSortEnabled());
        this.getTableWrapper().getTable().setMultiSelect(this.isMultiSelect());
        this.getTableWrapper().getTable().addValueChangeListener((Property.ValueChangeListener & Serializable)e -> {
            this.select(this.getTableWrapper().getTable().getValue());
            this.checkButtonState(this.getSelectedItem());
        });
        if (!this.getFormOptions().isPopup() && this.getFormOptions().isDoubleClickSelectAllowed()) {
            this.getTableWrapper().getTable().addItemClickListener((ItemClickEvent.ItemClickListener & Serializable)event -> {
                if (event.isDoubleClick()) {
                    this.select(event.getItem().getItemProperty((Object)"id").getValue());
                    this.doEdit();
                }
            });
        }
        this.constructTableDividers();
    }

    @Override
    public ServiceResultsTableWrapper<ID, T> constructTableWrapper() {
        ServiceResultsTableWrapper result = new ServiceResultsTableWrapper<ID, T>(this.getService(), this.getEntityModel(), this.getQueryType(), this.getSearchForm().extractFilter(), this.getSortOrders(), this.getFormOptions().isTableExportAllowed(), this.getJoins()){
            private static final long serialVersionUID = 6343267378913526151L;

            @Override
            protected Container.Filter beforeSearchPerformed(Container.Filter filter) {
                return AbstractSearchLayout.this.beforeSearchPerformed(filter);
            }

            @Override
            protected void doConstructContainer(Container container) {
                AbstractSearchLayout.this.doConstructContainer(container);
            }
        };
        result.setMaxResults(this.getMaxResults());
        if (this.getFormOptions().isSearchImmediately()) {
            this.getSearchForm().setSearchable(result);
        }
        result.build();
        return result;
    }

    protected final void customDetailView(Component root) {
        this.setCompositionRoot(root);
    }

    protected void detailsMode(T entity, int selectedTab) {
        this.detailsMode(entity);
        if (this.editForm != null) {
            this.editForm.selectTab(selectedTab);
        } else if (this.getFormOptions().isComplexDetailsMode()) {
            this.tabLayout.selectTab(selectedTab);
        }
    }

    @Override
    protected void detailsMode(T entity) {
        if (this.mainEditLayout == null) {
            this.mainEditLayout = new DefaultVerticalLayout();
            this.mainEditLayout.setStyleName("halfScreen");
        }
        FormOptions options = new FormOptions();
        options.setOpenInViewMode(this.getFormOptions().isOpenInViewMode());
        options.setScreenMode(ScreenMode.VERTICAL);
        options.setAttributeGroupMode(this.getFormOptions().getAttributeGroupMode());
        options.setPreserveSelectedTab(this.getFormOptions().isPreserveSelectedTab());
        options.setShowNextButton(this.getFormOptions().isShowNextButton());
        options.setShowPrevButton(this.getFormOptions().isShowPrevButton());
        options.setPlaceButtonBarAtTop(this.getFormOptions().isPlaceButtonBarAtTop());
        options.setFormNested(true);
        options.setValidationMode(this.getFormOptions().getValidationMode());
        options.setConfirmSave(this.getFormOptions().isConfirmSave());
        if (this.getFormOptions().isEditAllowed()) {
            options.setEditAllowed(true);
        } else {
            options.setOpenInViewMode(true).setEditAllowed(false);
        }
        if (options.isOpenInViewMode() || !this.isEditAllowed()) {
            options.setShowBackButton(true);
        }
        if (this.getFormOptions().isComplexDetailsMode() && entity != null && entity.getId() != null) {
            options.setShowBackButton(false);
            options.setHideCancelButton(true);
            if (this.tabContainerLayout == null) {
                this.buildDetailsTabLayout(entity, options);
            } else {
                this.tabLayout.setEntity(entity);
                this.tabLayout.reload();
            }
            if (this.selectedDetailLayout == null) {
                this.mainEditLayout.addComponent((Component)this.tabContainerLayout);
            } else {
                this.mainEditLayout.replaceComponent(this.selectedDetailLayout, (Component)this.tabContainerLayout);
            }
            this.selectedDetailLayout = this.tabContainerLayout;
        } else if (!this.getFormOptions().isComplexDetailsMode()) {
            if (this.editForm == null) {
                this.buildEditForm(entity, options);
            } else {
                this.editForm.setViewMode(options.isOpenInViewMode());
                this.editForm.setEntity(entity);
                this.editForm.resetTab();
            }
            if (this.selectedDetailLayout == null) {
                this.mainEditLayout.addComponent(this.editForm);
            } else {
                this.mainEditLayout.replaceComponent(this.selectedDetailLayout, this.editForm);
            }
            this.selectedDetailLayout = this.editForm;
        } else {
            Component comp = this.initTab(entity, 0, this.getFormOptions(), true);
            if (this.selectedDetailLayout == null) {
                this.mainEditLayout.addComponent(comp);
            } else {
                this.mainEditLayout.replaceComponent(this.selectedDetailLayout, comp);
            }
            this.selectedDetailLayout = comp;
        }
        this.checkButtonState(this.getSelectedItem());
        if (this.editForm != null) {
            this.afterEntitySelected(this.editForm, entity);
        }
        this.setCompositionRoot((Component)this.mainEditLayout);
    }

    protected void doEdit() {
        this.detailsMode(this.getSelectedItem());
    }

    protected void doRemove() {
        this.getService().delete(this.getSelectedItem());
    }

    public final void edit(T entity) {
        this.setSelectedItem(entity);
        this.doEdit();
    }

    public final void edit(T entity, int initialTab) {
        this.setSelectedItem(entity);
        this.doEdit();
        if (this.editForm != null) {
            this.editForm.selectTab(initialTab);
        } else {
            this.tabLayout.selectTab(initialTab);
        }
    }

    public Button getAddButton() {
        return this.addButton;
    }

    protected List<Container.Filter> getDefaultFilters() {
        return this.defaultFilters;
    }

    protected String[] getDetailModeTabCaptions() {
        return new String[0];
    }

    protected String getDetailModeTabTitle() {
        return null;
    }

    public Button getEditButton() {
        return this.editButton;
    }

    public ModelBasedEditForm<ID, T> getEditForm() {
        return this.editForm;
    }

    public int getFilterCount() {
        return this.getSearchForm().getFilterCount();
    }

    public VerticalLayout getMainSearchLayout() {
        return this.mainSearchLayout;
    }

    protected Resource getIconForTab(int index) {
        return null;
    }

    protected T getNextEntity(T current) {
        Serializable id;
        if (current != null && (id = (Serializable)this.getTableWrapper().getTable().nextItemId(current.getId())) != null) {
            AbstractEntity next = this.getService().fetchById((Object)id, this.getDetailJoinsFallBack());
            this.getTableWrapper().getTable().select(next.getId());
            this.afterEntitySelected(this.getEditForm(), next);
            return (T)next;
        }
        return null;
    }

    protected T getPrevEntity(T current) {
        Serializable id;
        if (current != null && (id = (Serializable)this.getTableWrapper().getTable().prevItemId(current.getId())) != null) {
            AbstractEntity prev = this.getService().fetchById((Object)id, this.getDetailJoinsFallBack());
            this.getTableWrapper().getTable().select(prev.getId());
            this.afterEntitySelected(this.getEditForm(), prev);
            return (T)prev;
        }
        return null;
    }

    public QueryType getQueryType() {
        return this.queryType;
    }

    public Button getRemoveButton() {
        return this.removeButton;
    }

    public AbstractModelBasedSearchForm<ID, T> getSearchForm() {
        if (this.searchForm == null) {
            this.searchForm = this.constructSearchForm();
        }
        return this.searchForm;
    }

    public VerticalLayout getSearchResultsLayout() {
        return this.searchResultsLayout;
    }

    public Collection<T> getSelectedItems() {
        return this.selectedItems;
    }

    protected boolean handleCustomException(RuntimeException ex) {
        return false;
    }

    protected boolean hasNextEntity(T current) {
        if (current != null) {
            return this.getTableWrapper().getTable().nextItemId(current.getId()) != null;
        }
        return false;
    }

    protected boolean hasPrevEntity(T current) {
        if (current != null) {
            return this.getTableWrapper().getTable().prevItemId(current.getId()) != null;
        }
        return false;
    }

    protected Component initTab(T entity, int index, FormOptions fo, boolean newEntity) {
        return null;
    }

    public boolean isFilterSet(String path) {
        return this.getSearchForm().isFilterSet(path);
    }

    public boolean isInSearchMode() {
        return ObjectUtils.equals((Object)this.getCompositionRoot(), (Object)this.mainSearchLayout);
    }

    public void postProcessSearchButtonBar(Layout buttonBar) {
    }

    @Override
    public void refresh() {
        this.getSearchForm().refresh();
    }

    public void refreshLabel(String propertyName) {
        if (this.editForm != null) {
            this.editForm.refreshLabel(propertyName);
        }
    }

    @Override
    public void reload() {
        this.setCompositionRoot((Component)this.mainSearchLayout);
        this.getSearchForm().clear();
        this.search();
    }

    public void reloadDetails() {
        this.setSelectedItem(this.getService().fetchById(this.getSelectedItem().getId(), this.getDetailJoinsFallBack()));
        this.detailsMode(this.getSelectedItem());
    }

    protected final void remove() {
        this.doRemove();
        this.setSelectedItem(null);
        this.search();
    }

    public void search() {
        boolean searched = this.searchForm.search();
        if (searched) {
            this.getTableWrapper().getTable().select(null);
            this.setSelectedItem(null);
        }
    }

    public void searchMode() {
        this.setCompositionRoot((Component)this.mainSearchLayout);
        this.getSearchForm().refresh();
        this.search();
    }

    public void select(Object selectedItems) {
        if (selectedItems != null) {
            if (selectedItems instanceof Collection) {
                Collection col = (Collection)selectedItems;
                if (col.size() == 1) {
                    Serializable id = (Serializable)col.iterator().next();
                    this.setSelectedItem(this.getService().fetchById((Object)id, this.getDetailJoinsFallBack()));
                    this.selectedItems = Lists.newArrayList((Object[])new AbstractEntity[]{this.getSelectedItem()});
                } else if (col.size() > 1) {
                    ArrayList ids = Lists.newArrayList();
                    for (Object c : col) {
                        ids.add((Serializable)c);
                    }
                    this.selectedItems = this.getService().fetchByIds((List)ids, this.getDetailJoinsFallBack());
                }
            } else {
                Serializable id = (Serializable)selectedItems;
                this.setSelectedItem(this.getService().fetchById((Object)id, this.getDetailJoinsFallBack()));
            }
        } else {
            this.setSelectedItem(null);
        }
    }

    public void setDefaultFilters(List<Container.Filter> defaultFilters) {
        this.defaultFilters = defaultFilters;
        if (this.searchForm != null) {
            this.searchForm.setDefaultFilters(defaultFilters);
        }
    }

    public void setQueryType(QueryType queryType) {
        this.queryType = queryType;
    }

    public abstract void setSearchValue(String var1, Object var2);

    public abstract void setSearchValue(String var1, Object var2, Object var3);

    public void validateBeforeSearch() {
    }

    public Button getComplexDetailModeBackButton() {
        return this.complexDetailModeBackButton;
    }
}

