/*
 * Decompiled with CFR 0.152.
 */
package com.ocs.dynamo.ui.composite.layout;

import com.ocs.dynamo.dao.FetchJoinInformation;
import com.ocs.dynamo.domain.AbstractEntity;
import com.ocs.dynamo.domain.model.EntityModel;
import com.ocs.dynamo.service.BaseService;
import com.ocs.dynamo.ui.Refreshable;
import com.ocs.dynamo.ui.Reloadable;
import com.ocs.dynamo.ui.component.DefaultHorizontalLayout;
import com.ocs.dynamo.ui.composite.form.ModelBasedEditForm;
import com.ocs.dynamo.ui.composite.layout.BaseServiceCustomComponent;
import com.ocs.dynamo.ui.composite.layout.FormOptions;
import com.ocs.dynamo.ui.composite.table.BaseTableWrapper;
import com.vaadin.data.Container;
import com.vaadin.data.Property;
import com.vaadin.data.sort.SortOrder;
import com.vaadin.server.FontAwesome;
import com.vaadin.server.Resource;
import com.vaadin.ui.Button;
import com.vaadin.ui.HorizontalLayout;
import com.vaadin.ui.Layout;
import com.vaadin.ui.Table;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.ObjectUtils;

public abstract class BaseCollectionLayout<ID extends Serializable, T extends AbstractEntity<ID>>
extends BaseServiceCustomComponent<ID, T>
implements Reloadable,
Refreshable {
    private static final int PAGE_LENGTH = 15;
    private static final long serialVersionUID = -2864711994829582000L;
    private HorizontalLayout buttonBar = new DefaultHorizontalLayout();
    private FetchJoinInformation[] detailJoins;
    private String dividerProperty;
    private Map<String, Container.Filter> fieldFilters = new HashMap<String, Container.Filter>();
    private FetchJoinInformation[] joins;
    private Integer maxResults;
    private boolean multiSelect = false;
    private int pageLength = 15;
    private Object previousDividerValue;
    private T selectedItem;
    private boolean sortEnabled = true;
    private List<SortOrder> sortOrders = new ArrayList<SortOrder>();
    private BaseTableWrapper<ID, T> tableWrapper;

    public BaseCollectionLayout(BaseService<ID, T> service, EntityModel<T> entityModel, FormOptions formOptions, SortOrder sortOrder, FetchJoinInformation ... joins) {
        super(service, entityModel, formOptions);
        this.joins = joins;
        if (sortOrder != null) {
            this.sortOrders.add(sortOrder);
        }
    }

    public final void addSortOrder(SortOrder sortOrder) {
        this.sortOrders.add(sortOrder);
    }

    protected void afterEntitySet(T entity) {
    }

    protected void afterTabSelected(int tabIndex) {
    }

    public void clearSortOrders() {
        this.sortOrders.clear();
    }

    protected final Button constructAddButton() {
        Button ab = new Button(this.message("ocs.add"));
        ab.setIcon((Resource)FontAwesome.PLUS);
        ab.addClickListener((Button.ClickListener & Serializable)e -> this.doAdd());
        ab.setVisible(!this.getFormOptions().isHideAddButton() && this.isEditAllowed());
        return ab;
    }

    protected final void constructTableDividers() {
        if (this.dividerProperty != null) {
            this.getTableWrapper().getTable().setStyleName("divider");
            this.getTableWrapper().getTable().setCellStyleGenerator((Table.CellStyleGenerator & Serializable)(source, itemId, propertyId) -> {
                Property prop;
                String result = null;
                if (itemId != null && (prop = source.getItem(itemId).getItemProperty((Object)this.dividerProperty)) != null) {
                    Object obj = prop.getValue();
                    if (!ObjectUtils.equals((Object)obj, (Object)this.previousDividerValue)) {
                        result = "divider";
                    }
                    this.previousDividerValue = obj;
                }
                return result;
            });
        }
    }

    protected abstract BaseTableWrapper<ID, T> constructTableWrapper();

    protected T createEntity() {
        return (T)this.getService().createNewEntity();
    }

    protected abstract void detailsMode(T var1);

    public void doAdd() {
        this.setSelectedItem(this.createEntity());
        this.detailsMode(this.getSelectedItem());
    }

    protected void doConstructContainer(Container container) {
    }

    public HorizontalLayout getButtonBar() {
        return this.buttonBar;
    }

    public FetchJoinInformation[] getDetailJoins() {
        return this.detailJoins;
    }

    public FetchJoinInformation[] getDetailJoinsFallBack() {
        return this.detailJoins == null || this.detailJoins.length == 0 ? this.getJoins() : this.detailJoins;
    }

    public String getDividerProperty() {
        return this.dividerProperty;
    }

    public Map<String, Container.Filter> getFieldFilters() {
        return this.fieldFilters;
    }

    public FetchJoinInformation[] getJoins() {
        return this.joins;
    }

    public Integer getMaxResults() {
        return this.maxResults;
    }

    public int getPageLength() {
        return this.pageLength;
    }

    protected String getParentGroup(String childGroup) {
        return null;
    }

    protected String[] getParentGroupHeaders() {
        return null;
    }

    public T getSelectedItem() {
        return this.selectedItem;
    }

    public List<SortOrder> getSortOrders() {
        return Collections.unmodifiableList(this.sortOrders);
    }

    public BaseTableWrapper<ID, T> getTableWrapper() {
        if (this.tableWrapper == null) {
            this.tableWrapper = this.constructTableWrapper();
            this.postProcessTableWrapper(this.tableWrapper);
        }
        return this.tableWrapper;
    }

    protected boolean isEditAllowed() {
        return true;
    }

    public boolean isMultiSelect() {
        return this.multiSelect;
    }

    public boolean isSortEnabled() {
        return this.sortEnabled;
    }

    protected void postProcessButtonBar(Layout buttonBar) {
    }

    protected void postProcessDetailButtonBar(Layout buttonBar, boolean viewMode) {
    }

    protected void postProcessEditFields(ModelBasedEditForm<ID, T> editForm) {
    }

    protected void postProcessLayout(Layout main) {
    }

    protected void postProcessTableWrapper(BaseTableWrapper<ID, T> wrapper) {
    }

    public void setDetailJoins(FetchJoinInformation[] detailJoins) {
        this.detailJoins = detailJoins;
    }

    public void setDividerProperty(String dividerProperty) {
        this.dividerProperty = dividerProperty;
    }

    public void setFieldFilters(Map<String, Container.Filter> fieldFilters) {
        this.fieldFilters = fieldFilters;
    }

    public void setMaxResults(Integer maxResults) {
        this.maxResults = maxResults;
    }

    public void setMultiSelect(boolean multiSelect) {
        this.multiSelect = multiSelect;
    }

    public void setPageLength(int pageLength) {
        this.pageLength = pageLength;
    }

    public void setSelectedItem(T selectedItem) {
        this.selectedItem = selectedItem;
        this.checkButtonState(selectedItem);
    }

    public void setSortEnabled(boolean sortEnabled) {
        this.sortEnabled = sortEnabled;
    }
}

