/*
 * Decompiled with CFR 0.152.
 */
package com.ocs.dynamo.ui.composite.layout;

import com.ocs.dynamo.domain.model.AttributeModel;
import com.ocs.dynamo.domain.model.EntityModelFactory;
import com.ocs.dynamo.exception.OCSRuntimeException;
import com.ocs.dynamo.exception.OCSValidationException;
import com.ocs.dynamo.service.MessageService;
import com.ocs.dynamo.service.ServiceLocatorFactory;
import com.ocs.dynamo.ui.BaseUI;
import com.ocs.dynamo.ui.Buildable;
import com.ocs.dynamo.ui.utils.FormatUtils;
import com.ocs.dynamo.ui.utils.VaadinUtils;
import com.ocs.dynamo.utils.ClassUtils;
import com.vaadin.server.Page;
import com.vaadin.shared.Position;
import com.vaadin.shared.ui.label.ContentMode;
import com.vaadin.ui.Component;
import com.vaadin.ui.CustomComponent;
import com.vaadin.ui.Label;
import com.vaadin.ui.Notification;
import com.vaadin.ui.UI;
import javax.persistence.OptimisticLockException;
import org.apache.log4j.Logger;

public abstract class BaseCustomComponent
extends CustomComponent
implements Buildable {
    private static final Logger LOG = Logger.getLogger(BaseCustomComponent.class);
    private static final long serialVersionUID = -8982555842423738005L;
    private MessageService messageService = ServiceLocatorFactory.getServiceLocator().getMessageService();

    protected Component constructLabel(Object entity, AttributeModel attributeModel) {
        Label fieldLabel = new Label("", ContentMode.HTML);
        fieldLabel.setCaption(attributeModel.getDisplayName());
        Object value = ClassUtils.getFieldValue((Object)entity, (String)attributeModel.getName());
        String formatted = FormatUtils.formatPropertyValue(this.getEntityModelFactory(), attributeModel, value, "<br/>");
        fieldLabel.setValue(formatted);
        return fieldLabel;
    }

    protected EntityModelFactory getEntityModelFactory() {
        return ServiceLocatorFactory.getServiceLocator().getEntityModelFactory();
    }

    protected MessageService getMessageService() {
        return this.messageService;
    }

    protected <T> T getService(Class<T> clazz) {
        return (T)ServiceLocatorFactory.getServiceLocator().getService(clazz);
    }

    protected void handleSaveException(RuntimeException ex) {
        if (ex instanceof OCSValidationException) {
            LOG.warn((Object)ex.getMessage(), (Throwable)ex);
            this.showNotifification((String)((OCSValidationException)ex).getErrors().get(0), Notification.Type.ERROR_MESSAGE);
        } else if (ex instanceof OCSRuntimeException) {
            LOG.error((Object)ex.getMessage(), (Throwable)ex);
            this.showNotifification(ex.getMessage(), Notification.Type.ERROR_MESSAGE);
        } else if (ex instanceof OptimisticLockException) {
            LOG.error((Object)ex.getMessage(), (Throwable)ex);
            this.showNotifification(this.message("ocs.optimistic.lock"), Notification.Type.ERROR_MESSAGE);
        } else {
            LOG.error((Object)ex.getMessage(), (Throwable)ex);
            this.showNotifification(this.message("ocs.error.occurred"), Notification.Type.ERROR_MESSAGE);
        }
    }

    protected String message(String key) {
        return this.getMessageService().getMessage(key, VaadinUtils.getLocale());
    }

    protected String message(String key, Object ... args) {
        return this.getMessageService().getMessage(key, VaadinUtils.getLocale(), args);
    }

    protected void navigate(String viewName) {
        BaseUI ui = (BaseUI)UI.getCurrent();
        ui.navigate(viewName);
    }

    protected void showNotifification(String message, Notification.Type type) {
        if (Page.getCurrent() != null) {
            Notification not = new Notification(message, type);
            if (Notification.Type.TRAY_NOTIFICATION.equals((Object)type)) {
                not.setStyleName("dynamoTray");
                not.setDelayMsec(1000);
                not.setPosition(Position.MIDDLE_CENTER);
            }
            not.show(Page.getCurrent());
        } else {
            LOG.info((Object)message);
        }
    }
}

