/*
 * Decompiled with CFR 0.152.
 */
package com.ocs.dynamo.ui.composite.layout;

import com.ocs.dynamo.domain.AbstractEntity;
import com.ocs.dynamo.domain.model.AttributeModel;
import com.ocs.dynamo.domain.model.EntityModel;
import com.ocs.dynamo.exception.OCSRuntimeException;
import com.ocs.dynamo.service.BaseService;
import com.ocs.dynamo.ui.composite.form.ModelBasedEditForm;
import com.ocs.dynamo.ui.composite.layout.BaseCustomComponent;
import com.ocs.dynamo.ui.composite.layout.FormOptions;
import com.ocs.dynamo.ui.utils.VaadinUtils;
import com.vaadin.server.Resource;
import com.vaadin.ui.Button;
import com.vaadin.ui.Field;
import com.vaadin.ui.Notification;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class BaseServiceCustomComponent<ID extends Serializable, T extends AbstractEntity<ID>>
extends BaseCustomComponent {
    private static final long serialVersionUID = 6015180039863418544L;
    private EntityModel<T> entityModel;
    private Map<String, String> fieldEntityModels = new HashMap<String, String>();
    private FormOptions formOptions;
    private Integer formTitleWidth;
    private BaseService<ID, T> service;
    private List<Button> toUpdate = new ArrayList<Button>();

    public BaseServiceCustomComponent(BaseService<ID, T> service, EntityModel<T> entityModel, FormOptions formOptions) {
        this.service = service;
        this.entityModel = entityModel;
        this.formOptions = formOptions;
    }

    public final void addFieldEntityModel(String path, String reference) {
        this.fieldEntityModels.put(path, reference);
    }

    protected void afterEntitySelected(ModelBasedEditForm<ID, T> editForm, T entity) {
    }

    protected void afterModeChanged(boolean viewMode, ModelBasedEditForm<ID, T> editForm) {
    }

    protected boolean beforeSave() {
        return true;
    }

    protected void checkButtonState(T selectedItem) {
        for (Button b : this.toUpdate) {
            boolean enabled = selectedItem != null && this.mustEnableButton(b, selectedItem);
            b.setEnabled(enabled);
        }
    }

    protected Field<?> constructCustomField(EntityModel<T> entityModel, AttributeModel attributeModel, boolean viewMode, boolean searchMode) {
        return null;
    }

    public EntityModel<T> getEntityModel() {
        return this.entityModel;
    }

    public Map<String, String> getFieldEntityModels() {
        return this.fieldEntityModels;
    }

    public FormOptions getFormOptions() {
        return this.formOptions;
    }

    public Integer getFormTitleWidth() {
        return this.formTitleWidth;
    }

    public BaseService<ID, T> getService() {
        return this.service;
    }

    protected boolean mustEnableButton(Button button, T selectedItem) {
        return true;
    }

    public final void registerButton(Button button) {
        if (button != null) {
            button.setEnabled(false);
            this.toUpdate.add(button);
        }
    }

    public final void removeFieldEntityModel(String path) {
        this.fieldEntityModels.remove(path);
    }

    public void setFormTitleWidth(Integer formTitleWidth) {
        this.formTitleWidth = formTitleWidth;
    }

    public void setService(BaseService<ID, T> service) {
        this.service = service;
    }

    protected abstract class RemoveButton
    extends Button {
        private static final long serialVersionUID = -942298948585447203L;

        public RemoveButton(String message, Resource icon) {
            super(message);
            this.setIcon(icon);
            this.addClickListener((Button.ClickListener & Serializable)event -> {
                Runnable r = () -> {
                    try {
                        this.doDelete();
                    }
                    catch (OCSRuntimeException ex) {
                        BaseServiceCustomComponent.this.showNotifification(ex.getMessage(), Notification.Type.ERROR_MESSAGE);
                    }
                };
                VaadinUtils.showConfirmDialog(BaseServiceCustomComponent.this.getMessageService(), BaseServiceCustomComponent.this.message("ocs.delete.confirm", this.getItemToDelete()), r);
            });
        }

        protected abstract void doDelete();

        protected abstract String getItemToDelete();
    }
}

