/*
 * Decompiled with CFR 0.152.
 */
package com.ocs.dynamo.ui.composite.layout;

import com.ocs.dynamo.dao.FetchJoinInformation;
import com.ocs.dynamo.domain.AbstractEntity;
import com.ocs.dynamo.domain.model.AttributeModel;
import com.ocs.dynamo.domain.model.EntityModel;
import com.ocs.dynamo.service.BaseService;
import com.ocs.dynamo.ui.component.DefaultVerticalLayout;
import com.ocs.dynamo.ui.composite.form.ModelBasedEditForm;
import com.ocs.dynamo.ui.composite.layout.BaseCollectionLayout;
import com.ocs.dynamo.ui.composite.layout.BaseServiceCustomComponent;
import com.ocs.dynamo.ui.composite.layout.FormOptions;
import com.ocs.dynamo.ui.composite.type.ScreenMode;
import com.ocs.dynamo.ui.utils.FormatUtils;
import com.vaadin.data.sort.SortOrder;
import com.vaadin.server.FontAwesome;
import com.vaadin.server.Resource;
import com.vaadin.ui.Button;
import com.vaadin.ui.Component;
import com.vaadin.ui.Field;
import com.vaadin.ui.HorizontalLayout;
import com.vaadin.ui.HorizontalSplitPanel;
import com.vaadin.ui.Label;
import com.vaadin.ui.Layout;
import com.vaadin.ui.Panel;
import com.vaadin.ui.TextField;
import com.vaadin.ui.VerticalLayout;
import java.io.Serializable;
import java.util.function.Consumer;

public abstract class BaseSplitLayout<ID extends Serializable, T extends AbstractEntity<ID>>
extends BaseCollectionLayout<ID, T> {
    private static final long serialVersionUID = 4606800218149558500L;
    private Button addButton;
    private Consumer<T> customSaveConsumer;
    private Integer defaultSplitPosition;
    private Layout detailFormLayout;
    private Layout detailLayout;
    private ModelBasedEditForm<ID, T> editForm;
    private Component headerLayout;
    private VerticalLayout mainLayout;
    private TextField quickSearchField;
    private Button removeButton;
    private Component selectedDetailLayout;

    public BaseSplitLayout(BaseService<ID, T> service, EntityModel<T> entityModel, FormOptions formOptions, SortOrder sortOrder, FetchJoinInformation ... joins) {
        super(service, entityModel, formOptions, sortOrder, joins);
    }

    protected void afterReload(T entity) {
    }

    public void attach() {
        super.attach();
        this.build();
    }

    @Override
    public void build() {
        this.buildFilter();
        if (this.mainLayout == null) {
            this.mainLayout = new DefaultVerticalLayout(true, true);
            HorizontalSplitPanel splitter = null;
            DefaultVerticalLayout splitterLayout = null;
            this.detailLayout = new DefaultVerticalLayout();
            this.emptyDetailView();
            this.headerLayout = this.constructHeaderLayout();
            if (this.headerLayout != null) {
                this.mainLayout.addComponent(this.headerLayout);
            }
            this.quickSearchField = this.constructSearchField();
            if (!this.isHorizontalMode() && this.quickSearchField != null) {
                this.mainLayout.addComponent((Component)this.quickSearchField);
            }
            this.getTableWrapper().getTable().setPageLength(this.getPageLength());
            this.getTableWrapper().getTable().setSortEnabled(this.isSortEnabled());
            this.constructTableDividers();
            if (this.isHorizontalMode()) {
                splitter = new HorizontalSplitPanel();
                this.mainLayout.addComponent((Component)splitter);
                splitterLayout = new DefaultVerticalLayout(false, true);
                if (this.quickSearchField != null) {
                    splitterLayout.addComponent((Component)this.quickSearchField);
                }
                splitterLayout.addComponent((Component)this.getTableWrapper());
                splitter.setFirstComponent((Component)splitterLayout);
                if (this.defaultSplitPosition != null) {
                    splitter.setSplitPosition((float)this.defaultSplitPosition.intValue());
                }
            } else {
                this.mainLayout.addComponent(this.getTableWrapper());
            }
            if (this.isHorizontalMode()) {
                splitterLayout.addComponent((Component)this.getButtonBar());
            } else {
                this.mainLayout.addComponent((Component)this.getButtonBar());
            }
            Panel editPanel = new Panel();
            editPanel.setContent((Component)this.detailLayout);
            if (this.isHorizontalMode()) {
                DefaultVerticalLayout extra = new DefaultVerticalLayout(true, false);
                extra.addComponent((Component)editPanel);
                splitter.setSecondComponent((Component)extra);
            } else {
                this.mainLayout.addComponent((Component)editPanel);
            }
            this.addButton = this.constructAddButton();
            this.getButtonBar().addComponent((Component)this.addButton);
            this.removeButton = this.constructRemoveButton();
            this.registerButton(this.removeButton);
            this.getButtonBar().addComponent((Component)this.removeButton);
            this.postProcessButtonBar((Layout)this.getButtonBar());
            this.postProcessLayout((Layout)this.mainLayout);
            this.checkButtonState(null);
            this.setCompositionRoot((Component)this.mainLayout);
        }
    }

    protected abstract void buildFilter();

    protected void checkMainButtons() {
        if (this.getAddButton() != null) {
            this.getAddButton().setVisible(!this.getFormOptions().isHideAddButton() && this.isEditAllowed());
        }
        if (this.getRemoveButton() != null) {
            this.getRemoveButton().setVisible(this.getFormOptions().isShowRemoveButton() && this.isEditAllowed());
        }
    }

    protected Component constructHeaderLayout() {
        return null;
    }

    protected final Button constructRemoveButton() {
        BaseServiceCustomComponent.RemoveButton rb = new BaseServiceCustomComponent.RemoveButton(this.message("ocs.remove"), null){

            @Override
            protected void doDelete() {
                BaseSplitLayout.this.remove();
            }

            @Override
            protected String getItemToDelete() {
                Object t = BaseSplitLayout.this.getSelectedItem();
                return FormatUtils.formatEntity(BaseSplitLayout.this.getEntityModel(), t);
            }
        };
        rb.setIcon((Resource)FontAwesome.TRASH);
        rb.setVisible(this.getFormOptions().isShowRemoveButton() && this.isEditAllowed());
        return rb;
    }

    protected abstract TextField constructSearchField();

    protected void customDetailView(Component component) {
        this.detailLayout.replaceComponent(this.selectedDetailLayout, component);
        this.selectedDetailLayout = component;
    }

    @Override
    protected void detailsMode(T entity) {
        if (this.detailFormLayout == null) {
            this.detailFormLayout = new DefaultVerticalLayout(false, false);
            this.getFormOptions().setHideCancelButton(true).setPreserveSelectedTab(true);
            this.editForm = new ModelBasedEditForm<ID, T>((AbstractEntity)entity, this.getService(), this.getEntityModel(), this.getFormOptions(), this.getFieldFilters()){

                @Override
                protected void afterEditDone(boolean cancel, boolean newObject, T entity) {
                    BaseSplitLayout.this.reload();
                    BaseSplitLayout.this.detailsMode(entity);
                    BaseSplitLayout.this.afterReload(entity);
                }

                @Override
                protected void afterEntitySet(T entity) {
                    BaseSplitLayout.this.afterEntitySet(entity);
                }

                @Override
                protected void afterModeChanged(boolean viewMode) {
                    BaseSplitLayout.this.afterModeChanged(viewMode, BaseSplitLayout.this.editForm);
                }

                @Override
                protected void afterTabSelected(int tabIndex) {
                    BaseSplitLayout.this.afterTabSelected(tabIndex);
                }

                @Override
                protected Field<?> constructCustomField(EntityModel<T> entityModel, AttributeModel attributeModel, boolean viewMode) {
                    return BaseSplitLayout.this.constructCustomField(entityModel, attributeModel, viewMode, false);
                }

                @Override
                protected String getParentGroup(String childGroup) {
                    return BaseSplitLayout.this.getParentGroup(childGroup);
                }

                @Override
                protected String[] getParentGroupHeaders() {
                    return BaseSplitLayout.this.getParentGroupHeaders();
                }

                @Override
                protected boolean handleCustomException(RuntimeException ex) {
                    return BaseSplitLayout.this.handleCustomException(ex);
                }

                @Override
                protected boolean isEditAllowed() {
                    return BaseSplitLayout.this.isEditAllowed();
                }

                @Override
                protected void postProcessButtonBar(HorizontalLayout buttonBar, boolean viewMode) {
                    BaseSplitLayout.this.postProcessDetailButtonBar((Layout)buttonBar, viewMode);
                }

                @Override
                protected void postProcessEditFields() {
                    BaseSplitLayout.this.postProcessEditFields(BaseSplitLayout.this.editForm);
                }
            };
            this.editForm.setCustomSaveConsumer(this.customSaveConsumer);
            this.editForm.setFormTitleWidth(this.getFormTitleWidth());
            this.editForm.setDetailJoins(this.getDetailJoinsFallBack());
            this.editForm.setFieldEntityModels(this.getFieldEntityModels());
            this.editForm.build();
            this.detailFormLayout.addComponent(this.editForm);
        } else {
            this.editForm.setViewMode(this.getFormOptions().isOpenInViewMode());
            this.editForm.setEntity(entity);
            this.editForm.resetTab();
        }
        this.setSelectedItem(entity);
        this.checkButtonState(this.getSelectedItem());
        this.afterEntitySelected(this.editForm, entity);
        this.detailLayout.replaceComponent(this.selectedDetailLayout, (Component)this.detailFormLayout);
        this.selectedDetailLayout = this.detailFormLayout;
    }

    protected void doRemove() {
        this.getService().delete(this.getSelectedItem());
    }

    public void doSave() {
        this.editForm.doSave();
    }

    public void emptyDetailView() {
        VerticalLayout vLayout = new VerticalLayout();
        vLayout.addComponent((Component)new Label(this.message("ocs.select.item", this.getEntityModel().getDisplayName())));
        this.detailLayout.replaceComponent(this.selectedDetailLayout, (Component)vLayout);
        this.selectedDetailLayout = vLayout;
    }

    public Button getAddButton() {
        return this.addButton;
    }

    public Consumer<T> getCustomSaveConsumer() {
        return this.customSaveConsumer;
    }

    public Integer getDefaultSplitPosition() {
        return this.defaultSplitPosition;
    }

    public Layout getDetailLayout() {
        return this.detailLayout;
    }

    public ModelBasedEditForm<ID, T> getEditForm() {
        return this.editForm;
    }

    public TextField getQuickSearchField() {
        return this.quickSearchField;
    }

    public Button getRemoveButton() {
        return this.removeButton;
    }

    protected boolean handleCustomException(RuntimeException ex) {
        return false;
    }

    protected boolean isHorizontalMode() {
        return ScreenMode.HORIZONTAL.equals((Object)this.getFormOptions().getScreenMode());
    }

    @Override
    public void refresh() {
    }

    public void refreshLabel(String propertyName) {
        if (this.editForm != null) {
            this.editForm.refreshLabel(propertyName);
        }
    }

    @Override
    public void reload() {
        Component component = this.constructHeaderLayout();
        if (component != null) {
            if (this.headerLayout != null) {
                this.mainLayout.replaceComponent(this.headerLayout, component);
            } else {
                this.mainLayout.addComponent(component, 0);
            }
        } else if (this.headerLayout != null) {
            this.mainLayout.removeComponent(this.headerLayout);
        }
        this.headerLayout = component;
        if (this.quickSearchField != null) {
            this.quickSearchField.setValue("");
        }
        this.getTableWrapper().reloadContainer();
        this.setSelectedItem(null);
        this.emptyDetailView();
        this.checkMainButtons();
    }

    public void reloadDetails() {
        this.setSelectedItem(this.getService().fetchById(this.getSelectedItem().getId(), this.getDetailJoinsFallBack()));
        this.detailsMode(this.getSelectedItem());
        this.getTableWrapper().reloadContainer();
    }

    protected final void remove() {
        this.doRemove();
        this.setSelectedItem(null);
        this.emptyDetailView();
        this.reload();
    }

    protected void reselect(T t) {
        this.detailsMode(t);
        this.getTableWrapper().getTable().select(t == null ? null : t.getId());
    }

    public void setCustomSaveConsumer(Consumer<T> customSaveConsumer) {
        this.customSaveConsumer = customSaveConsumer;
    }

    public void setDefaultSplitPosition(Integer defaultSplitPosition) {
        this.defaultSplitPosition = defaultSplitPosition;
    }

    public abstract void setSelectedItems(Object var1);

    public void setViewMode(boolean viewMode) {
        if (this.getSelectedItem() != null) {
            this.editForm.setViewMode(viewMode);
        }
    }
}

