/*
 * Decompiled with CFR 0.152.
 */
package com.ocs.dynamo.ui.composite.layout;

import com.ocs.dynamo.domain.AbstractEntity;
import com.ocs.dynamo.ui.CanAssignEntity;
import com.ocs.dynamo.ui.Reloadable;
import com.ocs.dynamo.ui.component.DefaultVerticalLayout;
import com.ocs.dynamo.ui.composite.layout.BaseCustomComponent;
import com.vaadin.ui.Component;
import com.vaadin.ui.Layout;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public abstract class CompositionLayout<ID extends Serializable, T extends AbstractEntity<ID>>
extends BaseCustomComponent
implements Reloadable,
CanAssignEntity<ID, T> {
    private static final long serialVersionUID = 3696293073812817902L;
    private List<Component> nestedComponents = new ArrayList<Component>();
    private T entity;

    public CompositionLayout(T entity) {
        this.entity = entity;
    }

    public void attach() {
        super.attach();
        this.build();
    }

    @Override
    public void build() {
        DefaultVerticalLayout main = new DefaultVerticalLayout();
        this.doBuildLayout((Layout)main);
        this.setCompositionRoot((Component)main);
    }

    protected abstract void doBuildLayout(Layout var1);

    @Override
    public void assignEntity(T entity) {
        this.entity = entity;
    }

    protected void addNestedComponent(Component c) {
        this.nestedComponents.add(c);
    }

    @Override
    public void reload() {
        for (Component c : this.nestedComponents) {
            if (c instanceof CanAssignEntity) {
                ((CanAssignEntity)c).assignEntity(this.entity);
            }
            if (!(c instanceof Reloadable)) continue;
            ((Reloadable)c).reload();
        }
    }

    public T getEntity() {
        return this.entity;
    }

    public void setEntity(T entity) {
        this.entity = entity;
    }
}

