/*
 * Decompiled with CFR 0.152.
 */
package com.ocs.dynamo.ui.composite.layout;

import com.ocs.dynamo.dao.FetchJoinInformation;
import com.ocs.dynamo.domain.AbstractEntity;
import com.ocs.dynamo.domain.model.EntityModel;
import com.ocs.dynamo.service.BaseService;
import com.ocs.dynamo.ui.composite.layout.BaseSplitLayout;
import com.ocs.dynamo.ui.composite.layout.FormOptions;
import com.ocs.dynamo.ui.composite.table.BaseTableWrapper;
import com.ocs.dynamo.ui.composite.table.FixedTableWrapper;
import com.vaadin.data.Container;
import com.vaadin.data.sort.SortOrder;
import com.vaadin.data.util.BeanItemContainer;
import com.vaadin.ui.TextField;
import java.io.Serializable;
import java.util.Collection;

public abstract class FixedSplitLayout<ID extends Serializable, T extends AbstractEntity<ID>>
extends BaseSplitLayout<ID, T> {
    private static final long serialVersionUID = 4606800218149558500L;
    private Collection<T> items;

    public FixedSplitLayout(BaseService<ID, T> service, EntityModel<T> entityModel, FormOptions formOptions, SortOrder sortOrder) {
        super(service, entityModel, formOptions, sortOrder, new FetchJoinInformation[0]);
    }

    @Override
    protected void afterReload(T t) {
        this.getTableWrapper().getTable().select(t);
    }

    @Override
    public void buildFilter() {
        this.items = this.loadItems();
    }

    @Override
    protected final TextField constructSearchField() {
        return null;
    }

    @Override
    protected BaseTableWrapper<ID, T> constructTableWrapper() {
        FixedTableWrapper tw = new FixedTableWrapper<ID, T>(this.getService(), this.getEntityModel(), this.getItems(), this.getSortOrders(), this.getFormOptions().isTableExportAllowed()){

            @Override
            protected void doConstructContainer(Container container) {
                FixedSplitLayout.this.doConstructContainer(container);
            }

            @Override
            protected void onSelect(Object selected) {
                FixedSplitLayout.this.setSelectedItems(selected);
                FixedSplitLayout.this.checkButtonState(FixedSplitLayout.this.getSelectedItem());
                if (FixedSplitLayout.this.getSelectedItem() != null) {
                    FixedSplitLayout.this.detailsMode(FixedSplitLayout.this.getSelectedItem());
                }
            }
        };
        tw.build();
        return tw;
    }

    public Collection<T> getItems() {
        return this.items;
    }

    protected abstract Collection<T> loadItems();

    @Override
    public void reload() {
        this.buildFilter();
        super.reload();
        BeanItemContainer beanContainer = (BeanItemContainer)this.getTableWrapper().getContainer();
        beanContainer.removeAllItems();
        beanContainer.addAll(this.getItems());
        this.setSelectedItem(null);
    }

    @Override
    public void setSelectedItems(Object selectedItems) {
        if (selectedItems != null) {
            if (selectedItems instanceof Collection) {
                Collection col = (Collection)selectedItems;
                AbstractEntity t = (AbstractEntity)col.iterator().next();
                this.setSelectedItem(this.getService().fetchById(t.getId(), new FetchJoinInformation[0]));
            } else {
                AbstractEntity t = (AbstractEntity)selectedItems;
                this.setSelectedItem(t);
            }
        } else {
            this.setSelectedItem(null);
            this.emptyDetailView();
        }
    }
}

