/*
 * Decompiled with CFR 0.152.
 */
package com.ocs.dynamo.ui.composite.layout;

import com.ocs.dynamo.dao.FetchJoinInformation;
import com.ocs.dynamo.domain.AbstractEntity;
import com.ocs.dynamo.domain.model.AttributeModel;
import com.ocs.dynamo.domain.model.EntityModel;
import com.ocs.dynamo.service.BaseService;
import com.ocs.dynamo.ui.composite.form.AbstractModelBasedSearchForm;
import com.ocs.dynamo.ui.composite.form.FlexibleFilterType;
import com.ocs.dynamo.ui.composite.form.ModelBasedFlexibleSearchForm;
import com.ocs.dynamo.ui.composite.layout.AbstractSearchLayout;
import com.ocs.dynamo.ui.composite.layout.FormOptions;
import com.ocs.dynamo.ui.container.QueryType;
import com.vaadin.data.sort.SortOrder;
import com.vaadin.ui.Field;
import com.vaadin.ui.Layout;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;

public class FlexibleSearchLayout<ID extends Serializable, T extends AbstractEntity<ID>>
extends AbstractSearchLayout<ID, T> {
    private static final long serialVersionUID = -6179979286298244161L;
    private Set<String> basicStringFilterProperties = new HashSet<String>();

    public FlexibleSearchLayout(BaseService<ID, T> service, EntityModel<T> entityModel, QueryType queryType, FormOptions formOptions, SortOrder sortOrder, FetchJoinInformation ... joins) {
        super(service, entityModel, queryType, formOptions, sortOrder, joins);
    }

    @Override
    protected AbstractModelBasedSearchForm<ID, T> constructSearchForm() {
        ModelBasedFlexibleSearchForm result = new ModelBasedFlexibleSearchForm<ID, T>(null, this.getEntityModel(), this.getFormOptions(), this.getDefaultFilters(), this.getFieldFilters()){
            private static final long serialVersionUID = 8929442625027442714L;

            @Override
            protected void afterSearchFieldToggle(boolean visible) {
                FlexibleSearchLayout.this.afterSearchFieldToggle(visible);
            }

            @Override
            protected void afterSearchPerformed() {
                FlexibleSearchLayout.this.afterSearchPerformed();
            }

            @Override
            protected Field<?> constructCustomField(EntityModel<T> entityModel, AttributeModel attributeModel) {
                return FlexibleSearchLayout.this.constructCustomField(entityModel, attributeModel, false, true);
            }

            @Override
            protected void postProcessButtonBar(Layout buttonBar) {
                FlexibleSearchLayout.this.postProcessSearchButtonBar(buttonBar);
            }

            @Override
            protected void validateBeforeSearch() {
                FlexibleSearchLayout.this.validateBeforeSearch();
            }
        };
        result.setFieldEntityModels(this.getFieldEntityModels());
        result.setBasicStringFilterProperties(this.basicStringFilterProperties);
        result.build();
        for (AttributeModel am : this.getEntityModel().getRequiredForSearchingAttributeModels()) {
            result.addFilter(am, result.getDefaultFilterType(am), null, null);
        }
        return result;
    }

    public void addBasicStringFilterProperty(String property) {
        this.basicStringFilterProperties.add(property);
    }

    @Override
    public ModelBasedFlexibleSearchForm<ID, T> getSearchForm() {
        return (ModelBasedFlexibleSearchForm)super.getSearchForm();
    }

    @Override
    public void setSearchValue(String propertyId, Object value) {
        ((ModelBasedFlexibleSearchForm)this.getSearchForm()).addFilter(this.getEntityModel().getAttributeModel(propertyId), FlexibleFilterType.EQUALS, value, null);
    }

    @Override
    public void setSearchValue(String propertyId, Object value, Object auxValue) {
        ((ModelBasedFlexibleSearchForm)this.getSearchForm()).addFilter(this.getEntityModel().getAttributeModel(propertyId), FlexibleFilterType.BETWEEN, value, auxValue);
    }
}

