/*
 * Decompiled with CFR 0.152.
 */
package com.ocs.dynamo.ui.composite.layout;

import com.ocs.dynamo.domain.AbstractEntity;
import com.ocs.dynamo.ui.CanAssignEntity;
import com.ocs.dynamo.ui.Reloadable;
import com.ocs.dynamo.ui.component.DefaultVerticalLayout;
import com.ocs.dynamo.ui.composite.layout.BaseCustomComponent;
import com.vaadin.server.Resource;
import com.vaadin.ui.Component;
import com.vaadin.ui.Layout;
import com.vaadin.ui.Panel;
import com.vaadin.ui.TabSheet;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;
import org.springframework.util.StringUtils;

public abstract class LazyTabLayout<ID extends Serializable, T extends AbstractEntity<ID>>
extends BaseCustomComponent
implements Reloadable {
    private static final long serialVersionUID = 3788799136302802727L;
    private Set<String> constructedTabs = new HashSet<String>();
    private T entity;
    private Panel panel;
    private TabSheet tabs;

    public LazyTabLayout(T entity) {
        this.entity = entity;
    }

    public void attach() {
        super.attach();
        this.build();
    }

    protected void beforeReload(int index, Component component) {
    }

    @Override
    public void build() {
        if (this.tabs == null) {
            this.tabs = new TabSheet();
            this.tabs.setSizeFull();
            String title = this.createTitle();
            if (!StringUtils.isEmpty((Object)title)) {
                this.panel = new Panel();
                this.panel.setCaptionAsHtml(true);
                this.panel.setCaption(this.createTitle());
                DefaultVerticalLayout main = new DefaultVerticalLayout(true, true);
                this.panel.setContent((Component)main);
                main.addComponent((Component)this.tabs);
                this.setCompositionRoot((Component)this.panel);
            } else {
                this.setCompositionRoot((Component)this.tabs);
            }
            this.setupLazySheet(this.tabs);
        }
    }

    protected abstract String createTitle();

    public T getEntity() {
        return this.entity;
    }

    protected abstract Resource getIconForTab(int var1);

    public TabSheet.Tab getTab(int index) {
        return this.tabs.getTab(index);
    }

    protected abstract String[] getTabCaptions();

    protected String getTabDescription(int index) {
        return null;
    }

    private int getTabIndex(String caption) {
        int index = 0;
        for (int i = 0; i < this.tabs.getComponentCount(); ++i) {
            TabSheet.Tab t = this.tabs.getTab(i);
            if (!t.getCaption().equals(caption)) continue;
            index = i;
            break;
        }
        return index;
    }

    private void initOrReload(Component selectedTab) {
        TabSheet.Tab tab = this.tabs.getTab(selectedTab);
        if (!this.constructedTabs.contains(tab.getCaption())) {
            this.constructedTabs.add(tab.getCaption());
            int index = this.getTabIndex(tab.getCaption());
            Component realTab = this.initTab(index);
            ((Layout)selectedTab).addComponent(realTab);
        } else {
            Layout layout = (Layout)selectedTab;
            Component next = (Component)layout.iterator().next();
            if (next instanceof Reloadable) {
                if (next instanceof CanAssignEntity) {
                    ((CanAssignEntity)next).assignEntity(this.getEntity());
                }
                this.beforeReload(this.getTabIndex(tab.getCaption()), next);
                ((Reloadable)next).reload();
            }
        }
    }

    protected abstract Component initTab(int var1);

    @Override
    public void reload() {
        this.initOrReload(this.tabs.getSelectedTab());
    }

    public void selectTab(int index) {
        this.tabs.setSelectedTab(index);
    }

    public void setEntity(T entity) {
        this.entity = entity;
        this.selectTab(0);
        if (this.panel != null) {
            this.panel.setCaption(this.createTitle());
        }
    }

    private void setupLazySheet(TabSheet tabs) {
        int i = 0;
        for (String caption : this.getTabCaptions()) {
            TabSheet.Tab t = tabs.addTab((Component)new DefaultVerticalLayout(false, false), caption);
            t.setIcon(this.getIconForTab(i));
            t.setDescription(this.getTabDescription(i++));
        }
        ((Layout)tabs.getTab(0).getComponent()).addComponent(this.initTab(0));
        this.constructedTabs.add(tabs.getTab(0).getCaption());
        tabs.addSelectedTabChangeListener((TabSheet.SelectedTabChangeListener & Serializable)event -> {
            Component component = event.getTabSheet().getSelectedTab();
            this.initOrReload(component);
        });
    }
}

