/*
 * Decompiled with CFR 0.152.
 */
package com.ocs.dynamo.ui.composite.layout;

import com.ocs.dynamo.dao.FetchJoinInformation;
import com.ocs.dynamo.domain.AbstractEntity;
import com.ocs.dynamo.domain.model.EntityModel;
import com.ocs.dynamo.service.BaseService;
import com.ocs.dynamo.ui.composite.layout.BaseSplitLayout;
import com.ocs.dynamo.ui.composite.layout.FormOptions;
import com.ocs.dynamo.ui.composite.table.BaseTableWrapper;
import com.ocs.dynamo.ui.composite.table.ServiceResultsTableWrapper;
import com.ocs.dynamo.ui.container.QueryType;
import com.ocs.dynamo.ui.container.ServiceContainer;
import com.vaadin.data.Container;
import com.vaadin.data.sort.SortOrder;
import com.vaadin.data.util.filter.And;
import com.vaadin.data.util.filter.Like;
import com.vaadin.event.FieldEvents;
import com.vaadin.ui.TextField;
import java.io.Serializable;
import java.util.Collection;
import org.springframework.util.StringUtils;

public class ServiceBasedSplitLayout<ID extends Serializable, T extends AbstractEntity<ID>>
extends BaseSplitLayout<ID, T> {
    private static final long serialVersionUID = 1068860513192819804L;
    private Container.Filter filter;
    private QueryType queryType;

    public ServiceBasedSplitLayout(BaseService<ID, T> service, EntityModel<T> entityModel, QueryType queryType, FormOptions formOptions, SortOrder sortOrder, FetchJoinInformation ... joins) {
        super(service, entityModel, formOptions, sortOrder, joins);
        this.queryType = queryType;
    }

    @Override
    protected final void buildFilter() {
        this.filter = this.constructFilter();
    }

    protected Container.Filter constructFilter() {
        return null;
    }

    protected Container.Filter constructQuickSearchFilter(String value) {
        return null;
    }

    @Override
    protected TextField constructSearchField() {
        if (this.getFormOptions().isShowQuickSearchField()) {
            TextField searchField = new TextField(this.message("ocs.search"));
            searchField.addTextChangeListener((FieldEvents.TextChangeListener & Serializable)event -> {
                String text = event.getText();
                if (!StringUtils.isEmpty((Object)text)) {
                    Container.Filter quickFilter = this.constructQuickSearchFilter(text);
                    if (quickFilter == null && this.getEntityModel().getMainAttributeModel() != null) {
                        quickFilter = new Like((Object)this.getEntityModel().getMainAttributeModel().getPath(), "%" + text + "%", false);
                    }
                    Container.Filter temp = quickFilter;
                    if (this.getFilter() != null) {
                        temp = new And(new Container.Filter[]{quickFilter, this.getFilter()});
                    }
                    this.getContainer().search(temp);
                } else {
                    this.getContainer().search(this.filter);
                }
            });
            return searchField;
        }
        return null;
    }

    @Override
    protected BaseTableWrapper<ID, T> constructTableWrapper() {
        ServiceResultsTableWrapper tw = new ServiceResultsTableWrapper<ID, T>(this.getService(), this.getEntityModel(), this.getQueryType(), this.filter, this.getSortOrders(), this.getFormOptions().isTableExportAllowed(), this.getJoins()){

            @Override
            protected void doConstructContainer(Container container) {
                ServiceBasedSplitLayout.this.doConstructContainer(container);
            }

            @Override
            protected void onSelect(Object selected) {
                ServiceBasedSplitLayout.this.setSelectedItems(selected);
                ServiceBasedSplitLayout.this.checkButtonState(ServiceBasedSplitLayout.this.getSelectedItem());
                if (ServiceBasedSplitLayout.this.getSelectedItem() != null) {
                    ServiceBasedSplitLayout.this.detailsMode(ServiceBasedSplitLayout.this.getSelectedItem());
                }
            }
        };
        tw.setMaxResults(this.getMaxResults());
        tw.build();
        return tw;
    }

    protected ServiceContainer<ID, T> getContainer() {
        return (ServiceContainer)this.getTableWrapper().getContainer();
    }

    public Container.Filter getFilter() {
        return this.filter;
    }

    public QueryType getQueryType() {
        return this.queryType;
    }

    @Override
    public ServiceResultsTableWrapper<ID, T> getTableWrapper() {
        return (ServiceResultsTableWrapper)super.getTableWrapper();
    }

    @Override
    public void reload() {
        this.buildFilter();
        super.reload();
        this.refresh();
        ((ServiceResultsTableWrapper)this.getTableWrapper()).setFilter(this.filter);
    }

    @Override
    public void setSelectedItems(Object selectedItems) {
        if (selectedItems != null) {
            if (selectedItems instanceof Collection) {
                Collection col = (Collection)selectedItems;
                Serializable id = (Serializable)col.iterator().next();
                this.setSelectedItem(this.getService().fetchById((Object)id, this.getDetailJoinsFallBack()));
            } else {
                Serializable id = (Serializable)selectedItems;
                this.setSelectedItem(this.getService().fetchById((Object)id, this.getDetailJoinsFallBack()));
            }
        } else {
            this.setSelectedItem(null);
            this.emptyDetailView();
        }
    }
}

