/*
 * Decompiled with CFR 0.152.
 */
package com.ocs.dynamo.ui.composite.layout;

import com.ocs.dynamo.dao.FetchJoinInformation;
import com.ocs.dynamo.domain.AbstractEntity;
import com.ocs.dynamo.domain.model.AttributeModel;
import com.ocs.dynamo.domain.model.EntityModel;
import com.ocs.dynamo.service.BaseService;
import com.ocs.dynamo.ui.CanAssignEntity;
import com.ocs.dynamo.ui.Reloadable;
import com.ocs.dynamo.ui.component.DefaultVerticalLayout;
import com.ocs.dynamo.ui.composite.form.ModelBasedEditForm;
import com.ocs.dynamo.ui.composite.layout.BaseServiceCustomComponent;
import com.ocs.dynamo.ui.composite.layout.FormOptions;
import com.ocs.dynamo.ui.composite.type.ScreenMode;
import com.vaadin.data.Container;
import com.vaadin.ui.Component;
import com.vaadin.ui.Field;
import com.vaadin.ui.HorizontalLayout;
import com.vaadin.ui.Layout;
import com.vaadin.ui.VerticalLayout;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;

public class SimpleEditLayout<ID extends Serializable, T extends AbstractEntity<ID>>
extends BaseServiceCustomComponent<ID, T>
implements Reloadable,
CanAssignEntity<ID, T> {
    private static final long serialVersionUID = -7935358582100755140L;
    private ModelBasedEditForm<ID, T> editForm;
    private T entity;
    private Map<String, Container.Filter> fieldFilters = new HashMap<String, Container.Filter>();
    private FetchJoinInformation[] joins;
    private VerticalLayout main;
    private Consumer<T> customSaveConsumer;

    public SimpleEditLayout(T entity, BaseService<ID, T> service, EntityModel<T> entityModel, FormOptions formOptions, FetchJoinInformation ... joins) {
        super(service, entityModel, formOptions);
        this.entity = entity;
        this.joins = joins;
    }

    protected void afterEditDone(boolean cancel, boolean newEntity, T entity) {
        if (entity.getId() != null) {
            if (this.getFormOptions().isOpenInViewMode()) {
                this.editForm.setViewMode(true);
            }
        } else {
            this.back();
        }
    }

    protected void afterLayoutBuilt(Layout layout, boolean viewMode) {
    }

    protected void afterTabSelected(int tabIndex) {
    }

    @Override
    public void assignEntity(T t) {
        this.setEntity(t);
        if (this.editForm != null) {
            this.editForm.resetTab();
        }
    }

    public void attach() {
        super.attach();
        this.build();
    }

    protected void back() {
    }

    @Override
    public void build() {
        if (this.main == null) {
            this.main = new DefaultVerticalLayout(true, true);
            if (this.entity == null) {
                this.entity = this.createEntity();
            }
            this.getFormOptions().setScreenMode(ScreenMode.VERTICAL);
            this.editForm = new ModelBasedEditForm<ID, T>((AbstractEntity)this.entity, this.getService(), this.getEntityModel(), this.getFormOptions(), this.fieldFilters){

                @Override
                protected void afterLayoutBuilt(Layout layout, boolean viewMode) {
                    SimpleEditLayout.this.afterLayoutBuilt(layout, viewMode);
                }

                @Override
                protected void afterEntitySet(T entity) {
                    SimpleEditLayout.this.afterEntitySet(entity);
                }

                @Override
                protected void afterEditDone(boolean cancel, boolean newObject, T entity) {
                    this.setEntity(entity);
                    SimpleEditLayout.this.afterEditDone(cancel, newObject, entity);
                }

                @Override
                protected void afterModeChanged(boolean viewMode) {
                    SimpleEditLayout.this.afterModeChanged(viewMode, SimpleEditLayout.this.editForm);
                }

                @Override
                protected void afterTabSelected(int tabIndex) {
                    SimpleEditLayout.this.afterTabSelected(tabIndex);
                }

                @Override
                protected void back() {
                    SimpleEditLayout.this.back();
                }

                @Override
                protected Field<?> constructCustomField(EntityModel<T> entityModel, AttributeModel attributeModel, boolean viewMode) {
                    return SimpleEditLayout.this.constructCustomField(entityModel, attributeModel, viewMode, false);
                }

                @Override
                protected String getParentGroup(String childGroup) {
                    return SimpleEditLayout.this.getParentGroup(childGroup);
                }

                @Override
                protected String[] getParentGroupHeaders() {
                    return SimpleEditLayout.this.getParentGroupHeaders();
                }

                @Override
                protected boolean isEditAllowed() {
                    return SimpleEditLayout.this.isEditAllowed();
                }

                @Override
                protected void postProcessButtonBar(HorizontalLayout buttonBar, boolean viewMode) {
                    SimpleEditLayout.this.postProcessButtonBar(buttonBar, viewMode);
                }

                @Override
                protected void postProcessEditFields() {
                    SimpleEditLayout.this.postProcessEditFields(SimpleEditLayout.this.editForm);
                }
            };
            this.editForm.setCustomSaveConsumer(this.customSaveConsumer);
            this.editForm.setDetailJoins(this.getJoins());
            this.editForm.setFormTitleWidth(this.getFormTitleWidth());
            this.editForm.setFieldEntityModels(this.getFieldEntityModels());
            this.editForm.build();
            this.main.addComponent(this.editForm);
            this.postProcessLayout((Layout)this.main);
            this.setCompositionRoot((Component)this.main);
            this.afterEntitySelected(this.editForm, this.getEntity());
            this.checkButtonState(this.getEntity());
        }
    }

    protected T createEntity() {
        return (T)this.getService().createNewEntity();
    }

    public ModelBasedEditForm<ID, T> getEditForm() {
        return this.editForm;
    }

    public T getEntity() {
        return this.entity;
    }

    public Map<String, Container.Filter> getFieldFilters() {
        return this.fieldFilters;
    }

    public FetchJoinInformation[] getJoins() {
        return this.joins;
    }

    protected String getParentGroup(String childGroup) {
        return null;
    }

    protected String[] getParentGroupHeaders() {
        return null;
    }

    protected boolean isEditAllowed() {
        return true;
    }

    public boolean isViewMode() {
        return this.editForm.isViewMode();
    }

    protected void postProcessButtonBar(HorizontalLayout buttonBar, boolean viewMode) {
    }

    protected void postProcessEditFields(ModelBasedEditForm<ID, T> editForm) {
    }

    protected void postProcessLayout(Layout main) {
    }

    public void refreshLabel(String propertyName) {
        if (this.editForm != null) {
            this.editForm.refreshLabel(propertyName);
        }
    }

    @Override
    public void reload() {
        if (this.getFormOptions().isOpenInViewMode()) {
            this.editForm.setViewMode(true);
        }
        if (this.entity.getId() != null) {
            this.setEntity(this.getService().fetchById(this.entity.getId(), this.getJoins()));
            this.editForm.resetTab();
        }
    }

    public void resetTab() {
        this.editForm.resetTab();
    }

    public void selectTab(int index) {
        this.editForm.selectTab(index);
    }

    public void setEntity(T entity) {
        this.entity = entity;
        if (this.entity == null) {
            this.entity = this.createEntity();
        }
        this.editForm.setEntity(this.entity);
        this.afterEntitySelected(this.editForm, this.entity);
        this.checkButtonState(this.getEntity());
    }

    public void setFieldFilters(Map<String, Container.Filter> fieldFilters) {
        this.fieldFilters = fieldFilters;
    }

    public void setJoins(FetchJoinInformation[] joins) {
        this.joins = joins;
    }

    public Consumer<T> getCustomSaveConsumer() {
        return this.customSaveConsumer;
    }

    public void setCustomSaveConsumer(Consumer<T> customSaveConsumer) {
        this.customSaveConsumer = customSaveConsumer;
    }

    public void doSave() {
        this.editForm.doSave();
    }

    public void afterEntitySet(T entity) {
    }
}

