/*
 * Decompiled with CFR 0.152.
 */
package com.ocs.dynamo.ui.composite.layout;

import com.ocs.dynamo.dao.FetchJoinInformation;
import com.ocs.dynamo.domain.AbstractEntity;
import com.ocs.dynamo.domain.model.EntityModel;
import com.ocs.dynamo.service.BaseService;
import com.ocs.dynamo.ui.composite.form.ModelBasedSearchForm;
import com.ocs.dynamo.ui.composite.layout.FormOptions;
import com.ocs.dynamo.ui.composite.layout.SimpleSearchLayout;
import com.ocs.dynamo.ui.composite.table.ServiceResultsTableWrapper;
import com.ocs.dynamo.ui.composite.table.ServiceResultsTreeTableWrapper;
import com.ocs.dynamo.ui.container.QueryType;
import com.ocs.dynamo.ui.container.hierarchical.HierarchicalFetchJoinInformation;
import com.ocs.dynamo.ui.container.hierarchical.ModelBasedHierarchicalContainer;
import com.vaadin.data.Container;
import com.vaadin.data.Item;
import com.vaadin.data.util.BeanItem;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import org.vaadin.addons.lazyquerycontainer.CompositeItem;

public class SimpleSearchTreeComponent<ID extends Serializable, T extends AbstractEntity<ID>>
extends SimpleSearchLayout<ID, T> {
    private List<BaseService<?, ?>> services;
    private Object selectedItem;

    public SimpleSearchTreeComponent(List<BaseService<?, ?>> services, EntityModel<T> entityModel, QueryType queryType, FormOptions formOptions, FetchJoinInformation ... joins) {
        super(services.get(0), entityModel, queryType, formOptions, null, joins);
        this.services = services;
    }

    @Override
    public ServiceResultsTableWrapper<ID, T> constructTableWrapper() {
        ServiceResultsTreeTableWrapper result = new ServiceResultsTreeTableWrapper<ID, T>(this.services, this.getEntityModel(), this.getQueryType(), null, this.getFormOptions().isTableExportAllowed(), this.getJoins()){

            @Override
            protected void doConstructContainer(Container container) {
                SimpleSearchTreeComponent.this.doConstructContainer(container);
            }

            @Override
            protected Container.Filter beforeSearchPerformed(Container.Filter filter) {
                return SimpleSearchTreeComponent.this.beforeSearchPerformed(filter);
            }
        };
        result.build();
        return result;
    }

    @Override
    protected ModelBasedSearchForm<ID, T> constructSearchForm() {
        ModelBasedHierarchicalContainer c = (ModelBasedHierarchicalContainer)this.getTableWrapper().getContainer();
        ModelBasedHierarchicalContainer.ModelBasedHierarchicalDefinition def = c.getHierarchicalDefinition(0);
        ModelBasedSearchForm result = new ModelBasedSearchForm(this.getTableWrapper(), def.getEntityModel(), this.getFormOptions(), this.getDefaultFilters(), this.getFieldFilters());
        result.build();
        return result;
    }

    public HierarchicalFetchJoinInformation[] getJoins() {
        return (HierarchicalFetchJoinInformation[])super.getJoins();
    }

    @Override
    public void build() {
        this.getTableWrapper();
        super.build();
    }

    @Override
    public void select(Object selectedItems) {
        if (selectedItems != null) {
            Object id;
            Collection col;
            if (selectedItems instanceof Collection && !(col = (Collection)selectedItems).isEmpty() && (id = col.iterator().next()) != null) {
                ModelBasedHierarchicalContainer c = (ModelBasedHierarchicalContainer)this.getTableWrapper().getContainer();
                Item item = c.getItem(id);
                if (item instanceof BeanItem) {
                    this.setSelectedHierarchicalItem(((BeanItem)item).getBean());
                } else if (item instanceof CompositeItem) {
                    this.setSelectedHierarchicalItem(((CompositeItem)item).getItem("default-item"));
                } else {
                    this.setSelectedHierarchicalItem(item);
                }
            }
        } else {
            this.setSelectedHierarchicalItem(null);
        }
    }

    protected void setSelectedHierarchicalItem(Object selectedItem) {
        this.selectedItem = selectedItem;
    }

    public Object getSelectedHierarchicalItem() {
        return this.selectedItem;
    }
}

