/*
 * Decompiled with CFR 0.152.
 */
package com.ocs.dynamo.ui.composite.layout;

import com.ocs.dynamo.dao.FetchJoinInformation;
import com.ocs.dynamo.domain.AbstractEntity;
import com.ocs.dynamo.domain.model.AttributeModel;
import com.ocs.dynamo.domain.model.EditableType;
import com.ocs.dynamo.domain.model.EntityModel;
import com.ocs.dynamo.domain.model.impl.ModelBasedFieldFactory;
import com.ocs.dynamo.service.BaseService;
import com.ocs.dynamo.ui.component.DefaultVerticalLayout;
import com.ocs.dynamo.ui.component.URLField;
import com.ocs.dynamo.ui.composite.layout.BaseCollectionLayout;
import com.ocs.dynamo.ui.composite.layout.BaseServiceCustomComponent;
import com.ocs.dynamo.ui.composite.layout.FormOptions;
import com.ocs.dynamo.ui.composite.table.BaseTableWrapper;
import com.ocs.dynamo.ui.composite.table.ModelBasedTable;
import com.ocs.dynamo.ui.composite.table.ServiceResultsTableWrapper;
import com.ocs.dynamo.ui.container.QueryType;
import com.ocs.dynamo.ui.container.ServiceContainer;
import com.ocs.dynamo.ui.utils.FormatUtils;
import com.ocs.dynamo.ui.utils.VaadinUtils;
import com.vaadin.data.Container;
import com.vaadin.data.Property;
import com.vaadin.data.sort.SortOrder;
import com.vaadin.server.FontAwesome;
import com.vaadin.server.Resource;
import com.vaadin.ui.Button;
import com.vaadin.ui.Component;
import com.vaadin.ui.Field;
import com.vaadin.ui.Layout;
import com.vaadin.ui.Table;
import com.vaadin.ui.TableFieldFactory;
import com.vaadin.ui.VerticalLayout;
import java.io.Serializable;
import java.util.Collection;
import org.vaadin.addons.lazyquerycontainer.CompositeItem;

public class TabularEditLayout<ID extends Serializable, T extends AbstractEntity<ID>>
extends BaseCollectionLayout<ID, T> {
    private static final int PAGE_LENGTH = 15;
    private static final long serialVersionUID = 4606800218149558500L;
    private Button addButton;
    private Button cancelButton;
    private Button editButton;
    private Container.Filter filter;
    private VerticalLayout mainLayout;
    private int pageLength = 15;
    private Resource removeIcon;
    private String removeMessage;
    private Button saveButton;
    private boolean viewmode;

    public TabularEditLayout(BaseService<ID, T> service, EntityModel<T> entityModel, FormOptions formOptions, SortOrder sortOrder, FetchJoinInformation ... joins) {
        super(service, entityModel, formOptions, sortOrder, joins);
    }

    public void attach() {
        super.attach();
        this.build();
    }

    @Override
    public void build() {
        this.filter = this.constructFilter();
        if (this.mainLayout == null) {
            this.setViewmode(!this.isEditAllowed() || this.getFormOptions().isOpenInViewMode());
            this.mainLayout = new DefaultVerticalLayout(true, true);
            this.constructTable();
            if (this.getFormOptions().isShowRemoveButton()) {
                String defaultMsg = this.message("ocs.remove");
                this.getTableWrapper().getTable().addGeneratedColumn((Object)defaultMsg, (Table.ColumnGenerator & Serializable)(source, itemId, columnId) -> this.isViewmode() ? null : new BaseServiceCustomComponent.RemoveButton(this.removeMessage, this.removeIcon){

                    @Override
                    protected void doDelete() {
                        CompositeItem ci = (CompositeItem)source.getItem(itemId);
                        TabularEditLayout.this.doRemove((AbstractEntity)VaadinUtils.getEntityFromItem(ci));
                    }

                    @Override
                    protected String getItemToDelete() {
                        CompositeItem ci = (CompositeItem)source.getItem(itemId);
                        AbstractEntity t = (AbstractEntity)VaadinUtils.getEntityFromItem(ci);
                        return FormatUtils.formatEntity(TabularEditLayout.this.getEntityModel(), t);
                    }
                });
            }
            this.mainLayout.addComponent((Component)this.getButtonBar());
            this.addButton = new Button(this.message("ocs.add"));
            this.addButton.setIcon((Resource)FontAwesome.PLUS);
            this.addButton.addClickListener((Button.ClickListener & Serializable)event -> {
                Serializable id = (Serializable)this.getContainer().addItem();
                this.createEntity(this.getEntityFromTable(id));
                this.getTableWrapper().getTable().setCurrentPageFirstItemId((Object)id);
            });
            this.getButtonBar().addComponent((Component)this.addButton);
            this.addButton.setVisible(!this.getFormOptions().isHideAddButton() && this.isEditAllowed() && !this.isViewmode());
            this.saveButton = new Button(this.message("ocs.save"));
            this.saveButton.setIcon((Resource)FontAwesome.SAVE);
            this.saveButton.setEnabled(false);
            this.saveButton.addClickListener((Button.ClickListener & Serializable)event -> {
                try {
                    this.getContainer().commit();
                    if (this.getFormOptions().isOpenInViewMode()) {
                        this.toggleViewMode(true);
                    }
                }
                catch (RuntimeException ex) {
                    this.handleSaveException(ex);
                }
            });
            this.getButtonBar().addComponent((Component)this.saveButton);
            this.saveButton.setVisible(!this.isViewmode());
            this.editButton = new Button(this.message("ocs.edit"));
            this.editButton.setIcon((Resource)FontAwesome.PENCIL);
            this.editButton.addClickListener((Button.ClickListener & Serializable)event -> this.toggleViewMode(false));
            this.editButton.setVisible(this.isViewmode() && this.getFormOptions().isEditAllowed());
            this.getButtonBar().addComponent((Component)this.editButton);
            this.cancelButton = new Button(this.message("ocs.cancel"));
            this.cancelButton.setIcon((Resource)FontAwesome.BAN);
            this.cancelButton.addClickListener((Button.ClickListener & Serializable)event -> {
                this.reload();
                this.toggleViewMode(true);
            });
            this.cancelButton.setVisible(!this.isViewmode() && this.getFormOptions().isOpenInViewMode());
            this.getButtonBar().addComponent((Component)this.cancelButton);
            this.postProcessButtonBar((Layout)this.getButtonBar());
            this.constructTableDividers();
            this.postProcessLayout((Layout)this.mainLayout);
        }
        this.setCompositionRoot((Component)this.mainLayout);
    }

    protected Container.Filter constructFilter() {
        return null;
    }

    protected void constructTable() {
        Table table = this.getTableWrapper().getTable();
        table.setEditable(!this.isViewmode());
        table.setBuffered(true);
        table.setMultiSelect(false);
        table.setColumnCollapsingAllowed(false);
        table.setCacheRate(2.0);
        table.setSortEnabled(this.isSortEnabled());
        table.setPageLength(this.getPageLength());
        if (this.getSortOrders() != null && !this.getSortOrders().isEmpty()) {
            ServiceContainer<ID, T> sc = this.getContainer();
            sc.sort(this.getSortOrders().toArray(new SortOrder[0]));
        }
        table.setTableFieldFactory((TableFieldFactory)new ModelBasedFieldFactory<T>(this.getEntityModel(), this.getMessageService(), true, false){

            @Override
            public Field<?> createField(String propertyId, EntityModel<?> fieldEntityModel) {
                Field<?> field;
                AttributeModel am = TabularEditLayout.this.getEntityModel().getAttributeModel(propertyId);
                Field<?> custom = TabularEditLayout.this.constructCustomField(TabularEditLayout.this.getEntityModel(), am, TabularEditLayout.this.isViewmode(), false);
                boolean hasFilter = TabularEditLayout.this.getFieldFilters().containsKey(propertyId);
                Field<?> field2 = custom != null ? custom : (field = hasFilter ? super.constructField(am, TabularEditLayout.this.getFieldFilters(), fieldEntityModel) : super.createField(propertyId, fieldEntityModel));
                if (field instanceof URLField) {
                    ((URLField)field).setEditable(!TabularEditLayout.this.isViewmode() && !EditableType.READ_ONLY.equals((Object)am.getEditableType()));
                }
                if (field != null && field.isEnabled()) {
                    field.addValueChangeListener((Property.ValueChangeListener & Serializable)event -> {
                        if (TabularEditLayout.this.saveButton != null) {
                            TabularEditLayout.this.saveButton.setEnabled(VaadinUtils.allFixedTableFieldsValid(TabularEditLayout.this.getTableWrapper().getTable()));
                        }
                    });
                    field.setSizeFull();
                    TabularEditLayout.this.postProcessField(am.getPath(), field);
                }
                return field;
            }
        });
        this.mainLayout.addComponent(this.getTableWrapper());
    }

    @Override
    protected BaseTableWrapper<ID, T> constructTableWrapper() {
        ServiceResultsTableWrapper tableWrapper = new ServiceResultsTableWrapper<ID, T>(this.getService(), this.getEntityModel(), QueryType.PAGING, this.filter, this.getSortOrders(), this.getFormOptions().isTableExportAllowed(), this.getJoins()){

            @Override
            protected void doConstructContainer(Container container) {
                TabularEditLayout.this.doConstructContainer(container);
            }

            @Override
            protected void onSelect(Object selected) {
                TabularEditLayout.this.setSelectedItems(selected);
                TabularEditLayout.this.checkButtonState(TabularEditLayout.this.getSelectedItem());
            }
        };
        tableWrapper.setMaxResults(this.getMaxResults());
        tableWrapper.build();
        return tableWrapper;
    }

    @Override
    protected T createEntity() {
        throw new UnsupportedOperationException("This method is not supported for this component - use the parameterized method instead");
    }

    protected T createEntity(T entity) {
        return entity;
    }

    @Override
    protected void detailsMode(T entity) {
    }

    protected void doRemove(T t) {
        this.getTableWrapper().getTable().removeItem(t.getId());
        this.getTableWrapper().getTable().commit();
    }

    public Button getAddButton() {
        return this.addButton;
    }

    public Button getCancelButton() {
        return this.cancelButton;
    }

    protected ServiceContainer<ID, T> getContainer() {
        return (ServiceContainer)this.getTableWrapper().getContainer();
    }

    public Button getEditButton() {
        return this.editButton;
    }

    protected T getEntityFromTable(ID id) {
        return (T)((AbstractEntity)VaadinUtils.getEntityFromContainer(this.getContainer(), id));
    }

    @Override
    public int getPageLength() {
        return this.pageLength;
    }

    public Resource getRemoveIcon() {
        return this.removeIcon;
    }

    public String getRemoveMessage() {
        return this.removeMessage;
    }

    public Button getSaveButton() {
        return this.saveButton;
    }

    public boolean isViewmode() {
        return this.viewmode;
    }

    protected void postProcessField(Object propertyId, Field<?> field) {
    }

    @Override
    public void refresh() {
    }

    @Override
    public void reload() {
        this.getContainer().search(this.constructFilter());
    }

    @Override
    public void setPageLength(int pageLength) {
        this.pageLength = pageLength;
    }

    public void setRemoveIcon(Resource removeIcon) {
        this.removeIcon = removeIcon;
    }

    public void setRemoveMessage(String removeMessage) {
        this.removeMessage = removeMessage;
    }

    public void setSelectedItems(Object selectedItems) {
        if (selectedItems != null) {
            if (selectedItems instanceof Collection) {
                Collection col = (Collection)selectedItems;
                Serializable id = (Serializable)col.iterator().next();
                this.setSelectedItem(this.getEntityFromTable(id));
            } else {
                Serializable id = (Serializable)selectedItems;
                this.setSelectedItem(this.getEntityFromTable(id));
            }
        } else {
            this.setSelectedItem(null);
        }
    }

    protected void setViewmode(boolean viewmode) {
        this.viewmode = viewmode;
    }

    protected void toggleViewMode(boolean viewMode) {
        this.setViewmode(viewMode);
        this.getTableWrapper().getTable().setEditable(!this.isViewmode() && this.isEditAllowed());
        this.saveButton.setVisible(!this.isViewmode());
        this.addButton.setVisible(!this.isViewmode() && !this.getFormOptions().isHideAddButton() && this.isEditAllowed());
        this.editButton.setVisible(this.isViewmode() && this.getFormOptions().isEditAllowed() && this.isEditAllowed());
        this.cancelButton.setVisible(!this.isViewmode());
        if (!viewMode) {
            ((ModelBasedTable)this.getTableWrapper().getTable()).removeGeneratedColumns();
        } else {
            ((ModelBasedTable)this.getTableWrapper().getTable()).addGeneratedColumns();
        }
    }
}

