/*
 * Decompiled with CFR 0.152.
 */
package com.ocs.dynamo.ui.composite.table;

import com.ocs.dynamo.dao.FetchJoinInformation;
import com.ocs.dynamo.domain.AbstractEntity;
import com.ocs.dynamo.domain.model.AttributeModel;
import com.ocs.dynamo.domain.model.EntityModel;
import com.ocs.dynamo.service.BaseService;
import com.ocs.dynamo.ui.Searchable;
import com.ocs.dynamo.ui.composite.layout.BaseCustomComponent;
import com.ocs.dynamo.ui.composite.table.ModelBasedTable;
import com.ocs.dynamo.ui.container.QueryType;
import com.vaadin.data.Container;
import com.vaadin.data.Property;
import com.vaadin.data.sort.SortOrder;
import com.vaadin.shared.data.sort.SortDirection;
import com.vaadin.ui.Component;
import com.vaadin.ui.Table;
import com.vaadin.ui.VerticalLayout;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;

public abstract class BaseTableWrapper<ID extends Serializable, T extends AbstractEntity<ID>>
extends BaseCustomComponent
implements Searchable {
    private static final long serialVersionUID = -4691108261565306844L;
    private boolean allowExport;
    private Container container;
    private EntityModel<T> entityModel;
    private FetchJoinInformation[] joins;
    private final QueryType queryType;
    private final BaseService<ID, T> service;
    private List<SortOrder> sortOrders = new ArrayList<SortOrder>();
    private Table table;

    public BaseTableWrapper(BaseService<ID, T> service, EntityModel<T> entityModel, QueryType queryType, List<SortOrder> sortOrders, boolean allowExport, FetchJoinInformation ... joins) {
        this.service = service;
        this.entityModel = entityModel;
        this.queryType = queryType;
        this.sortOrders = sortOrders != null ? sortOrders : new ArrayList();
        this.joins = joins;
        this.allowExport = allowExport;
    }

    protected Container.Filter beforeSearchPerformed(Container.Filter filter) {
        return null;
    }

    @Override
    public void build() {
        VerticalLayout main = new VerticalLayout();
        this.container = this.constructContainer();
        this.table = this.getTable();
        this.table.setPageLength(20);
        this.initSortingAndFiltering();
        main.addComponent((Component)this.table);
        this.table.addValueChangeListener((Property.ValueChangeListener & Serializable)event -> this.onSelect(this.table.getValue()));
        this.setCompositionRoot((Component)main);
    }

    protected abstract Container constructContainer();

    protected Table constructTable() {
        return new ModelBasedTable(this.container, this.entityModel, this.allowExport);
    }

    protected void doConstructContainer(Container container) {
    }

    public Container getContainer() {
        return this.container;
    }

    public EntityModel<T> getEntityModel() {
        return this.entityModel;
    }

    public FetchJoinInformation[] getJoins() {
        return this.joins;
    }

    public QueryType getQueryType() {
        return this.queryType;
    }

    public BaseService<ID, T> getService() {
        return this.service;
    }

    protected boolean[] getSortDirections() {
        boolean[] result = new boolean[this.getSortOrders().size()];
        for (int i = 0; i < result.length; ++i) {
            result[i] = SortDirection.ASCENDING == this.getSortOrders().get(i).getDirection();
        }
        return result;
    }

    public List<SortOrder> getSortOrders() {
        return Collections.unmodifiableList(this.sortOrders);
    }

    protected Object[] getSortProperties() {
        Object[] result = new Object[this.getSortOrders().size()];
        for (int i = 0; i < result.length; ++i) {
            result[i] = this.getSortOrders().get(i).getPropertyId();
        }
        return result;
    }

    public Table getTable() {
        if (this.table == null) {
            this.table = this.constructTable();
        }
        return this.table;
    }

    protected void initSortingAndFiltering() {
        if (this.getSortOrders() != null && !this.getSortOrders().isEmpty()) {
            this.table.sort(this.getSortProperties(), this.getSortDirections());
        } else if (this.getEntityModel().getSortOrder() != null && !this.getEntityModel().getSortOrder().keySet().isEmpty()) {
            Set keySet = this.getEntityModel().getSortOrder().keySet();
            Object[] properties = new Object[keySet.size()];
            boolean[] dirs = new boolean[keySet.size()];
            int i = 0;
            for (AttributeModel am : this.entityModel.getSortOrder().keySet()) {
                properties[i] = am.getName();
                dirs[i] = (Boolean)this.entityModel.getSortOrder().get(am);
                ++i;
            }
            this.table.sort(properties, dirs);
        }
    }

    protected void onSelect(Object selected) {
    }

    public abstract void reloadContainer();

    public void setJoins(FetchJoinInformation[] joins) {
        this.joins = joins;
    }

    public void setSortOrders(List<SortOrder> sortOrders) {
        this.sortOrders = sortOrders;
    }

    protected void setTable(Table table) {
        this.table = table;
    }
}

