/*
 * Decompiled with CFR 0.152.
 */
package com.ocs.dynamo.ui.composite.table;

import com.google.common.collect.Lists;
import com.ocs.dynamo.domain.AbstractEntity;
import com.ocs.dynamo.service.MessageService;
import com.ocs.dynamo.service.ServiceLocatorFactory;
import com.ocs.dynamo.ui.Buildable;
import com.ocs.dynamo.ui.composite.table.export.TableExportActionHandler;
import com.ocs.dynamo.ui.composite.table.export.TableExportMode;
import com.ocs.dynamo.ui.converter.ConverterFactory;
import com.ocs.dynamo.ui.utils.PasteUtils;
import com.ocs.dynamo.ui.utils.VaadinUtils;
import com.ocs.dynamo.util.SystemPropertyUtils;
import com.ocs.dynamo.utils.NumberUtils;
import com.vaadin.data.Container;
import com.vaadin.data.Item;
import com.vaadin.data.Property;
import com.vaadin.data.util.converter.Converter;
import com.vaadin.event.Action;
import com.vaadin.event.FieldEvents;
import com.vaadin.event.ItemClickEvent;
import com.vaadin.shared.MouseEventDetails;
import com.vaadin.ui.Component;
import com.vaadin.ui.Field;
import com.vaadin.ui.Table;
import com.vaadin.ui.TableFieldFactory;
import com.vaadin.ui.TextField;
import com.vaadin.ui.TreeTable;
import com.vaadin.ui.UI;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public abstract class InMemoryTreeTable<ID, U extends AbstractEntity<ID>, ID2, V extends AbstractEntity<ID2>>
extends TreeTable
implements Buildable {
    public static final String PREFIX_CHILDROW = "c";
    public static final String PREFIX_PARENTROW = "p";
    private String clickedColumn;
    private MessageService messageService = ServiceLocatorFactory.getServiceLocator().getMessageService();
    private boolean propagateChanges = true;
    private boolean viewMode;
    private boolean exportAllowed;

    public InMemoryTreeTable(boolean exportAllowed) {
        this.exportAllowed = exportAllowed;
    }

    protected abstract void addContainerProperties();

    @Override
    public void build() {
        this.setEditable(true);
        this.setSizeFull();
        List<V> parentCollection = this.getParentCollection();
        this.addContainerProperties();
        int nrOfProperties = this.getContainerPropertyIds().size();
        String[] sumColumns = this.getSumColumns();
        this.setCellStyleGenerator((Table.CellStyleGenerator & Serializable)(source, itemId, propertyId) -> {
            if (itemId.toString().startsWith(PREFIX_PARENTROW)) {
                return "parentRow";
            }
            return this.getCustomStyle(itemId, propertyId);
        });
        this.setTableFieldFactory(new TableFieldFactory(){
            private boolean editAllowed;
            {
                this.editAllowed = InMemoryTreeTable.this.isEditAllowed();
            }

            public Field<?> createField(Container container, Object itemId, Object propertyId, Component uiContext) {
                if (!InMemoryTreeTable.this.isViewMode() && this.editAllowed && InMemoryTreeTable.this.isEditable(propertyId.toString()) && itemId.toString().startsWith(InMemoryTreeTable.PREFIX_CHILDROW)) {
                    TextField tf = new TextField();
                    tf.setData(itemId);
                    tf.setNullRepresentation("");
                    tf.setNullSettingAllowed(true);
                    tf.setConverter(InMemoryTreeTable.this.createConverter(propertyId.toString()));
                    tf.addFocusListener((FieldEvents.FocusListener & Serializable)event -> InMemoryTreeTable.this.clickedColumn = propertyId.toString());
                    tf.addValueChangeListener((Property.ValueChangeListener & Serializable)event -> {
                        if (InMemoryTreeTable.this.propagateChanges) {
                            InMemoryTreeTable.this.handleChange(tf, propertyId.toString(), (String)event.getProperty().getValue());
                        }
                    });
                    tf.setStyleName("numerical");
                    InMemoryTreeTable.this.postProcessField(propertyId, itemId, (Field<?>)tf);
                    return tf;
                }
                return null;
            }
        });
        int parentCounter = 0;
        int childCounter = 0;
        HashMap<String, BigDecimal> totalSumMap = new HashMap<String, BigDecimal>();
        for (String string : sumColumns) {
            totalSumMap.put(string, BigDecimal.ZERO);
        }
        for (AbstractEntity v : parentCollection) {
            HashMap<String, BigDecimal> sumMap = new HashMap<String, BigDecimal>();
            for (String s : sumColumns) {
                sumMap.put(s, BigDecimal.ZERO);
            }
            Object[] objectArray = new Object[nrOfProperties];
            this.fillParentRow(objectArray, v);
            Object parentId = this.addItem(objectArray, PREFIX_PARENTROW + parentCounter);
            this.setChildrenAllowed(parentId, true);
            this.setCollapsed(parentId, false);
            List<U> rowCollection = this.getRowCollection(v);
            for (AbstractEntity u : rowCollection) {
                Object[] childRow = new Object[nrOfProperties];
                this.fillChildRow(childRow, u, v);
                Object childId = this.addItem(childRow, PREFIX_CHILDROW + childCounter);
                this.setParent(childId, parentId);
                this.setChildrenAllowed(childId, false);
                for (String column : sumColumns) {
                    Number value = (Number)this.getItem(childId).getItemProperty((Object)column).getValue();
                    BigDecimal sum = (BigDecimal)sumMap.get(column);
                    sumMap.put(column, sum.add(value == null ? BigDecimal.ZERO : this.toBigDecimal(value)));
                }
                ++childCounter;
            }
            for (String s : sumColumns) {
                BigDecimal sum = (BigDecimal)sumMap.get(s);
                this.getItem(parentId).getItemProperty((Object)s).setValue((Object)this.convertNumber(sum, s));
                BigDecimal totalSum = (BigDecimal)totalSumMap.get(s);
                totalSumMap.put(s, totalSum.add(sum));
            }
            ++parentCounter;
        }
        for (String string : sumColumns) {
            BigDecimal bd = (BigDecimal)totalSumMap.get(string);
            this.setColumnFooter(string, this.convertToString(bd, string));
        }
        this.setFooterVisible(true);
        for (Object propertyId2 : this.getContainerPropertyIds()) {
            if (!this.isRightAligned(propertyId2.toString())) continue;
            this.setColumnAlignment(propertyId2, Table.Align.RIGHT);
        }
        this.addItemClickListener((ItemClickEvent.ItemClickListener & Serializable)event -> {
            if (MouseEventDetails.MouseButton.RIGHT.equals((Object)event.getButton())) {
                this.clickedColumn = (String)event.getPropertyId();
            }
        });
        if (this.isShowActionMenu()) {
            this.constructActionMenu(parentCollection);
        }
    }

    protected void constructActionMenu(final List<V> parentCollection) {
        final Action copyPreviousAction = new Action(this.messageService.getMessage("ocs.copy.previous.column", VaadinUtils.getLocale()));
        final Action clearColumnAction = new Action(this.messageService.getMessage("ocs.clear.column", VaadinUtils.getLocale()));
        final Action fillColumnAction = new Action(this.messageService.getMessage("ocs.fill.column", VaadinUtils.getLocale()));
        final ArrayList<Action> actions = new ArrayList<Action>();
        if (!this.isViewMode() && this.isEditAllowed()) {
            actions.addAll(Lists.newArrayList((Object[])new Action[]{copyPreviousAction, fillColumnAction, clearColumnAction}));
        }
        actions.addAll(this.getAdditionalActions());
        this.addActionHandler(new Action.Handler(){

            public Action[] getActions(Object target, Object sender) {
                return actions.toArray(new Action[0]);
            }

            public void handleAction(Action action, Object sender, Object target) {
                if (!StringUtils.isEmpty((String)InMemoryTreeTable.this.clickedColumn) && InMemoryTreeTable.this.isRightClickable(InMemoryTreeTable.this.clickedColumn)) {
                    InMemoryTreeTable.this.propagateChanges = false;
                    if (action == fillColumnAction) {
                        String targetRow = (String)target;
                        Number value = (Number)InMemoryTreeTable.this.getItem(targetRow).getItemProperty((Object)InMemoryTreeTable.this.clickedColumn).getValue();
                        int i = 0;
                        for (AbstractEntity v : parentCollection) {
                            for (AbstractEntity u : InMemoryTreeTable.this.getRowCollection(v)) {
                                if (!targetRow.equals(InMemoryTreeTable.PREFIX_CHILDROW + i)) {
                                    InMemoryTreeTable.this.handleChange(InMemoryTreeTable.PREFIX_CHILDROW + i, InMemoryTreeTable.this.clickedColumn, value == null ? null : InMemoryTreeTable.this.convertToString(InMemoryTreeTable.this.toBigDecimal(value), InMemoryTreeTable.this.clickedColumn));
                                }
                                ++i;
                            }
                        }
                    } else if (action == copyPreviousAction) {
                        String previousColumnId = InMemoryTreeTable.this.getPreviousColumnId(InMemoryTreeTable.this.clickedColumn);
                        InMemoryTreeTable.this.copyValue(previousColumnId, InMemoryTreeTable.this.clickedColumn);
                    } else if (action == clearColumnAction) {
                        int i = 0;
                        for (AbstractEntity v : parentCollection) {
                            for (AbstractEntity u : InMemoryTreeTable.this.getRowCollection(v)) {
                                InMemoryTreeTable.this.handleChange(InMemoryTreeTable.PREFIX_CHILDROW + i, InMemoryTreeTable.this.clickedColumn, null);
                                ++i;
                            }
                        }
                    } else {
                        InMemoryTreeTable.this.handleAdditionalAction(action, sender, target);
                    }
                    InMemoryTreeTable.this.propagateChanges = true;
                }
                InMemoryTreeTable.this.clickedColumn = null;
            }
        });
        if (this.exportAllowed) {
            this.addActionHandler(new TableExportActionHandler(UI.getCurrent(), null, this.getReportTitle(), true, TableExportMode.EXCEL, null));
            this.addActionHandler(new TableExportActionHandler(UI.getCurrent(), null, this.getReportTitle(), true, TableExportMode.EXCEL_SIMPLIFIED, null));
            this.addActionHandler(new TableExportActionHandler(UI.getCurrent(), null, this.getReportTitle(), true, TableExportMode.CSV, null));
        }
    }

    protected Number convertFromString(String value, String propertyId) {
        Class<?> clazz = this.getEditablePropertyClass(propertyId);
        if (NumberUtils.isInteger(clazz)) {
            return VaadinUtils.stringToInteger(true, value);
        }
        if (NumberUtils.isLong(clazz)) {
            return VaadinUtils.stringToLong(true, value);
        }
        if (clazz.equals(BigDecimal.class)) {
            return VaadinUtils.stringToBigDecimal(false, false, true, value);
        }
        return null;
    }

    protected Number convertNumber(BigDecimal value, String propertyId) {
        Class<?> clazz = this.getEditablePropertyClass(propertyId);
        if (NumberUtils.isInteger(clazz)) {
            return value.intValue();
        }
        if (NumberUtils.isLong(clazz)) {
            return value.longValue();
        }
        if (clazz.equals(BigDecimal.class)) {
            return value;
        }
        return null;
    }

    protected String convertToString(BigDecimal value, String propertyId) {
        if (value == null) {
            return null;
        }
        Class<?> clazz = this.getEditablePropertyClass(propertyId);
        if (clazz.equals(Integer.class)) {
            return VaadinUtils.integerToString(true, false, value.intValue());
        }
        if (clazz.equals(Long.class)) {
            return VaadinUtils.longToString(true, false, value.longValue());
        }
        if (clazz.equals(BigDecimal.class)) {
            return VaadinUtils.bigDecimalToString(false, true, value);
        }
        return null;
    }

    protected void copyValue(String sourceColumnId, String targetColumnId) {
        int i = 0;
        if (!StringUtils.isEmpty((String)sourceColumnId)) {
            for (AbstractEntity v : this.getParentCollection()) {
                for (AbstractEntity u : this.getRowCollection(v)) {
                    Object value = this.getItem(PREFIX_CHILDROW + i).getItemProperty((Object)sourceColumnId).getValue();
                    if (value instanceof Number || value == null) {
                        this.handleChange(PREFIX_CHILDROW + i, targetColumnId, value == null ? null : this.convertToString(this.toBigDecimal((Number)value), targetColumnId));
                    }
                    ++i;
                }
            }
        }
    }

    protected Converter<String, ?> createConverter(String propertyId) {
        Class<?> clazz = this.getEditablePropertyClass(propertyId);
        boolean grouping = SystemPropertyUtils.useThousandsGroupingInEditMode();
        if (clazz.equals(Integer.class)) {
            return ConverterFactory.createIntegerConverter(grouping, false);
        }
        if (clazz.equals(Long.class)) {
            return ConverterFactory.createLongConverter(grouping, false);
        }
        if (clazz.equals(BigDecimal.class)) {
            return ConverterFactory.createBigDecimalConverter(false, false, grouping, SystemPropertyUtils.getDefaultDecimalPrecision(), null);
        }
        return null;
    }

    protected BigDecimal difference(BigDecimal newValue, BigDecimal oldValue) {
        return (newValue == null ? BigDecimal.ZERO : newValue).subtract(oldValue == null ? BigDecimal.ZERO : oldValue);
    }

    protected abstract void fillChildRow(Object[] var1, U var2, V var3);

    protected abstract void fillParentRow(Object[] var1, V var2);

    protected List<Action> getAdditionalActions() {
        return Lists.newArrayList();
    }

    public String getClickedColumn() {
        return this.clickedColumn;
    }

    protected abstract String[] getColumnstoUpdate(String var1);

    protected String getCustomStyle(Object itemId, Object propertyId) {
        return null;
    }

    protected abstract Class<?> getEditablePropertyClass(String var1);

    protected abstract String getKeyPropertyId();

    public MessageService getMessageService() {
        return this.messageService;
    }

    public String getObjectKey(String itemId) {
        return (String)this.getItem(itemId).getItemProperty((Object)this.getKeyPropertyId()).getValue();
    }

    private int getOffset(String rowId) {
        return Integer.parseInt(rowId.substring(1));
    }

    protected abstract List<V> getParentCollection();

    protected abstract String getPreviousColumnId(String var1);

    protected abstract String getReportTitle();

    protected abstract List<U> getRowCollection(V var1);

    protected abstract String[] getSumColumns();

    protected void handleAdditionalAction(Action action, Object sender, Object target) {
    }

    public void handleChange(String rowId, String propertyId, String value) {
        String childKey = this.getObjectKey(rowId);
        String parentId = (String)this.getParent(rowId);
        String parentKey = null;
        if (parentId != null) {
            parentKey = this.getObjectKey(parentId);
        }
        if (childKey != null && parentKey != null) {
            String[] values = PasteUtils.split(value);
            if (values != null && values.length > 1) {
                this.propagateChanges = false;
                int offset = this.getOffset(rowId);
                for (int i = 0; i < values.length; ++i) {
                    Number change;
                    String rId = PREFIX_CHILDROW + (offset + i);
                    Item item = this.getItem(rId);
                    if (item == null) continue;
                    String cKey = (String)this.getItem(rId).getItemProperty((Object)this.getKeyPropertyId()).getValue();
                    parentId = (String)this.getParent(rId);
                    if (parentId != null) {
                        parentKey = (String)this.getItem(parentId).getItemProperty((Object)this.getKeyPropertyId()).getValue();
                    }
                    if (!this.hasValueChanged(change = this.handleChange(propertyId, rId, parentId, cKey, parentKey, values[i]))) continue;
                    this.updateDependentFields(rId, parentId, propertyId, this.toBigDecimal(change));
                    this.setValue(rId, propertyId, values[i]);
                }
                VaadinUtils.enableCopyPaste();
                this.propagateChanges = true;
            } else {
                Number change = this.handleChange(propertyId, rowId, parentId, childKey, parentKey, value);
                if (this.hasValueChanged(change)) {
                    this.updateDependentFields(rowId, parentId, propertyId, this.toBigDecimal(change));
                    this.setValue(rowId, propertyId, value);
                }
            }
        }
    }

    protected abstract Number handleChange(String var1, String var2, String var3, String var4, String var5, Object var6);

    private void handleChange(TextField tf, String propertyId, String value) {
        this.handleChange((String)tf.getData(), propertyId, value);
    }

    private boolean hasValueChanged(Number change) {
        return change != null && Math.abs(change.doubleValue()) > 1.0E-5;
    }

    protected abstract boolean isEditable(String var1);

    protected boolean isEditAllowed() {
        return true;
    }

    public boolean isPropagateChanges() {
        return this.propagateChanges;
    }

    protected abstract boolean isRightAligned(String var1);

    protected boolean isRightClickable(String columnId) {
        return false;
    }

    protected boolean isShowActionMenu() {
        return true;
    }

    public boolean isViewMode() {
        return this.viewMode;
    }

    protected void postProcessField(Object propertyId, Object itemId, Field<?> field) {
    }

    public void setClickedColumn(String clickedColumn) {
        this.clickedColumn = clickedColumn;
    }

    public void setPropagateChanges(boolean propagateChanges) {
        this.propagateChanges = propagateChanges;
    }

    private void setValue(Object rowId, String propertyId, String value) {
        Number number = this.convertFromString(value, propertyId);
        this.getItem(rowId).getItemProperty((Object)propertyId).setValue((Object)number);
    }

    public void setViewMode(boolean viewMode) {
        this.viewMode = viewMode;
    }

    protected BigDecimal toBigDecimal(Number value) {
        return value == null ? null : BigDecimal.valueOf(value.doubleValue());
    }

    protected Integer toInt(Object value) {
        String temp;
        String string = temp = value == null ? null : (String)value;
        if (StringUtils.isEmpty((String)temp)) {
            return null;
        }
        temp = PasteUtils.stripSeparators(temp);
        return ConverterFactory.createIntegerConverter(false, false).convertToModel(temp, Integer.class, null);
    }

    private void updateDependentFields(String rowId, String parentRowId, String propertyId, BigDecimal delta) {
        for (String column : this.getColumnstoUpdate(propertyId)) {
            this.updateTableField(rowId, column, delta);
            this.updateParentAndFooter(parentRowId, column, delta);
        }
        this.updateParentAndFooter(parentRowId, propertyId, delta);
    }

    private void updateParentAndFooter(String parentRowId, String propertyId, BigDecimal delta) {
        this.updateTableField(parentRowId, propertyId, delta);
        String footerString = this.getColumnFooter(propertyId);
        Number footerValue = this.convertFromString(footerString, propertyId);
        BigDecimal bd = footerValue == null ? BigDecimal.ZERO : this.toBigDecimal(footerValue);
        bd = bd.add(delta);
        this.setColumnFooter(propertyId, this.convertToString(bd, propertyId));
    }

    private void updateTableField(String rowId, String propertyId, BigDecimal delta) {
        Number value = (Number)this.getItem(rowId).getItemProperty((Object)propertyId).getValue();
        BigDecimal bd = value == null ? BigDecimal.ZERO : this.toBigDecimal(value);
        bd = bd.add(delta);
        this.getItem(rowId).getItemProperty((Object)propertyId).setValue((Object)this.convertNumber(bd, propertyId));
    }
}

