/*
 * Decompiled with CFR 0.152.
 */
package com.ocs.dynamo.ui.composite.table;

import com.ocs.dynamo.domain.AbstractEntity;
import com.ocs.dynamo.domain.model.AttributeModel;
import com.ocs.dynamo.domain.model.AttributeType;
import com.ocs.dynamo.domain.model.EditableType;
import com.ocs.dynamo.domain.model.EntityModel;
import com.ocs.dynamo.domain.model.EntityModelFactory;
import com.ocs.dynamo.domain.model.impl.ModelBasedFieldFactory;
import com.ocs.dynamo.service.MessageService;
import com.ocs.dynamo.service.ServiceLocatorFactory;
import com.ocs.dynamo.ui.BaseUI;
import com.ocs.dynamo.ui.component.URLField;
import com.ocs.dynamo.ui.composite.table.TableUtils;
import com.ocs.dynamo.ui.composite.table.export.TableExportActionHandler;
import com.ocs.dynamo.ui.composite.table.export.TableExportMode;
import com.ocs.dynamo.ui.utils.FormatUtils;
import com.ocs.dynamo.ui.utils.VaadinUtils;
import com.vaadin.data.Container;
import com.vaadin.data.Property;
import com.vaadin.ui.Button;
import com.vaadin.ui.Table;
import com.vaadin.ui.UI;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.vaadin.addons.lazyquerycontainer.LazyQueryContainer;

public class ModelBasedTable<ID extends Serializable, T extends AbstractEntity<ID>>
extends Table {
    private static final long serialVersionUID = 6946260934644731038L;
    private Container container;
    private String currencySymbol;
    private EntityModel<T> entityModel;
    private EntityModelFactory entityModelFactory;
    private boolean exportAllowed;
    private boolean updateTableCaption = true;
    private MessageService messageService;

    public ModelBasedTable(Container container, EntityModel<T> model, boolean exportAllowed) {
        super("", container);
        this.container = container;
        this.entityModel = model;
        this.messageService = ServiceLocatorFactory.getServiceLocator().getMessageService();
        this.entityModelFactory = ServiceLocatorFactory.getServiceLocator().getEntityModelFactory();
        this.exportAllowed = exportAllowed;
        TableUtils.defaultInitialization(this);
        this.setTableFieldFactory(ModelBasedFieldFactory.getInstance(this.entityModel, this.messageService));
        this.generateColumns(model);
        if (this.isExportAllowed()) {
            ArrayList list = new ArrayList();
            list.add(model);
            this.addActionHandler(new TableExportActionHandler(UI.getCurrent(), list, model.getDisplayNamePlural(), null, false, TableExportMode.EXCEL, null));
            this.addActionHandler(new TableExportActionHandler(UI.getCurrent(), list, model.getDisplayNamePlural(), null, false, TableExportMode.EXCEL_SIMPLIFIED, null));
            this.addActionHandler(new TableExportActionHandler(UI.getCurrent(), list, model.getDisplayNamePlural(), null, false, TableExportMode.CSV, null));
        }
        if (this.isUpdateTableCaption()) {
            this.addItemSetChangeListener((Container.ItemSetChangeListener & Serializable)e -> this.updateTableCaption());
        }
    }

    private void addColumn(AttributeModel attributeModel, List<Object> propertyNames, List<String> headerNames) {
        if (attributeModel.isVisibleInTable()) {
            LazyQueryContainer lazyContainer;
            propertyNames.add(attributeModel.getPath());
            headerNames.add(attributeModel.getDisplayName());
            if (this.container instanceof LazyQueryContainer && !(lazyContainer = (LazyQueryContainer)this.container).getContainerPropertyIds().contains(attributeModel.getPath())) {
                lazyContainer.addContainerProperty((Object)attributeModel.getPath(), attributeModel.getType(), attributeModel.getDefaultValue(), EditableType.READ_ONLY.equals((Object)attributeModel.getEditableType()), attributeModel.isSortable());
            }
            this.addUrlField(attributeModel);
            this.addInternalLinkField(attributeModel);
            if (attributeModel.isNumerical()) {
                this.setColumnAlignment(attributeModel.getPath(), Table.Align.RIGHT);
            }
        }
    }

    private void addGeneratedColumn(AttributeModel attributeModel) {
        if (attributeModel.isVisibleInTable() && attributeModel.isUrl()) {
            this.addUrlField(attributeModel);
        }
    }

    public void addGeneratedColumns() {
        for (AttributeModel attributeModel : this.entityModel.getAttributeModels()) {
            this.addGeneratedColumn(attributeModel);
            if (attributeModel.getNestedEntityModel() == null) continue;
            for (AttributeModel nestedAttributeModel : attributeModel.getNestedEntityModel().getAttributeModels()) {
                this.addGeneratedColumn(nestedAttributeModel);
            }
        }
    }

    private void addUrlField(final AttributeModel attributeModel) {
        if (attributeModel.isUrl() && !this.isEditable()) {
            this.addGeneratedColumn(attributeModel.getPath(), new Table.ColumnGenerator(){
                private static final long serialVersionUID = -3191235289754428914L;

                public Object generateCell(Table source, Object itemId, Object columnId) {
                    URLField field = (URLField)((ModelBasedFieldFactory)ModelBasedTable.this.getTableFieldFactory()).createField(attributeModel.getPath(), null);
                    if (field != null) {
                        String val = (String)ModelBasedTable.this.getItem(itemId).getItemProperty(columnId).getValue();
                        field.setValue(val);
                    }
                    return field;
                }
            });
        }
    }

    private void addInternalLinkField(final AttributeModel attributeModel) {
        if (attributeModel.isNavigable() && !this.isEditable() && AttributeType.MASTER.equals((Object)attributeModel.getAttributeType())) {
            this.addGeneratedColumn(attributeModel.getPath(), new Table.ColumnGenerator(){
                private static final long serialVersionUID = -3191235289754428914L;

                public Object generateCell(Table source, Object itemId, Object columnId) {
                    Object val = ModelBasedTable.this.getItem(itemId).getItemProperty(columnId).getValue();
                    if (val != null) {
                        String str = FormatUtils.formatEntity(attributeModel.getNestedEntityModel(), val);
                        Button button = new Button(str);
                        button.setStyleName("link");
                        button.addClickListener((Button.ClickListener & Serializable)event -> {
                            BaseUI ui = (BaseUI)UI.getCurrent();
                            ui.navigateToEntityScreenDirectly(val);
                        });
                        return button;
                    }
                    return null;
                }
            });
        }
    }

    protected String formatPropertyValue(Object rowId, Object colId, Property<?> property) {
        String result = FormatUtils.formatPropertyValue(this, this.entityModelFactory, this.entityModel, rowId, colId, property, ", ");
        if (result != null) {
            return result;
        }
        return super.formatPropertyValue(rowId, colId, property);
    }

    protected void generateColumns(EntityModel<T> model) {
        this.generateColumns(model.getAttributeModels());
        this.setCaption(model.getDisplayNamePlural());
        this.setDescription(model.getDescription());
    }

    protected void generateColumns(List<AttributeModel> attributeModels) {
        ArrayList<Object> propertyNames = new ArrayList<Object>();
        ArrayList<String> headerNames = new ArrayList<String>();
        for (AttributeModel attributeModel : attributeModels) {
            this.addColumn(attributeModel, propertyNames, headerNames);
            if (attributeModel.getNestedEntityModel() == null) continue;
            for (AttributeModel nestedAttributeModel : attributeModel.getNestedEntityModel().getAttributeModels()) {
                this.addColumn(nestedAttributeModel, propertyNames, headerNames);
            }
        }
        this.setVisibleColumns(propertyNames.toArray());
        this.setColumnHeaders(headerNames.toArray(new String[0]));
    }

    public Container getContainer() {
        return this.container;
    }

    public String getCurrencySymbol() {
        return this.currencySymbol;
    }

    public boolean isExportAllowed() {
        return this.exportAllowed;
    }

    private void removeGeneratedColumn(AttributeModel attributeModel) {
        if (attributeModel.isVisibleInTable() && attributeModel.isUrl()) {
            this.removeGeneratedColumn(attributeModel.getPath());
        }
    }

    public void removeGeneratedColumns() {
        for (AttributeModel attributeModel : this.entityModel.getAttributeModels()) {
            this.removeGeneratedColumn(attributeModel);
            if (attributeModel.getNestedEntityModel() == null) continue;
            for (AttributeModel nestedAttributeModel : attributeModel.getNestedEntityModel().getAttributeModels()) {
                this.removeGeneratedColumn(nestedAttributeModel);
            }
        }
    }

    public void setColumnVisible(Object propertyId, boolean visible) {
        Object[] visibleCols = this.getVisibleColumns();
        List<Object> temp = Arrays.stream(visibleCols).filter(c -> !c.equals(propertyId)).collect(Collectors.toList());
        boolean alreadyVisible = Arrays.stream(visibleCols).anyMatch(c -> c.equals(propertyId));
        if (!alreadyVisible || visible) {
            temp.add(propertyId);
        }
        this.setVisibleColumns(temp.toArray(new Object[0]));
    }

    public void setCurrencySymbol(String currencySymbol) {
        this.currencySymbol = currencySymbol;
    }

    public void updateTableCaption() {
        this.setCaption(this.entityModel.getDisplayNamePlural() + " " + this.messageService.getMessage("ocs.showing.results", VaadinUtils.getLocale(), new Object[]{this.getContainerDataSource().size()}));
    }

    public boolean isUpdateTableCaption() {
        return this.updateTableCaption;
    }

    public void setUpdateTableCaption(boolean updateTableCaption) {
        this.updateTableCaption = updateTableCaption;
    }
}

