/*
 * Decompiled with CFR 0.152.
 */
package com.ocs.dynamo.ui.composite.table;

import com.ocs.dynamo.domain.AbstractEntity;
import com.ocs.dynamo.domain.model.AttributeModel;
import com.ocs.dynamo.domain.model.EditableType;
import com.ocs.dynamo.domain.model.EntityModel;
import com.ocs.dynamo.domain.model.EntityModelFactory;
import com.ocs.dynamo.service.MessageService;
import com.ocs.dynamo.service.ServiceLocatorFactory;
import com.ocs.dynamo.ui.composite.table.TableUtils;
import com.ocs.dynamo.ui.composite.table.export.TableExportActionHandler;
import com.ocs.dynamo.ui.composite.table.export.TableExportMode;
import com.ocs.dynamo.ui.container.hierarchical.HierarchicalContainer;
import com.ocs.dynamo.ui.container.hierarchical.ModelBasedHierarchicalContainer;
import com.ocs.dynamo.ui.utils.FormatUtils;
import com.ocs.dynamo.ui.utils.VaadinUtils;
import com.vaadin.data.Container;
import com.vaadin.data.Property;
import com.vaadin.event.Action;
import com.vaadin.ui.Notification;
import com.vaadin.ui.Table;
import com.vaadin.ui.TreeTable;
import com.vaadin.ui.UI;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.vaadin.addons.lazyquerycontainer.LazyQueryContainer;

public class ModelBasedTreeTable<ID extends Serializable, T extends AbstractEntity<ID>>
extends TreeTable
implements Action.Handler {
    private static final long serialVersionUID = -2011675569709594136L;
    private Action actionExpandAll;
    private Action actionCollapseAll;
    private EntityModelFactory entityModelFactory;
    private MessageService messageService = ServiceLocatorFactory.getServiceLocator().getMessageService();
    private String currencySymbol;
    private boolean expandAndHideAllowed = true;
    private boolean exportAllowed;

    public ModelBasedTreeTable(ModelBasedHierarchicalContainer<T> container, EntityModelFactory entityModelFactory, boolean exportAllowed) {
        super("", container);
        this.entityModelFactory = entityModelFactory;
        this.exportAllowed = exportAllowed;
        EntityModel<?> rootEntityModel = container.getHierarchicalDefinition(0).getEntityModel();
        TableUtils.defaultInitialization((Table)this);
        this.setCaption(rootEntityModel.getDisplayName());
        ModelBasedHierarchicalContainer<T> modelBasedHierarchicalContainer = container;
        modelBasedHierarchicalContainer.getClass();
        this.setTableFieldFactory(new ModelBasedHierarchicalContainer.HierarchicalFieldFactory(modelBasedHierarchicalContainer, container, this.messageService));
        this.generateColumns(container, rootEntityModel);
        this.actionExpandAll = new Action(this.messageService.getMessage("ocs.expandAll", VaadinUtils.getLocale()));
        this.actionCollapseAll = new Action(this.messageService.getMessage("ocs.hideAll", VaadinUtils.getLocale()));
        this.addActionHandler(this);
        if (exportAllowed) {
            this.addActionHandler(new TableExportActionHandler(UI.getCurrent(), this.getEntityModels(), rootEntityModel.getDisplayNamePlural(), null, true, TableExportMode.EXCEL, null));
            this.addActionHandler(new TableExportActionHandler(UI.getCurrent(), this.getEntityModels(), rootEntityModel.getDisplayNamePlural(), null, true, TableExportMode.EXCEL_SIMPLIFIED, null));
            this.addActionHandler(new TableExportActionHandler(UI.getCurrent(), this.getEntityModels(), rootEntityModel.getDisplayNamePlural(), null, true, TableExportMode.CSV, null));
        }
    }

    protected AttributeModel addContainerProperty(Object scpId, ModelBasedHierarchicalContainer.ModelBasedHierarchicalDefinition def, LazyQueryContainer lazyContainer) {
        AttributeModel attributeModel;
        AttributeModel aModel = null;
        if (scpId != null && (attributeModel = def.getEntityModel().getAttributeModel(scpId.toString())) != null) {
            aModel = attributeModel;
            if (!lazyContainer.getContainerPropertyIds().contains(attributeModel.getName())) {
                lazyContainer.addContainerProperty((Object)attributeModel.getName(), attributeModel.getType(), attributeModel.getDefaultValue(), EditableType.READ_ONLY.equals((Object)attributeModel.getEditableType()), attributeModel.isSortable());
            }
        }
        return aModel;
    }

    protected String formatPropertyValue(Object rowId, Object colId, Property<?> property) {
        String result = FormatUtils.formatPropertyValue((Table)this, this.entityModelFactory, null, rowId, colId, property, ",");
        if (result != null) {
            return result;
        }
        return super.formatPropertyValue(rowId, colId, property);
    }

    public void generateColumns(ModelBasedHierarchicalContainer<T> container, EntityModel<T> model) {
        ArrayList propertyNames = new ArrayList();
        ArrayList<String> headerNames = new ArrayList<String>();
        int propIndex = 0;
        for (Object propId : container.getContainerPropertyIds()) {
            AttributeModel aModel = null;
            for (int level = 0; level < container.getHierarchy().size(); ++level) {
                ModelBasedHierarchicalContainer.ModelBasedHierarchicalDefinition def = container.getHierarchicalDefinition(level);
                Container.Indexed c = def.getContainer();
                if (c instanceof LazyQueryContainer && propIndex < def.getPropertyIds().size()) {
                    LazyQueryContainer lazyContainer = (LazyQueryContainer)c;
                    Object scpId = def.getPropertyIds().get(propIndex);
                    aModel = this.addContainerProperty(scpId, def, lazyContainer);
                }
                if (aModel == null || !aModel.isNumerical()) continue;
                this.setColumnAlignment(aModel.getName(), Table.Align.RIGHT);
            }
            AttributeModel rootAttributeModel = model.getAttributeModel(propId.toString());
            if (rootAttributeModel == null) {
                rootAttributeModel = aModel;
            }
            if (rootAttributeModel != null) {
                propertyNames.add(propId);
                headerNames.add(rootAttributeModel.getDisplayName());
            }
            ++propIndex;
        }
        this.setCaption(model.getDisplayNamePlural());
        this.setDescription(model.getDescription());
        this.setVisibleColumns(propertyNames.toArray());
        this.setColumnHeaders(headerNames.toArray(new String[0]));
    }

    public Action getActionExpandAll() {
        return this.actionExpandAll;
    }

    public Action getActionHideAll() {
        return this.actionCollapseAll;
    }

    public Action[] getActions(Object target, Object sender) {
        if (this.isExpandAndHideAllowed()) {
            return new Action[]{this.actionExpandAll, this.actionCollapseAll};
        }
        return new Action[0];
    }

    public String getCurrencySymbol() {
        return this.currencySymbol;
    }

    private List<EntityModel<?>> getEntityModels() {
        ArrayList models = new ArrayList();
        ModelBasedHierarchicalContainer modelContainer = (ModelBasedHierarchicalContainer)this.getContainerDataSource();
        for (Map.Entry<Integer, HierarchicalContainer.HierarchicalDefinition> e : modelContainer.getHierarchy().entrySet()) {
            if (!(e.getValue() instanceof ModelBasedHierarchicalContainer.ModelBasedHierarchicalDefinition)) continue;
            models.add(((ModelBasedHierarchicalContainer.ModelBasedHierarchicalDefinition)e.getValue()).getEntityModel());
        }
        return models;
    }

    public void handleAction(Action action, Object sender, Object target) {
        if (action == this.actionExpandAll || action == this.actionCollapseAll) {
            boolean expand = action == this.actionExpandAll;
            Object s = this.getValue();
            if (s != null) {
                if (s instanceof Collection) {
                    Collection col = (Collection)s;
                    if (col.size() == 1) {
                        for (Object id : (Collection)s) {
                            this.setCollapseAll(id, !expand);
                        }
                    } else {
                        Notification.show((String)this.messageService.getMessage("ocs.select.single.row", VaadinUtils.getLocale()), (Notification.Type)Notification.Type.ERROR_MESSAGE);
                    }
                } else {
                    this.setCollapseAll(s, !expand);
                }
            } else if (target != null) {
                Notification.show((String)this.messageService.getMessage("ocs.select.row", VaadinUtils.getLocale()), (Notification.Type)Notification.Type.ERROR_MESSAGE);
            }
        }
    }

    public boolean isExpandAndHideAllowed() {
        return this.expandAndHideAllowed;
    }

    public void setCollapseAll(Object itemId, boolean collapse) {
        if (itemId != null) {
            this.setCollapsed(itemId, collapse);
            Collection ch = this.getChildren(itemId);
            if (ch != null && !ch.isEmpty()) {
                for (Object cid : ch) {
                    this.setCollapseAll(cid, collapse);
                }
            }
        }
    }

    public void setCurrencySymbol(String currencySymbol) {
        this.currencySymbol = currencySymbol;
    }

    public void setExpandAndHideAllowed(boolean expandAndHideAllowed) {
        this.expandAndHideAllowed = expandAndHideAllowed;
    }

    public boolean isExportAllowed() {
        return this.exportAllowed;
    }
}

