/*
 * Decompiled with CFR 0.152.
 */
package com.ocs.dynamo.ui.composite.table;

import com.ocs.dynamo.dao.FetchJoinInformation;
import com.ocs.dynamo.domain.AbstractEntity;
import com.ocs.dynamo.domain.model.EntityModel;
import com.ocs.dynamo.service.BaseService;
import com.ocs.dynamo.ui.Searchable;
import com.ocs.dynamo.ui.composite.table.BaseTableWrapper;
import com.ocs.dynamo.ui.composite.table.ModelBasedTable;
import com.ocs.dynamo.ui.container.QueryType;
import com.ocs.dynamo.ui.container.ServiceContainer;
import com.ocs.dynamo.ui.container.ServiceQueryDefinition;
import com.vaadin.data.Container;
import com.vaadin.data.sort.SortOrder;
import java.io.Serializable;
import java.util.List;

public class ServiceResultsTableWrapper<ID extends Serializable, T extends AbstractEntity<ID>>
extends BaseTableWrapper<ID, T>
implements Searchable {
    private static final long serialVersionUID = -4691108261565306844L;
    private Container.Filter filter;
    private Integer maxResults;

    public ServiceResultsTableWrapper(BaseService<ID, T> service, EntityModel<T> entityModel, QueryType queryType, Container.Filter filter, List<SortOrder> sortOrders, boolean allowExport, FetchJoinInformation ... joins) {
        super(service, entityModel, queryType, sortOrders, allowExport, joins);
        this.filter = filter;
    }

    @Override
    protected Container constructContainer() {
        ServiceContainer container = new ServiceContainer(this.getService(), this.getEntityModel(), 20, this.getQueryType(), this.getJoins());
        if (this.getMaxResults() != null) {
            ((ServiceQueryDefinition)container.getQueryView().getQueryDefinition()).setMaxQuerySize(this.getMaxResults());
        }
        this.doConstructContainer((Container)container);
        return container;
    }

    protected Container.Filter getFilter() {
        return this.filter;
    }

    public Integer getMaxResults() {
        return this.maxResults;
    }

    public ModelBasedTable<ID, T> getModelBasedTable() {
        return (ModelBasedTable)super.getTable();
    }

    @Override
    protected void initSortingAndFiltering() {
        ((ServiceContainer)this.getContainer()).getQueryView().addFilter(this.filter);
        super.initSortingAndFiltering();
    }

    @Override
    public void reloadContainer() {
        if (this.getContainer() instanceof Searchable) {
            ((Searchable)this.getContainer()).search(this.filter);
        }
    }

    @Override
    public void search(Container.Filter filter) {
        Container.Filter temp = this.beforeSearchPerformed(filter);
        if (this.getContainer() instanceof Searchable) {
            ((Searchable)this.getContainer()).search(temp != null ? temp : filter);
        }
    }

    public void setFilter(Container.Filter filter) {
        this.filter = filter;
        this.search(filter);
    }

    public void setMaxResults(Integer maxResults) {
        this.maxResults = maxResults;
    }
}

