/*
 * Decompiled with CFR 0.152.
 */
package com.ocs.dynamo.ui.composite.table.export;

import com.ocs.dynamo.dao.FetchJoinInformation;
import com.ocs.dynamo.dao.SortOrder;
import com.ocs.dynamo.dao.SortOrders;
import com.ocs.dynamo.domain.AbstractEntity;
import com.ocs.dynamo.domain.model.AttributeModel;
import com.ocs.dynamo.domain.model.EntityModel;
import com.ocs.dynamo.domain.model.EntityModelFactory;
import com.ocs.dynamo.domain.query.DataSetIterator;
import com.ocs.dynamo.exception.OCSRuntimeException;
import com.ocs.dynamo.filter.Filter;
import com.ocs.dynamo.service.BaseService;
import com.ocs.dynamo.service.ServiceLocatorFactory;
import com.ocs.dynamo.ui.composite.table.export.BaseXlsStyleGenerator;
import com.ocs.dynamo.ui.composite.table.export.CustomXlsStyleGenerator;
import com.ocs.dynamo.ui.composite.table.export.XlsStyleGenerator;
import com.ocs.dynamo.ui.utils.FormatUtils;
import com.ocs.dynamo.utils.DateUtils;
import com.ocs.dynamo.utils.MathUtils;
import java.io.IOException;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.Date;
import java.util.List;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public abstract class BaseExportTemplate<ID extends Serializable, T extends AbstractEntity<ID>> {
    protected static final int FIXED_COLUMN_WIDTH = 5120;
    protected static final int TITLE_ROW_HEIGHT = 40;
    protected static final int MAX_SIZE = 20000;
    private CustomXlsStyleGenerator<ID, T> customGenerator;
    private final boolean intThousandsGrouping;
    private EntityModelFactory entityModelFactory = ServiceLocatorFactory.getServiceLocator().getEntityModelFactory();
    private final Filter filter;
    private XlsStyleGenerator<ID, T> generator;
    private final FetchJoinInformation[] joins;
    private final BaseService<ID, T> service;
    private final SortOrder[] sortOrders;
    private final String title;
    private Workbook workbook;

    public BaseExportTemplate(BaseService<ID, T> service, SortOrder[] sortOrders, Filter filter, String title, boolean intThousandsGrouping, CustomXlsStyleGenerator<ID, T> customGenerator, FetchJoinInformation ... joins) {
        this.service = service;
        this.sortOrders = sortOrders;
        this.filter = filter;
        this.title = title;
        this.joins = joins;
        this.intThousandsGrouping = intThousandsGrouping;
        this.customGenerator = customGenerator;
    }

    protected boolean canResize() {
        return !(this.getWorkbook() instanceof SXSSFWorkbook);
    }

    protected Cell createCell(Row row, int colIndex, T entity, Object value, AttributeModel attributeModel) {
        CellStyle custom;
        Cell cell = row.createCell(colIndex);
        cell.setCellStyle(this.getGenerator().getCellStyle(colIndex, entity, value, attributeModel));
        if (this.getCustomGenerator() != null && (custom = this.getCustomGenerator().getCustomCellStyle(this.workbook, entity, value, attributeModel)) != null) {
            cell.setCellStyle(custom);
        }
        return cell;
    }

    protected XlsStyleGenerator<ID, T> createGenerator(Workbook workbook) {
        return new BaseXlsStyleGenerator(workbook, this.intThousandsGrouping);
    }

    protected Workbook createWorkbook(int size) {
        if (size > 20000) {
            return new SXSSFWorkbook();
        }
        return new XSSFWorkbook();
    }

    protected abstract byte[] generateCsv(DataSetIterator<ID, T> var1) throws IOException;

    protected abstract byte[] generateXls(DataSetIterator<ID, T> var1) throws IOException;

    public CustomXlsStyleGenerator<ID, T> getCustomGenerator() {
        return this.customGenerator;
    }

    public Filter getFilter() {
        return this.filter;
    }

    public XlsStyleGenerator<ID, T> getGenerator() {
        return this.generator;
    }

    public FetchJoinInformation[] getJoins() {
        return this.joins;
    }

    public abstract int getPageSize();

    public BaseService<ID, T> getService() {
        return this.service;
    }

    public SortOrder[] getSortOrders() {
        return this.sortOrders;
    }

    public String getTitle() {
        return this.title;
    }

    protected Workbook getWorkbook() {
        return this.workbook;
    }

    public final byte[] process(boolean xls) {
        try {
            List ids = this.service.findIds(this.getFilter(), this.sortOrders);
            DataSetIterator iterator = new DataSetIterator<ID, T>(ids, this.getPageSize()){

                protected List<T> readPage(List<ID> ids) {
                    return BaseExportTemplate.this.service.fetchByIds(ids, new SortOrders(BaseExportTemplate.this.sortOrders), BaseExportTemplate.this.joins);
                }
            };
            if (xls) {
                return this.generateXls(iterator);
            }
            return this.generateCsv(iterator);
        }
        catch (IOException ex) {
            throw new OCSRuntimeException(ex.getMessage(), (Throwable)ex);
        }
    }

    protected void resizeColumns(Sheet sheet) {
        if (this.canResize()) {
            for (int i = 0; i < sheet.getRow(0).getLastCellNum(); ++i) {
                sheet.autoSizeColumn(i);
            }
        }
    }

    public void setGenerator(XlsStyleGenerator<ID, T> generator) {
        this.generator = generator;
    }

    protected void setWorkbook(Workbook workbook) {
        this.workbook = workbook;
    }

    protected void writeCellValue(Cell cell, Object value, EntityModel<T> em, AttributeModel am) {
        if (value instanceof Integer || value instanceof Long) {
            cell.setCellValue(((Number)value).doubleValue());
        } else if (value instanceof Date && (am == null || !am.isWeek())) {
            cell.setCellValue((Date)value);
        } else if (value instanceof LocalDate) {
            cell.setCellValue(DateUtils.toLegacyDate((LocalDate)((LocalDate)value)));
        } else if (value instanceof LocalDateTime) {
            cell.setCellValue(DateUtils.toLegacyDate((LocalDateTime)((LocalDateTime)value)));
        } else if (value instanceof BigDecimal) {
            boolean isPercentage;
            boolean bl = isPercentage = am != null && am.isPercentage();
            if (isPercentage) {
                double temp = ((BigDecimal)value).divide(MathUtils.HUNDRED, 10, RoundingMode.HALF_UP).setScale(am.getPrecision() + 2, RoundingMode.HALF_UP).doubleValue();
                cell.setCellValue(temp);
            } else {
                cell.setCellValue(((BigDecimal)value).setScale(am == null ? 2 : am.getPrecision(), RoundingMode.HALF_UP).doubleValue());
            }
        } else if (am != null) {
            String str = FormatUtils.formatPropertyValue(this.entityModelFactory, am, value, ", ");
            cell.setCellValue(str);
        }
    }
}

