/*
 * Decompiled with CFR 0.152.
 */
package com.ocs.dynamo.ui.composite.table.export;

import com.ocs.dynamo.domain.AbstractEntity;
import com.ocs.dynamo.domain.model.AttributeDateType;
import com.ocs.dynamo.domain.model.AttributeModel;
import com.ocs.dynamo.ui.composite.table.export.XlsStyleGenerator;
import com.ocs.dynamo.util.SystemPropertyUtils;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.DataFormat;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.usermodel.Workbook;

public class BaseXlsStyleGenerator<ID extends Serializable, T extends AbstractEntity<ID>>
implements XlsStyleGenerator<ID, T> {
    private boolean thousandsGrouping;
    private CellStyle bigDecimalPercentageStyle;
    private CellStyle bigDecimalStyle;
    private CellStyle headerStyle;
    private CellStyle numberStyle;
    private CellStyle numberSimpleStyle;
    private CellStyle normal;
    private CellStyle titleStyle;
    private CellStyle dateStyle;
    private CellStyle dateTimeStyle;
    private CellStyle timeStyle;
    private CellStyle currencyStyle;
    private Workbook workbook;

    public BaseXlsStyleGenerator(Workbook workbook, boolean thousandsGrouping) {
        this.workbook = workbook;
        this.thousandsGrouping = thousandsGrouping;
        DataFormat format = workbook.createDataFormat();
        this.numberStyle = workbook.createCellStyle();
        this.numberStyle.setAlignment((short)3);
        this.setBorder(this.numberStyle, (short)1);
        this.numberStyle.setDataFormat(format.getFormat("#,#"));
        this.numberSimpleStyle = workbook.createCellStyle();
        this.numberSimpleStyle.setAlignment((short)3);
        this.setBorder(this.numberSimpleStyle, (short)1);
        this.numberSimpleStyle.setDataFormat(format.getFormat("#"));
        this.bigDecimalStyle = workbook.createCellStyle();
        this.bigDecimalStyle.setAlignment((short)3);
        this.setBorder(this.bigDecimalStyle, (short)1);
        this.bigDecimalStyle.setDataFormat(format.getFormat("#,##0.00"));
        this.bigDecimalPercentageStyle = workbook.createCellStyle();
        this.bigDecimalPercentageStyle.setAlignment((short)3);
        this.setBorder(this.bigDecimalPercentageStyle, (short)1);
        this.bigDecimalPercentageStyle.setDataFormat(format.getFormat("#,##0.00%"));
        this.normal = workbook.createCellStyle();
        this.normal.setAlignment((short)1);
        this.setBorder(this.normal, (short)1);
        Font titleFont = workbook.createFont();
        titleFont.setFontHeightInPoints((short)18);
        titleFont.setBoldweight((short)700);
        this.titleStyle = workbook.createCellStyle();
        this.titleStyle.setAlignment((short)2);
        this.titleStyle.setVerticalAlignment((short)1);
        this.titleStyle.setFont(titleFont);
        Font monthFont = workbook.createFont();
        monthFont.setFontHeightInPoints((short)11);
        monthFont.setColor(IndexedColors.WHITE.getIndex());
        this.headerStyle = workbook.createCellStyle();
        this.headerStyle.setAlignment((short)2);
        this.headerStyle.setVerticalAlignment((short)1);
        this.headerStyle.setFillForegroundColor(IndexedColors.GREY_50_PERCENT.getIndex());
        this.headerStyle.setFillPattern((short)1);
        this.headerStyle.setFont(monthFont);
        this.headerStyle.setWrapText(true);
        this.dateStyle = workbook.createCellStyle();
        this.setBorder(this.dateStyle, (short)1);
        this.dateStyle.setDataFormat(format.getFormat(SystemPropertyUtils.getDefaultDateFormat()));
        this.dateTimeStyle = workbook.createCellStyle();
        this.setBorder(this.dateTimeStyle, (short)1);
        this.dateTimeStyle.setDataFormat(format.getFormat(SystemPropertyUtils.getDefaultDateTimeFormat()));
        this.timeStyle = workbook.createCellStyle();
        this.setBorder(this.timeStyle, (short)1);
        this.timeStyle.setDataFormat(format.getFormat(SystemPropertyUtils.getDefaultTimeFormat()));
        this.currencyStyle = workbook.createCellStyle();
        this.setBorder(this.currencyStyle, (short)1);
        this.currencyStyle.setDataFormat(format.getFormat(SystemPropertyUtils.getDefaultCurrencySymbol() + " #,##0.00"));
    }

    @Override
    public CellStyle getCellStyle(int index, T entity, Object value, AttributeModel attributeModel) {
        if (value instanceof Integer || value instanceof Long) {
            return this.thousandsGrouping ? this.numberStyle : this.numberSimpleStyle;
        }
        if (value instanceof Date) {
            if (attributeModel == null || !attributeModel.isWeek()) {
                if (attributeModel == null || AttributeDateType.DATE.equals((Object)attributeModel.getDateType())) {
                    return this.dateStyle;
                }
                if (AttributeDateType.TIMESTAMP.equals((Object)attributeModel.getDateType())) {
                    return this.dateTimeStyle;
                }
                if (AttributeDateType.TIME.equals((Object)attributeModel.getDateType())) {
                    return this.timeStyle;
                }
            }
        } else if (value instanceof BigDecimal) {
            if (attributeModel != null && attributeModel.isPercentage()) {
                return this.bigDecimalPercentageStyle;
            }
            if (attributeModel != null && attributeModel.isCurrency()) {
                return this.currencyStyle;
            }
            return this.bigDecimalStyle;
        }
        return this.normal;
    }

    @Override
    public CellStyle getHeaderStyle(int index) {
        if (index == 0) {
            return this.titleStyle;
        }
        if (this.headerStyle == null) {
            return this.headerStyle;
        }
        return this.headerStyle;
    }

    public Workbook getWorkbook() {
        return this.workbook;
    }

    private void setBorder(CellStyle style, short border) {
        style.setBorderBottom(border);
        style.setBorderTop(border);
        style.setBorderLeft(border);
        style.setBorderRight(border);
    }

    public boolean isThousandsGrouping() {
        return this.thousandsGrouping;
    }
}

