/*
 * Decompiled with CFR 0.152.
 */
package com.ocs.dynamo.ui.composite.table.export;

import au.com.bytecode.opencsv.CSVWriter;
import com.ocs.dynamo.dao.FetchJoinInformation;
import com.ocs.dynamo.dao.SortOrder;
import com.ocs.dynamo.domain.AbstractEntity;
import com.ocs.dynamo.domain.model.AttributeModel;
import com.ocs.dynamo.domain.query.DataSetIterator;
import com.ocs.dynamo.filter.Filter;
import com.ocs.dynamo.service.BaseService;
import com.ocs.dynamo.ui.composite.table.export.BaseExportTemplate;
import com.ocs.dynamo.ui.composite.table.export.CustomXlsStyleGenerator;
import com.ocs.dynamo.ui.utils.VaadinUtils;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.List;
import org.apache.commons.lang.ObjectUtils;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;

public abstract class ExportPivotTemplate<ID extends Serializable, T extends AbstractEntity<ID>, ID2 extends Serializable, U extends AbstractEntity<ID2>>
extends BaseExportTemplate<ID, T> {
    private AttributeModel attributeModel;
    private final List<String> captions;

    public ExportPivotTemplate(BaseService<ID, T> service, SortOrder[] sortOrders, Filter filter, AttributeModel attributeModel, List<String> captions, String title, boolean intThousandsGrouping, CustomXlsStyleGenerator<ID, T> customGenerator, FetchJoinInformation ... joins) {
        super(service, sortOrders, filter, title, intThousandsGrouping, customGenerator, joins);
        this.attributeModel = attributeModel;
        this.captions = captions;
    }

    protected abstract boolean createAveragesColumn();

    protected abstract boolean createSumColumn();

    /*
     * Exception decompiling
     */
    @Override
    protected byte[] generateCsv(DataSetIterator<ID, T> iterator) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Loose catch block
     */
    @Override
    protected byte[] generateXls(DataSetIterator<ID, T> iterator) throws IOException {
        this.setWorkbook(this.createWorkbook(iterator.size()));
        Sheet sheet = this.getWorkbook().createSheet(this.getTitle());
        this.setGenerator(this.createGenerator(this.getWorkbook()));
        boolean resize = !(this.getWorkbook() instanceof SXSSFWorkbook);
        try {
            try (ByteArrayOutputStream stream = new ByteArrayOutputStream();){
                Row titleRow = sheet.createRow(0);
                titleRow.setHeightInPoints(40.0f);
                for (int i = 0; i < this.getCaptions().size(); ++i) {
                    if (!resize) {
                        sheet.setColumnWidth(i, 5120);
                    }
                    Cell cell = titleRow.createCell(i);
                    cell.setCellStyle(this.getGenerator().getHeaderStyle(i));
                    cell.setCellValue(this.getCaptions().get(i));
                }
                List<U> columns = this.getColumns();
                int j = 0;
                for (AbstractEntity u : this.getColumns()) {
                    Cell cell = titleRow.createCell(this.getCaptions().size() + j);
                    cell.setCellStyle(this.getGenerator().getHeaderStyle(this.getCaptions().size() + j));
                    cell.setCellValue(this.getColumnHeader(u));
                    ++j;
                }
                String rowTotalCaption = this.getRowTotalCaption();
                int lastColumnIndex = this.getCaptions().size() + columns.size();
                if (rowTotalCaption != null) {
                    Cell totalCell = titleRow.createCell(lastColumnIndex);
                    totalCell.setCellStyle(this.getGenerator().getHeaderStyle(lastColumnIndex));
                    totalCell.setCellValue(rowTotalCaption);
                }
                Object prevRowId = null;
                int index = 0;
                Row row = null;
                int rowSum = 0;
                int valueCount = 0;
                BigDecimal rowAverage = BigDecimal.ZERO;
                AbstractEntity entity = iterator.next();
                while (entity != null) {
                    Object rowId = this.getRowId(entity);
                    if (!ObjectUtils.equals(prevRowId, (Object)rowId)) {
                        this.writeEmptyCells(row, index, lastColumnIndex);
                        this.writeXlsRowTotal(row, lastColumnIndex, rowSum, rowAverage, valueCount);
                        row = sheet.createRow(sheet.getLastRowNum() + 1);
                        this.setXlsCellValues(row, entity);
                        rowSum = 0;
                        rowAverage = BigDecimal.ZERO;
                        index = 0;
                        valueCount = 0;
                    }
                    int colIndex = this.getCaptions().size() + index;
                    AbstractEntity column = (AbstractEntity)this.getColumns().get(index);
                    if (!this.columnValueMatches(entity, column)) {
                        this.createCell(row, colIndex, null, null, null);
                    } else {
                        Object value = this.getValue(entity);
                        if (value != null) {
                            Cell cell = this.createCell(row, colIndex, entity, value, this.attributeModel);
                            this.writeCellValue(cell, value, null, this.attributeModel);
                            if (value instanceof BigDecimal) {
                                rowSum += ((BigDecimal)value).intValue();
                                rowAverage = rowAverage.add((BigDecimal)value);
                            } else if (value instanceof Number) {
                                rowSum += ((Number)value).intValue();
                                rowAverage = rowAverage.add(BigDecimal.valueOf(((Number)value).doubleValue()));
                            }
                            ++valueCount;
                        } else {
                            this.createCell(row, colIndex, entity, null, null);
                        }
                        entity = iterator.next();
                    }
                    ++index;
                    prevRowId = rowId;
                }
                this.writeEmptyCells(row, index, lastColumnIndex);
                this.writeXlsRowTotal(row, lastColumnIndex, rowSum, rowAverage, valueCount);
                this.resizeColumns(sheet);
                this.getWorkbook().write((OutputStream)stream);
                byte[] byArray = stream.toByteArray();
                return byArray;
            }
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            if (this.getWorkbook() != null) {
                this.getWorkbook().close();
            }
        }
    }

    public List<String> getCaptions() {
        return this.captions;
    }

    protected abstract String getColumnHeader(U var1);

    protected abstract List<U> getColumns();

    protected abstract boolean columnValueMatches(T var1, U var2);

    protected abstract Object getRowId(T var1);

    protected abstract String getRowTotalCaption();

    protected abstract Object getValue(T var1);

    protected abstract void setCsvCellValues(List<String> var1, T var2);

    protected abstract void setXlsCellValues(Row var1, T var2);

    protected boolean usePercentages() {
        return false;
    }

    private void writeCsvRow(CSVWriter writer, List<String> row, Integer rowSum, BigDecimal rowAverage, int valueCount) {
        if (!row.isEmpty()) {
            if (this.createSumColumn()) {
                row.add(VaadinUtils.integerToString(true, false, rowSum));
            } else if (this.createAveragesColumn() && valueCount > 0) {
                BigDecimal avg = rowAverage.divide(new BigDecimal(valueCount));
                String s = VaadinUtils.bigDecimalToString(this.usePercentages(), true, avg);
                row.add(s);
            }
            writer.writeNext(row.toArray(new String[0]));
        }
    }

    private void writeEmptyCells(Row row, int index, int lastColumnIndex) {
        if (row != null) {
            for (int colIndex = this.getCaptions().size() + index; colIndex < lastColumnIndex; ++colIndex) {
                this.createCell(row, colIndex, null, null, null);
            }
        }
    }

    private void writeXlsRowTotal(Row row, int lastColumnIndex, Integer rowSum, BigDecimal rowAverage, int valueCount) {
        if (row != null && (this.createSumColumn() || this.createAveragesColumn())) {
            if (this.createSumColumn()) {
                this.createCell(row, lastColumnIndex, null, rowSum, null).setCellValue((double)rowSum.intValue());
            } else if (valueCount > 0) {
                BigDecimal avg = rowAverage.divide(new BigDecimal(valueCount), 10, RoundingMode.HALF_UP);
                String s = VaadinUtils.bigDecimalToString(this.usePercentages(), true, avg);
                this.createCell(row, lastColumnIndex, null, avg, null).setCellValue(s);
            }
        }
    }
}

