/*
 * Decompiled with CFR 0.152.
 */
package com.ocs.dynamo.ui.composite.table.export;

import com.ocs.dynamo.dao.FetchJoinInformation;
import com.ocs.dynamo.dao.SortOrder;
import com.ocs.dynamo.domain.AbstractEntity;
import com.ocs.dynamo.domain.model.AttributeModel;
import com.ocs.dynamo.domain.model.AttributeType;
import com.ocs.dynamo.domain.model.EntityModel;
import com.ocs.dynamo.domain.query.DataSetIterator;
import com.ocs.dynamo.filter.Filter;
import com.ocs.dynamo.service.BaseService;
import com.ocs.dynamo.ui.composite.table.export.BaseExportTemplate;
import com.ocs.dynamo.ui.composite.table.export.CustomXlsStyleGenerator;
import com.ocs.dynamo.utils.ClassUtils;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;

public abstract class ModelBasedExportTemplate<ID extends Serializable, T extends AbstractEntity<ID>>
extends BaseExportTemplate<ID, T> {
    private EntityModel<T> entityModel;

    public ModelBasedExportTemplate(BaseService<ID, T> service, EntityModel<T> entityModel, SortOrder[] sortOrders, Filter filter, String title, boolean intThousandsGrouping, CustomXlsStyleGenerator<ID, T> customGenerator, FetchJoinInformation ... joins) {
        super(service, sortOrders, filter, title, intThousandsGrouping, customGenerator, joins);
        this.entityModel = entityModel;
    }

    @Override
    protected byte[] generateXls(DataSetIterator<ID, T> iterator) throws IOException {
        this.setWorkbook(this.createWorkbook(iterator.size()));
        Sheet sheet = this.getWorkbook().createSheet(this.getTitle());
        this.setGenerator(this.createGenerator(this.getWorkbook()));
        boolean resize = this.canResize();
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        Row titleRow = sheet.createRow(0);
        titleRow.setHeightInPoints(40.0f);
        int i = 0;
        for (AttributeModel am : this.entityModel.getAttributeModels()) {
            if (!this.show(am)) continue;
            if (!resize) {
                sheet.setColumnWidth(i, 5120);
            }
            Cell cell = titleRow.createCell(i);
            cell.setCellStyle(this.getGenerator().getHeaderStyle(i));
            cell.setCellValue(am.getDisplayName());
            ++i;
        }
        int rowIndex = 1;
        AbstractEntity entity = iterator.next();
        while (entity != null) {
            Row row = sheet.createRow(rowIndex);
            int colIndex = 0;
            for (AttributeModel am : this.entityModel.getAttributeModels()) {
                if (am == null || !this.show(am)) continue;
                Object value = ClassUtils.getFieldValue((Object)entity, (String)am.getPath());
                Cell cell = this.createCell(row, colIndex, entity, value, am);
                this.writeCellValue(cell, value, this.entityModel, am);
                ++colIndex;
            }
            ++rowIndex;
            entity = iterator.next();
        }
        this.resizeColumns(sheet);
        this.getWorkbook().write((OutputStream)stream);
        return stream.toByteArray();
    }

    private boolean show(AttributeModel am) {
        if (!am.isVisible() || AttributeType.LOB.equals((Object)am.getAttributeType())) {
            return false;
        }
        if (AttributeType.DETAIL.equals((Object)am.getAttributeType()) || AttributeType.ELEMENT_COLLECTION.equals((Object)am.getAttributeType())) {
            return am.isVisibleInTable();
        }
        return true;
    }

    /*
     * Exception decompiling
     */
    @Override
    protected byte[] generateCsv(DataSetIterator<ID, T> iterator) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

