/*
 * Decompiled with CFR 0.152.
 */
package com.ocs.dynamo.ui.composite.table.export;

import au.com.bytecode.opencsv.CSVWriter;
import com.ocs.dynamo.domain.model.AttributeModel;
import com.ocs.dynamo.domain.model.EntityModel;
import com.ocs.dynamo.domain.model.EntityModelFactory;
import com.ocs.dynamo.service.MessageService;
import com.ocs.dynamo.service.ServiceLocatorFactory;
import com.ocs.dynamo.ui.composite.table.ModelBasedTreeTable;
import com.ocs.dynamo.ui.composite.table.export.CustomCellStyleGenerator;
import com.ocs.dynamo.ui.composite.table.export.HasReportTitle;
import com.ocs.dynamo.ui.composite.table.export.TableExportMode;
import com.ocs.dynamo.ui.composite.table.export.TableExportService;
import com.ocs.dynamo.ui.container.hierarchical.ModelBasedHierarchicalContainer;
import com.ocs.dynamo.ui.utils.FormatUtils;
import com.ocs.dynamo.ui.utils.VaadinUtils;
import com.ocs.dynamo.util.SystemPropertyUtils;
import com.ocs.dynamo.utils.DateUtils;
import com.ocs.dynamo.utils.NumberUtils;
import com.ocs.dynamo.utils.StringUtils;
import com.vaadin.addon.tableexport.ExcelExport;
import com.vaadin.addon.tableexport.TableExport;
import com.vaadin.data.Container;
import com.vaadin.data.Item;
import com.vaadin.data.Property;
import com.vaadin.event.Action;
import com.vaadin.ui.Grid;
import com.vaadin.ui.Notification;
import com.vaadin.ui.Table;
import com.vaadin.ui.TreeTable;
import com.vaadin.ui.UI;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.io.FileUtils;
import org.apache.log4j.Logger;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.DataFormat;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.ss.util.CellUtil;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class TableExportActionHandler
implements Action.Handler {
    private static final Logger LOG = Logger.getLogger(TableExportActionHandler.class);
    private static final BigDecimal HUNDRED = new BigDecimal(100);
    private static final String MIME_TYPE_XLSX = "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet";
    private static final int SCALE = 5;
    private static final long serialVersionUID = -276477801970861419L;
    private Action actionExport;
    private List<String> columnIds;
    private EntityModelFactory entityModelFactory;
    private List<EntityModel<?>> entityModels;
    private MessageService messageService = ServiceLocatorFactory.getServiceLocator().getMessageService();
    private String reportTitle;
    private boolean totalsRow;
    private int maxRowsStreaming;
    private int maxRowsNonStreaming;
    private UI ui;
    private CustomCellStyleGenerator cellStyleGenerator;
    private TableExportMode exportMode;

    public TableExportActionHandler(UI ui, List<EntityModel<?>> entityModels, String reportTitle, List<String> columnIds, boolean totalsRow, TableExportMode exportMode, CustomCellStyleGenerator cellStyleGenerator) {
        this(ui, columnIds, reportTitle, totalsRow, exportMode, cellStyleGenerator);
        this.entityModels = entityModels;
    }

    public TableExportActionHandler(UI ui, List<String> columnIds, String reportTitle, boolean totalsRow, TableExportMode exportMode, CustomCellStyleGenerator cellStyleGenerator) {
        this.entityModelFactory = ServiceLocatorFactory.getServiceLocator().getEntityModelFactory();
        this.columnIds = columnIds;
        this.cellStyleGenerator = cellStyleGenerator;
        this.exportMode = exportMode;
        this.maxRowsNonStreaming = SystemPropertyUtils.getMaximumExportRowsNonStreaming();
        this.maxRowsStreaming = SystemPropertyUtils.getMaximumExportRowsStreaming();
        this.reportTitle = this.messageService.getMessageNoDefault(reportTitle, VaadinUtils.getLocale());
        if (this.reportTitle == null) {
            this.reportTitle = reportTitle;
        }
        this.ui = ui;
        this.totalsRow = totalsRow;
        this.actionExport = new Action(TableExportMode.CSV.equals((Object)exportMode) ? this.messageService.getMessage("ocs.export.csv", VaadinUtils.getLocale()) : (TableExportMode.EXCEL_SIMPLIFIED.equals((Object)exportMode) ? this.messageService.getMessage("ocs.export.simple", VaadinUtils.getLocale()) : this.messageService.getMessage("ocs.export", VaadinUtils.getLocale())));
    }

    protected Workbook createWorkbook(int size) {
        if (!TableExportMode.EXCEL_SIMPLIFIED.equals((Object)this.exportMode) && size < this.maxRowsNonStreaming) {
            return new XSSFWorkbook();
        }
        if (size < this.maxRowsStreaming) {
            return new SXSSFWorkbook();
        }
        return null;
    }

    public void exportFromGrid(Grid grid) {
        Table table = new Table();
        table.setContainerDataSource((Container)grid.getContainerDataSource());
        for (Grid.Column c : grid.getColumns()) {
            Object oid = c.getPropertyId();
            ArrayList<String> caption = new ArrayList<String>();
            for (int i = 0; i < grid.getHeaderRowCount(); ++i) {
                Grid.HeaderRow r = grid.getHeaderRow(i);
                try {
                    caption.add(((Grid.HeaderCell)r.getCell(oid)).getText());
                    continue;
                }
                catch (Exception ex) {
                    caption.add(((Grid.HeaderCell)r.getCell(oid)).getHtml());
                }
            }
            table.setColumnHeader(c.getPropertyId(), caption.stream().collect(Collectors.joining(" ")).replaceAll("<\\w+/>", " "));
        }
        this.handleAction(this.actionExport, table, null);
    }

    protected AttributeModel findAttributeModel(Object propId) {
        if (this.entityModels != null) {
            String prop = propId.toString();
            int p = prop.indexOf(95);
            String pString = p >= 0 ? prop.substring(p + 1) : prop;
            return this.entityModels.stream().filter(em -> em.getAttributeModel(pString) != null).map(em -> em.getAttributeModel(pString)).findFirst().orElse(null);
        }
        return null;
    }

    public Action[] getActions(Object target, Object sender) {
        return new Action[]{this.actionExport};
    }

    private String getFormattedDate() {
        return DateUtils.formatDateTime((LocalDateTime)LocalDateTime.now(), (String)SystemPropertyUtils.getDefaultDateTimeFormat());
    }

    public void handleAction(Action action, Object sender, Object target) {
        if (action == this.actionExport && sender != null && sender instanceof Table) {
            Table table = (Table)sender;
            int size = 0;
            if (sender instanceof TreeTable) {
                TreeTable tt = (TreeTable)sender;
                if (tt.getContainerDataSource() instanceof ModelBasedHierarchicalContainer) {
                    ModelBasedHierarchicalContainer hc = (ModelBasedHierarchicalContainer)tt.getContainerDataSource();
                    size = hc.getBottomLevelSize();
                } else {
                    size = table.getContainerDataSource().size();
                }
            } else if (sender instanceof Table) {
                size = table.getContainerDataSource().size();
            }
            TableExportService service = (TableExportService)ServiceLocatorFactory.getServiceLocator().getService(TableExportService.class);
            if (TableExportMode.CSV.equals((Object)this.exportMode)) {
                ModelCSVExport export = new ModelCSVExport(table);
                if (table instanceof TreeTable) {
                    export.getTableHolder().setHierarchical(true);
                }
                export.setExportFileName((this.reportTitle + " " + this.getFormattedDate() + ".csv").replace(' ', '_'));
                export.setReportTitle(this.reportTitle);
                service.export(export);
            } else {
                Workbook wb = this.createWorkbook(size);
                if (wb == null) {
                    Notification.show((String)this.messageService.getMessage("ocs.export.too.large", VaadinUtils.getLocale()), (Notification.Type)Notification.Type.ERROR_MESSAGE);
                } else {
                    ModelExcelExport export = new ModelExcelExport(table, wb);
                    export.setReportTitle(this.reportTitle);
                    export.setRowHeaders(false);
                    if (table instanceof TreeTable) {
                        export.getTableHolder().setHierarchical(true);
                        export.setDisplayTotals(!(sender instanceof ModelBasedTreeTable));
                    }
                    export.setExportFileName((this.reportTitle + " " + this.getFormattedDate() + ".xlsx").replace(' ', '_'));
                    service.export((TableExport)export);
                }
            }
        }
    }

    class ModelExcelExport
    extends ExcelExport
    implements HasReportTitle {
        private static final long serialVersionUID = 5811530790417796915L;
        private CellStyle bigDecimalPercentageStyle;
        private CellStyle bigDecimalStyle;
        private CellStyle numberStyle;
        private CellStyle numberPercentageStyle;
        private CellStyle normal;
        private Map<Integer, Boolean> percentages;

        ModelExcelExport(Table table, Workbook workBook) {
            super(table, workBook, TableExportActionHandler.this.messageService.getMessage("ocs.export", VaadinUtils.getLocale()), TableExportActionHandler.this.reportTitle, null, TableExportActionHandler.this.totalsRow);
            this.percentages = new HashMap<Integer, Boolean>();
            DataFormat format = this.workbook.createDataFormat();
            this.numberStyle = this.workbook.createCellStyle();
            this.numberStyle.setAlignment((short)3);
            this.addBorder(this.numberStyle);
            this.numberStyle.setDataFormat(format.getFormat("#,#"));
            this.numberPercentageStyle = this.workbook.createCellStyle();
            this.numberPercentageStyle.setAlignment((short)3);
            this.addBorder(this.numberPercentageStyle);
            this.numberPercentageStyle.setDataFormat(format.getFormat("#,#%"));
            this.bigDecimalStyle = this.workbook.createCellStyle();
            this.bigDecimalStyle.setAlignment((short)3);
            this.addBorder(this.bigDecimalStyle);
            this.bigDecimalStyle.setDataFormat(format.getFormat("#,##0.00##"));
            this.bigDecimalPercentageStyle = this.workbook.createCellStyle();
            this.bigDecimalPercentageStyle.setAlignment((short)3);
            this.addBorder(this.bigDecimalPercentageStyle);
            this.bigDecimalPercentageStyle.setDataFormat(format.getFormat("#,##0.00%"));
            this.normal = this.workbook.createCellStyle();
            this.normal.setAlignment((short)1);
            this.addBorder(this.normal);
        }

        protected void addDataRow(Sheet sheetToAddTo, Object rootItemId, int row) {
            Row sheetRow = sheetToAddTo.createRow(row);
            List<Object> props = this.getPropIds();
            Item item = this.getTableHolder().getContainerDataSource().getItem(rootItemId);
            for (int col = 0; col < props.size(); ++col) {
                Object propId = props.get(col);
                Property<?> prop = this.getProperty(item, rootItemId, propId);
                Object value = prop == null ? null : prop.getValue();
                Cell sheetCell = sheetRow.createCell(col);
                CellStyle custom = null;
                CellStyle standard = this.normal;
                if (value != null) {
                    boolean isPercentage;
                    AttributeModel am = TableExportActionHandler.this.findAttributeModel(propId);
                    boolean bl = isPercentage = am != null && am.isPercentage();
                    if (TableExportActionHandler.this.cellStyleGenerator != null) {
                        custom = TableExportActionHandler.this.cellStyleGenerator.getCustomCellStyle(this.workbook, item, rootItemId, propId, value, am);
                    }
                    if (NumberUtils.isLong((Object)value) || NumberUtils.isInteger((Object)value)) {
                        if (isPercentage) {
                            sheetCell.setCellValue(this.toPercentageValue(am, value));
                            standard = this.numberPercentageStyle;
                            this.percentages.put(col, true);
                        } else {
                            standard = this.numberStyle;
                            sheetCell.setCellValue(((Number)value).doubleValue());
                            this.percentages.put(col, false);
                        }
                    } else if (value instanceof BigDecimal) {
                        if (isPercentage) {
                            sheetCell.setCellValue(this.toPercentageValue(am, value));
                            standard = this.bigDecimalPercentageStyle;
                            this.percentages.put(col, true);
                        } else {
                            sheetCell.setCellValue(((BigDecimal)value).setScale(5, RoundingMode.HALF_UP).doubleValue());
                            standard = this.bigDecimalStyle;
                            this.percentages.put(col, false);
                        }
                    } else if (am != null) {
                        if (value instanceof String) {
                            value = StringUtils.replaceHtmlBreaks((String)((String)value));
                        }
                        sheetCell.setCellValue(FormatUtils.formatPropertyValue(TableExportActionHandler.this.entityModelFactory, am, value, ", "));
                    } else {
                        value = StringUtils.replaceHtmlBreaks((String)value.toString());
                        sheetCell.setCellValue(value.toString());
                    }
                }
                if (custom != null) {
                    sheetCell.setCellStyle(custom);
                    continue;
                }
                if (standard == null) continue;
                sheetCell.setCellStyle(standard);
            }
        }

        private void addBorder(CellStyle style) {
            style.setBorderBottom((short)1);
            style.setBorderTop((short)1);
            style.setBorderLeft((short)1);
            style.setBorderRight((short)1);
        }

        private int addDataRowRecursively(Sheet sheetToAddTo, Object rootItemId, int row) {
            int numberAdded = 0;
            int localRow = row;
            this.addDataRow(sheetToAddTo, rootItemId, row);
            ++numberAdded;
            if (((Container.Hierarchical)this.getTableHolder().getContainerDataSource()).hasChildren(rootItemId)) {
                Collection children = ((Container.Hierarchical)this.getTableHolder().getContainerDataSource()).getChildren(rootItemId);
                int childCount = 0;
                for (Object child : children) {
                    childCount = this.addDataRowRecursively(sheetToAddTo, child, localRow + 1);
                    localRow += childCount;
                    numberAdded += childCount;
                }
                if (this.displayTotals) {
                    this.addDataRow(this.hierarchicalTotalsSheet, rootItemId, localRow);
                }
                if (numberAdded > 1 && !this.isStreaming()) {
                    this.sheet.groupRow(row + 1, row + numberAdded - 1);
                    this.sheet.setRowGroupCollapsed(row + 1, true);
                }
            }
            return numberAdded;
        }

        protected int addHierarchicalDataRows(Sheet sheetToAddTo, int row) {
            int localRow = row;
            Collection roots = ((Container.Hierarchical)this.getTableHolder().getContainerDataSource()).rootItemIds();
            this.sheet.setRowSumsBelow(false);
            int count = 0;
            for (Object rootId : roots) {
                count = this.addDataRowRecursively(sheetToAddTo, rootId, localRow);
                localRow += count;
            }
            return localRow;
        }

        protected void addTotalsRow(int currentRow, int startRow) {
            if (!this.isStreaming()) {
                this.totalsRow = this.sheet.createRow(currentRow);
                this.totalsRow.setHeightInPoints(30.0f);
                for (int col = 0; col < this.getPropIds().size(); ++col) {
                    Object propId = this.getPropIds().get(col);
                    Cell cell = this.totalsRow.createCell(col);
                    cell.setCellStyle(this.getCellStyle(currentRow, startRow, col, true));
                    Short poiAlignment = this.getTableHolder().getCellAlignment(propId);
                    CellUtil.setAlignment((Cell)cell, (Workbook)this.workbook, (short)poiAlignment);
                    Class<?> propType = this.getPropertyType(propId);
                    if (NumberUtils.isNumeric(propType)) {
                        boolean perc = Boolean.TRUE.equals(this.percentages.get(col));
                        if (NumberUtils.isInteger(propType) || NumberUtils.isLong(propType)) {
                            cell.setCellStyle(perc ? this.numberPercentageStyle : this.numberStyle);
                        } else if (BigDecimal.class.equals(propType)) {
                            cell.setCellStyle(perc ? this.bigDecimalPercentageStyle : this.bigDecimalStyle);
                        }
                        CellRangeAddress cra = new CellRangeAddress(startRow, currentRow - 1, col, col);
                        if (this.isHierarchical()) {
                            cell.setCellFormula("SUM(" + cra.formatAsString(this.hierarchicalTotalsSheet.getSheetName(), true) + ")");
                            continue;
                        }
                        cell.setCellFormula("SUM(" + cra.formatAsString() + ")");
                        continue;
                    }
                    if (col != 0) continue;
                    cell.setCellValue(this.createHelper.createRichTextString(TableExportActionHandler.this.messageService.getMessage("ocs.total", VaadinUtils.getLocale())));
                }
            }
        }

        private double toPercentageValue(AttributeModel am, Object value) {
            BigDecimal bd = null;
            bd = value instanceof BigDecimal ? (BigDecimal)value : BigDecimal.valueOf(((Number)value).doubleValue());
            return bd.divide(HUNDRED, 10, RoundingMode.HALF_UP).setScale(am.getPrecision() + 2, RoundingMode.HALF_UP).doubleValue();
        }

        protected void finalSheetFormat() {
            if (!this.isStreaming()) {
                super.finalSheetFormat();
            }
        }

        protected Property<?> getProperty(Item item, Object rootItemId, Object propId) {
            Property prop = this.getTableHolder().isGeneratedColumn(propId) ? this.getTableHolder().getPropertyForGeneratedColumn(propId, rootItemId) : item.getItemProperty(propId);
            return prop;
        }

        private Class<?> getPropertyType(Object propId) {
            Class classType = this.getTableHolder().isGeneratedColumn(propId) ? this.getTableHolder().getPropertyTypeForGeneratedColumn(propId) : this.getTableHolder().getContainerDataSource().getType(propId);
            return classType;
        }

        public List<Object> getPropIds() {
            if (TableExportActionHandler.this.columnIds != null) {
                return TableExportActionHandler.this.columnIds.stream().collect(Collectors.toList());
            }
            return super.getPropIds();
        }

        private boolean isStreaming() {
            return this.workbook instanceof SXSSFWorkbook;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean sendConverted() {
            File tempFile = null;
            try {
                tempFile = File.createTempFile("tmp", ".xlsx");
                FileOutputStream fileOut = new FileOutputStream(tempFile);
                this.workbook.write((OutputStream)fileOut);
                this.setMimeType(TableExportActionHandler.MIME_TYPE_XLSX);
                UI tableUI = this.getTableHolder().getUI();
                boolean bl = super.sendConvertedFileToUser(tableUI != null ? tableUI : TableExportActionHandler.this.ui, tempFile, this.exportFileName);
                return bl;
            }
            catch (IOException e) {
                LOG.error((Object)e.getMessage(), (Throwable)e);
                boolean bl = false;
                return bl;
            }
            finally {
                if (this.workbook != null) {
                    try {
                        this.workbook.close();
                    }
                    catch (IOException iOException) {}
                }
                if (tempFile != null) {
                    tempFile.delete();
                }
            }
        }
    }

    class ModelCSVExport
    extends TableExport
    implements HasReportTitle {
        private static final long serialVersionUID = -1932835869230658150L;
        private CSVWriter writer;
        private ByteArrayOutputStream out;
        private String exportFileName;
        private String reportTitle;
        private Container container;

        ModelCSVExport(Table table) {
            super(table);
        }

        protected void addDataRow(Object rootItemId) {
            List<Object> props = this.getPropIds();
            Item item = this.container.getItem(rootItemId);
            ArrayList<String> fields = new ArrayList<String>();
            for (Object prop1 : props) {
                Object value;
                Object propId = prop1;
                Property<?> prop = this.getProperty(item, rootItemId, propId);
                Object object = value = prop == null ? null : prop.getValue();
                if (value != null) {
                    AttributeModel am = TableExportActionHandler.this.findAttributeModel(propId);
                    if (am != null) {
                        value = FormatUtils.formatPropertyValue(TableExportActionHandler.this.entityModelFactory, am, value, ", ");
                    }
                    value = value instanceof String ? StringUtils.replaceHtmlBreaks((String)value.toString()) : NumberUtils.format((Object)value);
                }
                fields.add(value == null ? "" : value.toString());
            }
            this.writer.writeNext(fields.toArray(new String[0]));
        }

        protected void addDataRowRecursively(Object rootItemId) {
            this.addDataRow(rootItemId);
            if (this.container != null && ((Container.Hierarchical)this.container).hasChildren(rootItemId)) {
                Collection children = ((Container.Hierarchical)this.getTableHolder().getContainerDataSource()).getChildren(rootItemId);
                children.forEach(c -> this.addDataRowRecursively(c));
            }
        }

        protected void addDataRows() {
            this.container.getItemIds().forEach(i -> this.addDataRow(i));
        }

        protected void addHeaderRow() {
            ArrayList<String> headers = new ArrayList<String>();
            for (int col = 0; col < this.getPropIds().size(); ++col) {
                Object propId = this.getPropIds().get(col);
                String value = this.getTableHolder().getColumnHeader(propId);
                headers.add(value == null ? "" : value.trim());
            }
            this.writer.writeNext(headers.toArray(new String[0]));
        }

        protected void addHierarchicalDataRows() {
            Collection roots = ((Container.Hierarchical)this.getTableHolder().getContainerDataSource()).rootItemIds();
            for (Object rootId : roots) {
                this.addDataRowRecursively(rootId);
            }
        }

        public void convertTable() {
            this.out = new ByteArrayOutputStream();
            this.writer = new CSVWriter((Writer)new OutputStreamWriter(this.out), SystemPropertyUtils.getExportCsvSeparator().charAt(0), SystemPropertyUtils.getExportCsvQuoteChar().charAt(0));
            this.container = this.getTableHolder().getContainerDataSource();
            this.addHeaderRow();
            if (this.isHierarchical()) {
                this.addHierarchicalDataRows();
            } else {
                this.addDataRows();
            }
        }

        public String getExportFileName() {
            return this.exportFileName;
        }

        protected Property<?> getProperty(Item item, Object rootItemId, Object propId) {
            Property prop = this.getTableHolder().isGeneratedColumn(propId) ? this.getTableHolder().getPropertyForGeneratedColumn(propId, rootItemId) : item.getItemProperty(propId);
            return prop;
        }

        public List<Object> getPropIds() {
            if (TableExportActionHandler.this.columnIds != null) {
                return TableExportActionHandler.this.columnIds.stream().collect(Collectors.toList());
            }
            return super.getPropIds();
        }

        @Override
        public String getReportTitle() {
            return this.reportTitle;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean sendConverted() {
            File tempFile = null;
            try {
                this.writer.flush();
                tempFile = File.createTempFile("tmp", ".csv");
                FileUtils.writeByteArrayToFile((File)tempFile, (byte[])this.out.toByteArray());
                this.setMimeType(CSV_MIME_TYPE);
                UI tableUI = this.getTableHolder().getUI();
                boolean bl = super.sendConvertedFileToUser(tableUI != null ? tableUI : TableExportActionHandler.this.ui, tempFile, this.exportFileName);
                return bl;
            }
            catch (IOException e) {
                LOG.error((Object)e.getMessage(), (Throwable)e);
                boolean bl = false;
                return bl;
            }
            finally {
                if (tempFile != null) {
                    tempFile.delete();
                }
                try {
                    this.writer.close();
                }
                catch (IOException e) {
                    LOG.error((Object)e.getMessage(), (Throwable)e);
                }
            }
        }

        public void setExportFileName(String exportFileName) {
            this.exportFileName = exportFileName;
        }

        public void setReportTitle(String reportTitle) {
            this.reportTitle = reportTitle;
        }
    }
}

