/*
 * Decompiled with CFR 0.152.
 */
package com.ocs.dynamo.ui.container;

import com.ocs.dynamo.dao.SortOrder;
import com.ocs.dynamo.domain.AbstractEntity;
import com.ocs.dynamo.domain.model.EntityModel;
import com.ocs.dynamo.domain.model.EntityModelFactory;
import com.ocs.dynamo.filter.Filter;
import com.ocs.dynamo.filter.FilterConverter;
import com.ocs.dynamo.service.MessageService;
import com.ocs.dynamo.service.ServiceLocatorFactory;
import com.ocs.dynamo.ui.container.ServiceQueryDefinition;
import com.ocs.dynamo.utils.ClassUtils;
import com.vaadin.data.Container;
import com.vaadin.data.util.filter.And;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.vaadin.addons.lazyquerycontainer.AbstractBeanQuery;

public abstract class BaseServiceQuery<ID extends Serializable, T extends AbstractEntity<ID>>
extends AbstractBeanQuery<T> {
    private static final long serialVersionUID = 4128040933505878355L;
    private int countDown;
    private Class<?> idClass;
    private Class<T> entityClass;
    private MessageService messageService = ServiceLocatorFactory.getServiceLocator().getMessageService();
    private EntityModelFactory entityModelFactory = ServiceLocatorFactory.getServiceLocator().getEntityModelFactory();

    public BaseServiceQuery(ServiceQueryDefinition<ID, T> queryDefinition, Map<String, Object> queryConfiguration) {
        super(queryDefinition, queryConfiguration, null, null);
    }

    protected T constructBean() {
        if (this.entityClass == null) {
            this.entityClass = this.getCustomQueryDefinition().getService().getEntityClass();
        }
        if (this.idClass == null) {
            this.idClass = ClassUtils.getResolvedType(this.entityClass, (String)"id", (int[])new int[0]);
        }
        AbstractEntity result = (AbstractEntity)ClassUtils.instantiateClass(this.entityClass, (Object[])new Object[0]);
        if (Integer.class.equals(this.idClass)) {
            ClassUtils.setFieldValue((Object)result, (String)"id", (Object)(Integer.MAX_VALUE - this.countDown));
        } else if (Long.class.equals(this.idClass)) {
            ClassUtils.setFieldValue((Object)result, (String)"id", (Object)(Long.MAX_VALUE - (long)this.countDown));
        }
        --this.countDown;
        return (T)result;
    }

    protected Filter constructFilter() {
        ArrayList filters = new ArrayList();
        filters.addAll(this.getCustomQueryDefinition().getDefaultFilters());
        filters.addAll(this.getCustomQueryDefinition().getFilters());
        Container.Filter first = !filters.isEmpty() ? (Container.Filter)filters.remove(0) : null;
        while (!filters.isEmpty()) {
            Container.Filter filter = (Container.Filter)filters.remove(0);
            first = new And(new Container.Filter[]{first, filter});
        }
        EntityModel em = this.getCustomQueryDefinition().getEntityModel();
        if (em == null) {
            em = this.entityModelFactory.getModel(this.getCustomQueryDefinition().getService().getEntityClass());
        }
        return new FilterConverter(em).convert(first);
    }

    protected SortOrder[] constructOrder() {
        boolean[] sortPropertyAscendingStates;
        Object[] sortPropertyIds;
        ServiceQueryDefinition<ID, T> queryDefinition = this.getCustomQueryDefinition();
        if (queryDefinition.getSortPropertyIds().length == 0) {
            sortPropertyIds = queryDefinition.getDefaultSortPropertyIds();
            sortPropertyAscendingStates = queryDefinition.getDefaultSortPropertyAscendingStates();
        } else {
            sortPropertyIds = queryDefinition.getSortPropertyIds();
            sortPropertyAscendingStates = queryDefinition.getSortPropertyAscendingStates();
        }
        SortOrder[] orders = new SortOrder[sortPropertyIds.length];
        if (sortPropertyIds.length > 0) {
            for (int i = 0; i < sortPropertyIds.length; ++i) {
                orders[i] = new SortOrder(sortPropertyAscendingStates[i] ? SortOrder.Direction.ASC : SortOrder.Direction.DESC, sortPropertyIds[i].toString());
            }
        }
        return orders;
    }

    protected void saveBeans(List<T> addedBeans, List<T> modifiedBeans, List<T> removedBeans) {
        modifiedBeans.removeAll(removedBeans);
        addedBeans.removeAll(removedBeans);
        removedBeans.removeIf(t -> this.getCustomQueryDefinition().getService().findById(t.getId()) == null);
        for (AbstractEntity added : addedBeans) {
            added.setId(null);
        }
        this.countDown = 0;
        this.getCustomQueryDefinition().getService().update(modifiedBeans, addedBeans, removedBeans);
    }

    protected ServiceQueryDefinition<ID, T> getCustomQueryDefinition() {
        return (ServiceQueryDefinition)super.getQueryDefinition();
    }

    public MessageService getMessageService() {
        return this.messageService;
    }
}

