/*
 * Decompiled with CFR 0.152.
 */
package com.ocs.dynamo.ui.container;

import com.ocs.dynamo.dao.SortOrder;
import com.ocs.dynamo.dao.SortOrders;
import com.ocs.dynamo.domain.AbstractEntity;
import com.ocs.dynamo.filter.Filter;
import com.ocs.dynamo.ui.container.BaseServiceQuery;
import com.ocs.dynamo.ui.container.ServiceQueryDefinition;
import com.ocs.dynamo.ui.utils.VaadinUtils;
import com.vaadin.ui.Notification;
import java.io.Serializable;
import java.util.List;
import java.util.Map;

public class PagingServiceQuery<ID extends Serializable, T extends AbstractEntity<ID>>
extends BaseServiceQuery<ID, T> {
    private static final long serialVersionUID = -324739194626626683L;

    public PagingServiceQuery(ServiceQueryDefinition<ID, T> queryDefinition, Map<String, Object> queryConfiguration) {
        super(queryDefinition, queryConfiguration);
    }

    protected List<T> loadBeans(int startIndex, int count) {
        Filter serviceFilter = this.constructFilter();
        SortOrder[] orders = this.constructOrder();
        ServiceQueryDefinition definition = this.getCustomQueryDefinition();
        return definition.getService().fetch(serviceFilter, startIndex / definition.getBatchSize(), definition.getBatchSize(), new SortOrders(orders), definition.getJoins());
    }

    public int size() {
        if (this.getCustomQueryDefinition().getPredeterminedCount() != null) {
            return this.getCustomQueryDefinition().getPredeterminedCount();
        }
        int count = (int)this.getCustomQueryDefinition().getService().count(this.constructFilter(), false);
        if (this.getCustomQueryDefinition().getMaxQuerySize() > 0 && count >= this.getCustomQueryDefinition().getMaxQuerySize()) {
            Notification.show((String)this.getMessageService().getMessage("ocs.too.many.results", VaadinUtils.getLocale(), new Object[]{this.getCustomQueryDefinition().getMaxQuerySize()}), (Notification.Type)Notification.Type.ERROR_MESSAGE);
        }
        return count;
    }
}

