/*
 * Decompiled with CFR 0.152.
 */
package com.ocs.dynamo.ui.container;

import com.ocs.dynamo.dao.FetchJoinInformation;
import com.ocs.dynamo.domain.AbstractEntity;
import com.ocs.dynamo.domain.model.AttributeModel;
import com.ocs.dynamo.domain.model.EditableType;
import com.ocs.dynamo.domain.model.EntityModel;
import com.ocs.dynamo.service.BaseService;
import com.ocs.dynamo.ui.Searchable;
import com.ocs.dynamo.ui.container.QueryType;
import com.ocs.dynamo.ui.container.ServiceQueryDefinition;
import com.ocs.dynamo.ui.container.ServiceQueryFactory;
import com.vaadin.data.Container;
import com.vaadin.data.sort.SortOrder;
import com.vaadin.shared.data.sort.SortDirection;
import java.io.Serializable;
import org.vaadin.addons.lazyquerycontainer.LazyQueryContainer;

public class ServiceContainer<ID extends Serializable, T extends AbstractEntity<ID>>
extends LazyQueryContainer
implements Searchable {
    private static final long serialVersionUID = 2605988307857731787L;

    public ServiceContainer(BaseService<ID, T> service, EntityModel<T> model, boolean compositeItems, int batchSize, QueryType queryType, FetchJoinInformation ... joins) {
        super(new ServiceQueryDefinition<ID, T>(service, compositeItems, batchSize, model, queryType, joins), new ServiceQueryFactory());
        this.addContainerProperties(model);
    }

    public ServiceContainer(BaseService<ID, T> service, EntityModel<T> entityModel, int batchSize, QueryType queryType, FetchJoinInformation ... joins) {
        super(new ServiceQueryDefinition<ID, T>(service, true, batchSize, entityModel, queryType, joins), new ServiceQueryFactory());
    }

    public void addContainerProperties(EntityModel<?> model) {
        for (AttributeModel attributeModel : model.getAttributeModels()) {
            if (!attributeModel.isVisibleInTable()) continue;
            this.addContainerProperty(attributeModel.getName(), attributeModel.getType(), attributeModel.getDefaultValue(), EditableType.READ_ONLY.equals((Object)attributeModel.getEditableType()), attributeModel.isSortable());
        }
    }

    public void addContainerProperty(AttributeModel attributeModel) {
        this.addContainerProperty(attributeModel.getPath(), attributeModel.getType(), attributeModel.getDefaultValue(), EditableType.READ_ONLY.equals((Object)attributeModel.getEditableType()), attributeModel.isSortable());
    }

    public BaseService<ID, T> getService() {
        if (this.getQueryView() != null && this.getQueryView().getQueryDefinition() instanceof ServiceQueryDefinition) {
            return ((ServiceQueryDefinition)this.getQueryView().getQueryDefinition()).getService();
        }
        return null;
    }

    @Override
    public void search(Container.Filter filter) {
        this.getQueryView().removeFilters();
        if (filter != null) {
            this.getQueryView().addFilter(filter);
        }
        this.refresh();
    }

    public void sort(SortOrder ... sortOrder) {
        if (sortOrder != null && sortOrder.length > 0) {
            Object[] pIds = new Object[sortOrder.length];
            boolean[] sos = new boolean[sortOrder.length];
            int i = 0;
            for (SortOrder so : sortOrder) {
                pIds[i] = so.getPropertyId();
                sos[i++] = SortDirection.ASCENDING == so.getDirection();
            }
            this.sort(pIds, sos);
        }
    }
}

