/*
 * Decompiled with CFR 0.152.
 */
package com.ocs.dynamo.ui.container.hierarchical;

import com.ocs.dynamo.domain.AbstractEntity;
import com.ocs.dynamo.ui.utils.SubList;
import com.vaadin.data.Container;
import com.vaadin.data.Item;
import com.vaadin.data.Property;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.vaadin.addons.lazyquerycontainer.LazyQueryContainer;

public class HierarchicalContainer
implements Container.Hierarchical,
Container.Ordered,
Container.ItemSetChangeNotifier,
Container.ItemSetChangeListener,
Container.Sortable {
    private Map<Integer, HierarchicalDefinition> hierarchy = new HashMap<Integer, HierarchicalDefinition>();
    private List<?> primairyPropertyIds;
    private Map<HierarchicalId, Indexes> childIndexes = new HashMap<HierarchicalId, Indexes>();
    private List<Container.ItemSetChangeListener> itemSetChangeListeners = new ArrayList<Container.ItemSetChangeListener>();
    private boolean itemSetChangeEventInProgress = false;

    public HierarchicalContainer(Object ... propertyIds) {
        this.primairyPropertyIds = Arrays.asList(propertyIds);
    }

    public Map<Integer, HierarchicalDefinition> getHierarchy() {
        return this.hierarchy;
    }

    public HierarchicalDefinition getHierarchicalDefinitionByItemId(Object itemId) {
        HierarchicalId hId = (HierarchicalId)itemId;
        return this.getHierarchy().get(hId.getLevel());
    }

    public void addDefinition(HierarchicalDefinition definition) {
        this.getHierarchy().put(definition.getLevel(), definition);
        if (definition.getContainer() instanceof Container.ItemSetChangeNotifier) {
            ((Container.ItemSetChangeNotifier)definition.getContainer()).addItemSetChangeListener((Container.ItemSetChangeListener)this);
        }
    }

    public void addDefinition(Container.Indexed container, int level, Object itemPropertyId, Object itemPropertyIdParent, Object ... propertyIds) {
        this.getHierarchy().put(level, new HierarchicalDefinition(container, level, itemPropertyId, itemPropertyIdParent, Arrays.asList(propertyIds)));
        if (container instanceof Container.ItemSetChangeNotifier) {
            ((Container.ItemSetChangeNotifier)container).addItemSetChangeListener((Container.ItemSetChangeListener)this);
        }
    }

    protected Object unwrapItemId(Object itemId) {
        if (itemId == null) {
            return null;
        }
        if (!(itemId instanceof HierarchicalId)) {
            return itemId;
        }
        return ((HierarchicalId)itemId).getItemId();
    }

    protected Item mapItemProperties(HierarchicalDefinition definition, Item item) {
        if (item == null) {
            return null;
        }
        int i = 0;
        Collection pids = item.getItemPropertyIds();
        for (Object p : this.getContainerPropertyIds()) {
            Property prop;
            if (p == null || pids.contains(p) || (prop = item.getItemProperty(definition.getPropertyIds().get(i))) == null) continue;
            item.addItemProperty(p, prop);
        }
        return item;
    }

    protected Collection<Item> mapItemProperties(HierarchicalDefinition definition, Collection<Item> items) {
        if (items != null) {
            for (Item item : items) {
                this.mapItemProperties(definition, item);
            }
        }
        return items;
    }

    public Item getItem(Object itemId) {
        HierarchicalDefinition def = this.getHierarchicalDefinitionByItemId(itemId);
        return this.mapItemProperties(def, def.getContainer().getItem(this.unwrapItemId(itemId)));
    }

    public Collection<?> getContainerPropertyIds() {
        return this.primairyPropertyIds;
    }

    protected void setContainerPropertyIds(List<?> primairyPropertyIds) {
        this.primairyPropertyIds = primairyPropertyIds;
    }

    public List<?> getItemIds() {
        return this.rootItemIds();
    }

    public Object unmapProperty(HierarchicalDefinition definition, Object propertyId) {
        int i = this.primairyPropertyIds.indexOf(propertyId);
        if (i >= 0 && i < definition.getPropertyIds().size()) {
            return definition.getPropertyIds().get(i);
        }
        if (definition.getContainer().getContainerPropertyIds().contains(propertyId)) {
            return propertyId;
        }
        return null;
    }

    public Property<?> getContainerProperty(Object itemId, Object propertyId) {
        HierarchicalId hId = (HierarchicalId)itemId;
        HierarchicalDefinition def = this.getHierarchy().get(hId.getLevel());
        Object pId = this.unmapProperty(def, propertyId);
        return def.getContainer().getContainerProperty(hId.getItemId(), pId);
    }

    public Class<?> getType(Object propertyId) {
        for (int level : this.getHierarchy().keySet()) {
            HierarchicalDefinition def = this.getHierarchy().get(level);
            Object pId = this.unmapProperty(def, propertyId);
            if (pId == null) continue;
            return def.getContainer().getType(pId);
        }
        return null;
    }

    public int size() {
        return this.getHierarchy().get(0).getContainer().size();
    }

    public boolean containsId(Object itemId) {
        HierarchicalId hId = (HierarchicalId)itemId;
        HierarchicalDefinition def = this.getHierarchy().get(hId.getLevel());
        return def.getContainer().containsId(hId.getItemId());
    }

    public Item addItem(Object itemId) {
        throw new UnsupportedOperationException();
    }

    public Object addItem() {
        throw new UnsupportedOperationException();
    }

    public boolean addContainerProperty(Object propertyId, Class<?> type, Object defaultValue) {
        throw new UnsupportedOperationException();
    }

    public boolean removeContainerProperty(Object propertyId) {
        throw new UnsupportedOperationException();
    }

    public boolean removeAllItems() {
        throw new UnsupportedOperationException();
    }

    protected int searchIndexByPropertyValue(Container.Indexed container, Object propertyId, Object parentIdValue, int startIndex, boolean first) {
        int i;
        block10: {
            int ll = startIndex;
            int ul = container.size() - 1;
            i = ll + (ul - ll) / 2;
            int maxsteps = 16;
            do {
                int ci;
                Object currentpv;
                if (AbstractEntity.class.isInstance(currentpv = container.getItem(container.getIdByIndex(i)).getItemProperty(propertyId).getValue())) {
                    currentpv = ((AbstractEntity)currentpv).getId();
                }
                if ((ci = ((Comparable)parentIdValue).compareTo(currentpv)) == 0) {
                    if (first && i == ll || !first && i == ul) break block10;
                    int io = first ? i - 1 : i + 1;
                    Object otherpv = container.getItem(container.getIdByIndex(io)).getItemProperty(propertyId).getValue();
                    if (AbstractEntity.class.isInstance(otherpv)) {
                        otherpv = ((AbstractEntity)otherpv).getId();
                    }
                    if (!currentpv.equals(otherpv)) break block10;
                    if (first) {
                        ul = i - 1;
                    } else {
                        ll = i + 1;
                    }
                } else if (ci < 0) {
                    ul = i - 1;
                } else if (ci > 0) {
                    ll = i + 1;
                }
                i = ll + (ul - ll) / 2;
            } while (ul >= ll && --maxsteps >= 0);
            i = -1;
        }
        return i;
    }

    public List<?> getChildren(Object itemId) {
        HierarchicalDefinition cdef;
        Indexes childIndex;
        HierarchicalId hId = (HierarchicalId)itemId;
        if (hId.getLevel() + 1 < this.getHierarchy().size() && (childIndex = this.getChildIndexes(hId, cdef = this.getHierarchy().get(hId.getLevel() + 1))).getIndexFirstChild() >= 0 && childIndex.getIndexLastChild() >= 0 && childIndex.getIndexFirstChild() <= childIndex.getIndexLastChild()) {
            return new HierarchicalSubList(cdef.getLevel(), hId, (List)cdef.container.getItemIds(), childIndex.getIndexFirstChild(), childIndex.getIndexLastChild() + 1);
        }
        return null;
    }

    public int getBottomLevelSize() {
        int levels = this.getHierarchy().size();
        return this.getHierarchy().get(levels - 1).getContainer().size();
    }

    protected Indexes getChildIndexes(HierarchicalId parentItemId, HierarchicalDefinition childDefinition) {
        Indexes childIndex = null;
        if (this.childIndexes.containsKey(parentItemId)) {
            childIndex = this.childIndexes.get(parentItemId);
        } else {
            int fi = this.searchIndexByPropertyValue(childDefinition.getContainer(), childDefinition.getItemPropertyIdParent(), parentItemId.getItemId(), 0, true);
            int li = this.searchIndexByPropertyValue(childDefinition.getContainer(), childDefinition.getItemPropertyIdParent(), parentItemId.getItemId(), 0, false);
            childIndex = new Indexes(parentItemId.getLevel(), fi, li);
            this.childIndexes.put(parentItemId, childIndex);
        }
        return childIndex;
    }

    public Object getParent(Object itemId) {
        HierarchicalId hId = (HierarchicalId)itemId;
        return hId.getParentId();
    }

    public List<?> rootItemIds() {
        HierarchicalDefinition def = this.getHierarchy().get(0);
        return new HierarchicalSubList(def.getLevel(), null, (List)def.container.getItemIds(), 0, def.container.size());
    }

    public boolean setParent(Object itemId, Object newParentId) {
        throw new UnsupportedOperationException();
    }

    public boolean areChildrenAllowed(Object itemId) {
        HierarchicalId hId = (HierarchicalId)itemId;
        return hId.getLevel() < this.getHierarchy().size() - 1;
    }

    public boolean setChildrenAllowed(Object itemId, boolean areChildrenAllowed) {
        throw new UnsupportedOperationException();
    }

    public boolean isRoot(Object itemId) {
        HierarchicalId hId = (HierarchicalId)itemId;
        return hId.getLevel() == 0;
    }

    public boolean hasChildren(Object itemId) {
        HierarchicalId hId = (HierarchicalId)itemId;
        if (hId.getLevel() + 1 < this.getHierarchy().size()) {
            HierarchicalDefinition def = this.getHierarchy().get(hId.getLevel());
            if (def.itemPropertyIdHasChildren != null) {
                Property p = def.getContainer().getContainerProperty(hId.getItemId(), def.getItemPropertyIdHasChildren());
                return p != null && Boolean.TRUE.equals(p.getValue());
            }
            HierarchicalDefinition cdef = this.getHierarchy().get(hId.getLevel() + 1);
            Indexes childIndex = this.getChildIndexes(hId, cdef);
            return childIndex.getIndexFirstChild() >= 0;
        }
        return false;
    }

    public boolean removeItem(Object itemId) {
        throw new UnsupportedOperationException();
    }

    public Object nextItemId(Object itemId) {
        HierarchicalId hId = (HierarchicalId)itemId;
        HierarchicalDefinition def = this.getHierarchy().get(hId.getLevel());
        if (!def.container.isLastId(hId.getItemId())) {
            Indexes pi;
            int i = def.container.indexOfId(hId.getItemId()) + 1;
            HierarchicalId pId = hId.getParentId();
            if (pId != null && (pi = this.childIndexes.get(pId)).getIndexLastChild() < i) {
                pId = new HierarchicalId(hId.getLevel(), def.getContainer().nextItemId(hId.getItemId()), pId);
            }
            return new HierarchicalId(hId.getLevel(), def.container.getIdByIndex(i), pId);
        }
        HierarchicalId pId = hId.getParentId();
        if (pId != null) {
            return this.nextItemId(pId);
        }
        return null;
    }

    public Object prevItemId(Object itemId) {
        HierarchicalId hId = (HierarchicalId)itemId;
        HierarchicalDefinition def = this.getHierarchy().get(hId.getLevel());
        if (!def.container.isFirstId(hId.getItemId())) {
            Indexes pi;
            int i = def.container.indexOfId(hId.getItemId()) - 1;
            HierarchicalId pId = hId.getParentId();
            if (pId != null && i < (pi = this.childIndexes.get(pId)).getIndexFirstChild()) {
                pId = new HierarchicalId(hId.getLevel(), def.getContainer().nextItemId(hId.getItemId()), pId);
            }
            return new HierarchicalId(hId.getLevel(), def.container.getIdByIndex(i), pId);
        }
        HierarchicalId pId = hId.getParentId();
        if (pId != null) {
            return this.prevItemId(pId);
        }
        return null;
    }

    public Object firstItemId() {
        HierarchicalDefinition def = this.getHierarchy().get(0);
        if (def.getContainer().size() > 0) {
            return new HierarchicalId(0, def.container.firstItemId(), null);
        }
        return null;
    }

    public Object lastItemId() {
        HierarchicalDefinition def = this.getHierarchy().get(0);
        if (def.getContainer().size() > 0) {
            return new HierarchicalId(0, def.container.lastItemId(), null);
        }
        return null;
    }

    public boolean isFirstId(Object itemId) {
        if (itemId == null) {
            return false;
        }
        HierarchicalId hId = (HierarchicalId)itemId;
        HierarchicalDefinition def = this.getHierarchy().get(hId.getLevel());
        return def.container.isFirstId(hId.getItemId());
    }

    public boolean isLastId(Object itemId) {
        if (itemId == null) {
            return false;
        }
        HierarchicalId hId = (HierarchicalId)itemId;
        HierarchicalDefinition def = this.getHierarchy().get(hId.getLevel());
        return def.container.isLastId(hId.getItemId());
    }

    public Object addItemAfter(Object previousItemId) {
        throw new UnsupportedOperationException();
    }

    public Item addItemAfter(Object previousItemId, Object newItemId) {
        throw new UnsupportedOperationException();
    }

    public HierarchicalDefinition getHierarchicalDefinition(int level) {
        return this.getHierarchy().get(level);
    }

    public void addItemSetChangeListener(Container.ItemSetChangeListener listener) {
        this.itemSetChangeListeners.add(listener);
    }

    @Deprecated
    public void addListener(Container.ItemSetChangeListener listener) {
        throw new UnsupportedOperationException();
    }

    public void removeItemSetChangeListener(Container.ItemSetChangeListener listener) {
        this.itemSetChangeListeners.remove(listener);
    }

    @Deprecated
    public void removeListener(Container.ItemSetChangeListener listener) {
        throw new UnsupportedOperationException();
    }

    private void notifyItemSetChanged() {
        ItemSetChangeEvent event = new ItemSetChangeEvent(this);
        for (Container.ItemSetChangeListener listener : this.itemSetChangeListeners) {
            listener.containerItemSetChange((Container.ItemSetChangeEvent)event);
        }
    }

    public void containerItemSetChange(Container.ItemSetChangeEvent event) {
        if (!this.itemSetChangeEventInProgress) {
            this.itemSetChangeEventInProgress = true;
            this.childIndexes.clear();
            for (HierarchicalDefinition def : this.getHierarchy().values()) {
                if (def.getContainer() == event.getContainer() || !(def.getContainer() instanceof LazyQueryContainer)) continue;
                ((LazyQueryContainer)def.getContainer()).refresh();
            }
            this.notifyItemSetChanged();
            this.itemSetChangeEventInProgress = false;
        }
    }

    public void sort(Object[] propertyId, boolean[] ascending) {
        for (Integer level : this.getHierarchy().keySet()) {
            HierarchicalDefinition def = this.getHierarchicalDefinition(level);
            Container.Indexed c = def.getContainer();
            if (!(c instanceof Container.Sortable)) continue;
            ArrayList<Object> sids = new ArrayList<Object>();
            ArrayList<Integer> asci = new ArrayList<Integer>();
            for (int i = 0; i < propertyId.length; ++i) {
                Object pid = this.unmapProperty(def, propertyId[i]);
                if (!((Container.Sortable)c).getSortableContainerPropertyIds().contains(pid)) continue;
                sids.add(propertyId[i]);
                asci.add(i);
            }
            if (sids.isEmpty()) continue;
            boolean[] asc = new boolean[sids.size()];
            for (int i = 0; i < sids.size(); ++i) {
                asc[i] = ascending[(Integer)asci.get(i)];
            }
            ((Container.Sortable)c).sort(sids.toArray(new Object[0]), asc);
        }
    }

    public Collection<?> getSortableContainerPropertyIds() {
        LinkedHashSet sortablePids = new LinkedHashSet();
        for (Object pid : this.getContainerPropertyIds()) {
            for (Integer level : this.getHierarchy().keySet()) {
                HierarchicalDefinition def = this.getHierarchicalDefinition(level);
                Container.Indexed c = def.getContainer();
                Object mpid = this.unmapProperty(def, pid);
                if (!(c instanceof Container.Sortable) || mpid == null || !((Container.Sortable)c).getSortableContainerPropertyIds().contains(mpid)) continue;
                sortablePids.add(pid);
            }
        }
        return sortablePids;
    }

    public final class ItemSetChangeEvent
    extends EventObject
    implements Container.ItemSetChangeEvent {
        private ItemSetChangeEvent(HierarchicalContainer source) {
            super(source);
        }

        public Container getContainer() {
            return (Container)this.getSource();
        }
    }

    class HierarchicalSubList
    extends SubList<Object> {
        private int level;
        private HierarchicalId parentId;

        HierarchicalSubList(int level, HierarchicalId parentId, List<Object> list, int fromIndex, int toIndex) {
            super(list, fromIndex, toIndex);
            this.level = level;
            this.parentId = parentId;
        }

        @Override
        public HierarchicalId get(int index) {
            return new HierarchicalId(this.level, super.get(index), this.parentId);
        }

        @Override
        public ListIterator<Object> listIterator(int index) {
            this.rangeCheckForAdd(index);
            return new HierarchicalListIteratorImpl(this.getList().listIterator(index + this.getOffset()));
        }

        @Override
        public List<Object> subList(int fromIndex, int toIndex) {
            return new HierarchicalSubList(this.level, this.parentId, this.getList(), fromIndex, toIndex);
        }

        class HierarchicalListIteratorImpl
        extends SubList.ListIteratorImpl {
            HierarchicalListIteratorImpl(ListIterator<Object> i) {
                super(HierarchicalSubList.this, i);
            }

            @Override
            public Object next() {
                return new HierarchicalId(HierarchicalSubList.this.level, super.next(), HierarchicalSubList.this.parentId);
            }
        }
    }

    class HierarchicalId
    implements Serializable {
        private int level;
        private transient Object itemId;
        private HierarchicalId parentId;

        HierarchicalId(int level, Object itemId, HierarchicalId parentId) {
            this.level = level;
            this.itemId = itemId;
            this.parentId = parentId;
        }

        public int getLevel() {
            return this.level;
        }

        public Object getItemId() {
            return this.itemId;
        }

        public HierarchicalId getParentId() {
            return this.parentId;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.getOuterType().hashCode();
            result = 31 * result + (this.itemId == null ? 0 : this.itemId.hashCode());
            result = 31 * result + this.level;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof HierarchicalId)) {
                return false;
            }
            HierarchicalId other = (HierarchicalId)obj;
            if (!this.getOuterType().equals(other.getOuterType())) {
                return false;
            }
            if (this.itemId == null ? other.itemId != null : !this.itemId.equals(other.itemId)) {
                return false;
            }
            return this.level == other.level;
        }

        private HierarchicalContainer getOuterType() {
            return HierarchicalContainer.this;
        }

        public String toString() {
            return this.itemId == null ? "" : this.itemId.toString();
        }
    }

    class Indexes {
        private int level;
        private Integer indexFirstChild = null;
        private Integer indexLastChild = null;

        Indexes(int level, Integer indexFirstChild, Integer indexLastChild) {
            this.level = level;
            this.indexFirstChild = indexFirstChild;
            this.indexLastChild = indexLastChild;
        }

        public int getLevel() {
            return this.level;
        }

        public Integer getIndexFirstChild() {
            return this.indexFirstChild;
        }

        public Integer getIndexLastChild() {
            return this.indexLastChild;
        }
    }

    public class HierarchicalDefinition {
        private Container.Indexed container;
        private int level;
        private List<?> propertyIds;
        private Object itemPropertyId;
        private Object itemPropertyIdParent;
        private Object itemPropertyIdHasChildren;

        public HierarchicalDefinition(Container.Indexed container, int level, Object itemPropertyId, Object itemPropertyIdParent, List<?> propertyIds) {
            if (container == null) {
                throw new AssertionError((Object)"container is mandatory");
            }
            if (level < 0) {
                throw new AssertionError((Object)"level should be positive");
            }
            if (propertyIds == null) {
                throw new AssertionError((Object)"propertyIds is mandatory");
            }
            if (propertyIds.isEmpty()) {
                throw new AssertionError((Object)"propertyIds should contain at least 1 id");
            }
            if (itemPropertyId == null) {
                throw new AssertionError((Object)"itemPropertyId is mandatory");
            }
            if (level > 0 && itemPropertyIdParent == null) {
                throw new AssertionError((Object)"itemPropertyIdParent is mandatory for children");
            }
            this.container = container;
            this.level = level;
            this.propertyIds = propertyIds;
            this.itemPropertyId = itemPropertyId;
            this.itemPropertyIdParent = itemPropertyIdParent;
        }

        public Container.Indexed getContainer() {
            return this.container;
        }

        public int getLevel() {
            return this.level;
        }

        public List<?> getPropertyIds() {
            return this.propertyIds;
        }

        public Object getItemPropertyId() {
            return this.itemPropertyId;
        }

        public Object getItemPropertyIdParent() {
            return this.itemPropertyIdParent;
        }

        public Object getItemPropertyIdHasChildren() {
            return this.itemPropertyIdHasChildren;
        }

        public void setItemPropertyIdHasChildren(Object itemPropertyIdHasChildren) {
            this.itemPropertyIdHasChildren = itemPropertyIdHasChildren;
        }
    }
}

