/*
 * Decompiled with CFR 0.152.
 */
package com.ocs.dynamo.ui.container.hierarchical;

import com.ocs.dynamo.dao.FetchJoinInformation;
import com.ocs.dynamo.domain.AbstractEntity;
import com.ocs.dynamo.domain.model.AttributeModel;
import com.ocs.dynamo.domain.model.AttributeType;
import com.ocs.dynamo.domain.model.EntityModel;
import com.ocs.dynamo.domain.model.EntityModelFactory;
import com.ocs.dynamo.domain.model.impl.ModelBasedFieldFactory;
import com.ocs.dynamo.service.BaseService;
import com.ocs.dynamo.service.MessageService;
import com.ocs.dynamo.service.ServiceLocatorFactory;
import com.ocs.dynamo.ui.container.QueryType;
import com.ocs.dynamo.ui.container.ServiceContainer;
import com.ocs.dynamo.ui.container.hierarchical.HierarchicalContainer;
import com.ocs.dynamo.ui.container.hierarchical.HierarchicalFetchJoinInformation;
import com.ocs.dynamo.ui.utils.VaadinUtils;
import com.vaadin.data.Container;
import com.vaadin.data.fieldgroup.FieldGroupFieldFactory;
import com.vaadin.ui.Component;
import com.vaadin.ui.Field;
import com.vaadin.ui.TableFieldFactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.springframework.util.StringUtils;

public class ModelBasedHierarchicalContainer<T>
extends HierarchicalContainer {
    public static final String VISUAL_PROPERTY_IDS_MSG_KEY = "hierarchicalVisualPropertyIds";

    public ModelBasedHierarchicalContainer() {
        super(new Object[0]);
    }

    public ModelBasedHierarchicalContainer(MessageService messageService, EntityModel<T> rootEntityModel, List<BaseService<?, ?>> services, HierarchicalFetchJoinInformation[] joins) {
        super(new Object[0]);
        this.generateHierarchy(messageService, ServiceLocatorFactory.getServiceLocator().getEntityModelFactory(), rootEntityModel, services, joins, QueryType.ID_BASED);
    }

    public ModelBasedHierarchicalContainer(MessageService messageService, EntityModelFactory entityModelFactory, EntityModel<T> rootEntityModel, List<BaseService<?, ?>> services, HierarchicalFetchJoinInformation[] joins, QueryType queryType) {
        super(new Object[0]);
        this.generateHierarchy(messageService, entityModelFactory, rootEntityModel, services, joins, queryType);
    }

    public HierarchicalContainer generateHierarchy(MessageService messageService, EntityModelFactory entityModelFactory, EntityModel<T> rootEntityModel, List<BaseService<?, ?>> services, HierarchicalFetchJoinInformation[] joins, QueryType queryType) {
        if (rootEntityModel != null) {
            EntityModel pm = null;
            EntityModel cm = rootEntityModel;
            for (int level = 0; level < services.size(); ++level) {
                Container.Indexed container = this.createLevelContainer(level, services.get(level), cm, joins, queryType);
                ArrayList<Object> propertyIds = new ArrayList<Object>();
                String msg = messageService.getEntityMessage(cm.getReference(), VISUAL_PROPERTY_IDS_MSG_KEY, VaadinUtils.getLocale());
                if (!StringUtils.isEmpty((Object)msg)) {
                    String[] tokens = msg.split(",");
                    if (level == 0) {
                        this.setContainerPropertyIds(Arrays.asList(tokens));
                    }
                    for (Object object : tokens) {
                        if ("null".equalsIgnoreCase((String)object) || "".equals(object) || !container.getContainerPropertyIds().contains(object)) {
                            propertyIds.add(null);
                            continue;
                        }
                        propertyIds.add(object);
                    }
                } else {
                    for (AttributeModel am : cm.getAttributeModels()) {
                        if (!am.isVisibleInTable()) continue;
                        propertyIds.add(am.getName());
                    }
                }
                if (level > 0) {
                    AttributeModel parent = this.findRelatedAttributeModel(messageService, cm, null, AttributeType.MASTER, "itemPropertyIdParent");
                    this.addDefinition(new ModelBasedHierarchicalDefinition(cm, container, level, (Object)parent.getName(), propertyIds));
                } else {
                    this.addDefinition(new ModelBasedHierarchicalDefinition(cm, container, level, null, propertyIds));
                }
                if (level + 1 >= services.size()) continue;
                pm = cm;
                Class pec = services.get(level + 1).getEntityClass();
                AttributeModel child = this.findRelatedAttributeModel(messageService, pm, pec, AttributeType.DETAIL, "itemPropertyIdChild");
                cm = child != null ? child.getNestedEntityModel() : entityModelFactory.getModel(pm.getReference() + "_" + pec.getSimpleName(), pec);
            }
        }
        return this;
    }

    protected Container.Indexed createLevelContainer(int level, BaseService<?, ?> service, EntityModel<?> entityModel, HierarchicalFetchJoinInformation[] joins, QueryType queryType) {
        ArrayList<HierarchicalFetchJoinInformation> ljoins = new ArrayList<HierarchicalFetchJoinInformation>();
        if (joins != null) {
            for (HierarchicalFetchJoinInformation join : joins) {
                if (join.getLevel() != level) continue;
                ljoins.add(join);
            }
        }
        ServiceContainer container = new ServiceContainer(service, entityModel, false, 500, queryType, ljoins.toArray(new FetchJoinInformation[0]));
        container.getQueryView().setMaxCacheSize(10000);
        return container;
    }

    protected AttributeModel findRelatedAttributeModel(MessageService messageService, EntityModel<?> entityModel, Class<?> entityClassOther, AttributeType attributeType, String messageKey) {
        AttributeModel related = null;
        String msg = messageService.getEntityMessage(entityModel.getReference(), messageKey, VaadinUtils.getLocale());
        if (!StringUtils.isEmpty((Object)msg) && entityModel.getAttributeModel(msg) != null) {
            related = entityModel.getAttributeModel(msg);
        } else {
            List ms = entityModel.getAttributeModelsForType(attributeType, entityClassOther);
            if (!ms.isEmpty()) {
                related = (AttributeModel)ms.get(0);
            }
        }
        return related;
    }

    @Override
    public ModelBasedHierarchicalDefinition getHierarchicalDefinition(int level) {
        return (ModelBasedHierarchicalDefinition)this.getHierarchy().get(level);
    }

    @Override
    public ModelBasedHierarchicalDefinition getHierarchicalDefinitionByItemId(Object itemId) {
        return (ModelBasedHierarchicalDefinition)super.getHierarchicalDefinitionByItemId(itemId);
    }

    @Override
    public void addDefinition(HierarchicalContainer.HierarchicalDefinition definition) {
        if (!(definition instanceof ModelBasedHierarchicalDefinition)) {
            throw new UnsupportedOperationException("The use of a ModelBasedHierarchicalDefinition is mandatory for a ModelBasedHierarchicalContainer.");
        }
        super.addDefinition(definition);
    }

    @Override
    public void addDefinition(Container.Indexed container, int level, Object itemPropertyId, Object itemPropertyIdParent, Object ... propertyIds) {
        throw new UnsupportedOperationException("The use of a ModelBasedHierarchicalDefinition is mandatory for a ModelBasedHierarchicalContainer.");
    }

    public void addDefinition(EntityModel<?> entityModel, Container.Indexed container, int level, Object itemPropertyIdParent, Object ... propertyIds) {
        super.addDefinition(new ModelBasedHierarchicalDefinition(entityModel, container, level, itemPropertyIdParent, Arrays.asList(propertyIds)));
    }

    public class HierarchicalFieldFactory
    implements FieldGroupFieldFactory,
    TableFieldFactory {
        private ModelBasedHierarchicalContainer<T> container;
        private MessageService messageService;

        public HierarchicalFieldFactory(ModelBasedHierarchicalContainer<T> container, MessageService messageService) {
            this.container = container;
            this.messageService = messageService;
        }

        public Field<?> createField(Container container, Object itemId, Object propertyId, Component uiContext) {
            Object p;
            ModelBasedHierarchicalDefinition def = null;
            def = itemId instanceof HierarchicalContainer.HierarchicalId ? this.container.getHierarchicalDefinitionByItemId(itemId) : this.container.getHierarchicalDefinition(0);
            if (def != null && (p = this.container.unmapProperty(def, propertyId)) != null) {
                return def.getFieldFactory(this.messageService).createField((Container)def.getContainer(), this.container.unwrapItemId(itemId), p, uiContext);
            }
            return null;
        }

        public <F extends Field> F createField(Class<?> dataType, Class<F> fieldType) {
            FieldGroupFieldFactory f = (FieldGroupFieldFactory)this.container.getHierarchicalDefinition(0).getFieldFactory(this.messageService);
            return (F)f.createField(dataType, fieldType);
        }

        protected ModelBasedHierarchicalContainer<T> getContainer() {
            return this.container;
        }
    }

    public class ModelBasedHierarchicalDefinition
    extends HierarchicalContainer.HierarchicalDefinition {
        private EntityModel<?> entityModel;
        private ModelBasedFieldFactory<AbstractEntity<?>> fieldFactory;

        public ModelBasedHierarchicalDefinition(EntityModel<?> entityModel, Container.Indexed container, int level, Object itemPropertyIdParent, List<?> propertyIds) {
            super(container, level, entityModel.getIdAttributeModel().getName(), itemPropertyIdParent, propertyIds);
            this.entityModel = entityModel;
        }

        public EntityModel<?> getEntityModel() {
            return this.entityModel;
        }

        public void setEntityModel(EntityModel<?> entityModel) {
            this.entityModel = entityModel;
        }

        public TableFieldFactory getFieldFactory(MessageService messageService) {
            if (this.fieldFactory == null) {
                this.fieldFactory = ModelBasedFieldFactory.getInstance(this.entityModel, messageService);
            }
            return this.fieldFactory;
        }
    }
}

