/*
 * Decompiled with CFR 0.152.
 */
package com.ocs.dynamo.ui.container.pivot;

import com.ocs.dynamo.ui.container.pivot.PivotIdList;
import com.ocs.dynamo.ui.container.pivot.PivotItem;
import com.vaadin.data.Container;
import com.vaadin.data.Item;
import com.vaadin.data.Property;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class PivotContainer
implements Container,
Container.ItemSetChangeListener,
Container.Indexed,
Container.Sortable {
    private static final long serialVersionUID = 8057632998281455615L;
    private Container sourceContainer;
    private Object columnPropertyId;
    private Object rowPropertyId;
    private List<?> columnIds;
    private int rowCount;
    private List<String> propIds;
    private PivotIdList pivotIdList;
    private List<String> pivotedColumnPostFixes;
    private static final int MAX_CACHE_SIZE = 100;
    private Map<Object, PivotItem> cache = new HashMap<Object, PivotItem>();

    public PivotContainer(Container sourceContainer, Object columnPropertyId, Object rowPropertyId, List<?> columnIds, List<String> pivotedColumnPostFixes, int rowCount) {
        if (sourceContainer == null) {
            throw new IllegalArgumentException("sourceContainer is mandatory");
        }
        if (!(sourceContainer instanceof Container.Indexed)) {
            throw new IllegalArgumentException("sourceContainer must implement Container.Indexed");
        }
        if (columnPropertyId == null) {
            throw new IllegalArgumentException("columnPropertyId is mandatory");
        }
        if (rowPropertyId == null) {
            throw new IllegalArgumentException("rowPropertyId is mandatory");
        }
        if (columnIds == null) {
            throw new IllegalArgumentException("columnIds is mandatory");
        }
        if (columnIds.isEmpty()) {
            throw new IllegalArgumentException("columnIds size must be > 0");
        }
        if (rowCount < 0) {
            throw new IllegalArgumentException("rowCount must be >=0");
        }
        this.sourceContainer = sourceContainer;
        this.columnPropertyId = columnPropertyId;
        this.rowPropertyId = rowPropertyId;
        this.columnIds = columnIds;
        this.rowCount = rowCount;
        this.pivotedColumnPostFixes = pivotedColumnPostFixes;
        if (sourceContainer instanceof Container.ItemSetChangeNotifier) {
            ((Container.ItemSetChangeNotifier)sourceContainer).addItemSetChangeListener((Container.ItemSetChangeListener)this);
        }
    }

    protected List<String> getPropertyIds() {
        if (this.propIds == null) {
            HashSet<String> temp = new HashSet<String>();
            for (Object i : this.sourceContainer.getContainerPropertyIds()) {
                if (this.columnPropertyId.equals(i)) continue;
                temp.add(i.toString());
            }
            for (Object cid : this.columnIds) {
                for (String postFix : this.pivotedColumnPostFixes) {
                    if (this.rowPropertyId.equals(postFix)) continue;
                    temp.add(cid + "_" + postFix);
                }
            }
            this.propIds = new ArrayList<String>(temp);
        }
        return this.propIds;
    }

    public Item getItem(Object itemId) {
        return this.createPivotItem(itemId);
    }

    public Collection<?> getContainerPropertyIds() {
        return this.getPropertyIds();
    }

    public Collection<?> getItemIds() {
        if (this.pivotIdList == null) {
            this.pivotIdList = new PivotIdList(this);
        }
        return this.pivotIdList;
    }

    public Property getContainerProperty(Object itemId, Object propertyId) {
        return this.getItem(itemId).getItemProperty(propertyId);
    }

    public Class<?> getType(Object propertyId) {
        Class type = this.sourceContainer.getType(propertyId);
        String pid = propertyId.toString();
        int i = pid.lastIndexOf(95);
        if (type == null && i >= 0 && i < pid.length()) {
            type = this.sourceContainer.getType((Object)pid.substring(i + 1));
        }
        return type;
    }

    public int size() {
        return this.rowCount;
    }

    public boolean containsId(Object itemId) {
        return itemId instanceof Integer;
    }

    public Item addItem(Object itemId) {
        throw new UnsupportedOperationException();
    }

    public Object addItem() {
        throw new UnsupportedOperationException();
    }

    public boolean removeItem(Object itemId) {
        return false;
    }

    public boolean addContainerProperty(Object propertyId, Class<?> type, Object defaultValue) {
        throw new UnsupportedOperationException();
    }

    public boolean removeContainerProperty(Object propertyId) {
        throw new UnsupportedOperationException();
    }

    public boolean removeAllItems() {
        return this.sourceContainer.removeAllItems();
    }

    protected Container getSourceContainer() {
        return this.sourceContainer;
    }

    protected Object getColumnPropertyId() {
        return this.columnPropertyId;
    }

    protected List<?> getColumnIds() {
        return this.columnIds;
    }

    protected Object getRowPropertyId() {
        return this.rowPropertyId;
    }

    private Item createPivotItem(Object pivotId) {
        if (this.cache.containsKey(pivotId)) {
            return this.cache.get(pivotId);
        }
        HashMap<Object, Item> columnItems = new HashMap<Object, Item>();
        Container.Indexed sc = (Container.Indexed)this.sourceContainer;
        Object rowValue = null;
        Item column = null;
        for (int i = ((Integer)pivotId).intValue(); i < sc.size(); ++i) {
            column = sc.getItem(sc.getIdByIndex(i));
            if (column == null) continue;
            Object newRowValue = column.getItemProperty(this.rowPropertyId).getValue();
            if (rowValue == null) {
                rowValue = newRowValue;
            }
            if (newRowValue == null || !newRowValue.equals(rowValue)) break;
            columnItems.put(column.getItemProperty(this.columnPropertyId).getValue().toString(), column);
        }
        PivotItem pi = new PivotItem(columnItems, this);
        if (this.cache.size() > 100) {
            this.cache.clear();
        }
        this.cache.put(pivotId, pi);
        return pi;
    }

    public void containerItemSetChange(Container.ItemSetChangeEvent event) {
        this.reset();
    }

    public void reset() {
        this.pivotIdList = null;
        this.propIds = null;
    }

    public Object nextItemId(Object itemId) {
        int index = this.indexOfId(itemId);
        if (index >= 0 && index < this.size() - 1) {
            return this.getIdByIndex(index + 1);
        }
        return null;
    }

    public Object prevItemId(Object itemId) {
        int index = this.indexOfId(itemId);
        if (index > 0) {
            return this.getIdByIndex(index - 1);
        }
        return null;
    }

    public Object firstItemId() {
        if (this.size() > 0) {
            return this.getIdByIndex(0);
        }
        return null;
    }

    public Object lastItemId() {
        if (this.size() > 0) {
            return this.getIdByIndex(this.size() - 1);
        }
        return null;
    }

    public boolean isFirstId(Object itemId) {
        if (itemId == null) {
            return false;
        }
        return itemId.equals(this.firstItemId());
    }

    public boolean isLastId(Object itemId) {
        if (itemId == null) {
            return false;
        }
        return itemId.equals(this.lastItemId());
    }

    public Object addItemAfter(Object previousItemId) {
        throw new UnsupportedOperationException();
    }

    public Item addItemAfter(Object previousItemId, Object newItemId) {
        throw new UnsupportedOperationException();
    }

    public int indexOfId(Object itemId) {
        return ((List)this.getItemIds()).indexOf(itemId);
    }

    public Object getIdByIndex(int index) {
        return ((List)this.getItemIds()).get(index);
    }

    public List<?> getItemIds(int startIndex, int numberOfItems) {
        if (startIndex < 0) {
            throw new IndexOutOfBoundsException("Start index cannot be negative! startIndex=" + startIndex);
        }
        if (startIndex > this.size()) {
            throw new IndexOutOfBoundsException("Start index exceeds container size! startIndex=" + startIndex + " containerLastItemIndex=" + (this.size() - 1));
        }
        if (numberOfItems < 1) {
            if (numberOfItems == 0) {
                return Collections.emptyList();
            }
            throw new IllegalArgumentException("Cannot get negative amount of items! numberOfItems=" + numberOfItems);
        }
        int endIndex = startIndex + numberOfItems;
        if (endIndex > this.size()) {
            endIndex = this.size();
        }
        return Collections.unmodifiableList(((List)this.getItemIds()).subList(startIndex, endIndex));
    }

    public Object addItemAt(int index) {
        throw new UnsupportedOperationException();
    }

    public Item addItemAt(int index, Object newItemId) {
        throw new UnsupportedOperationException();
    }

    public int getRowCount() {
        return this.rowCount;
    }

    public void setRowCount(int rowCount) {
        if (this.rowCount != rowCount) {
            this.rowCount = rowCount;
            this.reset();
        }
    }

    public void sort(Object[] propertyId, boolean[] ascending) {
    }

    public Collection<?> getSortableContainerPropertyIds() {
        if (this.sourceContainer instanceof Container.Sortable) {
            return ((Container.Sortable)this.sourceContainer).getSortableContainerPropertyIds();
        }
        return new HashSet();
    }

    public PivotIdList getPivotIdList() {
        return this.pivotIdList;
    }
}

