/*
 * Decompiled with CFR 0.152.
 */
package com.ocs.dynamo.ui.container.pivot;

import com.ocs.dynamo.ui.container.pivot.PivotContainer;
import com.vaadin.data.Container;
import com.vaadin.data.Item;
import java.io.Serializable;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class PivotIdList
extends AbstractList<Integer>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Map<Integer, Integer> cachedIds = new HashMap<Integer, Integer>();
    private PivotContainer container;

    public PivotIdList(PivotContainer container) {
        if (container == null) {
            throw new AssertionError((Object)"Container is mandatory");
        }
        this.container = container;
    }

    @Override
    public Integer get(int index) {
        int ci;
        if (index < 0 || index >= this.container.size()) {
            throw new IndexOutOfBoundsException();
        }
        if (this.cachedIds.containsKey(index)) {
            return this.cachedIds.get(index);
        }
        int startIndex = 0;
        for (ci = index - 1; ci >= 0; --ci) {
            if (!this.cachedIds.containsKey(ci)) continue;
            startIndex = this.cachedIds.get(ci);
            break;
        }
        if (ci < 0) {
            ci = 0;
        }
        Container.Indexed sc = (Container.Indexed)this.container.getSourceContainer();
        Object rowValue = null;
        Object newRowValue = null;
        for (int i = startIndex; i < sc.size(); ++i) {
            Item column = sc.getItem(sc.getIdByIndex(i));
            if (column != null) {
                newRowValue = column.getItemProperty(this.container.getRowPropertyId()).getValue();
                if (rowValue == null) {
                    rowValue = newRowValue;
                } else if (!newRowValue.equals(rowValue)) {
                    ++ci;
                    rowValue = newRowValue;
                }
            }
            if (index != ci) continue;
            this.cachedIds.put(index, i);
            return i;
        }
        return null;
    }

    @Override
    public int indexOf(Object id) {
        if (id == null) {
            throw new AssertionError((Object)"Id is mandatory");
        }
        for (Map.Entry<Integer, Integer> entry : this.cachedIds.entrySet()) {
            if (!id.equals(entry.getValue())) continue;
            return entry.getKey();
        }
        return -1;
    }

    @Override
    public int size() {
        return this.container.size();
    }

    @Override
    public List<Integer> subList(int fromIndex, int toIndex) {
        ArrayList<Integer> sl = new ArrayList<Integer>();
        for (int i = fromIndex; i < toIndex; ++i) {
            sl.add(this.get(i));
        }
        return sl;
    }
}

