/*
 * Decompiled with CFR 0.152.
 */
package com.ocs.dynamo.ui.container.pivot;

import com.ocs.dynamo.ui.container.pivot.PivotContainer;
import com.vaadin.data.Container;
import com.vaadin.data.Item;
import com.vaadin.data.Property;
import com.vaadin.data.util.ObjectProperty;
import java.util.Collection;
import java.util.Map;

public class PivotItem
implements Item {
    private static final long serialVersionUID = 3972300096945691561L;
    private Map<Object, Item> columns;
    private Item firstColumn;
    private PivotContainer pivotContainer;

    public PivotItem(Map<Object, Item> columns, PivotContainer pivotContainer) {
        if (columns == null) {
            throw new IllegalArgumentException("columns is mandatory");
        }
        if (pivotContainer == null) {
            throw new IllegalArgumentException("pivotContainer is mandatory");
        }
        this.columns = columns;
        this.pivotContainer = pivotContainer;
    }

    public boolean addItemProperty(Object id, Property property) {
        Item ni;
        String[] ids;
        Item column = this.getColumn(id);
        if (column != null) {
            return column.addItemProperty(id, property);
        }
        return id != null && (ids = id.toString().split("_")).length > 1 && (ni = this.createColumn(ids[0], ids[1], property.getValue())) != null;
    }

    protected Item createColumn(Object columnId, Object propertyId, Object columnValue) {
        Container sc = this.pivotContainer.getSourceContainer();
        Object nid = sc.addItem();
        if (nid != null) {
            Item ni = sc.getItem(nid);
            Item c = this.columns.values().iterator().next();
            ni.getItemProperty(this.pivotContainer.getRowPropertyId()).setValue(c.getItemProperty(this.pivotContainer.getRowPropertyId()).getValue());
            ni.getItemProperty(this.pivotContainer.getColumnPropertyId()).setValue(columnId);
            ni.getItemProperty(propertyId).setValue(columnValue);
            this.columns.put(columnId, ni);
            return ni;
        }
        return null;
    }

    public Item getColumn(Object id) {
        Item column = null;
        if (id != null) {
            String[] ids = id.toString().split("_");
            if (ids.length > 1) {
                column = this.columns.get(ids[0]);
            } else if (ids.length > 0) {
                column = this.columns.get(id);
            }
        }
        return column;
    }

    public Property getItemProperty(Object id) {
        Object result = null;
        if (id != null) {
            String[] ids = id.toString().split("_");
            if (ids.length > 1) {
                result = this.columns.containsKey(ids[0]) ? this.columns.get(ids[0]).getItemProperty((Object)ids[1]) : new ObjectProperty(null, this.pivotContainer.getType(ids[1]));
            } else if (ids.length > 0 && this.pivotContainer.getPropertyIds().contains(id)) {
                if (this.firstColumn == null && !this.columns.isEmpty()) {
                    this.firstColumn = this.columns.values().iterator().next();
                }
                if (this.firstColumn != null) {
                    result = this.firstColumn.getItemProperty(id);
                }
            }
        }
        return result;
    }

    public Collection<?> getItemPropertyIds() {
        return this.pivotContainer.getPropertyIds();
    }

    public boolean removeItemProperty(Object id) {
        Item column = this.getColumn(id);
        if (column != null) {
            return column.removeItemProperty(id);
        }
        return false;
    }
}

