/*
 * Decompiled with CFR 0.152.
 */
package com.ocs.dynamo.ui.converter;

import com.ocs.dynamo.ui.utils.VaadinUtils;
import com.vaadin.data.util.converter.StringToBigDecimalConverter;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Locale;
import org.apache.commons.lang.StringUtils;

public class BigDecimalConverter
extends StringToBigDecimalConverter {
    private static final long serialVersionUID = -6491010958762673241L;
    private String pattern;
    private boolean useGrouping;
    private int precision;

    public BigDecimalConverter(String pattern) {
        this.pattern = pattern;
    }

    public BigDecimalConverter(int precision, boolean useGrouping) {
        this.precision = precision;
        this.useGrouping = useGrouping;
    }

    public BigDecimal convertToModel(String value, Class<? extends BigDecimal> targetType, Locale locale) {
        Number number = this.convertToNumber(value, BigDecimal.class, locale);
        return number == null ? null : BigDecimal.valueOf(number.doubleValue()).setScale(this.precision, RoundingMode.HALF_UP);
    }

    protected NumberFormat getFormat(Locale locale) {
        return this.getDecimalFormat(locale);
    }

    public DecimalFormat getDecimalFormat(Locale locale) {
        locale = locale != null ? locale : VaadinUtils.getLocale();
        DecimalFormat decimalFormat = this.constructFormat(locale);
        if (!StringUtils.isEmpty((String)this.pattern)) {
            decimalFormat.applyPattern(this.pattern);
        } else {
            decimalFormat.setGroupingUsed(this.useGrouping);
            decimalFormat.setMaximumFractionDigits(this.precision);
            decimalFormat.setMinimumFractionDigits(this.precision);
        }
        return decimalFormat;
    }

    protected DecimalFormat constructFormat(Locale locale) {
        return (DecimalFormat)DecimalFormat.getInstance(locale);
    }
}

