/*
 * Decompiled with CFR 0.152.
 */
package com.ocs.dynamo.ui.converter;

import com.ocs.dynamo.domain.model.AttributeModel;
import com.ocs.dynamo.ui.converter.BigDecimalConverter;
import com.ocs.dynamo.ui.converter.CurrencyBigDecimalConverter;
import com.ocs.dynamo.ui.converter.GroupingStringToIntegerConverter;
import com.ocs.dynamo.ui.converter.GroupingStringToLongConverter;
import com.ocs.dynamo.ui.converter.LocalDateTimeToDateConverter;
import com.ocs.dynamo.ui.converter.LocalDateToDateConverter;
import com.ocs.dynamo.ui.converter.LocalTimeToDateConverter;
import com.ocs.dynamo.ui.converter.PercentageBigDecimalConverter;
import com.ocs.dynamo.ui.converter.PercentageIntegerConverter;
import com.ocs.dynamo.ui.converter.PercentageLongConverter;
import com.ocs.dynamo.ui.converter.ZonedDateTimeToDateConverter;
import com.ocs.dynamo.util.SystemPropertyUtils;
import com.vaadin.data.util.converter.Converter;
import com.vaadin.data.util.converter.StringToIntegerConverter;
import com.vaadin.data.util.converter.StringToLongConverter;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.Date;

public final class ConverterFactory {
    private ConverterFactory() {
    }

    public static BigDecimalConverter createBigDecimalConverter(boolean currency, boolean percentage, boolean useGrouping, int precision, String currencySymbol) {
        if (currency) {
            return new CurrencyBigDecimalConverter(precision, useGrouping, currencySymbol);
        }
        if (percentage) {
            return new PercentageBigDecimalConverter(precision, useGrouping);
        }
        return new BigDecimalConverter(precision, useGrouping);
    }

    public static <T> Converter<String, T> createConverterFor(Class<T> clazz, AttributeModel attributeModel, boolean grouping) {
        if (clazz.equals(Integer.class) || clazz.equals(Integer.TYPE)) {
            return ConverterFactory.createIntegerConverter(grouping, attributeModel.isPercentage());
        }
        if (clazz.equals(Long.class) || clazz.equals(Long.TYPE)) {
            return ConverterFactory.createLongConverter(grouping, attributeModel.isPercentage());
        }
        if (clazz.equals(BigDecimal.class)) {
            return ConverterFactory.createBigDecimalConverter(attributeModel.isCurrency(), attributeModel.isPercentage(), grouping, attributeModel.getPrecision(), SystemPropertyUtils.getDefaultCurrencySymbol());
        }
        return null;
    }

    public static <T> Converter<Date, T> createDateConverter(Class<T> clazz) {
        if (clazz.equals(LocalDateTime.class)) {
            return ConverterFactory.createLocalDateTimeConverter();
        }
        if (clazz.equals(LocalDate.class)) {
            return ConverterFactory.createLocalDateConverter();
        }
        if (clazz.equals(LocalTime.class)) {
            return ConverterFactory.createLocalTimeConverter();
        }
        return null;
    }

    public static StringToIntegerConverter createIntegerConverter(boolean useGrouping, boolean percentage) {
        return percentage ? new PercentageIntegerConverter(useGrouping) : new GroupingStringToIntegerConverter(useGrouping);
    }

    public static LocalDateToDateConverter createLocalDateConverter() {
        return new LocalDateToDateConverter();
    }

    public static LocalDateTimeToDateConverter createLocalDateTimeConverter() {
        return new LocalDateTimeToDateConverter();
    }

    public static LocalTimeToDateConverter createLocalTimeConverter() {
        return new LocalTimeToDateConverter();
    }

    public static StringToLongConverter createLongConverter(boolean useGrouping, boolean percentage) {
        return percentage ? new PercentageLongConverter(useGrouping) : new GroupingStringToLongConverter(useGrouping);
    }

    public static ZonedDateTimeToDateConverter createZonedDateTimeConverter() {
        return new ZonedDateTimeToDateConverter();
    }
}

