/*
 * Decompiled with CFR 0.152.
 */
package com.ocs.dynamo.ui.converter;

import com.ocs.dynamo.ui.converter.BigDecimalConverter;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Locale;
import org.apache.commons.lang.StringUtils;

public class CurrencyBigDecimalConverter
extends BigDecimalConverter {
    private static final long serialVersionUID = -8785156070280947096L;
    private String currencySymbol;

    public CurrencyBigDecimalConverter(int precision, boolean useGrouping, String currencySymbol) {
        super(precision, useGrouping);
        this.currencySymbol = currencySymbol;
    }

    @Override
    public BigDecimal convertToModel(String value, Class<? extends BigDecimal> targetType, Locale locale) {
        if (value == null) {
            return null;
        }
        if (!StringUtils.isEmpty((String)value) && !value.startsWith(this.currencySymbol)) {
            String oldValue = value.trim();
            value = this.currencySymbol;
            value = value + (this.getDecimalFormat(locale).getPositivePrefix().length() > 1 ? " " : "");
            value = value + oldValue;
        }
        return super.convertToModel(value, targetType, locale);
    }

    @Override
    protected DecimalFormat constructFormat(Locale locale) {
        DecimalFormat nf = (DecimalFormat)DecimalFormat.getCurrencyInstance(locale);
        DecimalFormatSymbols s = nf.getDecimalFormatSymbols();
        s.setCurrencySymbol(this.currencySymbol);
        nf.setDecimalFormatSymbols(s);
        return nf;
    }
}

